/* picoSubr.c
 * 16jul90abu
 */

#include "pico.h"
#include "stack.h"

static pico sortFun;

/* Prototypes */
static pico array(number,pico);
static number depth(pico);
static pico mSort(pico,number);
static number size(pico);

pico Quote(x)
pico x;
{
	return car(x);
}

pico Lambda(x)
pico x;
{
	return x;
}

pico mSort(l,n)
register pico l;
register number n;
{
	register pico l1,l2;
	register number m;

	if (n == 1)
		return newCell(car(l),nilSym);
	m = n/2;
	n -= m;
	push(mSort(l,m));
	do
		l = cdr(l);
	while (--m);
	push(l2 = mSort(l,n));
	l1 = nos;
	if (num(apply1(sortFun,car(l1))) > num(apply1(sortFun,car(l2)))) {
		push(l = l1);
		l1 = cdr(l1);
	}
	else {
		push(l = l2);
		l2 = cdr(l2);
	}
	while (isCell(l1) && isCell(l2)) {
		if (num(apply1(sortFun,car(l1))) > num(apply1(sortFun,car(l2)))) {
			setCdr(l,l1);
			l1 = cdr(l1);
		}
		else {
			setCdr(l,l2);
			l2 = cdr(l2);
		}
		l = cdr(l);
	}
	setCdr(l, isCell(l1)? l1:l2);
	l = pop();
	drop2();
	return l;
}

pico Sort(x)
register pico x;
{
	push(EVAL1(x));
	x = cdr(x);
	push(sortFun = EVAL1(x));
	if (isCell(x = nos))
		x = mSort(x,length(x));
	drop2();
	return x;
}

pico Copy(x)
register pico x;
{
	push(EVAL1(x));
	x = copy(tos);
	drop();
	return x;
}

pico Diff(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	x = cdr(x);
	push(x = EVAL1(x));
	y = nilSym;
	while (isCell(x)) {
		if (!member(car(x),nos))
			y = newCell(car(x),y);
		x = cdr(x);
	}
	x = nos;
	while (isCell(x)) {
		if (!member(car(x),tos))
			y = newCell(car(x),y);
		x = cdr(x);
	}
	drop2();
	return y;
}

pico Sect(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	x = cdr(x);
	push(x = EVAL1(x));
	y = nilSym;
	while (isCell(x)) {
		if (member(car(x),nos))
			y = newCell(car(x),y);
		x = cdr(x);
	}
	drop2();
	return y;
}

pico Assoc(x)
register pico x;
{
	register pico y, z;

	x = EVAL2(x,y);
	while (isCell(y)) {
		if (isCell(z = car(y)) && equal(x, car(z)))
			return z;
		y = cdr(y);
	}
	return nilSym;
}

pico Append(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	x = cdr(x);
	y = EVAL1(x);
	y = append(pop(),y);
	while (isCell(x = cdr(x))) {
		push(y);
		y = EVAL1(x);
		y = append(pop(),y);
	}
	return y;
}

pico Reverse(x)
register pico x;
{
	register pico y;

	push(x = EVAL1(x));
	y = nilSym;
	while (isCell(x)) {
		y = newCell(car(x),y);
		x = cdr(x);
	}
	drop();
	return y;
}

pico Insert(x)
register pico x;
{
	number n;
	register pico y;

	push(EVAL1(x));
	x = cdr(x);
	n = num(EVAL1(x));
	NEEDNUM(n);
	n = unBox(n);
	x = EVAL1(cdr(x));
	if (--n < 0  ||  !isCell(x))
		return newCell(pop(),x);
	push(x);
	push(y = newCell(car(x),nilSym));
	while (x = cdr(x), --n >= 0  &&  isCell(x)) {
		setCdr(y, newCell(car(x),nilSym));
		y = cdr(y);
	}
	setCdr(y, newCell(tros,x));
	x = pop();
	drop2();
	return x;
}

pico Delete(x)
register pico x;
{
	push(EVAL1(x));
	x = EVAL1(cdr(x));
	return delete(pop(),x);
}

pico Cut(x)
register pico x;
{
	register pico y, z;

	y = EVAL1(x);
	z = car(cdr(x));
	NEEDSYM(z);
	CHECKSYM(z);
	if (isCell(x = val(z))) {
		if (equal(y, car(x))) {
			setVal(z, cdr(x));
			return tSym;
		}
		else {
			while (z = x, isCell(x = cdr(x))) {
				if (equal(y, car(x))) {
					setCdr(z, cdr(x));
					return tSym;
				}
			}
		}
	}
	return nilSym;
}

pico Nconc(x)
register pico x;
{
	push(EVAL1(x));
	while (isCell(x = cdr(x)))
		tos = nconc(tos,EVAL1(x));
	return pop();
}

pico Nconc1(x)
register pico x;
{
	register pico y, z;
	register number count;

	push(EVAL1(x));
	x = newCell(EVAL1(cdr(x)),nilSym);
	return nconc(pop(),x);
}

pico Rplaca(x)
register pico x;
{
	pico y;

	x = EVAL2(x,y);
	NEEDCELL(x);
	setCar(x,y);
	return x;
}

pico Rplacd(x)
register pico x;
{
	pico y;

	x = EVAL2(x,y);
	NEEDCELL(x);
	setCdr(x,y);
	return x;
}

pico Cons(x)
register pico x;
{
	push(EVAL1(x));
	x = EVAL1(cdr(x));
	return newCell(pop(),x);
}

pico Cons2(x)
register pico x;
{
	pico y;

	push(EVAL1(x));
	x = cdr(x);
	y = EVAL1(x);
	tos = newCell(tos,y);
	x = cdr(x);
	push(EVAL1(x));
	x = EVAL1(cdr(x));
	y = newCell(pop(),x);
	return newCell(pop(),y);
}

pico List(x)
register pico x;
{
	register pico y;

	if (!isCell(x))
		return x;
	push(y = newCell(EVAL1(x),nilSym));
	while (isCell(x = cdr(x))) {
		setCdr(y, newCell(EVAL1(x),nilSym));
		y = cdr(y);
	}
	return pop();
}

pico array(n,x)
register number n;
register pico x;
{
	register number m;

	NEEDNUM(n);
	n = unBox(n);
	push(nilSym);
	if (isCell(x)) {
		m = (number)EVAL1(x);
		while (--n >= 0)
			tos = newCell(array(m,cdr(x)),tos);
	}
	else
		while (--n >= 0)
			tos = newCell(tSym,tos);
	return pop();
}

pico Array(x)
register pico x;
{
	return array((number)EVAL1(x),cdr(x));
}

pico Car(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(x);
}

pico Cdr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(x);
}

pico Caar(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(car(x));
}

pico Cadr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(cdr(x));
}

pico Cdar(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(car(x));
}

pico Cddr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(cdr(x));
}

pico Caaar(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(car(car(x)));
}

pico Caadr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(car(cdr(x)));
}

pico Cadar(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(cdr(car(x)));
}

pico Caddr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(cdr(cdr(x)));
}

pico Cdaar(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(car(car(x)));
}

pico Cdadr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(car(cdr(x)));
}

pico Cddar(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(cdr(car(x)));
}

pico Cdddr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(cdr(cdr(x)));
}

pico Cadddr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return car(cdr(cdr(cdr(x))));
}

pico Cddddr(x)
register pico x;
{
	x = EVAL1(x);
	NEEDLIST(x);
	return cdr(cdr(cdr(cdr(x))));
}

pico Nthcdr(x)
register pico x;
{
	register number n;

	n = num(EVAL1(x));
	NEEDNUM(n);
	n = unBox(n);
	if (isCell(x = EVAL1(cdr(x))))
		while (--n >= 0)
			x = cdr(x);
	return x;
}

pico Nth(x)
register pico x;
{
	register number n;

	n = num(EVAL1(x));
	NEEDNUM(n);
	n = unBox(n);
	if (isCell(x = EVAL1(cdr(x))))
		while (--n >= 0)
			x = cdr(x);
	return car(x);
}

pico Index(x)
register pico x;
{
	register pico y;
	register number n;

	push(EVAL1(x));
	x = cdr(x);
	x = EVAL1(x);
	n = 0;
	y = pop();
	while (isCell(x)) {
		if (equal(y,car(x)))
			return boxNum(n);
		++n;
		x = cdr(x);
	}
	return nilSym;
}

pico Tail(x)
register pico x;
{
	register pico y;

	x = EVAL1(x);
	if (!isCell(x))
		return nilSym;
	do
		y = x;
	while (isCell(x = cdr(x)));
	return y;
}

pico Last(x)
register pico x;
{
	register pico y;

	x = EVAL1(x);
	if (!isCell(x))
		return nilSym;
	do
		y = x;
	while (isCell(x = cdr(x)));
	return car(y);
}

pico Last2(x)
register pico x;
{
	register pico y;

	x = EVAL1(x);
	if (!isCell(x) || !isCell(cdr(x)))
		return nilSym;
	do
		y = x;
	while (isCell(cdr(x = cdr(x))));
	return car(y);
}

pico Access(x)
register pico x;
{
	register pico y;
	register number n;

	push(y = EVAL1(x));
	do {
		NEEDCELL(y);
		x = cdr(x);
		n = num(EVAL1(x));
		NEEDNUM(n);
		n = unBox(n);
		while (--n >= 0)
			y = cdr(y);
		y = car(y);
	} while (isCell(cdr(x)));
	drop();
	return y;
}

pico Store(x)
register pico x;
{
	register pico y;
	register number n;

	push(EVAL1(x));
	x = cdr(x);
	push(y = EVAL1(x));
	loop {
		x = cdr(x);
		n = num(EVAL1(x));
		NEEDNUM(n);
		n = unBox(n);
		while (--n >= 0)
			y = cdr(y);
		if (!isCell(cdr(x)))
			break;
		y = car(y);
	}
	drop();
	x = pop();
	NEEDCELL(y);
	return setCar(y,x);
}

pico Subst(x)
register pico x;
{
	register pico y;

	push(EVAL1(x)); /* New item */
	x = cdr(x);
	push(EVAL1(x)); /* Old item */
	x = cdr(x);
	x = EVAL1(x);
	y = pop();
	while (isCell(x)) {
		if (equal(y, car(x)))
			return setCar(x,pop());
		x = cdr(x);
	}
	drop();
	return nilSym;
}

pico Swap(x)
register pico x;
{
	register pico y, z;
	register number i,j,tmp;

	i = num(EVAL1(x));
	NEEDNUM(i);
	i = unBox(i);
	x = cdr(x);
	j = num(EVAL1(x));
	NEEDNUM(j);
	j = unBox(j);
	if (j < i)
		tmp=i, i=j, j=tmp;
	j -= i;
	z = x = EVAL1(cdr(x));
	NEEDCELL(x);
	while (--i >= 0)
		x = cdr(x);
	if (isCell(x)) {
		y = x;
		while (--j >= 0)
			x = cdr(x);
		if (isCell(x)) {
			tmp = num(car(x));
			setCar(x, car(y));
			setCar(y, (pico)tmp);
		}
	}
	return z;
}

pico Length(x)
register pico x;
{
	register number n;

	x = EVAL1(x);
	n = 0;
	while (isCell(x)) {
		if (++n > MAXLIST)
			circError();
		x = cdr(x);
	}
	return boxNum(n);
}

pico StrLen(x)
pico x;
{
	return boxNum(strLength(EVAL1(x)));
}

number depth(x)
register pico x;
{
	if (isNil(x))
		return 1;
	if (!isCell(x))
		return 0;
	return maxNumber(depth(car(x))+1, depth(cdr(x)));
}

pico Depth(x)
pico x;
{
	return boxNum(depth(EVAL1(x)));
}

number size(x)
register pico x;
{
	if (!isCell(x))
		return 0;
	return size(car(x)) + size(cdr(x)) + 1;
}

pico pSize(x)
pico x;
{
	return boxNum(size(EVAL1(x)));
}
