[boss.l 01jun90]

(setq $app 'idle)   [Current application]
(setq $apps)        [List of all app's]
(setq $point (0.0)) [Re-usable point]
(setq *help)

<de getEvent ()
   (if (eq mouseDown (ev-what *event))
      (setq
         *lastWhen (ev-when *event)
         *lastV (word (add 10 *event))
         *lastH (word (add 12 *event)) )
      (and
         *help
         (eq keyDown (ev-what *event))
         (eq #helpKey (bitand charCodeMask (ev-message *event)))
         (*help) ) )
   (GetNextEvent everyEvent *event) >

<de doEvent ()
   (catch 'error
      ((method (ev-what *event) 'boss)) >

<de go ()
   (de *task ()
      (gc 1000)
      (SystemTask)
      (if (getEvent)
         (doEvent)
         (when (memq $app $apps)
            (may idle $app)
            (GetMouse $point)
            (LocalToGlobal $point)
            (may setCursor $app $point) >

(de front () $app)


(object boss)

<to start (obj x)
   (push x $apps) >

<to stop (obj x)
   (cut x $apps)
   (unless $apps
      (may cleanUp $app)
      (may setUp (setq $app 'idle))
      (may begin $app) >

<to quit ()
   (when (memq $app $apps)
      (may end $app) )
   (all close $apps)
   (quit) >

[+++ Toolbox Events +++]
<to #mouseDown ()
   (local (pt win f m)
      (setq pt (ev-where *event))
      (case (setq f (FindWindow pt win))
         (#inMenuBar
            (may able $app)
            (unless (zerop (high (setq m (MenuSelect pt))))
               (if (eq appleM (high m))
                  (if (eq 1 (low m))
                     (Alert aboutID)
                     (OpenDeskAcc
                        (GetItem
                           (GetResource "MENU" appleM)
                           (low m) ) ) )
                  ((or (method m $app) (method (high m) $app))
                     $app (low m) ) )
               (HiliteMenu 0) ) )
         (#inSysWindow
            (SystemClick *event win) )
         (#inContent
            (may content (GetWRefCon win) pt) )
         (#inDrag
            (DragWindow win pt (rect (add 6 *screenBits))) )
         (#inGrow
            (may grow (GetWRefCon win) pt) )
         (#inGoAway
            (when (TrackGoAway win pt)
               (do close (GetWRefCon win)) ) )
         ((#inZoomIn #inZoomOut)
            (when (TrackBox win pt f)
               (may zoom (GetWRefCon win) f) >

<to #mouseUp ()
   (may mouseUp $app) >

<to #keyDown ()
   (may able $app)
   (may keyDown $app
      (bitand charCodeMask (ev-message *event))
      (ev-modifiers *event) >

<to #keyUp ()
   (may keyUp $app
      (bitand charCodeMask (ev-message *event))
      (ev-modifiers *event) >

<to #autoKey ()
   (may able $app)
   (may autoKey $app
      (bitand charCodeMask (ev-message *event))
      (ev-modifiers *event) >

<to #updateEvt ()
   (do update (GetWRefCon (ev-message *event))) >

<to #diskEvt ()
   (may diskEvt $app (ev-message *event)) >

<to #activateEvt ()
   (local (obj)
      (setq obj (GetWRefCon (ev-message *event)))
      (if (zerop (bitand activeFlag (ev-modifiers *event)))
         (may deActivate obj)
         (progn
            (when (and (memq obj $apps) (neq obj $app))
               (when (memq $app $apps)
                  (may end $app) )
               (unless (eq (may classify obj) (may classify $app))
                  (may cleanUp $app)
                  (may setUp obj) )
               (may begin (setq $app obj)) )
            (may activate obj) >

<to #networkEvt ()
   (may networkEvt $app (ev-message *event)) >

<to #driverEvt ()
   (may driverEvt $app (ev-message *event)) >

<to #app1Evt ()
   (may app1Evt $app (ev-message *event)) >

<to #app2Evt ()
   (may app2Evt $app (ev-message *event)) >

t [boss.l]
