[docWin.l 08jun90]

<de viewRect (win)
   (local (r)
      (setq r (portRect win))
      (rplaca (cdr r)
         (sub (right r) #(sub1 SBarWidth)) )
      (rplacd (cdr r)
         (sub (bottom r) #(sub1 SBarWidth)) )
      r >

<de hSBarRect (win)
   (local (r)
      (setq r (portRect win))
      (cons2
         (sub1 (left r))
         (sub (bottom r) #(sub1 SBarWidth))
         (sub (right r) #(sub2 SbarWidth))
         (add1 (bottom r)) >

<de vSBarRect (win)
   (local (r)
      (setq r (portRect win))
      (cons2
         (sub (right r) #(sub1 SBarWidth))
         (sub1 (top r))
         (add1 (right r))
         (sub (bottom r) #(sub2 SBarWidth)) >

<de sizeBoxRect (win)
   (local (r)
      (setq r (portRect win))
      (cons2
         (sub (right r) #(sub1 SBarWidth))
         (sub (bottom r) #(sub1 SBarWidth))
         (add1 (right r))
         (add1 (bottom r)) >

[++ Calc. ZoomWindow size ++]
<de maxZoom (obj)
   (local (p)
      (with obj
         (setq p (ptr (ptr (add 130 (slot winPtr)))))
         (word (add 10 p) [std.left]
            (max
               3
               (sub
                  (word (add 14 p)) [std.right]
                  (add (slot size-h) #(sub1 SBarWidth)) ) ) )
         (word (add 12 p) [std.bottom]
            (min
               (word (add 10 *screenBits))
               (add
                  (word (add 8 p)) [std.top]
                  (add (slot size-v) #(sub1 SBarWidth)) >

[+++ Invalidate window's scroll bars and size box +++]
<de invalSS (win)
   (InvalRect (vSBarRect win))
   (InvalRect (hSBarRect win))
   (InvalRect (sizeBoxRect win)) >

[+++ Set the scroll bars +++]
<de fixSBars (obj)
   (local (ctl r)
      (with obj
         (localPort (slot winPtr)
            (PenNormal)
            (setq
               ctl (slot vSBar)
               r (vSBarRect *port) )
            (HideControl ctl)
            (MoveControl ctl (left r) (top r))
            (SizeControl ctl SBarWidth (sub (bottom r) (top r)))
            (ShowControl ctl)
            (ValidRect r)
            (setq
               ctl (slot hSBar)
               r (hSBarRect *port) )
            (HideControl ctl)
            (MoveControl ctl (left r) (top r))
            (SizeControl ctl (sub (right r) (left r)) SBarWidth)
            (ShowControl ctl)
            (ValidRect r)
            (DrawGrowIcon *port)
            (ValidRect (sizeBoxRect *port)) >

<de doScroll (h v)
   (local (r rgn)
      (setq r (viewRect *port))
      (setq rgn (NewRgn))
      (ScrollRect r h v rgn)
      (SetOrigin
         (sub (left r) h)
         (sub (top r) v) )
      (OffsetRgn (updateRgn *port) h v)
      (OffsetRgn rgn (minus h) (minus v))
      (UnionRgn rgn updt updt)
      (fixSBars obj)
      (do adjSBars obj)
      (DisposeRgn rgn) >

<de scrollWin (cntl part)
   (local (r val d)
      (setq
         r (viewRect *port)
         val (GetCtlValue cntl)
         d (sub (GetCtlMax cntl) (GetCtlValue cntl)) )
      (if (eq cntl (get obj 'vSBar))
         <case part
            (#inUpButton
               (doScroll 0 (min val (inc speed speedInc))) )
            (#inDownButton
               (doScroll 0 (minus (min d (inc speed speedInc)))) )
            (#inPageUp
               (doScroll
                  0
                  (min
                     val
                     (sub (bottom r) (top r)) ) ) )
            (#inPageDown
               (doScroll
                  0
                  (minus
                     (min
                        d
                        (sub (bottom r) (top r)) >
         <case part
            (#inUpButton
               (doScroll (min val (inc speed speedInc)) 0) )
            (#inDownButton
               (doScroll (minus (min d (inc speed speedInc))) 0) )
            (#inPageUp
               (doScroll
                  (min
                     val
                     (sub (right r) (left r)) )
                  0 ) )
            (#inPageDown
               (doScroll
                  (minus
                     (min
                        d
                        (sub (right r) (left r)) ) )
                  0 > >


(object docWin window)

<to t (obj pos h v s r)
   (default
      pos (60 . 40)
      h 900
      v 700
      s "Untitled"
      r (cons2 0 0 h v) )
   (local (win)
      <setq r
         (cons2
            (left r)
            (top r)
            (min
               (right r)
               (add
                  (left r)
                  (sub (word (add 12 *screenBits)) (car pos) 20) ) )
            (min
               (bottom r)
               (add
                  (top r)
                  (sub (word (add 10 *screenBits)) (cdr pos) 20) >
      (setq win
         (NewCWindow
            nil
            (cons
               pos
               (cons
                  (add
                     (car pos)
                     (sub (right r) (left r))
                     #(sub1 SBarWidth) )
                  (add
                     (cdr pos)
                     (sub (bottom r) (top r))
                     #(sub1 SBarWidth) ) ) )
            s t zoomDocProc -1 t obj ) )
      (SetPort win)
      (SetOrigin (left r) (top r))
      (with obj
         (slot winPtr win)
         (slot size-h h)
         (slot size-v v)
         (slot hSBar
            (NewControl
               win
               (hSBarRect win)
               nil t 0 0 1000 scrollBarProc ) )
         (slot vSBar
            (NewControl
               win
               (vSBarRect win)
               nil t 0 0 1000 scrollBarProc ) ) )
      (do adjSBars obj)
      (maxZoom obj) >

<to adjSBars (obj)
   (local (r)
      (with obj
         (setq r (viewRect (slot winPtr)))
         (SetCtlMax (slot hSBar)
            (sub
               (slot size-h)
               (sub (right r) (left r)) ) )
         (SetCtlValue (slot hSBar) (left r))
         (SetCtlMax (slot vSBar)
            (sub
               (slot size-v)
               (sub (bottom r) (top r)) ) )
         (SetCtlValue (slot vSBar) (top r)) >

<to grow (obj pt)
   (local (h v siz)
      (localPort (get obj 'winPtr)
         (setq
            h (get obj 'size-h)
            v (get obj 'size-v)
            siz (GrowWindow *port pt
               (cons2 100 100 (add h SBarWidth) (add v SBarWidth)) ) )
         (invalSS *port)
         (EraseRect (sizeBoxRect *port))
         (SizeWindow *port (low siz) (high siz) t)
         (invalSS *port)
         (when
            (or
               (lessp h (right (viewRect *port)))
               (lessp v (bottom (viewRect *port))) )
            (local (r)
               (setq r (portRect *port))
               (InvalRect r)
               (SetOrigin
                  (limit
                     (sub h (sub (right r) (left r) #(sub1 SBarWidth)))
                     0 (left r) )
                  (limit
                     (sub v (sub (bottom r) (top r) #(sub1 SBarWidth)))
                     0 (top r) ) ) ) )
         (fixSBars obj)
         (do adjSBars obj) >

<to zoom (obj n)
   (local (h v)
      (localPort (get obj 'winPtr)
         (setq
            h (get obj 'size-h)
            v (get obj 'size-v) )
         (invalSS *port)
         (ZoomWindow *port n)
         (invalSS *port)
         (when
            (or
               (lessp h (right (viewRect *port)))
               (lessp v (bottom (viewRect *port))) )
            (local (r)
               (setq r (portRect *port))
               (InvalRect r)
               (SetOrigin
                  (sub h (sub (right r) (left r) #(sub1 SBarWidth)))
                  (sub v (sub (bottom r) (top r) #(sub1 SBarWidth))) ) ) )
         (fixSBars obj)
         (do adjSBars obj) >

<to scroll (obj cntl part pt)
   (localPort (get obj 'winPtr)
      (PenNormal)
      (if (eq part inThumb)
         (unless (zerop (TrackControl cntl pt))
            (do refresh obj)
            (SetOrigin
               (GetCtlValue (get obj 'hSBar))
               (GetCtlValue (get obj 'vSBar)) )
            (fixSBars obj)
            (do adjSBars obj) )
         (local (speed speedInc updt)
            (zero speed)
            (setq speedInc 1)
            (setq updt (NewRgn))
            (TrackControl cntl pt scrollWin)
            (InvalRgn updt)
            (DisposeRgn updt) >

<to update (obj $foo)
   (from window update obj
      '(()
         (DrawControls *port)
         (DrawGrowIcon *port)
         (and $foo
            (localClip (viewRect *port)
               ($foo) >

<to activate (obj)
   (with obj
      (SetPort (slot winPtr))
      (PenNormal)
      (DrawGrowIcon *port)
      (HiliteControl (slot vSBar) 0)
      (HiliteControl (slot hSBar) 0) >

<to deActivate (obj)
   (with obj
      (localPort (slot winPtr)
         (PenNormal)
         (DrawGrowIcon *port)
         (HiliteControl (slot vSBar) 255)
         (HiliteControl (slot hSBar) 255) >

<to change (obj h v nm)
   (with obj
      (slot size-h h)
      (slot size-v v)
      (SetWTitle (slot winPtr) (or nm "Untitled"))
      (invalSS (slot winPtr))
      (EraseRect (sizeBoxRect (slot winPtr)))
      (SizeWindow
         (slot winPtr)
         (add h #(sub1 SBarWidth))
         (add v #(sub1 SBarWidth))
         t )
      (invalSS (slot winPtr))
      (SetOrigin 0 0)
      (InvalRect (portRect (slot winPtr))) )
   (maxZoom obj)
   (fixSBars obj)
   (do adjSBars obj) >

t [docWin.l]
