[go.l 10jan92]

<setq
   abstand 32
   steinRadius 15
   pos-h 32
   pos-v 32
   brettFarbe (pack 1023 744 237)
   schwarzFarbe 0
   weissFarbe -1
>

[+ Strategische Punkte +]
<de *stratPunkte
   (3.3) (9.3) (15.3)
   (3.9) (9.9) (15.9)
   (3.15) (9.15) (15.15) >

[+ Berechne Pixel-Koordinaten aus Board-Koordinaten +]
<de pix-h (h)
   (add #pos-h (mul h #abstand)) >

<de pix-v (v)
   (add #pos-v (mul v #abstand)) >

[+ Berechne Board-Koordinaten aus Pixel-Koordinaten +]
<de brd-h (h)
   (div (add h #(minus pos-h) #(div2 abstand)) #abstand) >

<de brd-v (v)
   (div (add v #(minus pos-v) #(div2 abstand)) #abstand) >

<de knoedel (r h v c)
   (local (r)
      (setq r (cons2 (sub h r) (sub v r) (add h r 1) (add v r 1)))
      (RGBForeColor (if c #schwarzFarbe #weissFarbe))
      (PaintOval r)
      (RGBForeColor 0)
      (FrameOval r) >

<de malStein (h v c)
   (knoedel #steinRadius (pix-h h) (pix-v v) c) >

<de invalStone (pt)
   (local (h v)
      (setq
         h (pix-h (car pt))
         v (pix-v (cdr pt)) )
      (InvalRect
         (cons2
            (sub h #steinRadius)
            (sub v #steinRadius)
            (add h #(add1 steinRadius))
            (add v #(add1 steinRadius)) >

<de malBrett ()
   (with *app
      (for (h 0 (slot groesse))
         (MoveTo (pix-h h) #pos-v)
         (Line 0 (mul #abstand (sub1 (slot groesse)))) )
      (for (v 0 (slot groesse))
         (MoveTo #pos-h (pix-v v))
         (Line (mul #abstand (sub1 (slot groesse))) 0) )
      (when (eq (slot groesse) 19)
         (mapc *stratPunkte
            (lambda (pt)
               (knoedel 3 (pix-h (car pt)) (pix-v (cdr pt)) t) ) ) )
      (mapc (slot blacks)
         (lambda (x) (malStein (car x) (cdr x) t)) )
      (mapc (slot whites)
         (lambda (x) (malStein (car x) (cdr x))) >

<de setzStein (pt c)
   (local (h v)
      (with *app
         (setq
            h (brd-h (car pt))
            v (brd-v (cdr pt))
            pt (cons h v) )
         (when
            (and
               (lessp h (slot groesse))
               (lessp v (slot groesse))
               (not (member pt (slot blacks)))
               (not (member pt (slot whites))) )
            (if c
               (slot blacks (cons pt (slot blacks)))
               (slot whites (cons pt (slot whites))) )
            (slot stones (cons pt (slot stones)))
            (invalStone pt) [(malStein h v c)]
            >

<de entferne (pt)
   (with *app
      (when (or (member pt (slot blacks)) (member pt (slot whites)))
         (slot blacks (delete pt (slot blacks)))
         (slot whites (delete pt (slot whites)))
         (slot stones (delete pt (slot stones)))
         (invalStone pt) >


(object go picApp)

<to t (obj n nm)
   (with obj
      (from docWin t obj
         (100 . 100)
         (add #(mul2 #pos-h) (mul #abstand (sub1 n)))
         (add #(mul2 #pos-v) (mul #abstand (sub1 n)))
         nm )
      (RGBBackColor #brettFarbe)
      (slot groesse n)
      (slot blacks nil)
      (slot whites nil)
      (slot move t)
      (start obj) >

<to close (obj)
   (do hide 'spot)
   [(zapUndo)]
   (from picApp close obj)
   t >

<to update (*app)
   (from docWin update *app
      (lambda ()
         (EraseRect (portRect *port))
         (malBrett) >

<to content (*app pt)
   (from picApp content *app pt
      (lambda (pt)
         (with *app
            (if (setzStein pt (slot move))
               (slot move (not (slot move)))
               (SysBeep 0) >

t
