/*
	File: ExportInterface.h

	Copyright 1990 by Thomas Knoll.

	This file describes version 3 of Photoshop's Export module interface.
*/

/* Operation selectors */

#define exportSelectorAbout    0
#define exportSelectorStart    1
#define exportSelectorContinue 2
#define exportSelectorFinish   3
#define exportSelectorPrepare  4

/* Image modes */

#define exportModeBitmap	   0
#define exportModeGrayScale    1
#define exportModeIndexedColor 2
#define exportModeRGBColor	   3
#define exportModeCMYKColor    4
#define exportModeHSLColor	   5
#define exportModeHSBColor	   6
#define exportModeMultichannel 7

/* Error return values. The plug-in module may also return standard Macintosh
   operating system error codes, or report its own errors, in which case it
   can return any positive integer. */

#define exportBadParameters -30200	/* "a problem with the export module interface" */
#define exportBadMode		-30201	/* "the export module does not support <mode> images" */

typedef unsigned char ExportLUT [256];

typedef struct ExportRecord {

	long		serialNumber;		/* Photoshop's serial number, to allow
									   copy protected plug-in modules. */
	ProcPtr 	abortProc;			/* The plug-in module may call this no-argument
									   BOOLEAN function (using Pascal calling
									   conventions) several times a second during long
									   operations to allow the user to abort the operation.
									   If it returns TRUE, the operation should be aborted
									   (and a positive error code returned). */
	ProcPtr 	progressProc;		/* The plug-in module may call this two-argument
									   procedure (using Pascal calling conventions)
									   periodically to update a progress indicator.
									   The first parameter (type LONGINT) is the number
									   of operations completed; the second (type LONGINT)
									   is the total number of operations. */

	long		maxData;			/* Maximum number of bytes that should be
									   requested at once (the plug-in should reduce
									   its requests by the size any large buffers
									   it allocates). The plug-in may reduce this
									   value in the exportSelectorPrepare routine. */

	short		imageMode;			/* Image mode */
	Point		imageSize;			/* Size of image */
	short		depth;				/* Bits per sample, currently will be 1 or 8 */
	short		planes; 			/* Samples per pixel */
	Fixed		imageHRes;			/* Pixels per inch */
	Fixed		imageVRes;			/* Pixels per inch */
	ExportLUT	redLUT; 			/* Red LUT, only used for Indexed Color images */
	ExportLUT	greenLUT;			/* Green LUT, only used for Indexed Color images */
	ExportLUT	blueLUT;			/* Blue LUT, only used for Indexed Color images */

	Rect		theRect;			/* Rectangle requested, set to empty rect when done */
	short		loPlane;			/* First plane requested */
	short		hiPlane;			/* Last plane requested */

	Ptr 		data;				/* A pointer to the requested image data */
	long		rowBytes;			/* Spacing between rows */

	Str255		filename;			/* Document file name */
	short		vRefNum;			/* Volume reference number, or zero if none */
	Boolean 	dirty;				/* Changes since last saved flag. The plug-in may clear
									   this field to prevent prompting the user when
									   closing the document. */

	Rect		selectBBox; 		/* Bounding box of current selection, or an empty
									   rect if there is no current selection. */

	} ExportRecord, *ExportRecordPtr;
