/* gradat.c
 * 13aug91abu
 */

#pragma segment gradat

#include ":src:pico.h"
#include ":src:mac.h"

typedef struct {
	bool isLine;
	long h1,v1,h2,v2;
	int color[4];
	double dist, weight;
} grad;

/* Prototypes */
static void nearLinePt(long,long,long,long,long,long,long*,long*);
static void nearCircPt(long,long,long,long,long,long*,long*);
static bool sected(long,long,long,long,grad*,int,int);
static unsigned char gradate(grad*,int,int,double);
static pico Gradat(pico);

symInit gradSyms[] = {
	{"GRADAT",		Gradat},
	NULL
};

void nearLinePt(h,v,h1,v1,h2,v2,ph,pv)
register long h,v,h1,v1,h2,v2;
register long *ph,*pv;
{
	register double a,b,c,n;

	c = (double)((h2-h1)*(h2-h1) + (v2-v1)*(v2-v1));
	if (c == 0.0)
		*ph = h1,  *pv = v1;
	else {
		a = (double)((h1-h)*(h1-h) + (v1-v)*(v1-v));
		b = (double)((h2-h)*(h2-h) + (v2-v)*(v2-v));
		n = (a - b + c) / (2*c);
		if (n <= 0.0)
			*ph = h1,  *pv = v1;
		else if (n >= 1.0)
			*ph = h2,  *pv = v2;
		else {
			*ph = h1 + (integer)(n*(h2-h1));
			*pv = v1 + (integer)(n*(v2-v1));
		}
	}
}

void nearCircPt(h,v,ch,cv,r,ph,pv)
register long h,v,ch,cv,r;
register long *ph,*pv;
{
	register double d;

	if ((d = distPt(h,v,ch,cv)) == 0.0) {
		*ph = h + r;
		*pv = v;
	}
	else {
		*ph = ch + (long)((double)(h - ch) / d * r);
		*pv = cv + (long)((double)(v - cv) / d * r);
	}
}

bool sected(h1,v1,h2,v2,p,n,self)
register long h1,v1,h2,v2;
register grad *p;
register int n,self;
{
	long dy,nenn,ph,pv;
	double m;

	p += n;
	while (--n >= 0) {
		--p;
		if (n == self)
			continue;
		if (p->isLine) {
			dy = p->v2 - p->v1;
			if ((nenn = (h2 - h1) * dy - (p->h2 - p->h1) * (v2 - v1)) == 0)
				continue;
			m = (double)(dy * (p->h1 - h1) + (p->h2 - p->h1) * (v1 - p->v1));
			m /= (double)nenn;
			if (0.0 <= m  &&  m <= 1.0) {
				if (dy == 0)
					continue;
				m = ((double)(v1 - p->v1) + m * (double)(v2 - v1)) / (double)dy;
				if (0.0 <= m  &&  m <= 1.0)
					return YES;
			}
		}
		else {
			nearLinePt(p->h2,p->v2,h1,v1,h2,v2,&ph,&pv);
			if ((long)distPt(p->h2,p->v2,ph,pv) <= p->h1 &&
					((long)distPt(p->h2,p->v2,h1,v1) > p->h1 ||
						(long)distPt(p->h2,p->v2,h2,v2) > p->h1 ) )
				return YES;
		}
	}
	return NO;
}

/* Generate Gradation */
unsigned char gradate(p,n,col,w)
register grad *p;
register int n,col;
register double w;
{
	register unsigned char c;

	c = 0;
	while (--n >= 0) {
		if (p->dist >= 0.0)
			c += (unsigned char)(minNumber(100, p->color[col] + p->color[3]) * p->weight / w);
		++p;
	}
	return c;
}

pico Gradat(x)
pico x;
{
	register pico y,z;
	register grad **g;
	unsigned char **base, *p;
	register long i,j,k,n,h,v;
	long ph,pv;
	double d,dSum,wSum;

	push(EVAL1(x)); /* Progress function */
	x = cdr(x);
	base = (unsigned char**)nextDynamo(&x);
	h = nextNum(&x);
	v = nextNum(&x);
	x = EVAL1(x);
	g = (grad**)NewHandle(0);
	n = 0;
	while (isCell(x)) {				/* Read grad list into handle */
		y = car(x);
		SetHandleSize((Handle)g, GetHandleSize((Handle)g) + sizeof(grad));
		if (isCell(car(z = car(y)))) {
			(*g)[n].isLine = YES;
			(*g)[n].h1 = unBox(car(car(z)));
			(*g)[n].v1 = unBox(cdr(car(z)));
		}
		else {
			(*g)[n].isLine = NO;
			(*g)[n].h1 = unBox(car(z));	/* Circle's radius */
		}
		(*g)[n].h2 = unBox(car(cdr(z)));
		(*g)[n].v2 = unBox(cdr(cdr(z)));
		y = cdr(y),  (*g)[n].color[0] = unBox(car(y)); /* Yellow */
		y = cdr(y),  (*g)[n].color[1] = unBox(car(y)); /* Magenta */
		y = cdr(y),  (*g)[n].color[2] = unBox(car(y)); /* Cyan */
		y = cdr(y),  (*g)[n].color[3] = unBox(car(y)); /* Key */
		++n;
		x = cdr(x);
	}
	apply2(tos, boxNum(v), unBufString("Calculating Gradation"));
	for (i = 0; i < v; ++i) {
		for (j = 0; j < h; ++j) {
			dSum = 0.0;
			for (k = 0; k < n; ++k) {
				if ((*g)[k].isLine)
					nearLinePt(j, i, (*g)[k].h1, (*g)[k].v1, (*g)[k].h2, (*g)[k].v2, &ph, &pv);
				else
					nearCircPt(j, i, (*g)[k].h2, (*g)[k].v2, (*g)[k].h1, &ph, &pv);
				if (sected(j,i,ph,pv,*g,n,k))
					(*g)[k].dist = -1;
				else
					dSum += (*g)[k].dist = distPt(j,i,ph,pv);
			}
			wSum = 0.0;
			for (k = 0; k < n; ++k)
				if ((d = (*g)[k].dist) >= 0.0)
					wSum  +=  (*g)[k].weight  =  (d == 0.0)? 1e9 : dSum/d;
			wSum = wSum * 100.0/255.0;
			p = *base + i*h + j;
			*p = gradate(*g,n,2,wSum);					/* Cyan */
			*(p + h*v) = gradate(*g,n,1,wSum);		/* Magenta */
			*(p + 2*h*v) = gradate(*g,n,0,wSum);	/* Yellow */
		}
		if (isNil(apply1(tos,nilSym))) {
			DisposHandle((Handle)g);
			drop();
			return nilSym;
		}
	}
	DisposHandle((Handle)g);
	drop();
	return tSym;
}
