/* rtFile.c
 * 29aug92abu
 */

#pragma segment rtFile

#include "retch.h"

/* Prototypes */
static pico TfRead(pico);
static pico ReadPx(pico);
static pico TfWrite(pico);
static pico ClTile(pico);
static pico RdTile(pico);
static pico WrTile(pico);
static pico MvTile(pico);
static pico RdCMYK(pico);
static pico WrCMYK(pico);
static pico Restor(pico);

static number pixPos(number,number);
static bool tfwr(Afile*,uchar*,number,number,number,bool);

/* Globals */

symInit rtFileSyms[] = {
	{"readPx",		ReadPx},
	{"tfRead",		TfRead},
	{"tfWrite",		TfWrite},
	{"clTile",		ClTile},
	{"rdTile",		RdTile},
	{"wrTile",		WrTile},
	{"mvTile",		MvTile},
	{"rdCMYK",		RdCMYK},
	{"wrCMYK",		WrCMYK},
	{"restor",		Restor},
	NULL
};

static number pixPos(h,v,cols)
number h,v,cols;
{
	h = absNumber(h);
	v = absNumber(v);
	return (v/TILE * cols + h/TILE) * TILE2 + v%TILE * TILE + h%TILE;
}

/* Tile File Scan Line Read/Write */
pico ReadPx(x)
pico x;
{
	Afile *f;
	register uchar *p, *q;
	register bool rev;
	register number w, len;
	long count;
	uchar buf[WINSIZE*sizeof(pixel)];

	f = (Afile*)nextNum(&x);
	p = (uchar*)nextNum(&x);
	if ((len = nextNum(&x)) <= 0)
		return nilSym;
	rev = nextBool(&x);
	count = len * sizeof(pixel);
	if (!f->fd) {
      libBlock(f->memory + f->mPos, buf, count);
      f->mPos += count;
	}
	else if (FSRead(f->fd, &count, buf))
		return nilSym;
	q = buf;
	if (!isNum(x = EVAL1(x))) {
		if (rev)
			do {
				p -= 4;
				*(pixel*)p = *(pixel*)q;
				q += 4;
			} while (--len);
		else
			BlockMove(q, p, len * sizeof(pixel));
	}
	else {
		w = unBox(x) * 255 / 10000;
		do {
			if (rev)
				p -= 4;
			*p = blend(*q,*p,w);
			*(p+1) = blend(*(q+1), *(p+1), w);
			*(p+2) = blend(*(q+2), *(p+2), w);
			*(p+3) = blend(*(q+3), *(p+3), w);
			if (!rev)
				p += 4;
			q += 4;
		} while (--len);
	}
	return tSym;
}

pico TfRead(x)
pico x;
{
	Afile *f;
	uchar *p;
	number cols,v,h1,h2,h;
	long cnt,count;

	f = (Afile*)nextNum(&x);
	p = (uchar*)nextNum(&x);
	cols = nextNum(&x);
	v = nextNum(&x);
	h1 = pixPos(nextNum(&x), v, cols);
	h2 = pixPos(nextNum(&x), v, cols);
	if (h2 <= (h = h1 + TILE-1 & ~(TILE-1))) {
		count = (h2 - h1)*sizeof(pixel);
		if (SetFPos(f->fd, fsFromStart, TFHEAD + h1*sizeof(pixel)) ||
											FSRead(f->fd, &count, p))
			return nilSym;
	}
	else {
		if (cnt = h - h1) {
			count = cnt*sizeof(pixel);
			if (SetFPos(f->fd, fsFromStart, TFHEAD + h1*sizeof(pixel)) ||
												FSRead(f->fd, &count, p))
				return nilSym;
			h1 += cnt + TILE2 - TILE;
			p += cnt*sizeof(pixel);
		}
		h = h2 & ~(TILE-1);
		while (h1 < h) {
			count = TILE*sizeof(pixel);
			if (SetFPos(f->fd, fsFromStart, TFHEAD + h1*sizeof(pixel)) ||
												FSRead(f->fd, &count, p))
				return nilSym;
			h1 += TILE2;
			p += TILE*sizeof(pixel);
		}
		if (cnt = h2 - h1) {
			count = cnt*sizeof(pixel);
			if (SetFPos(f->fd, fsFromStart, TFHEAD + h1*sizeof(pixel)) ||
												FSRead(f->fd, &count, p))
				return nilSym;
		}
	}
	return tSym;
}

pico TfWrite(x)
pico x;
{
	Afile *f;
	uchar *p;
	number cols,v,h1,h2,h,w;
	bool rev;
	long cnt;

	f = (Afile*)nextNum(&x);
	p = (uchar*)nextNum(&x);
	cols = nextNum(&x);
	v = nextNum(&x);
	h1 = nextNum(&x);
	h2 = nextNum(&x);
	w = isNum(w = num(EVAL1(x)))?  unBox(w)*255/10000 : 255;
	x = cdr(x);
	if (rev = nextBool(&x)) {
		cnt = h2 - h1;
		h2 = absNumber(h1);
		h1 = h2 - cnt;
		p += cnt * sizeof(pixel);
	}
	h1 = pixPos(h1, v, cols);
	h2 = pixPos(h2, v, cols);
	if (h2 <= (h = h1 + TILE-1 & ~(TILE-1))) {
		if (!tfwr(f, p, h1, (h2 - h1)*sizeof(pixel), w, rev))
			return nilSym;
	}
	else {
		if (cnt = h - h1) {
			if (!tfwr(f, p, h1, cnt*sizeof(pixel), w, rev))
				return nilSym;
			h1 += cnt + TILE2 - TILE;
			if (rev)
				p -= cnt*sizeof(pixel);
			else
				p += cnt*sizeof(pixel);
		}
		h = h2 & ~(TILE-1);
		while (h1 < h) {
			if (!tfwr(f, p, h1, TILE*sizeof(pixel), w, rev))
				return nilSym;
			h1 += TILE2;
			if (rev)
				p -= TILE*sizeof(pixel);
			else
				p += TILE*sizeof(pixel);
		}
		if (cnt = h2 - h1) {
			if (!tfwr(f, p, h1, cnt*sizeof(pixel), w, rev))
				return nilSym;
		}
	}
	return tSym;
}

static bool tfwr(f,p,h,cnt,w,rev)
Afile* f;
register uchar *p;
number h,cnt,w;
bool rev;
{
	register int i;
	uchar buf[TILE*sizeof(pixel)];
	long count;

	count = cnt;
	if (SetFPos(f->fd, fsFromStart, TFHEAD + h*sizeof(pixel)))
		return NO;
	if (w == 255) {
		if (rev) {
			i = 0;
			while (i < cnt) {
				buf[i+3] = *--p;
				buf[i+2] = *--p;
				buf[i+1] = *--p;
				buf[i+0] = *--p;
				i += 4;
			}
			return FSWrite(f->fd, &count, buf) == noErr;
		}
		return FSWrite(f->fd, &count, p) == noErr;
	}
	if (FSRead(f->fd, &count, buf))
		return NO;
	count = cnt;
	if (SetFPos(f->fd, fsFromStart, TFHEAD + h*sizeof(pixel)))
		return NO;
	i = 0;
	if (rev) {
		while (i < cnt) {
			buf[i+3] = blend(*--p, buf[i+3], w);
			buf[i+2] = blend(*--p, buf[i+2], w);
			buf[i+1] = blend(*--p, buf[i+1], w);
			buf[i+0] = blend(*--p, buf[i+0], w);
			i += 4;
		}
	}
	else {
		while (i < cnt) {
			buf[i+0] = blend(*p++, buf[i+0], w);
			buf[i+1] = blend(*p++, buf[i+1], w);
			buf[i+2] = blend(*p++, buf[i+2], w);
			buf[i+3] = blend(*p++, buf[i+3], w);
			i += 4;
		}
	}
	return FSWrite(f->fd, &count, buf) == noErr;
}

/* Clear tile */
pico ClTile(x)
pico x;
{
	register pixel *p;
	register int i;
	Handle hndl;
	long h,v;

	hndl = (Handle)nextNum(&x);
	h = (int)nextNum(&x);
	v = (int)nextNum(&x);
	p = *(pixel**)hndl + (v * WINSIZE + h) * TILE;
	i = TILE;
	do {
		p[0] = 0;
		p[1] = 0;
		p[2] = 0;
		p[3] = 0;
		p[4] = 0;
		p[5] = 0;
		p[6] = 0;
		p[7] = 0;
		p[8] = 0;
		p[9] = 0;
		p[10] = 0;
		p[11] = 0;
		p[12] = 0;
		p[13] = 0;
		p[14] = 0;
		p[15] = 0;
		p[16] = 0;
		p[17] = 0;
		p[18] = 0;
		p[19] = 0;
		p[20] = 0;
		p[21] = 0;
		p[22] = 0;
		p[23] = 0;
		p[24] = 0;
		p[25] = 0;
		p[26] = 0;
		p[27] = 0;
		p[28] = 0;
		p[29] = 0;
		p[30] = 0;
		p[31] = 0;
		p += WINSIZE;
	} while (--i > 0);
	return tSym;
}

/* Read tile */
pico RdTile(x)
pico x;
{
	Handle hndl;
	long tile, h, v, tiles;
	Afile *f;
	long count;
	char tileBuff[TILEBUFF];
	char *buf;

	if (!(tiles = nextNum(&x)))
		return tSym;
	f = (Afile*)nextNum(&x);
	tile = nextNum(&x);
	hndl = (Handle)nextNum(&x);
	h = nextNum(&x);
	v = nextNum(&x);
	count = tiles*TILEBUFF;
	if (tiles == 1)
		buf = tileBuff;
	else if (!(buf = NewPtr(count)))
		return nilSym;
	if (SetFPos(f->fd, fsFromStart, TFHEAD + tile*TILEBUFF) ||
										FSRead(f->fd, &count, buf))
		return nilSym;
	if (isNum(x = EVAL1(x))) {
		register uchar *p, *q;
		register int i;

		p = *(uchar**)hndl + (v * WINSIZE + h) * TILE*sizeof(pixel);
		q = (uchar*)buf + unBox(x);
		while (--tiles >= 0) {
			i = TILE;
			do {
				move1to4Planes(q,p);
				p += WINSIZE*sizeof(pixel);
				q += 32*sizeof(pixel);
			} while (--i > 0);
			p += (TILE - WINSIZE*TILE)*sizeof(pixel);
		}
	}
	else {
		register pixel *p, *q;
		register int i;

		p = *(pixel**)hndl + (v * WINSIZE + h) * TILE;
		q = (pixel*)buf;
		while (--tiles >= 0) {
			i = TILE;
			do {
				move4Planes(q,p);
				p += WINSIZE;
				q += 32;
			} while (--i > 0);
			p += TILE - WINSIZE*TILE;
		}
	}
	if (buf != tileBuff)
		DisposPtr(buf);
	return tSym;
}

/* Write tile */
pico WrTile(x)
pico x;
{
	Handle hndl;
	long tile, h, v;
	Afile *f;
	long count;
	char tileBuff[TILEBUFF];

	f = (Afile*)nextNum(&x);
	tile = nextNum(&x);
	hndl = (Handle)nextNum(&x);
	h = nextNum(&x);
	v = nextNum(&x);
	if (isNum(x = EVAL1(x))) {
		register uchar *p, *q;
		register int i;

		count = TILEBUFF;
		if (SetFPos(f->fd, fsFromStart, TFHEAD + tile*TILEBUFF) ||
										FSRead(f->fd, &count, tileBuff))
			return nilSym;
		p = (uchar*)tileBuff;
		q = *(uchar**)hndl + (v * WINSIZE + h) * TILE*sizeof(pixel);
		p += unBox(x);
		q += unBox(x);
		i = TILE;
		do {
			move1Plane(q,p);
			q += WINSIZE*sizeof(pixel);
			p += 32*sizeof(pixel);
		} while (--i > 0);
	}
	else if (x ==  tSym) {
		register uchar *p, *q;
		register int i;

		count = TILEBUFF;
		if (SetFPos(f->fd, fsFromStart, TFHEAD + tile*TILEBUFF) ||
										FSRead(f->fd, &count, tileBuff))
			return nilSym;
		p = (uchar*)tileBuff;
		q = *(uchar**)hndl + (v * WINSIZE + h) * TILE*sizeof(pixel);
		i = TILE;
		do {
			move3Planes(q,p);
			q += WINSIZE*sizeof(pixel);
			p += 32*sizeof(pixel);
		} while (--i > 0);
	}
	else {
		register pixel *p, *q;
		register int i;

		p = (pixel*)tileBuff;
		q = *(pixel**)hndl + (v * WINSIZE + h) * TILE;
		i = TILE;
		do {
			move4Planes(q,p);
			q += WINSIZE;
			p += 32;
		} while (--i > 0);
	}
	count = TILEBUFF;
	if (SetFPos(f->fd, fsFromStart, TFHEAD + tile*TILEBUFF) ||
										FSWrite(f->fd, &count, tileBuff))
		return nilSym;
	return tSym;
}

/* Move tile */
pico MvTile(x)
pico x;
{
	register pixel *p, *q;
	register int i;
	long h,v,dh,dv;

	q = *(pixel**)nextNum(&x);
	h = (int)nextNum(&x);
	v = (int)nextNum(&x);
	dh = (int)nextNum(&x);
	dv = (int)nextNum(&x);
	q += (v * WINSIZE + h) * TILE;
	p = q + (dv * WINSIZE + dh) * TILE;
	i = TILE;
	do {
		move4Planes(q,p);
		p += WINSIZE;
		q += WINSIZE;
	} while (--i > 0);
	return tSym;
}

pico RdCMYK(x)
pico x;
{
	register long i,h,v,h1,v1,j;
	Afile *src, *dst;
	uchar *datBuf;
	uchar buf[TFHEAD];
	Handle hndl;
	long count, inc, scl, lim;
	pixel *q;
	cell c1,c2;

	push(EVAL1(x),c1); /* Progress function */
	x = cdr(x);
	push(EVAL1(x),c2); /* Progress dialog text */
   NEEDSTRING(tos(c2));
	x = cdr(x);
	src = (Afile*)nextNum(&x);
	dst = (Afile*)nextNum(&x);
	SetFPos(dst->fd, fsFromStart, 0);
	count = TFHEAD; /* Read header */
	if (FSRead(src->fd, &count, buf)) {
		drop(c1);
		return nilSym;
	}
	count = TFHEAD; /* Write header */
	if (FSWrite(dst->fd, &count, buf)) {
		drop(c1);
		return nilSym;
	}
	h = buf[0] * 256 + buf[1];
	v = buf[2] * 256 + buf[3];
	if (!(datBuf = NewPtr(h * TILEBUFF))) {
		drop(c1);
		return nilSym;
	}
	hndl = NULL;
	scl = 0;
	if (isCell(x)) {
		inc = maxNumber(1, TILE / maxNumber(1,minNumber(PEEP/h,PEEP/v)));
		scl = TILE / inc;
		lim = scl * inc;
		if (!(hndl = NewHandle(h*v*4*scl*scl))) {
			drop(c1);
			DisposPtr(datBuf);
			return nilSym;
		}
		val(nextVar(&x)) = boxNum(hndl);
		val(nextVar(&x)) = boxNum(scl);
		val(nextVar(&x)) = boxNum(h);
		val(nextVar(&x)) = boxNum(v);
		HLock(hndl);
		q = *(pixel**)hndl;
	}
	x = pop(c2);
	apply2(tos(c1), boxNum(v), x);
	for (v1 = 0; v1 < v; ++v1) {
		count = h * TILEBUFF;
		FSRead(src->fd, &count, datBuf);
		if (hndl)
			for (j = 0; j < lim; j += inc)
				for (h1 = 0; h1 < h; ++h1)
					for (i = 0; i < lim; i += inc)
						*q++ = ((pixel*)datBuf)[(h1*TILE + j)*TILE + i];
		count = h * TILEBUFF;
		if (FSWrite(dst->fd, &count, datBuf) || isNil(apply1(tos(c1),nilSym))) {
			DisposPtr(datBuf);
			if (hndl)
				DisposHandle(hndl);
			drop(c1);
			return nilSym;
		}
	}
	DisposPtr(datBuf);
	if (hndl)
		HUnlock(hndl);
	drop(c1);
	return tSym;
}

pico WrCMYK(x)
pico x;
{
	register long i,h,v,h1,v1,j;
	Afile *src, *dst;
	uchar *datBuf;
	uchar buf[TFHEAD];
	Handle hndl;
	long count, inc, scl, lim;
	pixel *q;
	cell c1,c2;

	push(EVAL1(x),c1); /* Progress function */
	x = cdr(x);
	push(EVAL1(x),c2); /* Progress dialog text */
   NEEDSTRING(tos(c2));
	x = cdr(x);
	src = (Afile*)nextNum(&x);
	dst = (Afile*)nextNum(&x);
	SetFPos(src->fd, fsFromStart, 0);
	count = TFHEAD; /* Read header */
	if (FSRead(src->fd, &count, buf)) {
		drop(c1);
		return nilSym;
	}
	count = TFHEAD; /* Write header */
	if (FSWrite(dst->fd, &count, buf)) {
		drop(c1);
		return nilSym;
	}
	h = (long)(*(word*)buf);
	v = (long)(*(word*)(buf+2));
	if (!(datBuf = NewPtr(h * TILEBUFF))) {
		drop(c1);
		return nilSym;
	}
	if (hndl = nextPtr(&x)) {
		inc = maxNumber(1, TILE / maxNumber(1,minNumber(PEEP/h,PEEP/v)));
		scl = TILE / inc;
		lim = scl * inc;
		HLock(hndl);
		q = *(pixel**)hndl;
	}
	x = pop(c2);
	apply3(tos(c1), boxNum(v), x, tSym);
	for (v1 = 0; v1 < v; ++v1) {
		count = h * TILEBUFF;
		FSRead(src->fd, &count, datBuf);
		if (hndl)
			for (j = 0; j < lim; j += inc)
				for (h1 = 0; h1 < h; ++h1)
					for (i = 0; i < lim; i += inc)
						*q++ = ((pixel*)datBuf)[(h1*TILE + j)*TILE + i];
		count = h * TILEBUFF;
		if (FSWrite(dst->fd, &count, datBuf) || isNil(apply1(tos(c1),nilSym))) {
			DisposPtr(datBuf);
			if (hndl)
				HUnlock(hndl);
			drop(c1);
			return nilSym;
		}
	}
	DisposPtr(datBuf);
	if (hndl)
		HUnlock(hndl);
	drop(c1);
	return tSym;
}

/* Restore with blend */
pico Restor(x)
pico x;
{
	register number h;
	register uchar *p, *q;
	Afile *src, *dst;
	number cols,w,v;
	uchar *srcBuf, *dstBuf;
	long cnt, count;

	src = (Afile*)nextNum(&x);
	dst = (Afile*)nextNum(&x);
	cols = nextNum(&x);
	w = nextNum(&x) * 255 / 10000;
	v = nextNum(&x);
	cnt = cols*TILEBUFF;
	if (!(srcBuf = NewPtr(cnt)))
		return nilSym;
	if (!(dstBuf = NewPtr(cnt))) {
		DisposPtr(srcBuf);
		return nilSym;
	}
	count = cnt;
	if (SetFPos(src->fd, fsFromStart, TFHEAD + v*cols*TILEBUFF) ||
										FSRead(src->fd, &count, srcBuf)) {
		DisposPtr(srcBuf);
		DisposPtr(dstBuf);
		return nilSym;
	}
	count = cnt;
	if (SetFPos(dst->fd, fsFromStart, TFHEAD + v*cols*TILEBUFF) ||
										FSRead(dst->fd, &count, dstBuf)) {
		DisposPtr(srcBuf);
		DisposPtr(dstBuf);
		return nilSym;
	}
	p = dstBuf;
	q = srcBuf;
	h = cnt;
	do {
		*p = blend(*q,*p,w);
		++p;
		++q;
	} while (--h);
	SetFPos(dst->fd, fsFromStart, TFHEAD + v*cols*TILEBUFF);
	FSWrite(dst->fd, &cnt, dstBuf);
	DisposPtr(srcBuf);
	DisposPtr(dstBuf);
	return tSym;
}
