[chess.l 04oct92abu]

[+++ Init Board +++]
<de Board
   (A1  B1  C1  D1  E1  F1  G1  H1)
   (A2  B2  C2  D2  E2  F2  G2  H2)
   (A3  B3  C3  D3  E3  F3  G3  H3)
   (A4  B4  C4  D4  E4  F4  G4  H4)
   (A5  B5  C5  D5  E5  F5  G5  H5)
   (A6  B6  C6  D6  E6  F6  G6  H6)
   (A7  B7  C7  D7  E7  F7  G7  H7)
   (A8  B8  C8  D8  E8  F8  G8  H8) >

<de brd (i j)
   (unless (or (minusp i) (minusp j))
      (access Board i j) >

<de brdMove (i j)
   (when (brd i j)
      (link :res :p (brd i j)) >

<de wpMoves (i j)
   (local (:res :p)
      (setq :res)
      (unless (memq (brd i j) '(A1 B1 C1 D1 E1 F1 G1 H1))
         (brdMove (add1 i) j)
         (brdMove (add1 i) (sub1 j))
         (brdMove (add1 i) (add1 j))
         (when (memq (brd i j) '(A2 B2 C2 D2 E2 F2 G2 H2))
            (brdMove (add2 i) j) ) )
      :res >

<de bpMoves (i j)
   (local (:res :p)
      (setq :res)
      (unless (memq (brd i j) '(A8 B8 C8 D8 E8 F8 G8 H8))
         (brdMove (sub1 i) j)
         (brdMove (sub1 i) (sub1 j))
         (brdMove (sub1 i) (add1 j))
         (when (memq (brd i j) '(A7 B7 C7 D7 E7 F7 G7 H7))
            (brdMove (sub2 i) j) ) )
      :res >

<de nMoves (i)
   (local (result)
      (setq result)
      (brdMove (sub i 25))
      (brdMove (sub i 23))
      (brdMove (sub i 14))
      (brdMove (sub i 10))
      (brdMove (add i 10))
      (brdMove (add i 14))
      (brdMove (add i 23))
      (brdMove (add i 25))
      (reverse result) >

<de bMoves (i)
   (local (result lst)
      (setq result)
      (setq lst)
      (push
         (local (i lst)
            (while (brd (inc i 11))
               (push (brd i) lst) )
            (reverse lst) )
         result )
      (push
         (local (i lst)
            (while (brd (inc i 13))
               (push (brd i) lst) )
            (reverse lst) )
         result )
      (push
         (local (i lst)
            (while (brd (dec i 13))
               (push (brd i) lst) )
            (reverse lst) )
         result )
      (push
         (local (i lst)
            (while (brd (dec i 11))
               (push (brd i) lst) )
            (reverse lst) )
         result >

<de rMoves (i)
   (local (result lst)
      (setq result)
      (setq lst)
      (push
         (local (i lst)
            (while (brd (dec i))
               (push (brd i) lst) )
            (reverse lst) )
         result )
      (push
         (local (i lst)
            (while (brd (inc i))
               (push (brd i) lst) )
            (reverse lst) )
         result )
      (push
         (local (i lst)
            (while (brd (inc i 12))
               (push (brd i) lst) )
            (reverse lst) )
         result )
      (push
         (local (i lst)
            (while (brd (dec i 12))
               (push (brd i) lst) )
            (reverse lst) )
         result >

<de kMoves (i)
   (local (result)
      (setq result)
      (brdMove (sub1 i))
      (brdMove (sub i 13))
      (brdMove (sub i 12))
      (brdMove (sub i 11))
      (brdMove (add1 i))
      (brdMove (add i 13))
      (brdMove (add i 12))
      (brdMove (add i 11))
      (reverse result) >

<de mkBoard ()
   (local (c b r p)
      (setq c)
      (for (i 26 118)
         (when (brd i)
            (default c
               '(NIL T NIL T NIL T NIL T T NIL T NIL T NIL T NIL) )
            (put (brd i) 'occupant)
            (if (setq p (bpMoves i))
               (put (brd i) 'bPawn p) )
            (if (setq p (wpMoves i))
               (put (brd i) 'wPawn p) )
            (put (brd i) 'knight (nMoves i))
            (put (brd i) 'bishop (setq b (bMoves i)))
            (put (brd i) 'rook (setq r (rMoves i)))
            (put (brd i) 'queen (append r b))
            (put (brd i) 'king (kMoves i))
            (put (brd i) 'whAtt)
            (put (brd i) 'blAtt)
            (put (brd i) 'pawns)
            (put (brd i) 'color (pop c)) >

[??? (setq Types '(king queen rook bishop knight wPawn bPawn)) ???]

(de Blacks
   bRook-1    bKnight-1  bBishop-1  bQueen
   bKing      bBishop-2  bKnight-2  bRook-2
   bPawn-a    bPawn-b    bPawn-c    bPawn-d
   bPawn-e    bPawn-f    bPawn-g    bPawn-h )

(de Whites
   wPawn-a    wPawn-b    wPawn-c    wPawn-d
   wPawn-e    wPawn-f    wPawn-g    wPawn-h
   wRook-1    wKnight-1  wBishop-1  wQueen
   wKing      wBishop-2  wKnight-2  wRook-2 )

<mapc (append Blacks Whites)
   '((x)
      (put x 'type)
      (put x 'color)
      (put x 'position)
      (put x 'moves)
      (put x 'attacks)
      (put x 'moveFun) >

<de attkSave (x)
   (put piece 'attacks (cons x (get piece 'attacks)))
   (if (get piece 'color)
      (put x 'blAtt (cons piece (get x 'blAtt)))
      (put x 'whAtt (cons piece (get x 'whAtt))) >

<de moveSave (x)
   (put piece 'moves (cons x (get piece 'moves))) >

<de freeScan ()
   (while (and thread (null (setq enpiec (get (car thread) 'occupant))))
      (push (car thread) mov)
      (attkSave (pop thread)) >

<de transScan ()
   (while (and thread (null (get (car thread) 'occupant)))
      (attkSave (pop thread)) )
   (when thread
      (attkSave (car thread)) >

<de tryPawn (m)
   (when m
      (attkSave m)
      (and
         (get m 'occupant)
         (neq
            (get piece 'color)
            (get (get m 'occupant) 'color) )
         (moveSave m) >


[+ Move functions +]
<de king (moves)
   (while moves
      (attkSave (car moves))
      (and
         (null
            (get
               (car moves)
               (if (get piece 'color) 'whAtt 'blAtt) ) )
         (or
            (null (get (car moves) 'occupant))
            (neq
               (get piece 'color)
               (get (get (car moves) 'occupant) 'color) ) )
         (moveSave (car moves)) )
      (pop moves) >

<de queen (moves)
   (local (mov thread enpiec d)
      (off mov)
      (while moves
         (when (setq thread (pop moves))
            (freeScan)
            (when enpiec
               (if (eq (get enpiec 'color) (get piece 'color))
                  (progn
                     (setq d (length moves))
                     (attkSave (pop thread))
                     (when thread
                        (case (get enpiec 'type)
                           (wPawn
                              (and
                                 (not (get piece 'color))
                                 (or (eq d 2) (eq d 3))
                                 (attkSave (car thread)) ) )
                           (bPawn
                              (and
                                 (get piece 'color)
                                 (or (zerop d) (eq d 1))
                                 (attkSave (car thread)) ) )
                           (bishop
                              (when (lessp d 4)
                                 (transScan) ) )
                           (rook
                              (when (lessp 3 d)
                                 (transScan) ) ) ) ) )
                  (progn
                     (push (car thread) mov)
                     (attkSave (pop thread)) ) ) ) ) )
      (put piece 'moves mov) >

<de rook (moves)
   (local (mov thread enpiec)
      (off mov)
      (while moves
         (when (setq thread (pop moves))
            (freeScan)
            (when enpiec
               (if (eq (get enpiec 'color) (get piece 'color))
                  (progn
                     (attkSave (pop thread))
                     (and
                        thread
                        (eq rook (get enpiec 'type))
                        (transScan) ) )
                  (progn
                     (push (car thread) mov)
                     (attkSave (pop thread)) ) ) ) ) )
      (put piece 'moves mov) >

<de bishop (moves)
   (local (mov thread enpiec d)
      (off mov)
      (while moves
         (when (setq thread (pop moves))
            (freeScan)
            (when enpiec
               (if (eq (get enpiec 'color) (get piece 'color))
                  (progn
                     (setq d (length moves))
                     (attkSave (pop thread))
                     (when thread
                        (case (get enpiec 'type)
                           (wPawn
                              (and
                                 (not (get piece 'color))
                                 (or (eq d 2) (eq d 3))
                                 (attkSave (car thread)) ) )
                           (bPawn
                              (and
                                 (get piece 'color)
                                 (or (zerop d) (eq d 1))
                                 (attkSave (car thread)) ) ) ) ) )
                  (progn
                     (push (car thread) mov)
                     (attkSave (pop thread)) ) ) ) ) )
      (put piece 'moves mov) >

<de knight (moves)
   (while moves
      (attkSave (car moves))
      (if
         (or
            (null (get (car moves) 'occupant))
            (neq
               (get piece 'color)
               (get (get (car moves) 'occupant) 'color) ) )
         (moveSave (car moves)) )
      (pop moves) >

<de wPawn (moves)
   (tryPawn (pop moves))
   (tryPawn (pop moves))
   (when (null (get (car moves) 'occupant))
      (put (car moves) 'pawns
         (cons piece (get (car moves) 'pawns)) )
      (moveSave (pop moves))
      (and
         moves
         (null (get (car moves) 'occupant))
         (put (car moves) 'pawns
            (cons piece (get (car moves) 'pawns)) )
         (moveSave (car moves)) >

(define bPawn wPawn)

[Init the constant piece properties]
<local (l)
   (setq l '(
      rook knight bishop queen king bishop knight rook
      bPawn bPawn bPawn bPawn bPawn bPawn bPawn bPawn ) )
   (mapc Blacks
      '((x)
         (put x 'color T)
         (put x 'moveFun (getd (car l)))
         (put x 'type (pop l>

<local (l)
   (setq l '(
      wPawn wPawn wPawn wPawn wPawn wPawn wPawn wPawn
      rook knight bishop queen king bishop knight rook ) )
   (mapc Whites
      '((x)
         (put x 'color NIL)
         (put x 'moveFun (getd (car l)))
         (put x 'type (pop l>

[++ Init the empty board ++]
<de initBoard ()
   (mapc Board
      '((square)
         (put square 'blAtt)
         (put square 'whAtt)
         (put square 'occupant) >

[++ Retreat piece ++]
<de retreat ()
   (when (memq (get piece 'type) '(bPawn wPawn))
      (mapc (get piece 'moves)
         '((x)
            (put x 'pawns
               (delete piece (get x 'pawns)) ) ) ) )
   (put piece 'moves)
   (mapc (get piece 'attacks)
      (if (get piece 'color)
         '((x) (put x 'blAtt (delete piece (get x 'blAtt))))
         '((x) (put x 'whAtt (delete piece (get x 'whAtt)))) ) )
   (put piece 'attacks) >

[++ New generation of all field lists ++]
<de newGen (piece)
   (retreat)
   ((get piece 'moveFun)
      (get
         (get piece 'position)
         (get piece 'type) >

[++ Pick up a piece ++]
<de pick (piece)
   (unless (get piece 'position)
      (error "Not placed") )
   (local (square)
      (retreat)
      (setq square (get piece 'position))
      (put square 'occupant)
      (put piece 'position)
      (mapc (get square 'whAtt) newGen)
      (mapc (get square 'blAtt) newGen)
      (mapc (get square 'pawns) newGen)
      piece >

[Place a piece on the board]
<de place (piece square)
   (if (get piece 'position)
      (error "Not picked") )
   (if (get square 'occupant)
      (error "Occupied") )
   (put piece 'position square)
   (put square 'occupant piece)
   ((get piece 'moveFun)
      (get square (get piece 'type)) )
   (mapc (get square 'whAtt) newGen)
   (mapc (get square 'blAtt) newGen)
   (mapc (get square 'pawns) newGen)
   piece >

[++ Perform one move ++]
<de mov (from to)
   (unless (get from 'occupant)
      (error "No piece") )
   (place (pick (get from 'occupant)) to) >

[++ Set up game position ++]
<de setUp ()
   (initBoard)
   (local (Board)
      (mapc Blacks
         '((x)
            (place x (pop Board)) ) )
      (setq Board (nthcdr 32 Board))
      (mapc Whites
         '((x)
            (place x (pop Board)) ) ) )
   (mapc Blacks newGen)
   (mapc Whites newGen) >

[+++ Display board +++]
<setq bNames
   '((king . \K) (queen . \Q) (rook . \R)
         (bishop . \B) (knight . \N) (bPawn . \P)) >
<setq wNames
   '((king . \k) (queen . \q) (rook . \r)
         (bishop . \b) (knight . \n) (wPawn . \p)) >

<de display ()
   (local (Board line row square piece)
      (setq line "  +-----------------+")
      (prin2 line)
      (terpri)
      (setq row 9)
      (while Board
         (prin1 (dec row))
         (prin2 " | ")
         (reptn 8
            (setq square (pop Board))
            (if (setq piece (get square 'occupant))
               (putc
                  (cdr (assoc (get piece 'type)
                     (if (get piece 'color) bNames wNames) ) ) )
               (if (get square 'color)
                  (putc \-)
                  (space) ) )
            (space) )
         (putc \|)
         (terpri) )
      (prin2 line)
      (terpri)
      (prin2 "    a b c d e f g h")
      (terpri) >

<de init ()
   (setUp)
   (display) >

T
