[graf.l 27jun92]

<de closed (z)
   (equal (car z) (last z)) >

<de span (ph pv sh sv m f)
   (unless f
      (xchg ph sh)
      (xchg pv sv) )
   (local (h v n)
      (setq
         h (sub sh ph)
         v (sub sv pv)
         n (pythag (sub ph (car m)) (sub pv (cdr m))) )
      (if (and (zerop h) (zerop v))
         (if f 100 -100)
         (muldiv
            (mul
               (sign
                  (add
                     (muldiv h (sub pv (cdr m)) n)
                     (muldiv v (sub (car m) ph) n) ) )
               (sub (pythag h v) (mul2 n)) )
            100
            (mul2 n) >

<de arcb2 (ph pv sh sv h v d m r)
   (local (uv uh h1 v1 h2 v2 d1 d2)
      (setq
         uh (add (car m) (muldiv (sub h (car m)) r d))
         uv (add (cdr m) (muldiv (sub v (cdr m)) r d))
         h1 (div2 (add ph uh))
         v1 (div2 (add pv uv))
         h2 (div2 (add uh sh))
         v2 (div2 (add uv sv))
         d1 (pythag (sub h1 (car m)) (sub v1 (cdr m)))
         d2 (pythag (sub h2 (car m)) (sub v2 (cdr m))) )
      (if (lessp (dist (cons ph pv) (cons sh sv)) r)
         (list
            (bezier
               ph pv
               (add (car m) (muldiv (sub h1 (car m)) r d1))
               (add (cdr m) (muldiv (sub v1 (cdr m)) r d1))
               (add (car m) (muldiv (sub h2 (car m)) r d2))
               (add (cdr m) (muldiv (sub v2 (cdr m)) r d2))
               sh sv )
            (cons sh sv) )
         (nconc
            (arcb2 ph pv uh uv h1 v1 d1 m r)
            (arcb2 uh uv sh sv h2 v2 d2 m r) >

<de arcb1 (ph pv sh sv m r)
   (local (h v)
      (setq
         h (div2 (add ph sh))
         v (div2 (add pv sv)) )
      (arcb2 ph pv sh sv h v
         (pythag (sub h (car m)) (sub v (cdr m)))
         m r) >

<de arcBez (pa m pe f)
   (local (ph pv sh sv r res h v)
      (setq
         ph (car pa)
         pv (cdr pa)
         sh (car pe)
         sv (cdr pe)
         r
         (min
            (pythag (sub ph (car m)) (sub pv (cdr m)))
            (pythag (sub sh (car m)) (sub sv (cdr m))) ) )
      (unless (zerop r)
         (setq res (list pa))
         (while (lessp -10 (span ph pv sh sv m f))
            (if f
               (setq
                  h (add (car m) pv (minus (cdr m)))
                  v (add (cdr m) (car m) (minus ph)) )
               (setq
                  h (add (car m) (cdr m) (minus pv))
                  v (add (cdr m) ph (minus (car m))) ) )
            (nconc res (arcb1 ph pv h v m r))
            (setq  ph h  pv v) )
         (nconc res (arcb1 ph pv sh sv m r)) >

<de circBez (p q r s)
   (local (m b f n d)
      (and
         [(setq m (intsec p (normal q p) s (normal r s) t))]
         (setq
            b (midPt q r)
            f (midPt (midPt (midPt p q) b) (midPt b (midPt r s)))
            m (center p f s)
            n (distPt m f)
            d (div n 100) )
         (leq (abs (sub n (distPt m p))) d)
         (leq (abs (sub n (distPt m s))) d)
         (leq (abs (sub (distPt p f) (distPt f s))) d)
         (cons (rSyst m p q) m) >

[+ Check if zug is a hole in graf +]
<de isHole (z g)
   (find g
      (lambda (l)
         (and
            (neq l z)
            (inside (car z) (list l) 10000) >

<de secBez (n p q r s)
   (if (minusp (dec n))
      (sift
         (intsec pt1 pt2 p q)
         (intsec pt1 pt2 q r)
         (intsec pt1 pt2 r s) )
      (local (a b c d e f)
         (setq
            a (midPt p q)
            b (midPt q r)
            c (midPt r s)
            d (midPt a b)
            e (midPt b c)
            f (midPt d e) )
         (nconc
            (secBez n p a d f)
            (secBez n f e c s) >

[+ Intersect graf with a line +]
<de secGraf (g pt1 pt2)
   (mapcan g
      (lambda (lst)
         (local (l pt p)
            (setq l)
            (when (setq pt (pop lst))
               (while lst
                  (setq l
                     (nconc l
                        (if (pointp (car lst))
                           (when
                              (setq p
                                 (intsec pt1 pt2 pt (setq pt (pop lst))) )
                              (list p) )
                           (secBez 5
                              pt
                              (caar lst)
                              (cdr (pop lst))
                              (setq pt (pop lst)) ) ) ) ) ) )
            l >

[+ Reverse a zug +]
<de anti (z)
   (local (lst)
      (setq lst)
      (mapc z
         (lambda (x)
            (push
               (if (pointp x)
                  x
                  (cons (cdr x) (car x)) )
               lst ) ) )
      lst >

[+ Check for cyclonality +]
(setq :c-scl (sqr 10000))

<de area (lst)
   (local (n pt x)
      (zero n)
      (setq pt (pop lst))
      (while (setq x (pop lst))
         (if (pointp x)
            (setq
               n (add n
                  (sub
                     (muldiv (car pt) (cdr x) #:c-scl)
                     (muldiv (cdr pt) (car x) #:c-scl) ) )
               pt x )
            (setq
               n (add n
                  (sub
                     (muldiv (car pt) (cdar x) #:c-scl)
                     (muldiv (cdr pt) (caar x) #:c-scl) )
                  (sub
                     (muldiv (caar x) (cddr x) #:c-scl)
                     (muldiv (cdar x) (cadr x) #:c-scl) ) )
               pt (cdr x) ) ) )
      n >

<de cyclon (lst)
   (minusp (area lst)) >

[+ Low-level bezier-intersections +]
<de splitBez (pt p q r s)
   (local (a b c d e f m)
      (setq
         a (midPt p q)
         b (midPt q r)
         c (midPt r s)
         d (midPt a b)
         e (midPt b c)
         f (midPt d e)
         m (div (dist p s) 8) )
      (cond
         ((nearPt pt p m)
            (list (list pt) (list pt (cons q r))) )
         ((nearPt pt f m)
            (list (list (cons a d) pt) (list pt (cons e c))) )
         ((nearPt pt s m)
            (list (list (cons q r) pt) (list pt)) )
         (T
            (if (lessp (dist p pt) (dist pt s))
               (local (m w x)
                  (setq
                     m (midPt e c)
                     w (midPt
                        (midPt m (midPt f e))
                        (midPt m (midPt c s)) )
                     x (bezier
                        (car pt) (cdr pt)
                        (car f) (cdr f)
                        (car w) (cdr w)
                        (car s) (cdr s) ) )
                  [(if (nearPt pt (car x))
                     (BREAK 1) )]
                  (list
                     (list pt)
                     (list pt x) ) )
               (local (m v x)
                  (setq
                     m (midPt a d)
                     v (midPt
                        (midPt m (midPt p a))
                        (midPt m (midPt d f)) )
                     x (bezier
                        (car p) (cdr p)
                        (car v) (cdr v)
                        (car f) (cdr f)
                        (car pt) (cdr pt) ) )
                  [(if (nearPt (cdr x) pt)
                     (BREAK 2) )]
                  (list
                     (list x pt)
                     (list pt) >

[+ Connect two grafs +]
<de chain (g1 g2)
   (local (x)
      (mapc g2
         (lambda (l2)
            (cond
               ((setq x
                     (find g1
                        (lambda (l1) (nearPt (last l1) (car l2))) ) )
                  (nconc x (cdr l2)) )
               ((setq x
                     (find g1
                        (lambda (l1) (nearPt (last l1) (last l2))) ) )
                  (nconc x (cdr (anti l2))) )
               (T (setq g1 (nconc1 g1 l2))) ) ) )
      (map g1
         (lambda (g)
            (while
               (or
                  (and
                     (setq x
                        (find (cdr g)
                           (lambda (l)
                              (nearPt (last (car g)) (car l)) ) ) )
                     (nconc (car g) (cdr x)) )
                  (and
                     (setq x
                        (find (cdr g)
                           (lambda (l)
                              (nearPt (last (car g)) (last l))) ) )
                     (nconc (car g) (cdr (anti x))) ) )
               (cut x g) ) ) )
      g1 >

[+ Clean up graf zug +]
<de sauber (g)
   (local (res p pt x)
      (mapcan g
         (lambda (z)
            (when z
               (setq res (setq p (chop 1 z)))
               (while z
                  (setq pt (car p))
                  (if (pointp (setq x (pop z)))
                     (when (farPt pt x)
                        (link p x) )
                     (cond
                        ((nearPt (car x) (cdr x))
                           (when (farPt pt (car x))
                              (link p (car x)) ) )
                        ((nearPt pt (car x))
                           (link p (cdr x)) )
                        ((nearPt (cdr x) (car z))
                           (link p (car x))
                           (link p (pop z)) )
                        (T
                           (link p x)
                           (link p (pop z)) ) ) ) )
               (when (cdr res)
                  (list res) >

T
