[boss.l 08jan93]

(setq App 'idle)
(off Apps Dlg Help)
(zero :last :lastV :lastH :dbl)

(setq :point '(:h . :v)) [Re-usable point]

<de getEvent ()
   (if (eq #mouseDown (ev-what Event))
      (setq
         :last (ev-when Event)
         :lastV (word (add 10 Event))
         :lastH (word (add 12 Event)) )
      (and
         Help
         (eq #keyDown (ev-what Event))
         (eq #helpKey (bitAnd #charCodeMask (ev-message Event)))
         (Help) ) )
   (GetNextEvent #everyEvent Event) >

<de doIdle ()
   (local (win)
      (catch 'error
         (may idle App)
         (GetMouse :point)
         (LocalToGlobal :point)
         (or
            (eq #inSysWindow (FindWindow :point win))
            (may setCursor App :point)
            (SetCursor Arrow) >

<de doEvent ()
   (catch 'error
      (case (ev-what Event)
         (#mouseDown
            (if
               (or
                  (lessp (ptr #DoubleTime) (sub (ev-when Event) :last))
                  (lessp 3 (abs (sub :lastV (word (add 10 Event)))))
                  (lessp 3 (abs (sub :lastH (word (add 12 Event))))) )
               (progn
                  (zero :dbl)
                  (doMouseDown) )
               (case (mod (inc :dbl) 3)
                  (1 (doDouble))
                  (2 (doTriple))
                  (T (doMouseDown)) ) ) )
         (#mouseUp (doMouseUp))
         (#keyDown (doKeyDown))
         (#keyUp (doKeyUp))
         (#autoKey (doAutoKey))
         (#updateEvt (doUpdate))
         (#diskEvt (doDiskEvt))
         (#activateEvt (doActivate))
         (#networkEvt (doNetworkEvt))
         (#driverEvt (doDriverEvt))
         (#app1Evt (doApp1Evt))
         (#app2Evt (doApp2Evt))
         (#app3Evt (doApp3Evt))
         (#app4Evt )
            >

<de run (Done)
   (repeat
      (SystemTask)
      (if (getEvent)
         (or
            (console Event)
            (doEvent) )
         (doIdle) )
      (when Dlg (DisposDialog Dlg) (off Dlg))
      Done >

<de delay (n)
   (inc n (TickCount))
   (while (lessp (TickCount) n)
      (SystemTask) >

<de doMouseDown ()
   (local (pt f w)
      (setq pt (ev-where Event))
      (case (setq f (FindWindow pt w))
         (#inMenuBar
            (may select App)
            (doAble MBar)
            (doMenu MBar pt) )
         (#inSysWindow
            (SystemClick Event w) )
         (#inContent
            (may content (GetWRefCon w) pt) )
         (#inDrag
            (DragWindow w pt (rect (add 6 ScreenBits))) )
         (#inGrow
            (may grow (GetWRefCon w) pt) )
         (#inGoAway
            (when (TrackGoAway w pt)
               (do close (GetWRefCon w)) ) )
         ((#inZoomIn #inZoomOut)
            (when (TrackBox w pt f)
               (may zoom (GetWRefCon w) f) >

<de doDouble ()
   (or
      (may double App)
      (doMouseDown)  >

<de doTriple ()
   (or
      (may triple App)
      (doMouseDown)  >

<de doMouseUp ()
   (may mouseUp App) >

<de doKeyDown ()
   (local (m c)
      (setq
         m (ev-modifiers Event)
         c (bitAnd #charCodeMask (ev-message Event)) )
      (if (zerop (bitAnd #cmdKey m))
         (may keyDown App c m)
         (progn
            (may select App)
            (doAble MBar)
            (doKey MBar c) >

<de doKeyUp ()
   (may keyUp App
      (bitAnd #charCodeMask (ev-message Event))
      (ev-modifiers Event) >

<de doAutoKey ()
   (local (m c)
      (setq
         m (ev-modifiers Event)
         c (bitAnd #charCodeMask (ev-message Event)) )
      (if (zerop (bitAnd #cmdKey m))
         (may autoKey App c m)
         (progn
            (may select App)
            (doAble MBar)
            (doKey MBar c) >

<de doUpdate ()
   (do update (GetWRefCon (ev-message Event))) >

<de doDiskEvt ()
   (may diskEvt App (ev-message Event)) >

<de doActivate ()
   (local (obj)
      (setq obj (GetWRefCon (ev-message Event)))
      (if (zerop (bitAnd #activeFlag (ev-modifiers Event)))
         (may deActivate obj)
         (progn
            (when (and (memq obj Apps) (neq obj App))
               (when (memq App Apps)
                  (may end App) )
               (unless (eq (may classify obj) (may classify App))
                  (may cleanUp App)
                  (may setUp obj) )
               (may begin (setq App obj)) )
            (may activate obj) >

<de doNetworkEvt ()
   (may networkEvt App (ev-message Event)) >

<de doDriverEvt ()
   (may driverEvt App (ev-message Event)) >

<de doApp1Evt ()
   (may app1Evt App (ev-message Event)) >

<de doApp2Evt ()
   (may app2Evt App (ev-message Event)) >

<de doApp3Evt ()
   (may app3Evt App (ev-message Event)) >


<de start (obj)
   (push obj Apps) >

<de stop (obj)
   (cut obj Apps)
   (unless Apps
      (may cleanUp App)
      (may setUp (setq App 'idle))
      (may begin App) >

<de Quit ()
   (if (find Apps '((obj) (not (do close obj))))
      (progn (run) NIL)
      (progn (cleanUp) T) >

<de busy (n . :body)
   (SetCursor (ptr (GetCursor #watchCursor)))
   (mapc :body eval)
   (gc n) >

T
