[docWin.l 30sep92]

<de fit-h (pt h)
   (min h (sub (word (add 12 ScreenBits)) (car pt) 20)) >

<de fit-v (pt v)
   (min v (sub (word (add 10 ScreenBits)) (cdr pt) 20)) >

<de viewRect (win)
   (local (r)
      (setq r (portRect win))
      (rplaca (cdr r)
         (sub (right r) #(sub1 SBarWidth)) )
      (rplacd (cdr r)
         (sub (bottom r) #(sub1 SBarWidth)) )
      r >

<de hSBarRect (win)
   (local (r)
      (setq r (portRect win))
      (cons2
         (sub1 (left r))
         (sub (bottom r) #(sub1 #SBarWidth))
         (sub (right r) #(sub2 #SBarWidth))
         (add1 (bottom r)) >

<de vSBarRect (win)
   (local (r)
      (setq r (portRect win))
      (cons2
         (sub (right r) #(sub1 #SBarWidth))
         (sub1 (top r))
         (add1 (right r))
         (sub (bottom r) #(sub2 #SBarWidth)) >

<de sizeBoxRect (win)
   (local (r)
      (setq r (portRect win))
      (cons2
         (sub (right r) #(sub1 #SBarWidth))
         (sub (bottom r) #(sub1 #SBarWidth))
         (add1 (right r))
         (add1 (bottom r)) >

[++ Calc. ZoomWindow size ++]
<de maxZoom (obj)
   (local (p)
      (with obj
         (setq p (ptr (ptr (add 130 (slot winPtr)))))
         (word (add 10 p) [std.left]
            (max
               3
               (sub
                  (word (add 14 p)) [std.right]
                  (add (slot size-h) #(sub1 #SBarWidth)) ) ) )
         (word (add 12 p) [std.bottom]
            (min
               (word (add 10 ScreenBits))
               (add
                  (word (add 8 p)) [std.top]
                  (add (slot size-v) #(sub1 #SBarWidth)) >

[+++ Invalidate window's scroll bars and size box +++]
<de invalSS (win)
   (InvalRect (vSBarRect win))
   (InvalRect (hSBarRect win))
   (InvalRect (sizeBoxRect win)) >

[+++ Set the scroll bars +++]
<de fixSBars (obj)
   (local (ctl r)
      (with obj
         (localPort (slot winPtr)
            (PenNormal)
            (setq
               ctl (slot vSBar)
               r (vSBarRect Port) )
            (HideControl ctl)
            (MoveControl ctl (left r) (top r))
            (SizeControl ctl #SBarWidth (sub (bottom r) (top r)))
            (ShowControl ctl)
            (ValidRect r)
            (setq
               ctl (slot hSBar)
               r (hSBarRect Port) )
            (HideControl ctl)
            (MoveControl ctl (left r) (top r))
            (SizeControl ctl (sub (right r) (left r)) #SBarWidth)
            (ShowControl ctl)
            (ValidRect r)
            (DrawGrowIcon Port)
            (ValidRect (sizeBoxRect Port)) >

<de scrol1 (h v)
   (local (r rgn)
      (setq r (viewRect Port))
      (setq rgn (NewRgn))
      (ScrollRect r h v rgn)
      (SetOrigin
         (sub (left r) h)
         (sub (top r) v) )
      (OffsetRgn (UpdateRgn Port) h v)
      (OffsetRgn rgn (minus h) (minus v))
      (UnionRgn rgn :updt :updt)
      (fixSBars :obj)
      (do adjSBars :obj)
      (DisposeRgn rgn) >

<de scrol2 (cntl part)
   (local (r val d)
      (setq
         r (viewRect Port)
         val (GetCtlValue cntl)
         d (sub (GetCtlMax cntl) (GetCtlValue cntl)) )
      (if (eq cntl (get :obj 'vSBar))
         <case part
            (#inUpButton
               (scrol1 0 (min val :scrl)) )
            (#inDownButton
               (scrol1 0 (minus (min d :scrl))) )
            (#inPageUp
               (scrol1
                  0
                  (min
                     val
                     (round (sub (bottom r) (top r)) :scrl) ) ) )
            (#inPageDown
               (scrol1
                  0
                  (minus
                     (min
                        d
                        (round (sub (bottom r) (top r)) :scrl) >
         <case part
            (#inUpButton
               (scrol1 (min val :scrl) 0) )
            (#inDownButton
               (scrol1 (minus (min d :scrl)) 0) )
            (#inPageUp
               (scrol1
                  (min
                     val
                     (round (sub (right r) (left r)) :scrl) )
                  0 ) )
            (#inPageDown
               (scrol1
                  (minus
                     (min
                        d
                        (round (sub (right r) (left r)) :scrl) ) )
                  0 > >


(object docWin window)

<to T (obj pos h v s r f)
   (default
      pos (60 . 40)
      h 900
      v 700
      s "Untitled"
      r (cons2 0 0 h v) )
   (local (win)
      (setq
         r (cons
            (car r)
            (cons
               (add (left r) (fit-h pos (sub (right r) (left r))))
               (add (top r) (fit-v pos (sub (bottom r) (top r)))) ) )
         win (NewCWindow
            NIL
            (cons
               pos
               (cons
                  (add
                     (car pos)
                     (sub (right r) (left r))
                     #(sub1 #SBarWidth) )
                  (add
                     (cdr pos)
                     (sub (bottom r) (top r))
                     #(sub1 #SBarWidth) ) ) )
            s T #zoomDocProc -1 T obj ) )
      (SetPort win)
      (SetOrigin
         (if f
            (div2 (sub h (right r) (left r)))
            (left r) )
         (if f
            (div2 (sub v (bottom r) (top r)))
            (top r) ) )
      (with obj
         (slot winPtr win)
         (slot size-h h)
         (slot size-v v)
         (slot view (viewRect win))
         (slot hSBar
            (NewControl
               win
               (hSBarRect win)
               NIL T 0 0 1000 #scrollBarProc ) )
         (slot vSBar
            (NewControl
               win
               (vSBarRect win)
               NIL T 0 0 1000 #scrollBarProc ) ) )
      (do adjSBars obj)
      (maxZoom obj) >

<to adjSBars (obj)
   (local (r)
      (with obj
         (setq r (viewRect (slot winPtr)))
         (SetCtlMax (slot hSBar)
            (sub
               (slot size-h)
               (sub (right r) (left r)) ) )
         (SetCtlValue (slot hSBar) (left r))
         (SetCtlMax (slot vSBar)
            (sub
               (slot size-v)
               (sub (bottom r) (top r)) ) )
         (SetCtlValue (slot vSBar) (top r)) >

<to grow (obj pt n)
   (default n 1)
   (local (h v siz)
      (localPort (get obj 'winPtr)
         (setq
            h (get obj 'size-h)
            v (get obj 'size-v)
            siz (GrowWindow Port pt
               (cons2 100 100
                  (add h #SBarWidth)
                  (add v #SBarWidth) ) ) )
         (invalSS Port)
         (EraseRect (sizeBoxRect Port))
         (SizeWindow Port
            (add #(sub1 SBarWidth)
               (round (sub (low siz) #(sub1 SBarWidth)) n) )
            (add #(sub1 SBarWidth)
               (round (sub (high siz) #(sub1 SBarWidth)) n) )
            T )
         (invalSS Port)
         (when
            (or
               (lessp h (right (viewRect Port)))
               (lessp v (bottom (viewRect Port))) )
            (local (r)
               (setq r (portRect Port))
               (InvalRect r)
               (SetOrigin
                  (limit
                     (sub h (sub (right r) (left r)
                           #(sub1 #SBarWidth) ) )
                     0 (left r) )
                  (limit
                     (sub v (sub (bottom r) (top r) #(sub1 #SBarWidth)))
                     0 (top r) ) ) ) )
         (put obj 'view (viewRect Port))
         (fixSBars obj)
         (do adjSBars obj) >

<to zoom (obj n)
   (local (h v)
      (localPort (get obj 'winPtr)
         (setq
            h (get obj 'size-h)
            v (get obj 'size-v) )
         (invalSS Port)
         (ZoomWindow Port n)
         (invalSS Port)
         (when
            (or
               (lessp h (right (viewRect Port)))
               (lessp v (bottom (viewRect Port))) )
            (local (r)
               (setq r (portRect Port))
               (InvalRect r)
               (SetOrigin
                  (sub h (sub (right r) (left r)
                        #(sub1 #SBarWidth) ) )
                  (sub v (sub (bottom r) (top r)
                        #(sub1 #SBarWidth) ) ) ) ) )
         (put obj 'view (viewRect Port))
         (fixSBars obj)
         (do adjSBars obj) >

<to scroll (:obj cntl part pt :scrl)
   (default :scrl 1)
   (with :obj
      (localPort (slot winPtr)
         (PenNormal)
         (if (eq part #inThumb)
            (unless (zerop (TrackControl cntl pt))
               (do inval :obj)
               (SetOrigin
                  (round (GetCtlValue (slot hSBar)) :scrl)
                  (round (GetCtlValue (slot vSBar)) :scrl) )
               (fixSBars :obj)
               (do adjSBars :obj) )
            (local (:updt)
               (setq :updt (NewRgn))
               (TrackControl cntl pt scrol2)
               (InvalRgn :updt)
               (DisposeRgn :updt) ) )
         (slot view (viewRect Port)) >

<to update (obj :foo)
   (from window update obj
      '((obj)
         (DrawControls Port)
         (DrawGrowIcon Port)
         (and :foo (localClip (get obj 'view) (:foo obj))) >

<to activate (obj)
   (with obj
      (SetPort (slot winPtr))
      (PenNormal)
      (DrawGrowIcon Port)
      (HiliteControl (slot vSBar) 0)
      (HiliteControl (slot hSBar) 0) >

<to deActivate (obj)
   (with obj
      (localPort (slot winPtr)
         (PenNormal)
         (DrawGrowIcon Port)
         (HiliteControl (slot vSBar) 255)
         (HiliteControl (slot hSBar) 255) >

<to change (obj h v r)
   (default r (cons2 0 0 h v))
   (local (pt dh dv)
      (with obj
         (localPort (slot winPtr)
            (slot size-h h)
            (slot size-v v)
            (invalSS Port)
            (EraseRect (sizeBoxRect Port))
            (setq
               pt (LocalToGlobal (car (portRect Port)))
               dh (sub (right r) (left r))
               dv (sub (bottom r) (top r)) )
            (SizeWindow Port
               (add (fit-h pt (min h dh)) #(sub1 #SBarWidth))
               (add (fit-v pt (min v dv)) #(sub1 #SBarWidth))
               T )
            (invalSS Port)
            (SetOrigin
               (limit (left r) 0 (sub h dh))
               (limit (top r) 0 (sub v dv)) )
            (slot view (viewRect Port))
            (do inval obj)
            (maxZoom obj)
            (fixSBars obj)
            (do adjSBars obj) >

T
