[txtWin.l 21jun92]

[++++++
<de index-line (obj n)
   (local (i p)
      (with obj
         (zero i)
         (for (p (HLock (TEGetText (slot teRec))) (add n p))
            (when (eq ^M (byte p))
               (inc i) ) )
         (HUnlock (slot teRec))
         i >
   (local (i p q)
      (zero i)
      (setq
         p (add #(add2 96) (HLock (slot teRec)))
         q (add p (mul2 (te-nlines (ptr (slot teRec))))) )
      (while (and (lessp p q) (leq (word p) n))
         (inc i)
         (inc p 2) )
      (HUnlock (slot teRec))
      i >
++++++]

<de selStart (obj)
   (with obj
      (txLine
         (slot teRec)
         (te-selStart (ptr (slot teRec))) >
      [(index-line obj (te-selStart (ptr (slot teRec)))) >]

<de selEnd (obj)
   (with obj
      (txLine
         (slot teRec)
         (te-selEnd (ptr (slot teRec))) >
      [(index-line obj (te-selEnd (ptr (slot teRec)))) >]

<de txPos (h v)
   (do refresh obj)
   (slot pos-h h)
   (slot pos-v v)
   (te-destRect (ptr (slot teRec))
      (cons2
         (add 4 h)
         (add 4 v)
         (add (slot size-h) h)
         (add (slot size-v) v) >

<de txView (obj)
   (with obj
      (te-viewRect
         (ptr (slot teRec))
         (InsetRect (viewRect Port) 4 4) >

<de txScroll (h v)
   (TEScroll h v (slot teRec))
   (slot pos-h (add h (slot pos-h)))
   (slot pos-v (add v (slot pos-v)))
   (fixSBars obj)
   (do adjSBars obj) >

<de scrollText (cntl part)
   (local (r val d)
      (setq
         r (viewRect Port)
         val (GetCtlValue cntl)
         d (sub (GetCtlMax cntl) (GetCtlValue cntl)) )
      (with obj
         (if (eq cntl (get obj 'vSBar))
            <case part
               (#inUpButton
                  (txScroll 0 (min val (inc speed speedInc))) )
               (#inDownButton
                  (txScroll 0 (minus (min d (inc speed speedInc)))) )
               (#inPageUp
                  (txScroll
                     0
                     (min
                        val
                        (sub (bottom r) (top r)) ) ) )
               (#inPageDown
                  (txScroll
                     0
                     (minus
                        (min
                           d
                           (sub (bottom r) (top r)) >
            <case part
               (#inUpButton
                  (txScroll (min val (inc speed speedInc)) 0) )
               (#inDownButton
                  (txScroll (minus (min d (inc speed speedInc))) 0) )
               (#inPageUp
                  (txScroll
                     (min
                        val
                        (sub (right r) (left r)) )
                     0 ) )
               (#inPageDown
                  (txScroll
                     (minus
                        (min
                           d
                           (sub (right r) (left r)) ) )
                     0 > >

<de autoScroll (pos)
   (local (obj lhgt vrct hs vs)
      (with (setq obj (front))
         (setq
            lhgt (slot height)
            vrct (te-viewRect (ptr (slot teRec)))
            hs (slot hsBar)
            vs (slot vsBar) )
         (cond
            ((lessp (cdr pos) (top vrct))
               (when (plusp (GetCtlValue vs))
                  (txScroll 0 lhgt) ) )
            ((lessp (bottom vrct) (cdr pos))
               (when (lessp (GetCtlValue vs) (GetCtlMax vs))
                  (txScroll 0 (minus lhgt)) ) )
            ((lessp (car pos) (left vrct) )
               (when (plusp (GetCtlValue hs))
                  (txScroll lhgt 0) ) )
            ((lessp (right vrct) (car pos))
               (when (lessp (GetCtlValue hs) (GetCtlMax hs))
                  (txScroll (minus lhgt) 0) >

<de clikFun ()
   (autoScroll (GetMouse))
   T >

<de teProp (obj)
   (local (l)
      (with obj
         (setq l
            (TEGetStyle
               (sub1 (te-selStart (ptr (slot teRec))))
               (slot teRec) ) )
         (slot height (pop l))
         (slot ascent (pop l))
         (slot font (pop l))
         (slot face (pop l))
         (slot size (pop l))
         (slot color (pop l)) >


(object txtWin docWin)

<to T (obj pos h1 h2 v nm)
   (with obj
      (slot pos-h 0)
      (slot pos-v 0)
      (from docWin T obj pos h2 v nm (cons2 0 0 h1 v))
      (TextFont 4) [Monaco]
      (TextSize 9)
      (slot teRec
         (TENew
            (cons2 4 4 (sub h2 4) (sub v 4))
            (cons2 4 4 (sub h1 4) (sub v 4)) ) )
      (te-clikLoop (ptr (slot teRec)) clikFun)
      (teProp obj) >

<to adjSBars (obj)
   (local (r)
      (with obj
         (setq r (viewRect (slot winPtr)))
         (SetCtlMax (slot hSBar)
            (sub (slot size-h) (right r)) )
         (SetCtlValue (slot hSBar) (minus (slot pos-h)))
         (SetCtlMax (slot vSBar)
            (sub (slot size-v) (bottom r)) )
         (SetCtlValue (slot vSBar) (minus (slot pos-v))) >

<to close (obj)
   (TEDispose (get obj 'teRec))
   (from docWin close obj) >

<to begin (obj)
   (TEActivate (get obj 'teRec)) >

<to end (obj)
   (TEDeactivate (get obj 'teRec)) >

<to idle (obj)
   (TEIdle (get obj 'teRec)) >

[+ Receive update event +]
<to update (obj)
   (from docWin update obj
      '(()
         (TEUpdate (portRect Port) (get obj 'teRec)) >

<to grow (obj pt)
   (local (h v siz)
      (with obj
         (localPort (slot winPtr)
            (setq
               h (slot size-h)
               v (slot size-v)
               siz (GrowWindow Port pt
                  (cons2 100 100 (add h SBarWidth) (add v SBarWidth)) ) )
            (invalSS Port)
            (EraseRect (sizeBoxRect Port))
            (SizeWindow Port (low siz) (high siz) T)
            (invalSS Port)
            (when
               (or
                  (lessp
                     (add h (slot pos-h))
                     (right (viewRect Port)) )
                  (lessp
                     (add v (slot pos-v))
                     (bottom (viewRect Port)) ) )
               (txPos
                  (max
                     (slot pos-h)
                     (sub (right (viewRect Port)) h) )
                  (max
                     (slot pos-v)
                     (sub (bottom (viewRect Port)) v) ) ) )
            (do refresh obj)
            (EraseRect (portRect Port))
            (fixSBars obj)
            (do adjSBars obj)
            (txView obj) >

<to zoom (obj n)
   (local (h v)
      (with obj
         (localPort (slot winPtr)
            (setq
               h (slot size-h)
               v (slot size-v) )
            (invalSS Port)
            (ZoomWindow Port n)
            (invalSS Port)
            (when
               (or
                  (lessp
                     (add h (slot pos-h))
                     (right (viewRect Port)) )
                  (lessp
                     (add v (slot pos-v))
                     (bottom (viewRect Port)) ) )
               (txPos
                  (max
                     (slot pos-h)
                     (sub (right (viewRect Port)) h) )
                  (max
                     (slot pos-v)
                     (sub (bottom (viewRect Port)) v) ) ) )
            (do refresh obj)
            (EraseRect (portRect Port))
            (fixSBars obj)
            (do adjSBars obj)
            (txView obj) >

<to scroll (obj cntl part pt)
   (with obj
      (localPort (slot winPtr)
         (if (eq part #inThumb)
            (unless (zerop (TrackControl cntl pt))
               (txPos
                  (minus (GetCtlValue (slot hSBar)))
                  (minus (GetCtlValue (slot vSBar))) )
               (fixSBars obj)
               (do adjSBars obj) )
            (local (speed speedInc)
               (zero speed)
               (setq speedInc 1)
               (TrackControl cntl pt scrollText) ) )
         (txView obj) >

<to adjust (obj)
   (local (teH v1 v2)
      (with obj
         (setq
            teH (slot teRec)
            v1 (slot size-v)
            v2 (add #(mul2 4) (mul (slot height) (te-nLines (ptr teH)))) )
         (when (lessp v1 v2)
            (slot size-v v2)
            (txPos (slot pos-h) (sub (slot pos-v) (sub v2 v1)))
            (do adjSBars obj)
            (maxZoom obj) >

<to touch (obj)
   (local (n)
      (with obj
         (setq n (selStart obj))
         (unless
            (and
               (slot dirty)
               (leq (slot dirty) n) )
            (slot dirty n) >

T
