[asm.l 10oct92]

(off PC Range)

<de org (n s)
   (when PC
      (setq Range
         (nconc1 Range PC) )
      (prHex PC)
      (prLine ";") )
   (when n
      ((if PC nconc setq) Range (list n))
      (prHex n)
      (when s
         (prin2 " ")
         (prin2 s) )
      (terpri) )
   (setq PC n) >

<de asmEnd ()
   (org) >

<de pass (Asm)
   (while Asm
      (eval
         (cond
            ((pairp (car Asm))
               (pop Asm) )
            ((assoc (car Asm) InSet)
               (cdr (assoc (pop Asm) InSet)) )
            ((assoc (car Asm) AsTab)
               (cdr (assoc (pop Asm) AsTab)) )
            (T
               (error
                  ((if (symbolp (car Asm)) pname format) (car Asm))
                  " - Bad instruction" >

<de asm lst
   (local (Pass)
      (local (PC)
         (off Pass)
         (pass lst) )
      (on Pass)
      (pass lst) >

<de hiByte (n)
   (bitAnd 0FF (bitr 8 n)) >

<de loByte (n)
   (bitAnd 0FF n) >

<de rom (b)
   (unless (lessp -1 (sub PC RomStart) RomSize)
      (error "PC out of range") )
   (byte (add Rom (sub PC RomStart)) b)
   (inc PC) >

<de rom2 (w)
   (rom (hiByte w))
   (rom (loByte w)) >

<de defLbl (:x n)
   (when (funp (value :x))
      (prin2 "Overwriting function ")
      (print :x) )
   (record :x)
   (set :x n) >

<de asByte (x)
   (if (numberp x)
      (rom x)
      (mapc x
         '((c)
            (if (minusp c)
               (reptn (minus c) (rom 32))
               (rom c) >

<de AsTab
   (byte asByte (eval (pop Asm)))
   (- defLbl (pop Asm) PC) >

T
