[asm51.l 10oct92]

(meta  \, comma  \@ ind  \$ imm  \+ add  \/ cpl)

(de Regs  R0 R1 R2 R3 R4 R5 R6 R7)

<de asmVal (:x)
   (if Pass (eval :x) 0) >

<de adrErr (:x)
   (print :x)
   (error "Bad addressing mode") >

<de parseArg (f)
   (and f (neq 'comma (pop Asm)) (error "Missing Comma"))
   (local (:x)
      (case (setq :x (pop Asm))
         (A '(A))
         (C '(C))
         (AB '(AB))
         (DPTR '(DPTR))
         (@
            (case (setq :x (pop Asm))
               (DPTR '(-DPTR))
               (A
                  (unless (eq '+ (pop Asm))
                     (adrErr :x) )
                  (case (pop Asm)
                     (DPTR '(-A-DPTR))
                     (PC '(-A-PC))
                     (T (adrErr :x)) ) )
               (R0 '(@ . 0))
               (R1 '(@ . 1))
               (T (adrErr :x)) ) )
         (/ (cons :x (asmVal (pop Asm))))
         ($ (cons :x (asmVal (pop Asm))))
         (T [n or Rn]
            (cond
               ((memq :x Regs)
                  (cons 'R (index :x Regs)) )
               ((and (pairp :x) (numberp (car :x)))
                  (cons 'D (add (car :x) (eval (cdr :x)))) )
               ((numberp (setq :x (asmVal :x)))
                  (cons 'D :x) )
               (T (adrErr :x)) >

<de relAdr (d)
   (rom
      (if Pass
         (progn
            (setq d (sub d PC 1))
            (unless (leq -128 d 127)
               (error
                  "Jump out of range by "
                  (format (sub d (if (minusp d) -128 127))) ) )
            d )
         0 >

<de absAdr (op d)
   (local (p)
      (setq p (add2 PC))
      (if Pass
         (progn
            (unless (eq (bitAnd 0F800 p) (bitAnd 0F800 d))
               (error "Bad absolute jump") )
            (rom (bitOr op (bitAnd 0E0 (bitr 3 d))))
            (rom d) )
         (progn (rom op) (rom 0)) >

<de doAsm (lst)
   (local (x)
      (if (setq x (assoc M lst))
         (eval (cdr x))
         (adrErr M) >

<de asm1 lst
   (local (A M)
      (setq
         A (parseArg)
         M (pop A) )
      (doAsm lst) >

<de asm2 lst
   (local (A1 A2 M)
      (setq
         A1 (parseArg)
         A2 (parseArg T)
         M (cons (pop A1) (pop A2)) )
      (doAsm lst) >

<de asm3 lst
   (local (A A1 A2 M)
      (setq
         A (parseArg)
         A1 (parseArg T)
         A2 (parseArg T)
         M (cons (pop A) (cons (pop A1) (pop A2))) )
      (doAsm lst) >

<de InSet
   (MOV asm2
      ((A . R) rom (add 0E8 A2))
      ((R . A) rom (add 0F8 A1))
      ((A . @) rom (add 0E6 A2))
      ((@ . A) rom (add 0F6 A1))
      ((A . D) progn (rom 0E5) (rom A2))
      ((D . A) progn (rom 0F5) (rom A1))
      ((A . $) progn (rom 074) (rom A2))
      ((R . $) progn (rom (add 078 A1)) (rom A2))
      ((@ . $) progn (rom (add 076 A1)) (rom A2))
      ((D . $) progn (rom 075) (rom A1) (rom A2))
      ((R . D) progn (rom (add 0A8 A1)) (rom A2))
      ((D . R) progn (rom (add 088 A2)) (rom A1))
      ((D . @) progn (rom (add 086 A2)) (rom A1))
      ((@ . D) progn (rom (add 0A6 A1)) (rom A2))
      ((D . D) progn (rom 085) (rom A2) (rom A1))
      ((DPTR . $) progn (rom 090) (rom2 A2))
      ((C . D) progn (rom 0A2) (rom A2))
      ((D . C) progn (rom 092) (rom A1)) )
   (MOVC asm2
      ((A . -A-DPTR) rom 093)
      ((A . -A-PC) rom 083) )
   (MOVX asm2
      ((A . @) rom (add 0E2 A2))
      ((@ . A) rom (add 0F2 A1))
      ((A . -DPTR) rom 0E0)
      ((-DPTR . A) rom 0F0) )
   (XCH asm2
      ((A . R) rom (add 0C8 A2))
      ((A . D) progn (rom 0C5) (rom A2))
      ((A . @) rom (add 0C6 A2)) )
   (XCHD asm2 ((A . @) rom (add 0D6 A2)))
   (SWAP asm1 (A rom 0C4))
   (PUSH asm1 (D progn (rom 0C0) (rom A)))
   (POP asm1 (D progn (rom 0D0) (rom A)))
   (ANL asm2
      ((A . R) rom (add 058 A2))
      ((A . @) rom (add 056 A2))
      ((A . D) progn (rom 055) (rom A2))
      ((A . $) progn (rom 054) (rom A2))
      ((D . A) progn (rom 052) (rom A1))
      ((D . $) progn (rom 053) (rom A1) (rom A2))
      ((C . D) progn (rom 082) (rom A2))
      ((C . /) progn (rom 0B0) (rom A2)) )
   (ORL asm2
      ((A . R) rom (add 048 A2))
      ((A . @) rom (add 046 A2))
      ((A . D) progn (rom 045) (rom A2))
      ((A . $) progn (rom 044) (rom A2))
      ((D . A) progn (rom 042) (rom A1))
      ((D . $) progn (rom 043) (rom A1) (rom A2))
      ((C . D) progn (rom 072) (rom A2))
      ((C . /) progn (rom 0A0) (rom A2)) )
   (XRL asm2
      ((A . R) rom (add 068 A2))
      ((A . @) rom (add 066 A2))
      ((A . D) progn (rom 065) (rom A2))
      ((A . $) progn (rom 064) (rom A2))
      ((D . A) progn (rom 062) (rom A1))
      ((D . $) progn (rom 063) (rom A1) (rom A2)) )
   (ADD asm2
      ((A . R) rom (add 028 A2))
      ((A . @) rom (add 026 A2))
      ((A . D) progn (rom 025) (rom A2))
      ((A . $) progn (rom 024) (rom A2)) )
   (ADDC asm2
      ((A . R) rom (add 038 A2))
      ((A . @) rom (add 036 A2))
      ((A . D) progn (rom 035) (rom A2))
      ((A . $) progn (rom 034) (rom A2)) )
   (SUBB asm2
      ((A . R) rom (add 098 A2))
      ((A . @) rom (add 096 A2))
      ((A . D) progn (rom 095) (rom A2))
      ((A . $) progn (rom 094) (rom A2)) )
   (CLR asm1
      (A rom 0E4)
      (C rom 0C3)
      (D progn (rom 0C2) (rom A)) )
   (CPL asm1
      (A rom 0F4)
      (C rom 0B3)
      (D progn (rom 0B2) (rom A)) )
   (SETB asm1
      (C rom 0D3)
      (D progn (rom 0D2) (rom A)) )
   (INC asm1
      (A rom 04)
      (R rom (add 08 A))
      (@ rom (add 06 A))
      (D progn (rom 05) (rom A))
      (DPTR rom 0A3) )
   (DEC asm1
      (A rom 014)
      (R rom (add 018 A))
      (@ rom (add 016 A))
      (D progn (rom 015) (rom A)) )
   (MUL asm1 (AB rom 0A4))
   (DIV asm1 (AB rom 084))
   (DA asm1 (A rom 0D4))
   (RL asm1 (A rom 023))
   (RLC asm1 (A rom 033))
   (RR asm1 (A rom 03))
   (RRC asm1 (A rom 013))
   (LCALL asm1 (D progn (rom 012) (rom2 A)))
   (ACALL asm1 (D absAdr 011 A))
   (LJMP asm1 (D progn (rom 02) (rom2 A)))
   (JMP asm1 (-A-DPTR rom 073))
   (AJMP asm1 (D absAdr 01 A))
   (SJMP asm1 (D progn (rom 080) (relAdr A)))
   (JZ asm1 (D progn (rom 060) (relAdr A)))
   (JNZ asm1 (D progn (rom 070) (relAdr A)))
   (JC asm1 (D progn (rom 040) (relAdr A)))
   (JNC asm1 (D progn (rom 050) (relAdr A)))
   (JB asm2 ((D . D) progn (rom 020) (rom A1) (relAdr A2)))
   (JNB asm2 ((D . D) progn (rom 030) (rom A1) (relAdr A2)))
   (JBC asm2 ((D . D) progn (rom 010) (rom A1) (relAdr A2)))
   (CJNE asm3
      ((A D . D) progn (rom 0B5) (rom A1) (relAdr A2))
      ((A $ . D) progn (rom 0B4) (rom A1) (relAdr A2))
      ((R $ . D) progn (rom (add 0B8 A)) (rom A1) (relAdr A2))
      ((@ $ . D) progn (rom (add 0B6 A)) (rom A1) (relAdr A2)) )
   (DJNZ asm2
      ((R . D) progn (rom (add 0D8 A1)) (relAdr A2))
      ((D . D) progn (rom 0D5) (rom A1) (relAdr A2)) )
   (RET rom 022)
   (RETI rom 032)
   (NOP rom 0) >

T
