[scmpAsm.l 10oct92]

<de disp ()
   (if Pass
      (bitand 0FF (eval (pop Asm)))
      (progn (pop Asm) 0) >

<de xPtr (op)
   (bitor op (bitand 3 (disp))) >

<de immed (op)
   (bitor op (disp)) >

<de memAdr (op)
   (local (d $a)
      (setq  d (disp)  $a (pop Asm))
      (bitor op d
         (bitl 8
            (if (eq '* (car $a))
               (bitor 4 (cadr $a))
               (car $a) >

<de jmpAdr (op)
   (local ($a $b)
      (setq
         $a (pop Asm)
         $b (when (member (car Asm) '((1) (2) (3))) (pop Asm)) )
      (bitor op
         (if Pass
            (progn
               (setq $a (eval $a))
               (if $b
                  (bitor
                     (bitl 8 (car $b))
                     (bitand 0FF $a) )
                  (progn
                     (setq $a (sub $a PC 2))
                     (unless (leq -128 $a 127)
                        (error
                           "Jump out of range by "
                           (format
                              (sub $a
                                 (if (minusp $a) -128 127) ) ) ) )
                     (bitand 0FF $a) ) ) )
            0 >

<de InSet
   (ld  rom2 (memAdr 0C000))
   (st  rom2 (memAdr 0C800))
   (and rom2 (memAdr 0D000))
   (or  rom2 (memAdr 0D800))
   (xor rom2 (memAdr 0E000))
   (dad rom2 (memAdr 0E800))
   (add rom2 (memAdr 0F000))
   (cad rom2 (memAdr 0F800))
   (ild rom2 (memAdr 0A800))
   (dld rom2 (memAdr 0B800))
   (ldi rom2 (immed 0C400))
   (ani rom2 (immed 0D400))
   (ori rom2 (immed 0DC00))
   (xri rom2 (immed 0E400))
   (dai rom2 (immed 0EC00))
   (adi rom2 (immed 0F400))
   (cai rom2 (immed 0FC00))
   (jmp rom2 (jmpAdr 09000))
   (jp  rom2 (jmpAdr 09400))
   (jz  rom2 (jmpAdr 09800))
   (jnz rom2 (jmpAdr 09C00))
   (dly rom2 (immed 08F00))
   (lde rom 040)
   (xae rom 001)
   (ane rom 050)
   (ore rom 058)
   (xre rom 060)
   (dae rom 068)
   (ade rom 070)
   (cae rom 078)
   (xpal rom (xPtr 030))
   (xpah rom (xPtr 034))
   (xppc rom (xPtr 03C))
   (sio rom 019)
   (sr  rom 01C)
   (srl rom 01D)
   (rr  rom 01E)
   (rrl rom 01F)
   (halt rom 0)
   (ccl rom 2)
   (scl rom 3)
   (dint rom 4)
   (ien rom 5)
   (csa rom 6)
   (cas rom 7)
   (nop rom 8) >


[+++ Macro Definitions +++]

<de ldad (r adr)
   (asm
      ldi (hiByte adr)   xpah r
      ldi (loByte adr)   xpal r >

<de ldsr (adr)
   (ldad 3 (sub1 adr)) >

<de jsr (adr)
   (ldsr 3 adr)
   (asm xppc 3) >

t
