[fokker.l 05feb92abu]

(setq
   *size-h 512
   *size-v 256
   *vRect (cons2 0 0 *size-h *size-v)
   *winRect (mvRect *vRect 60 40)
   $event (dynamo free (alloc 16))
   *fokker (planeRec 960 1800 1200 (-40000 -30000 0) (0 0 0)) )

(pitch *fokker 1550)
(zero *thrust)
(de *thrusts (AUS.0) (LEER.1000) (1.80000) (2.160000) (3.240000))
(setq *trim 8)
(zero *elevator *aileron *rudder)
(off *pos *vel)

<de init ()
   (local (rb p)
      (unless (setq *zBuf (alloc (mul 4 *size-h *size-v)))
         (error "Memory") )
      (defKey \e (EraseRect (portRect *port)))
      (SetPort
         (setq *win (NewCWindow nil *winRect "View" t 0 -1)) )
      (setq
         *offMap (newOffMap *size-h *size-v)
         *fBuf (ptr (ptr *offMap)) >

<de viewFokker ()
   (paint fokker (position *fokker) (ref *fokker))
   (paint
      (if (zerop *thrust) latte propeller)
      (position *fokker)
      (ref *fokker))
   (CopyBits (ptr *offMap) (portMap *port) *vRect *vRect srcCopy) >

<de test (x y z a)
   (default a 1000)
   (camera a (list x y z) (position *fokker)
      *size-h *size-v *fBuf *zBuf
      #(pack 0 800 0) #(pack 600 800 1000) )
   (viewFokker) >


<de fokkerLoop ()
   (gc 1000)
   (while (GetNextEvent keyDownMask (ref $event))
      (case (bitand charCodeMask (ev-message (ref $event)))
         (27 (quit))
         (\7 (when (lessp *thrust 4) (inc *thrust)))
         (\1 (unless (zerop *thrust) (dec *thrust)))
         (\5 (zero *elevator *aileron))
         (\8 (dec *elevator 4))
         (\2 (inc *elevator 4))
         (\4 (dec *aileron 4))
         (\6 (inc *aileron 4))
         (\- (dec *trim))
         (\+ (inc *trim))
         (\* (zero *trim))
         (28 (dec *rudder 2))
         (29 (inc *rudder 2))
         (31 (zero *rudder)) ) )
   (dPlane *fokker
      (cdr (nth *thrust *thrusts))
      (add *trim *elevator)
      *aileron
      (if (zerop *rudder) *aileron *rudder) )
   (setq
      *pos (position *fokker)
      *vel (velocity *fokker)
      *w (toWorld *fokker 1000 0 0) )
   (and
      (zerop (caddr *pos))
      (lessp (caddr *w) 250) [sin(14.5)]
      (pitch *fokker 100) )
   #(case 2
      (1
         '(camera 400 (mapcar2 *pos *vel sub) *pos
            *size-h *size-v *fBuf *zBuf
            #(pack 0 800 0) #(pack 600 800 1000) ) )
      (2
         '(camera 5000 (0 0 181) *pos
            *size-h *size-v *fBuf *zBuf
            #(pack 0 800 0) #(pack 600 800 1000) ) )
      )
   (viewFokker)
   [(local (w p)
      (setq
         w (toWorld *fokker 10000 10000 10000)
         p (toPlane *fokker (car w) (cadr w) (caddr w)) )
      (unless
         (and
            (leq 9999 (car p) 10001)
            (leq 9999 (cadr p) 10001)
            (leq 9999 (caddr p) 10001) )
         (error "Transformation mismatch") ) )]
   (prin1 (car (nth *thrust *thrusts))) (space)
   (prin2 (format (speed *fokker) 2)) (prin2 " km/h  ")
   (prin2 (format (caddr *pos) 2)) (prin2 " m  ")
   (prin2 (format (caddr *vel) 2)) (prin2 " m/s  ")
   (prin1 *trim) (space)
   (print *w) >

t
