[main.l 17dec92]

<de init ()
   [(serial "A")]
   (reptn 6 (MoreMasters))
   (soundInit)
   (readStrings)
   (setq
      Event (alloc 16)
      IMBar (idleMBar)
      RcMBar (rcMBar) )
   (do init 'spot)
   (do setUp (setq App 'idle))
   (run) >

<de cleanUp ()
>

<de rcMBar ()
   (mkMBar
      ((#appleMark)
         ("" #(str "About RcSim ..") T (aboutDialog))
         ("-") )
      (#(str "File")
         ("/O" #(str "Open ..") T (openCmd))
         ("/N" #(str "New") NIL (newCmd))
         ("" #(str "Wire Frame")
            (eq 'rcSim (do classify App))
            (newWire App) )
         ("-")
         ("/W" #(str "Close") T (do close App))
         ("/S" #(str "Save") NIL (saveCmd))
         ("" #(str "Save as ..") NIL (doSave))
         ("" #(str "Revert") NIL (revertCmd))
         ("-")
         ("/Q" #(str "Quit") T (on Done)) )
      (#(str "Edit")
         ("/Z" #(str "Undo"))
         ("/R" #(str "Redo"))
         ("-")
         ("/X" #(str "Cut"))
         ("/C" #(str "Copy"))
         ("/V" #(str "Paste"))
         ("" #(str "Clear"))
         ("/D" #(str "Duplicate"))
         ("/A" #(str "Select All")) )
      (#(str "Simulation")
         ("/F" #(str "Fly") T (doFly))
         >

<de openCmd ()
   (local (nm)
      [(localVol (GetVol)]
         (when
            (and
               [(needMem #(add (mul 4 640 640) (mul 4 256 256)))]
               (setq nm (getFile "TEXT")) )
            (doOpen nm) >

<de newWire (app)
   (new 'wireSim 630 380 app)
   >


(object wireSim w-win)

<to classify () 'wireSim>

<to T (obj h v app)
   (from w-win T obj (10.40) "Wire Frame" h v)
   (with obj
      (slot plane (get app 'plane))
      (slot latte (mkWire (get app 'latte)))
      (slot propeller (mkWire (get app 'propeller)))
      (slot fuselage (mkWire (get app 'fuselage)))
      (do view obj)
      (start obj) >

<to close (obj)
   (from w-win close obj)
   (stop obj)
   T >

<to setUp (App)
   (setMenu RcMBar)
>

<to view (obj a pos)
   (default
      a 12000
      pos (0 0 181) )
   (local (p)
      (setq p (get obj 'plane))
      (from w-win view obj a pos (position p)
         '((obj)
            (with obj
               (wire (slot fuselage) (position p) (ref p))
               (wire
                  (if (zerop (throttle p))
                     (slot latte) (slot propeller) )
                  (position p) (ref p) >


(object rcSim z-win)

<to classify () 'rcSim>

<to T (obj nm h v)
   (from z-win T obj (60.60) nm h v)
   (with obj
      (load nm)
      (do view obj)
      (start obj) >

<to close (obj)
   (from z-win close obj)
   (stop obj)
   T >

<to setUp (App)
   (setMenu RcMBar)
>

<to view (obj a pos)
   (default
      a 12000
      pos (0 0 181) )
   (local (p)
      (setq p (get obj 'plane))
      (from z-win view obj a pos (position p)
         #(pack 0 800 0) #(pack 600 800 1000)
         '((obj)
            (with obj
               (paint (slot fuselage) (position p) (ref p))
               (paint
                  (if (zerop (throttle p))
                     (slot latte) (slot propeller) )
                  (position p) (ref p) >

T
