[prim.l 14aug92]

[+ Make wire frame from polygon list +]
<de mkWire (lst)
   (local (:shadows :points :strokes l p p1)
      (off :shadows :points :strokes)
      (while (setq l (pop lst))
         (pop l)
         (when (pop l)
            (setq :shadows (nconc1 :shadows (mkShadow l))) )
         (setq p (setq p1 (pop l)))
         (while l
            (mkWire1 p (setq p (pop l))) )
         (mkWire1 p p1) )
      (cons :shadows (cons :points :strokes)) >

<de mkWire1 (p1 p2)
   (local (s1 s2)
      (or (member p1 :points) (setq :points (nconc1 :points p1)))
      (or (member p2 :points) (setq :points (nconc1 :points p2)))
      (setq
         s1 (cons (index p1 :points) (index p2 :points))
         s2 (cons (index p2 :points) (index p1 :points)) )
      (or
         (member s1 :strokes)
         (member s2 :strokes)
         (setq :strokes (nconc1 :strokes s1)) >

<de mkShadow (l)
   (local (p)
      (setq p
         (best l
            '((x)
               (distance x
                  (best l '((y) (distance x y))) ) ) ) )
      (cons p (best l '((x) (distance p x)))) >

[+ Create a bitmap +]
<de newBitMap (h v)
   (local (b r)
      (setq
         b (alloc 14)
         r (mul2 (div (add h 15) 16)) )
      (ptr b (alloc (mul v r))) [baseAdr]
      (word (add 4 b) r) [rowBytes]
      (rect (add 6 b) (cons2 0 0 h v)) [bounds]
      b >

<de zapBitMap (b)
   (free (ptr b))
   (free b) >

[+ Create a 32-bit Pixel Map +]
<de newOffMap (h v)
   (local (pm p)
      (setq p (HLock (setq pm (NewPixMap))))
      (word (add 4 p) (bitOr 08000 (mul 4 h))) [+ rowBytes +]
      (rect (add 6 p) (cons2 0 0 h v)) [+ bounds +]
      (word (add 30 p) 16) [+ pixelType RGBDirect +]
      (word (add 32 p) 32) [+ pixelSize +]
      (word (add 34 p) 3) [+ cmpCount +]
      (word (add 36 p) 8) [+ cmpSize +]
      (HUnlock pm) >

T
