/* dPlane.c
 * 07dec92abu
 */

#pragma segment dPlane

#include "rcSim.h"

#define DT			(1.0/20.0)	/* Time Step 1/20 s */
#define SECONDS	20				/* Ticks/s */
#define GRAV		9.81			/* Gravity 9.81 [kg*m/s^2] */
#define DAMP(a,b)	(a = (a+b)/2.0)

int markow = 1;
vector turbulence = {0.0, 0.0, 0.0};

pico RcControl(x)
pico x;
{
	planeHandle h;
	int n;
	EventRecord event;
	static int bit0 = 0;
	static int chan = 0;

	h = nextPlane(&x);
	while (GetNextEvent(keyDownMask, &event)) {
		switch (event.message & charCodeMask) {
			case 27:
				return nilSym;
			case '5':
				(*h)->rcChan[0] = (*h)->rcZero[0];
				(*h)->rcChan[1] = (*h)->rcZero[1];
				break;
			case 31:
				(*h)->rcChan[2] = (*h)->rcZero[2];
				break;
			case '4':
				(*h)->rcChan[0] += 10;
				if ((*h)->rcChan[0] > 255)
					(*h)->rcChan[0] = 255;
				break;
			case '6':
				(*h)->rcChan[0] -= 10;
				if ((*h)->rcChan[0] < 0)
					(*h)->rcChan[0] = 0;
				break;
			case '8':
				(*h)->rcChan[1] += 10;
				if ((*h)->rcChan[1] > 255)
					(*h)->rcChan[1] = 255;
				break;
			case '2':
				(*h)->rcChan[1] -= 10;
				if ((*h)->rcChan[1] < 0)
					(*h)->rcChan[1] = 0;
				break;
			case 28:
				(*h)->rcChan[2] += 10;
				if ((*h)->rcChan[2] > 255)
					(*h)->rcChan[2] = 255;
				break;
			case 29:
				(*h)->rcChan[2] -= 10;
				if ((*h)->rcChan[2] < 0)
					(*h)->rcChan[2] = 0;
				break;
			case '7':
				(*h)->rcChan[3] += 20;
				if ((*h)->rcChan[3] > 255)
					(*h)->rcChan[3] = 255;
				break;
			case '1':
				(*h)->rcChan[3] -= 20;
				if ((*h)->rcChan[3] < 0)
					(*h)->rcChan[3] = 0;
				break;
		}
	}
	while (serialReady())
		if ((n = serialIn()) & 0x80)
			(*h)->rcChan[chan] = n << 1 & 255 | bit0;
		else
			bit0 = n & 1,   chan = (n >> 1) & 3;
	return tSym;
}

pico Aileron(x)
pico x;
{
	planeHandle h;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x)))
		return boxNum((*h)->rcZero[0] - (*h)->rcChan[0]);
	(*h)->rcChan[0] = (*h)->rcZero[0] - unBox(x);
	return x;
}

pico Elevator(x)
pico x;
{
	planeHandle h;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x)))
		return boxNum((*h)->rcZero[1] - (*h)->rcChan[1]);
	(*h)->rcChan[1] = (*h)->rcZero[1] - unBox(x);
	return x;
}

pico Rudder(x)
pico x;
{
	planeHandle h;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x)))
		return boxNum((*h)->rcZero[2] - (*h)->rcChan[2]);
	(*h)->rcChan[2] = (*h)->rcZero[2] - unBox(x);
	return x;
}

pico Throttle(x)
pico x;
{
	planeHandle h;
	number n;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x))) {
		n = (*h)->rcChan[3] - (*h)->rcZero[3];
		return boxNum(n>=0? n : 0);
	}
	(*h)->rcChan[3] = unBox(x) + (*h)->rcZero[3];
	return x;
}

pico DPlane(x)
pico x;
{
	planeHandle h;
	register plane *p;
	double ail, ele, rud, thr;
	register long n;
	register double r,m,a;
	bool taxi,stick;
	vector vg,vp,fp,fw,dv;

	h = nextPlane(&x);
	HLock((Handle)h);
	p = *h;

	ail = (double)(p->rcZero[0] - p->rcChan[0]) / 50.0;
	ele = (double)(p->rcZero[1] - p->rcChan[1] + 6) / 50.0;
	rud = (double)(p->rcZero[2] - p->rcChan[2]) / 50.0;
	thr = (double)(p->rcChan[3] - p->rcZero[3]) / 100.0;
	if (thr < 0.0)
		thr = 0.0;

	n = (*(long*)Ticks - p->ticks) / 3;
	p->ticks += n * 3;
	r = p->rc;
	m = p->mass;
	p->stall = NO;
	while (--n >= 0) {
		antiTrans(p->vel.x, p->vel.y, p->vel.z, &p->rotMat, &vg);

		/* Wind and turbulence */
		vp.x = vg.x + turbulence.x;
		vp.y = vg.y + turbulence.y - wind;
		vp.z = vg.z + turbulence.z;

		taxi = stick = NO;
		if (p->pos.z <= p->touch) {
			taxi = YES;
			if (fabs(vg.x) < 0.1)
				stick = YES;
		}

		/* Plane system */
		fp.x = thr * p->power;
		if (vp.x < 0.1)
			fp.z = 0.0;
		else if (fabs(a = vp.z/vp.x) > p->limit)
			fp.z = 0.0,  p->stall |= YES;
		else
			fp.z = vp.x*vp.x * p->lc * a;
		fp.x +=  r * vp.x * fabs(vp.x);
		fp.y  =  r * (taxi? 10.0:2.0) * vp.y * fabs(vp.y);
		fp.z +=  r * 6.0 * vp.z * fabs(vp.z);
		if (taxi && !stick) {
			fp.x  -=  m * sign(vg.x);
			fp.y  -=  8.0 * m * sign(vg.y);
		}

		/* Turn plane */
		if (taxi  &&  p->rotMat.a.z < p->pitch)
			pitch(&p->rotMat, DT/10.0);
		if (!stick) {
			pitch(&p->rotMat,
				(vp.x * ele  +  vp.z * p->stab.y) *
				DT * 0.1 );
			if (!taxi)
				roll(&p->rotMat,
					(ail * vp.x  -  vp.y  -  thr * 2.0  +
								p->rotMat.b.z * p->stab.x ) *
					DT * 0.1 );
			yaw(&p->rotMat,
				(taxi?  rud  :  rud * vp.x  +  vp.y * p->stab.z) *
				DT * 0.1 );
		}

		/* World system */
		transform(fp.x, fp.y, fp.z, &p->rotMat, &fw);
		fw.z -= m * GRAV;

		/* Accelerate */
		a = DT / m;
		dv.x = a * fw.x;
		dv.y = a * fw.y;
		dv.z = a * fw.z;
		if (stick  &&  sqrt(dv.x*dv.x + dv.y*dv.y) < 0.1)
			p->vel.x = p->vel.y = p->vel.z = 0.0;
		else {
			p->vel.x += DAMP(p->dv.x, dv.x);
			p->vel.y += DAMP(p->dv.y, dv.y);
			p->vel.z += DAMP(p->dv.z, dv.z);
			if (taxi  &&  p->vel.z <= 0.0) {
				if (p->vel.z < -3.0) {
					HUnlock((Handle)h);
					return nilSym;
				}
				p->vel.z = p->dv.z = 0.0;
			}

			/* Translate */
			p->pos.x  +=  p->vel.x * DT;
			p->pos.y  +=  p->vel.y * DT;
			p->pos.z  +=  p->vel.z * DT;
			if (p->pos.z < p->touch)
				p->pos.z = p->touch;
		}
		if (!--markow) {
			markow = 2*SECONDS;
			/*
			DAMP(turbulence.x, random(4,wind));
			DAMP(turbulence.y, random(4,wind));
			DAMP(turbulence.z, random(4,wind));
			*/
		}
	}
	HUnlock((Handle)h);
	return tSym;
}

void pitch(p,a)
register matrix *p;
double a;
{
	matrix m;
	register double ca,sa;

	ca = cos(a);
	sa = sin(a);
	m = *p;
	p->a.x  =  m.a.x * ca + m.c.x * sa;
	p->a.y  =  m.a.y * ca + m.c.y * sa;
	p->a.z  =  m.a.z * ca + m.c.z * sa;
	p->c.x  =  m.c.x * ca - m.a.x * sa;
	p->c.y  =  m.c.y * ca - m.a.y * sa;
	p->c.z  =  m.c.z * ca - m.a.z * sa;
}

void roll(p,a)
register matrix *p;
double a;
{
	matrix m;
	register double ca,sa;

	ca = cos(a);
	sa = sin(a);
	m = *p;
	p->b.x  =  m.b.x * ca - m.c.x * sa;
	p->b.y  =  m.b.y * ca - m.c.y * sa;
	p->b.z  =  m.b.z * ca - m.c.z * sa;
	p->c.x  =  m.c.x * ca + m.b.x * sa;
	p->c.y  =  m.c.y * ca + m.b.y * sa;
	p->c.z  =  m.c.z * ca + m.b.z * sa;
}

void yaw(p,a)
register matrix *p;
double a;
{
	matrix m;
	register double ca,sa;

	ca = cos(a);
	sa = sin(a);
	m = *p;
	p->a.x  =  m.a.x * ca + m.b.x * sa;
	p->a.y  =  m.a.y * ca + m.b.y * sa;
	p->a.z  =  m.a.z * ca + m.b.z * sa;
	p->b.x  =  m.b.x * ca - m.a.x * sa;
	p->b.y  =  m.b.y * ca - m.a.y * sa;
	p->b.z  =  m.b.z * ca - m.a.z * sa;
}

#if 0
double vAngle(v,m)
register vector *v;
register matrix *m;
{
	register double mag;

	if ((mag = magnitude(v)) == 0.0)
		return 0.0;
	return -(v->x * m->c.x + v->y * m->c.y + v->z * m->c.z) / mag;
}
#endif
