/* rcSim.h
 * 21feb92abu
 */

#include ":src:pico.h"
#include ":src:mac.h"

#define METER			1.0
#define CENTIMETER	0.01
#define MILLIMETER	0.001
#define GRAM			0.001
#define PI				3.141592654
#define RHO				1.225

extern OSType creator;
extern integer binVol;

typedef struct {
   double x,y,z;
} vector;

typedef struct {
   vector a,b,c;
} matrix, **matHandle;

typedef struct {
	matrix rotMat;				/* Must be first item */
	long ticks;					/* [1/60 sec] */
	vector pos;					/* Position [m] */
	vector vel,dv;				/* Velocity [m/s] */
	double touch;				/* Touchdown height [m] */
	double pitch;				/* Ground pitch */
	double mass;				/* [kg] */
	double lc,rc;				/* A * c [m^2] */
	double limit;				/* tan(a) */
	vector stab;				/* Roll stability */
	double power;				/* Power [kg * m / s^2] */
	double rpm;					/* [1 / min] */
	bool stall;					/* Stall flag */
	int rcChan[4];				/* Direct RC value */
	int rcZero[4];				/* RC calibration */
} plane, **planeHandle;

/* Globals */
extern double wind;

/* Prototypes */
pico boxVector(vector*,double);
void unBoxVector(pico,vector*,double);
double nextDouble(pico*,double);
double nextAngle(pico*);
void nextVector(pico*,vector*,double);
planeHandle nextPlane(pico*);
double magnitude(vector*);
void transform(double,double,double,matrix*,vector*);
void antiTrans(double,double,double,matrix*,vector*);
void identity(matrix*);
double sign(double);
void disposPlaneRec(pico);
void pitch(matrix*,double);
void roll(matrix*,double);
void yaw(matrix*,double);

pico RcControl(pico);
pico DPlane(pico);
pico Aileron(pico);
pico Elevator(pico);
pico Rudder(pico);
pico Throttle(pico);
