/* simul.c
 * 07dec92abu
 */

#pragma segment simul

#include "rcSim.h"

/* Prototypes */
static pico PlaneRec(pico);
static pico SetNow(pico);
static pico Mass(pico);
static pico Position(pico);
static pico Velocity(pico);
static pico Speed(pico);
static pico Doppler(pico);
static pico Pitch(pico);
static pico Roll(pico);
static pico Yaw(pico);
static pico ToPlane(pico);
static pico ToWorld(pico);
static pico Distance(pico);

/* Globals */
double wind = 0.0;

symInit rcSyms[] = {
	{"rc-control",	RcControl},
	{"dPlane",		DPlane},
	{"aileron",		Aileron},
	{"elevator",	Elevator},
	{"rudder",		Rudder},
	{"throttle",	Throttle},
	{"planeRec",	PlaneRec},
	{"setNow",		SetNow},
	{"mass",			Mass},
	{"position",	Position},
	{"velocity",	Velocity},
	{"speed",		Speed},
	{"doppler",		Doppler},
	{"pitch",		Pitch},
	{"roll",			Roll},
	{"yaw",			Yaw},
	{"toPlane",		ToPlane},
	{"toWorld",		ToWorld},
	{"distance",	Distance},
	NULL
};


pico PlaneRec(x)
pico x;
{
	register planeHandle h;

	h = (planeHandle)NewHandle(sizeof(plane));
	identity(&(*h)->rotMat);
	(*h)->ticks = *(long*)Ticks;
	nextVector(&x, &(*h)->pos, CENTIMETER);  /* Position [cm] */
	yaw(&(*h)->rotMat, nextAngle(&x));  /* Turn [deg] */
	(*h)->vel.x = (*h)->vel.y = (*h)->vel.z = 0.0;
	(*h)->dv.x = (*h)->dv.y = (*h)->dv.z = 0.0;
	(*h)->touch = (*h)->pos.z;
	pitch(&(*h)->rotMat, (*h)->pitch = nextAngle(&x));  /* Ground pitch [deg] */
	(*h)->mass = nextDouble(&x, GRAM); /* Mass [g] */
	(*h)->lc = nextDouble(&x, 0.01) * RHO/2.0;  /* Lift */
	(*h)->rc = nextDouble(&x, 0.0001) * RHO/2.0;  /* Resistance */
	(*h)->limit = tan(nextAngle(&x));  /* Limit [deg] */
	nextVector(&x, &(*h)->stab, 0.01);  /* Stability */
	(*h)->power = nextDouble(&x, 1.0);  /* Power [N] */
	(*h)->rpm = nextDouble(&x, 1.0) / 60.0;  /* rpm [1/s] */
	(*h)->rcChan[0] = (*h)->rcZero[0] = 167;
	(*h)->rcChan[1] = (*h)->rcZero[1] = 167;
	(*h)->rcChan[2] = (*h)->rcZero[2] = 167;
	(*h)->rcChan[3] = (*h)->rcZero[3] = 120;
	return dynamo(boxSubr(num(disposPlaneRec)), boxNum(h));
}

pico SetNow(x)
pico x;
{
	return boxNum((*nextPlane(&x))->ticks = *(long*)Ticks);
}

pico Mass(x)
pico x;
{
	register planeHandle h;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x)))
		return boxDouble((*h)->mass / GRAM);
	NEEDNUM(x);
	(*h)->mass = (double)unBox(x) * GRAM;
	return x;
}

pico Position(x)
pico x;
{
	register planeHandle h;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x)))
		return boxVector(&(*h)->pos, CENTIMETER);
	unBoxVector(x, &(*h)->pos, CENTIMETER);
	return x;
}

pico Velocity(x)
pico x;
{
	register planeHandle h;

	h = nextPlane(&x);
	if (isNil(x = EVAL1(x)))
		return boxVector(&(*h)->vel, CENTIMETER);
	unBoxVector(x, &(*h)->vel, CENTIMETER);
	return x;
}

pico Speed(x)
pico x;
{
	return boxDouble(magnitude(&(*nextPlane(&x))->vel) * 360);
}

pico Doppler(x)
pico x;
{
	register planeHandle h;
	register double a,thr,v,f;

	h = nextPlane(&x);
	a = -((*h)->pos.x * (*h)->vel.x + (*h)->pos.y * (*h)->vel.y);
	a /= sqrt((*h)->pos.x * (*h)->pos.x + (*h)->pos.y * (*h)->pos.y) *
				sqrt((*h)->vel.x * (*h)->vel.x + (*h)->vel.y * (*h)->vel.y);
	thr = (double)((*h)->rcChan[3] - (*h)->rcZero[3]) / 200.0;
	v = magnitude(&(*h)->vel);
	f = (thr * (*h)->rpm / 2.0 + v * 2.0) / 2.0;
	return boxDouble(f + f * v * a / 300.0);
}

pico Pitch(x)
pico x;
{
	register planeHandle h;

	h = nextPlane(&x);
	pitch(&(*h)->rotMat, nextAngle(&x));
	return tSym;
}

pico Roll(x)
pico x;
{
	register planeHandle h;

	h = nextPlane(&x);
	roll(&(*h)->rotMat, nextAngle(&x));
	return tSym;
}

pico Yaw(x)
pico x;
{
	register planeHandle h;

	h = nextPlane(&x);
	yaw(&(*h)->rotMat, nextAngle(&x));
	return tSym;
}

pico ToPlane(x)
pico x;
{
	planeHandle h;
	vector v;

	h = nextPlane(&x);
	v.x = nextDouble(&x,MILLIMETER);
	v.y = nextDouble(&x,MILLIMETER);
	v.z = nextDouble(&x,MILLIMETER);
	antiTrans(v.x, v.y, v.z, &(*h)->rotMat, &v);
	return boxVector(&v,MILLIMETER);
}

pico ToWorld(x)
pico x;
{
	planeHandle h;
	vector v;

	h = nextPlane(&x);
	v.x = nextDouble(&x,MILLIMETER);
	v.y = nextDouble(&x,MILLIMETER);
	v.z = nextDouble(&x,MILLIMETER);
	transform(v.x, v.y, v.z, &(*h)->rotMat, &v);
	return boxVector(&v,MILLIMETER);
}

pico Distance(x)
pico x;
{
	vector v,w;

	nextVector(&x, &v, 1.0);
	nextVector(&x, &w, 1.0);
	v.x -= w.x;
	v.y -= w.y;
	v.z -= w.z;
	return boxDouble(magnitude(&v));
		
}
