[blot.l 14aug92]

<de drawBlot (h v b)
   (local (dh dv n)
      (mapc b
         '((l)
            (setq
               dh (pop l)
               dv (pop l) )
            (for (i 0 (length l))
               (setq n (sub 1023 (mul 4 (pop l))))
               (pixel (add i h dh) (add v dv) (pack n n n)) >

<de doBlot (n)
   (do inval 'msrWin)
   (if n
      (setq Blot (nth n Blots))
      (local (nm fd)
         (and
            (setq nm (getFile1 #(str "User Blot") #(str "Set") "blot"))
            (setq fd (open nm))
            (setq Blot (parseBlot fd))
            (close fd) >

<de parseBlot (fd)
   (local (p res l h)
      (setq
         p (alloc #(mul 32 32))
         res )
      (readBlock fd p #(mul 32 32))
      (for (i 31 -1 (sub1 i))
         (when (find (setq l (stuff (add p (mul i 32)) 32)) plusp)
            (push (cons (sub i 16) l) res) ) )
      (free p)
      (mapcar res
         '((l)
            (setq h -16)
            (while (zerop (cadr l))
               (rplacd l (cddr l))
               (inc h) )
            (while (zerop (last l))
               (shift l) )
            (cons h l) >

<de blotRgn (pt blot)
   (local (z h v h1 v1)
      (setq
         z (get App 'zoom)
         h (car pt)
         v (cdr pt)
         h1 (add h (mul z (caar blot)))
         v1 (add v (mul z (cadar blot))) )
      (OpenRgn)
      (MoveTo h1 v1)
      (mapc (cdr blot)
         '((l)
            (LineTo
               (add h (mul z (car l)))
               (add v (mul z (cadr l))) ) ) )
      (mapc (reverse blot)
         '((l)
            (LineTo
               (add h
                  (mul z
                     (add (sub2 (length l)) (car l)) ) )
               (add v (mul z (add (cadr l)))) ) ) )
      (LineTo h1 v1)
      (CloseRgn (NewRgn)) >


[+++ Blot data +++]
<de Blots

[1] <
   (-1 -1  255 255)
   (-1  0  255 255) >

[2a] <
   (-2 -4          255 255 255 255)
   (-3 -3      255 255 255 255 255 255)
   (-4 -2  255 255 255 255 255 255 255 255)
   (-4 -1  255 255 255 255 255 255 255 255)
   (-4  0  255 255 255 255 255 255 255 255)
   (-4  1  255 255 255 255 255 255 255 255)
   (-3  2      255 255 255 255 255 255)
   (-2  3          255 255 255 255) >

[2b] <
   (-2 -4           82  98  98  82)
   (-3 -3      113 163 180 180 163 113)
   (-4 -2   82 163 217 236 236 217 163  82)
   (-4 -1   98 180 236 255 255 236 180  98)
   (-4  0   98 180 236 255 255 236 180  98)
   (-4  1   82 163 217 236 236 217 163  82)
   (-3  2      113 163 180 180 163 113)
   (-2  3           82  98  98  82) >

[3a] <
   (-2 -6                  255 255 255 255)
   (-4 -5          255 255 255 255 255 255 255 255)
   (-5 -4      255 255 255 255 255 255 255 255 255 255)
   (-5 -3      255 255 255 255 255 255 255 255 255 255)
   (-6 -2  255 255 255 255 255 255 255 255 255 255 255 255)
   (-6 -1  255 255 255 255 255 255 255 255 255 255 255 255)
   (-6  0  255 255 255 255 255 255 255 255 255 255 255 255)
   (-6  1  255 255 255 255 255 255 255 255 255 255 255 255)
   (-5  2      255 255 255 255 255 255 255 255 255 255)
   (-5  3      255 255 255 255 255 255 255 255 255 255)
   (-4  4          255 255 255 255 255 255 255 255)
   (-2  5                  255 255 255 255) >

[3b] <
   (-2 -6                   60  66  66  60)
   (-4 -5           66  99 120 127 127 120  99  66)
   (-5 -4       66 113 150 172 180 180 172 150 113  66)
   (-5 -3       99 150 188 213 221 221 213 188 150  99)
   (-6 -2   60 120 172 213 238 246 246 238 213 172 120  60)
   (-6 -1   66 127 180 221 246 255 255 246 221 180 127  66)
   (-6  0   66 127 180 221 246 255 255 246 221 180 127  66)
   (-6  1   60 120 172 213 238 246 246 238 213 172 120  60)
   (-5  2       99 150 188 213 221 221 213 188 150  99)
   (-5  3       66 113 150 172 180 180 172 150 113  66)
   (-4  4           66  99 120 127 127 120  99  66)
   (-2  5                   60  66  66  60) >

[+ 4a +] <
   (-3 -8                      255 255 255 255 255 255)
   (-5 -7              255 255 255 255 255 255 255 255 255 255)
   (-6 -6          255 255 255 255 255 255 255 255 255 255 255 255)
   (-7 -5      255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-7 -4      255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-8 -3  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-8 -2  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-8 -1  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-8  0  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-8  1  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-8  2  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-7  3      255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-7  4      255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-6  5          255 255 255 255 255 255 255 255 255 255 255 255)
   (-5  6              255 255 255 255 255 255 255 255 255 255)
   (-3  7                      255 255 255 255 255 255) >


[+ 4b +] <
   (-3 -8                       36  46  50  50  46  36)
   (-5 -7               39  64  82  94  98  98  94  82  64  39)
   (-6 -6           46  79 105 125 138 142 142 138 125 105  79  46)
   (-7 -5       39  79 113 142 163 176 180 180 176 163 142 113  79  39)
   (-7 -4       64 105 142 172 194 207 212 212 207 194 172 142 105  64)
   (-8 -3   36  82 125 163 194 217 231 236 236 231 217 194 163 125  82  36)
   (-8 -2   46  94 138 176 207 231 245 250 250 245 231 207 176 138  94  46)
   (-8 -1   50  98 142 180 212 236 250 255 255 250 236 212 180 142  98  50)
   (-8  0   50  98 142 180 212 236 250 255 255 250 236 212 180 142  98  50)
   (-8  1   46  94 138 176 207 231 245 250 250 245 231 207 176 138  94  46)
   (-8  2   36  82 125 163 194 217 231 236 236 231 217 194 163 125  82  36)
   (-7  3       64 105 142 172 194 207 212 212 207 194 172 142 105  64)
   (-7  4       39  79 113 142 163 176 180 180 176 163 142 113  79  39)
   (-6  5           46  79 105 125 138 142 142 138 125 105  79  46)
   (-5  6               39  64  82  94  98  98  94  82  64  39)
   (-3  7                       36  46  50  50  46  36) >

[+ 5a +] <
   ( -3 -12                                      255 255 255 255 255 255)
   ( -5 -11                              255 255 255 255 255 255 255 255 255 255)
   ( -7 -10                      255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   ( -8  -9                  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   ( -9  -8              255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-10  -7          255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-10  -6          255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-11  -5      255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-11  -4      255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-12  -3  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-12  -2  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-12  -1  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-12   0  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-12   1  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-12   2  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-11   3      255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-11   4      255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-10   5          255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   (-10   6          255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   ( -9   7              255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   ( -8   8                  255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   ( -7   9                      255 255 255 255 255 255 255 255 255 255 255 255 255 255)
   ( -5  10                              255 255 255 255 255 255 255 255 255 255)
   ( -3  11                                      255 255 255 255 255 255) >

[+ 5b +] <
   ( -3 -12                                       27  32  33  33  32  27)
   ( -5 -11                               41  52  60  64  66  66  64  60  52  41)
   ( -7 -10                       39  56  71  82  91  96  98  98  96  91  82  71  56  39)
   ( -8  -9                   45  66  84  99 111 120 126 128 128 126 120 111  99  84  66  45)
   ( -9  -8               45  69  91 110 126 138 148 153 155 155 153 148 138 126 110  91  69  45)
   (-10  -7           39  66  91 113 133 150 163 172 178 180 180 178 172 163 150 133 113  91  66  39)
   (-10  -6           56  84 110 133 153 171 184 194 200 202 202 200 194 184 171 153 133 110  84  56)
   (-11  -5       41  71  99 126 150 171 188 202 213 219 221 221 219 213 202 188 171 150 126  99  71  41)
   (-11  -4       52  82 111 138 163 184 202 217 227 233 236 236 233 227 217 202 184 163 138 111  82  52)
   (-12  -3   27  60  91 120 148 172 194 213 227 238 244 246 246 244 238 227 213 194 172 148 120  91  60  27)
   (-12  -2   32  64  96 126 153 178 200 219 233 244 251 253 253 251 244 233 219 200 178 153 126  96  64  32)
   (-12  -1   33  66  98 128 155 180 202 221 236 246 253 255 255 253 246 236 221 202 180 155 128  98  66  33)
   (-12   0   33  66  98 128 155 180 202 221 236 246 253 255 255 253 246 236 221 202 180 155 128  98  66  33)
   (-12   1   32  64  96 126 153 178 200 219 233 244 251 253 253 251 244 233 219 200 178 153 126  96  64  32)
   (-12   2   27  60  91 120 148 172 194 213 227 238 244 246 246 244 238 227 213 194 172 148 120  91  60  27)
   (-11   3       52  82 111 138 163 184 202 217 227 233 236 236 233 227 217 202 184 163 138 111  82  52)
   (-11   4       41  71  99 126 150 171 188 202 213 219 221 221 219 213 202 188 171 150 126  99  71  41)
   (-10   5           56  84 110 133 153 171 184 194 200 202 202 200 194 184 171 153 133 110  84  56)
   (-10   6           39  66  91 113 133 150 163 172 178 180 180 178 172 163 150 133 113  91  66  39)
   ( -9   7               45  69  91 110 126 138 148 153 155 155 153 148 138 126 110  91  69  45)
   ( -8   8                   45  66  84  99 111 120 126 128 128 126 120 111  99  84  66  45)
   ( -7   9                       39  56  71  82  91  96  98  98  96  91  82  71  56  39)
   ( -5  10                               41  52  60  64  66  66  64  60  52  41)
   ( -3  11                                       27  32  33  33  32  27) >

> [+++ Blots +++]

T
