[brushDialog.l 14aug92]

(off Brushes)

<de bdlg-set (obj)
   (setq Brush
      (mapcar (get obj 'sBar) GetCtlValue) >

<de bdlg-text (obj)
   (with obj
      (mapc2 (slot text) (slot sBar)
         '((c1 c2)
            (unless (eq (car c1) (GetCtlValue c2))
               (rplaca c1 (GetCtlValue c2))
               (SetIText (cdr c1)
                  (pixPercent (GetCtlValue c2)) >

<de bdlg-paint (obj)
   (local (l)
      (with obj
         (setq l (slot sBar))
         (localPort (slot winPtr)
            (RGBForeColor
               (rgb
                  (GetCtlValue (car l))
                  (GetCtlValue (cadr l))
                  (GetCtlValue (caddr l))
                  (GetCtlValue (cadddr l)) ) )
            (PaintRect '((6.90) 280.120))
            (RGBForeColor 0) >

(object brushDialog modeless)

(setq :pos)

<to T (obj c)
   (when (needMem #(mul 4 1024))
      (if Brushes
         (progn
            (rplaca :pos (add 4 (car :pos)))
            (rplacd :pos (add 8 (cdr :pos))) )
         (setq :pos (cons 12 80)) )
      (from modeless T obj
         (dialog #(add 010000 rDocProc) #(str "Brush") T :pos 290 160
            #resCtrl (80.10) 200 20 #hSBarId [1]
            #resCtrl (80.30) 200 20 #hSBarId [2]
            #resCtrl (80.50) 200 20 #hSBarId [3]
            #resCtrl (80.70) 200 20 #hSBarId [4]
            #resCtrl (80.124) 200 20 #hSBarId [5]
            #statText (32.10) 36 16 "0" [6]
            #statText (32.30) 36 16 "0" [7]
            #statText (32.50) 36 16 "0" [8]
            #statText (32.70) 36 16 "0" [9]
            #statText (32.124) 36 16 "0" [10]
            #statText (6.10) 24 16 "C:"
            #statText (6.30) 24 16 "M:"
            #statText (6.50) 24 16 "Y:"
            #statText (6.70) 24 16 "K:"
            #statText (6.124) 24 16 "I:"
            #statText (98.142) 32 16 "0"
            #statText (133.142) 32 16 "25"
            #statText (171.142) 32 16 "50"
            #statText (208.142) 32 16 "75"
            #statText (242.142) 32 16 "100" ) )
      (with obj
         (slot sBar
            (mapcar (1 2 3 4 5)
               '((i)
                  (setq i (d-item (slot winPtr) i))
                  (SetCtlMin i 25)
                  (SetCtlMax i 225)
                  (SetCtlValue i (pop c))
                  (ShowControl i)
                  i ) ) )
         (slot text
            (mapcar (6 7 8 9 10)
               '((i) (cons 0 (d-item (slot winPtr) i))) ) )
         (bdlg-text obj) >

<to close (obj)
   (cut obj Brushes)
   (from modeless close obj) >

<to activate (obj)
   (cut obj Brushes)
   (push obj Brushes)
   (bdlg-set obj)
   (from modeless activate obj) >

<to deActivate (obj)
   (SendBehind (get obj 'winPtr)) >

<to content (obj pt)
   (from modeless content obj pt
      '((pt part cntl)
         (with obj
            (when (memq cntl (slot sBar))
               (scroll pt part cntl
                  progn (bdlg-text obj) (bdlg-paint obj)) )
            (bdlg-set obj)
            (bdlg-text obj)
            (bdlg-paint obj) >

<to update (obj)
   (from modeless update obj
      '(() (bdlg-paint obj)) >

<to set (obj c)
   (mapc2 (get obj 'sBar) c SetCtlValue)
   (bdlg-set obj)
   (bdlg-text obj)
   (bdlg-paint obj) >

T
