[cmyk.l 14aug92]

(setq :blend 10000)

(object cmyk picApp)

<to classify () 'cmyk>

<to T (obj z r)
   (with obj
      (slot home (get App 'home))
      (slot name
         (append
            (get (get App 'home) 'name)
            " - Zoom "
            (format z) ) )
      (slot zoom z)
      (from docWin T obj
         (winLoc -30 22)
         (mul 640 z)
         (mul 640 z)
         (slot name)
         r )
      (start obj) >

<to close (obj)
   (busy 10000)
   (do hide 'spot)
   [(zapUndo)]
   (offPxSrc)
   (with obj
      (slot- undo Undo)
      (slot- redo Redo)
      (slot- mark Mark)
      (slot- zooms (delete obj (slot- zooms))) )
   (peepUp obj)
   (from picApp close obj)
   T >

<to setUp (App)
   (setMenu RMBar)
   (and Fats (do show 'fatPix))
   (and MsrWin (do show 'msrWin))
   (markTool)
   (and ShowTools (do show Tools))
   (all show Brushes) >

<to begin (App)
   (put Tools 'app App)
   (markTool)
   (with App
      (put (slot- peep) 'app App)
      (do show (slot- peep))
      (setq
         Undo (slot- undo)
         Redo (slot- redo)
         Mark (slot- mark) ) )
   (setUndo)
   (setRedo)
   (and
      PxSrc
      (neq 'pixelCopy (getMode))
      (h-mask 'pixelCopy #(str "Pixel Copy Mode") T) >

<to end (App)
   (with App
      (do hide (slot- peep))
      (do hide 'spot)
      (slot- undo Undo)
      (slot- redo Redo)
      (slot- mark Mark) >

<to cleanUp (App)
   (all hide Brushes)
   (do hide Tools)
   (do hide 'msrWin)
   (do hide 'fatPix) >

<to click (App win pt)
   (with App
      (when (eq win (get (slot- peep) 'winPtr))
         (do content (slot- peep) pt)
         T >

(zero :cnt)
<to idle (App)
   (when (eq 200 (inc :cnt))
      (zero :cnt)
      (msrMem) )
   (fatSpot) >

<to grow (App pt)
   (from docWin grow App pt (get App 'zoom))
   (InvalRect (portRect (get App 'winPtr)))
   (peepUp App) >

<to zoom (App f)
   (from docWin zoom App f)
   (peepUp App) >

<to scroll (App cntl part pt)
   (from docWin scroll App cntl part pt (get App 'zoom))
   (peepUp App) >

<to update (obj)
   (from docWin update obj
      '(()
         (busy 10000)
         (showTiles obj (eq (get obj 'home) (get App 'home))) >

[++ File Menu ++]
<de newCmd ()
   (when (needMem #(add (mul 4 640 640) (mul 4 256 256)))
      [(zapUndo)]
      (new '(mask cmyk2)) >

<de doOpen (nm)
   (if
      (find Apps
         '((obj)
            (with obj
               (and
                  (eq (GetVol) (slot- vol))
                  (equal nm (slot- name)) ) ) ) )
      (generalAlert "" nm #(str "is already open"))
      (local (tmp fd1 fd b sc h v)
         (when (setq fd (open nm))
            (when
               (localVol Bin
                  (and
                     (needVol 0 (fSize fd))
                     (setq fd1 (create (setq tmp (genTmp)))) ) )
               (if
                  (rdCMYK
                     progress (append #(str "Open Image: ") nm)
                     fd fd1 b sc h v )
                  (flag
                     (new '(mask cmyk1) (GetVol) nm tmp fd1 b sc h v)
                     'there )
                  (progn (close fd1) (erase tmp)) ) )
            (close fd) >
<de openCmd ()
   (local (nm)
      (when
         (and
            (needMem #(add (mul 4 640 640) (mul 4 256 256)))
            (setq nm
               (getFile1 #(str "Open Image")
                  #(str "Open") "CMYK" ) ) )
         [(zapUndo)]
         (doOpen nm) >

<de saveCmd ()
   (with App
      (saveCmyk (slot- name) (slot- vol)) >

<de revertCmd ()
   (local (fd)
      (with App
         (localVol (slot- vol)
            (when
               (and
                  (needMem (mul #(mul 4 tile2) (slot- cols)))
                  (setq fd (open (slot- name))) )
               (rdCMYK
                  progress #(str "Revert to Saved")
                  fd (slot- fd) )
               (close fd)
               (zapUndo)
               (slot- dirty (array 0 20))
               (remove (get App 'home) 'dirty)
               (readTiles -app)
               (invalCmyks App) >

<de restoreCmd ()
   (local (w fd buf)
      (with -app
         (localVol (slot- vol)
            (when
               (and
                  (needMem (mul #(mul 2 4 tile2) (slot- cols)))
                  (setq w (blendDialog :blend))
                  (setq fd (open (slot- name))) )
               (setq :blend w)
               (zapUndo)
               (cond
                  (Mark
                     (flushTiles)
                     (setq buf (alloc (mul #(mul 4 tile2) (slot- cols))))
                     (catch T
                        (progress
                           (scanLines Mark)
                           #(str "Restore Mask Contents") )
                        (scan Mark 2
                           '((v h1 h2 [f])
                              (tfRead fd buf (slot- cols) v h1 h2)
                              (tfWrite (slot- fd) buf (slot- cols)
                                 v h1 h2 w )
                              (unless (progress) (throw T)) ) ) )
                     (flag (get App 'home) 'dirty) )
                  ((eq w 10000)
                     (rdCMYK
                        progress #(str "Revert to Saved")
                        fd (slot- fd) )
                     (slot- dirty (array 0 20))
                     (remove (get App 'home) 'dirty) )
                  (T
                     (flushTiles)
                     (catch T
                        (progress
                           (slot- rows)
                           #(str "Restore Whole Image") )
                        (for (i 0 (slot- rows))
                           (restor fd (slot- fd) (slot- cols) w i)
                           (unless (progress) (throw T)) ) )
                     (flag (get App 'home) 'dirty) ) )
               (close fd)
               (readTiles App)
               (invalCmyks App) >

<de loadMaskCmd ()
   (local (nm f g)
      (when
         (and
            (setq nm (getFile1 #(str "Load Mask") #(str "Load") "pGrf"))
            (setq f (open nm))
            (setq g (read f))
            (close f)
            (fitMask g) )
         (make #(str "Load Mask") NIL
            (list (is showMask (get App 'home)))
            '((f)
               (removeMask Mark)
               ((if f flag remove) (get App 'home) 'showMask)
               (invalOthers) )
            (list g)
            '((g)
               (mapc g
                  '((z)
                     (drawMask z)
                     (hiMask z) ) )
               (invalOthers)
               (with App
                  (flag (get App 'home) 'showMask)
                  (slot- mask
                     (append g (slot- mask)) >

<de saveMaskCmd ()
   (local (s f)
      (localVol (GetVol)
         (when
            (and
               (setq s
                  (putFile1 #(str "Save Mask")
                     #(str "Save") "FreeMask" ) )
               (setq f (create s)) )
            (print (get App 'home 'mask) f)
            (close f)
            (fType s "pGrf") >

[++ Edit Menu ++]
<de cutCmd ()
   (local (dh dv)
      (with App
         (setq
            dh (minus (mul #tile (slot- pos-h)))
            dv (minus (mul #tile (slot- pos-v))) )
         (make #(str "Cut") NIL
            (list Mark CmykClip)
            '((m c)
               (putMask m)
               (setq CmykClip c)
               (invalOthers) )
            (list (mvGraf Mark dh dv))
            '((g)
               (setq CmykClip g)
               (removeMask Mark)
               (invalOthers) >

<de copyCmd ()
   (local (dh dv)
      (with App
         (setq
            dh (minus (mul #tile (slot- pos-h)))
            dv (minus (mul #tile (slot- pos-v))) )
         (make #(str "Copy") NIL
            (list CmykClip)
            '((g) (setq CmykClip g))
            (list (mvGraf Mark dh dv))
            '((g) (setq CmykClip g) >

<de pasteCmd ()
   (local (g)
      (when (fitMask CmykClip)
         (with App
            (setq g
               (mvGraf CmykClip
                  (mul #tile (slot- pos-h))
                  (mul #tile (slot- pos-v)) ) )
            (while (find g '((z) (member z (slot- mask))))
               (setq g (mvGraf g 10 10)) )
            (make #(str "Paste") NIL
               (list Mark)
               '((g)
                  (removeMask Mark)
                  (mapc g hiMask)
                  (invalOthers) )
               (list g)
               '((g)
                  (putMask g)
                  (invalOthers) >

<de clearCmd ()
   (make #(str "Clear") NIL
      (list Mark)
      '((g)
         (putMask g)
         (invalOthers) )
      NIL
      '(()
         (removeMask Mark)
         (setq Mark)
         (invalOthers) >

<de dupCmd ()
   (make #(str "Duplicate") NIL
      (list Mark)
      '((g)
         (removeMask Mark)
         (mapc g hiMask)
         (invalOthers) )
      (list Mark)
      '((g)
         (putMask (mvGraf g 10 10))
         (invalOthers) >

<de allCmd ()
   (make #(str "Select All") NIL
      (list Mark)
      '((g)
         (mapc Mark
            '((z)
               (or
                  (memq z g)
                  (unHiMask z) ) ) )
         (invalOthers) )
      (with App (list (slot- mask)))
      '((g)
         (mapc g hiMask)
         (invalOthers) >

<de mirrorCmd ()
   (with App
      (make #(str "Mirror") NIL
         (list Mark (slot- mask))
         undoMask
         (list (mirror Mark) T)
         makeMask >

<de invertCmd ()
   (with App
      (make #(str "Invert") NIL
         (list Mark (slot- mask))
         undoMask
         (list (invert Mark) T)
         makeMask >

[++ Retouch Menu ++]
<de maskCmd ()
   (unless (eq 'mask (getMode))
      [(all hide Brushes)]
      (s-mask) >

<de msrCmd ()
   (unless (eq 'measure (getMode))
      (h-mask 'measure #(str "Measure Mode"))
      (do print 'spot #(str "Measure")) >

<de spuitCmd ()
   (unless (eq 'spuit (getMode))
      (h-mask 'spuit #(str "Spuit Mode"))
      (enterSrc) >

<de pxlCopyCmd ()
   (unless (eq 'pixelCopy (getMode))
      (h-mask 'pixelCopy #(str "Pixel Copy Mode"))
      (enterSrc) >

<de brushCmd ()
   (unless (eq 'brush (getMode))
      (h-mask 'brush #(str "Brush Mode")) >

<de softenCmd ()
   (unless (eq 'soften (getMode))
      (h-mask 'soften #(str "Soften Mode")) >

<de sharpenCmd ()
   (unless (eq 'sharpen (getMode))
      (h-mask 'sharpen #(str "Sharpen Mode")) >

<de cBitsCmd ()
   (local (d)
      (and
         (setq d
            (storage
               (mul #(mul 4 tile2) (get App 'home 'cols))
               (mul 4 (scan Mark 2)) ) )
         (make #(str "Copy Pixel") NIL
            (list Bitsclip)
            '((x) (setq Bitsclip x))
            (list (saveColor Mark d) Mark)
            '((d m) (setq BitsClip (cons d m))) >

[++++++
<de pBitsCmd ()
   (local (u)
      (and
         (setq u
            (storage
               (mul #(mul 4 tile2) (get App 'home 'cols))
               (mul 4 (scan Mark 2)) ) )
         (pasteBits u #(str "Paste Pixel")) >
++++++]

<de blendCmd ()
   (local (g f m w)
      (setq g Mark)
      (when (setq f (isMirror (cdr BitsClip) Mark))
         (setq g (mirror g 0)) )
      (when (isInvert (cdr BitsClip) Mark)
         (setq g (invert g 0)) )
      (and
         (setq m
            (storage
               (mul #(mul 4 tile2) (get App 'home 'cols))
               (mul 4 (scan g 2)) ) )
         (setq w (blendDialog :blend))
         (progn
            (setq :blend w)
            (busy 20000)
            (make #(str "Blend") T
               (list (saveColor g m f) g f)
               undoColor
               (list (car BitsClip) w g f)
               doPasteBits >

<de lToneCmd ()
   (local (u crv)
         (and
            (setq u
               (storage
                  (mul #(mul 4 tile2) (get App 'home 'cols))
                  (mul 4 (scan Mark 2)) ) )
            (setq crv (curvDialog))
            (make #(str "Local Tone Change") T
               (list (saveColor Mark u) Mark)
               undoColor
               (list crv)
               '((crv)
                  (colSet crv)
                  (progress (scanLines Mark) #(str "Local Tone Change"))
                  (with App
                     (if (hasMask Mark)
                        <local (b dh dv)
                           (touchMask Mark)
                           (setq
                              b (slot- base)
                              dh (mul #tile (slot- pos-h))
                              dv (mul #tile (slot- pos-v)) )
                           (localLock b
                              (catch T
                                 (scan Mark 2
                                    '((v h1 h2 [f])
                                       (chgCol
                                          (pixPtr b
                                             (sub h1 dh) (sub v dv) )
                                          (sub h2 h1) )
                                       (unless (progress) (throw T)) >
                        <local (buf)
                           (with App
                              (flushTiles)
                              (setq buf
                                 (alloc
                                    (mul #(mul 4 tile2) (slot- cols))))
                              (catch T
                                 (scan Mark 2
                                    '((v h1 h2)
                                       (tfRead (slot- fd)
                                          buf (slot- cols) v h1 h2 )
                                       (chgCol buf (sub h2 h1))
                                       (tfWrite (slot- fd)
                                          buf (slot- cols) v h1 h2 )
                                       (unless (progress) (throw T)) ) ) )
                              (free buf)
                              (flag (get App 'home) 'dirty)
                              (readTiles App) > )
                     (invalCmyks App) >

<de gToneCmd ()
   (local (n siz crv buf pos)
      (with App
         (setq
            n (mul #tile2 (slot- cols))
            siz (mul 4 n) )
         (when (and (needMem siz) (setq crv (curvDialog)))
            (zapUndo)
            (flushTiles)
            (setq buf (alloc siz))
            (colSet crv)
            (progress (slot- rows) #(str "Global Tone Change"))
            (setq pos #TFHEAD)
            (catch T
               (reptn (slot- rows)
                  (seek pos (slot- fd))
                  (readBlock (slot- fd) buf siz)
                  (chgCol buf n)
                  (seek pos (slot- fd))
                  (writeBlock (slot- fd) buf siz)
                  (inc pos siz)
                  (unless (progress) (throw T)) ) )
            (free buf)
            (flag (get App 'home) 'dirty)
            (readTiles App)
            (invalCmyks App) >

<de loCmd ()
   (pixFilter pixLo #(str "Low Pass Filter")) >

<de hiCmd ()
   (pixFilter pixHi #(str "High Pass Filter")) >

<de zoomCmd ()
   (local (pt1 pt2 r h v z1 z2)
      (when
         (and
            (needMem #(mul 4 1024))
            (setq pt1 (click NIL NIL fatSpot))
            (setq pt2
               (click NIL stiff zoomSpot pt1
                  '((oPt nPt) (FrameRect (bounds oPt nPt)))
                  T ) )
            (setq r (bounds pt1 pt2))
            (plusp (setq h (sub (right r) (left r))))
            (plusp (setq v (sub (bottom r) (top r)))) )
         (setq
            z2 (calcZoom h v)
            z1 (div z2 (get App 'zoom)) )
         (if (lessp 50 z2)
            (SysBeep 8)
            (with App
               (slot- zooms
                  (cons
                     (new (list (getMode) 'cmyk)
                        z2
                        (cons2
                           (mul z1 (left r))
                           (mul z1 (top r))
                           (mul z1 (right r))
                           (mul z1 (bottom r)) ) )
                     (slot- zooms) >

[++ Freeline Menu ++++]
<de tglMsk ()
   ((if (is showMask (get App 'home)) remove flag)
      (get App 'home)
      'showMask )
   (updtAllMasks) >

<de showMaskCmd ()
   (make #(str "Toggle Show Mask") NIL
      NIL
      tglMsk
      NIL
      tglMsk >

<de showCutCmd ()
   (with App
      (slot- showCut (not (slot- showCut))) )
   (invalCmyks App) >

<de showToolsCmd ()
   (if (toggle ShowTools)
      (do show Tools)
      (do hide Tools) >

T
