[cmykPrim.l 14aug92]

<de invalOthers ()
   (with App
      (if (eq App (slot home))
         (all inval (slot zooms))
         (progn
            (do inval (slot home))
            (mapc (get (slot home) 'zooms)
               '((obj) (or (eq obj App) (do inval obj))) >

<de updtAllMasks ()
   (with App
      (and
         (slot- mask)
         (invalCmyks App) >

[When set to mask mode, show masks]
<de doSMask ()
   (offPxSrc)
   (do hide 'spot)
   (flag (get App 'home) 'showMask)
   (updtAllMasks)
   (setMode 'mask)
   (markTool) >

<de s-mask ()
   (busy 10000)
   (make #(str "Mask Mode") NIL
      (list (getMode))
      doHMask
      NIL
      doSMask >

[When change cmykModi, hide masks]
<de doHMask (m f)
   (or f (offPxSrc))
   (do hide 'spot)
   (when (eq 'mask (getMode))
      (remove (get App 'home) 'showMask)
      (updtAllMasks) )
   (setMode m)
   (markTool) >

<de h-mask (m s f)
   (busy 10000)
   (make s NIL
      (list (getMode))
      '((m) (if (eq m 'mask) (doSMask) (doHMask m)))
      (list m f)
      doHMask >

<de undoMask (x y)
   (mapc Mark drawHiMask)
   (mapc (setq Mark x) drawHiMask)
   (with App (slot- mask y))
   (invalOthers) >

<de makeMask (x f)
   (with App
      (mapc Mark
         '((z)
            (when (or f Redo)
               (drawHiMask z) )
            (slot- mask (delete z (slot- mask))) ) )
      (mapc (setq Mark x)
         '((z)
            (when (or f Redo)
               (drawHiMask z) )
            (slot- mask (cons z (slot- mask))) ) )
      (invalOthers) >

<de freeMaskRgn (pts)
   (local (rgn)
      (setq rgn (NewRgn))
      (OpenRgn)
      (drawMask pts)
      (CloseRgn rgn)
      rgn >

<de enterSrc ()
   (do print 'spot #(str "Enter Source")) >

<de enterDst ()
   (do print 'spot #(str "Enter Destination")) >

<de peepUp (obj)
   (with obj
      (do inval (slot- peep) >

<de invalCmyks (obj)
   (with obj
      (do inval (slot home))
      (all inval (get (slot home) 'zooms)) >

<de putMask (lst)
   (mapc Mark unHiMask)
   (mapc lst drawMask)
   (with App
      (slot- mask
         (append (slot- mask) lst) )
      (mapc lst hiMask) >

<de removeMask (lst)
   (with App
      (mapc lst
         '((z)
            (slot- mask
               (delete z (slot- mask)) )
            (drawMask z)
            (unHiMask z) >

<de zoomSpot (pt1 pt2)
   (fatSpot)
   (local (h v)
      (and
         (not (zerop (setq h (sub (car pt1) (car pt2)))))
         (not (zerop (setq v (sub (cdr pt1) (cdr pt2)))))
         (if (lessp 50 (calcZoom h v))
            (do hide 'spot)
            (do print 'spot
               (append
                  "Zoom "
                  (format (calcZoom h v))) >

<de refine (z)
   (mapcon z
      '((x)
         (if (and (cadr x) (lessp 8  (distPt (car x) (cadr x))))
            (list
               (car x)
               (midPt (car x) (cadr x)) )
            (list (car x)) >

<de optim (pt l)
   (local (w h1 v1 h v h2 v2 wx)
      (zero w)
      (setq
         h1 (sub (car pt) :dh)
         v1 (sub (cdr pt) :dv)
         h (sub (caar l) :dh)
         v (sub (cdar l) :dv)
         h2 (sub (caadr l) :dh)
         v2 (sub (cdadr l) :dv) )
      (if (lessp (abs (sub h2 h1)) (abs (sub v2 v1)))
         (for (i (sub2 h) (add 3 h))
            (setq wx
               (add
                  (colEdge :bs h1 v1 i v)
                  (colEdge :bs i v h2 v2) ) )
            (when (lessp w wx)
               (rplaca (car l) (add i :dh))
               (setq w wx) ) )
         (for (i (sub2 v) (add 3 v))
            (setq wx
               (add
                  (colEdge :bs h1 v1 h i)
                  (colEdge :bs h i h2 v2) ) )
            (when (lessp w wx)
               (rplacd (car l) (add i :dv))
               (setq w wx) >

<de optimize (l)
   (prog1 (setq l (copy l))
      (optim (last2 l) l)
      (rplaca (tail l) (car l))
      (reptn (sub2 (length l))
         (optim (pop l) l) >

<de optimCmd ()
   (busy 20000)
   (local (:bs :dh :dv)
      (with App
         (setq
            :bs (slot- base)
            :dh (mul #tile (slot- pos-h))
            :dv (mul #tile (slot- pos-v)) )
         (make #(str "Optimize") NIL
            (list Mark (slot- mask))
            undoMask
            (list
               (mapcar Mark
                  '((z)
                     (optimize
                        (optimize
                           (refine z) ) ) ) )
               T )
            makeMask >

T
