[dialog.l 14aug92]

<de rtScroll (dlg ev il)
   (when (eq #mouseDown (ev-what ev))
      (local (pt part cntl i v)
         (localPort dlg
            (setq
               pt (GlobalToLocal (ev-where ev))
               part (FindControl pt dlg cntl) )
            (when
               (setq i
                  (find il
                     '((i)
                        (or (eq cntl (car i)) (eq cntl (cdr i))) ) ) )
               <if (eq part #inThumb)
                  (unless (zerop (TrackControl cntl pt))
                     (if (eq cntl (car i))
                        (SetCtlValue (cdr i)
                           (limit (GetCtlValue (cdr i))
                              0 (GetCtlValue cntl) ) )
                        (SetCtlValue (car i)
                           (limit (GetCtlValue cntl)
                              (GetCtlValue (car i))
                              10000 ) ) ) )
                  (TrackControl cntl pt
                     '((cntl part)
                        (setq v (GetCtlValue cntl))
                        (case part
                           (#inUpButton
                              (SetCtlValue cntl (dec v 25)) )
                           (#inDownButton
                              (SetCtlValue cntl (inc v 25)) )
                           (#inPageUp
                              (SetCtlValue cntl (dec v 2500)) )
                           (#inPageDown
                              (SetCtlValue cntl (inc v 2500)) ) )
                        (if (eq cntl (car i))
                           (SetCtlValue (cdr i)
                              (limit (GetCtlValue (cdr i)) 0 v) )
                           (SetCtlValue (car i)
                              (limit (GetCtlValue (car i)) v 10000) >
               NIL >

<de rtDlg (ttl a1 a2 b1 b2 c1 c2 d1 d2 e1 e2 val)
   (local (dlg il itemHit)
      (setq
         dlg (dialog #dBoxProc NIL NIL (100.100) 400 340
            #btnCtrl (50.300) 50 20 #(str "Ok")
            #btnCtrl (290.300) 70 20 #(str "Cancel")
            #statText (120.15) 160 16 ttl
            #resCtrl (100.50) 200 20 #hSBarId [4]
            #resCtrl (100.68) 200 20 #hSBarId [5]
            #resCtrl (100.100) 200 20 #hSBarId [6]
            #resCtrl (100.118) 200 20 #hSBarId [7]
            #resCtrl (100.150) 200 20 #hSBarId [8]
            #resCtrl (100.168) 200 20 #hSBarId [9]
            #resCtrl (100.200) 200 20 #hSBarId [10]
            #resCtrl (100.218) 200 20 #hSBarId [11]
            #resCtrl (100.250) 200 20 #hSBarId [12]
            #resCtrl (100.268) 200 20 #hSBarId [13]
            #statText (10.60) 80 16 a1
            #statText (310.60) 80 16 a2
            #statText (10.110) 80 16 b1
            #statText (310.110) 80 16 b2
            #statText (10.160) 80 16 c1
            #statText (310.160) 80 16 c2
            #statText (10.210) 80 16 d1
            #statText (310.210) 80 16 d2
            #statText (10.260) 80 16 e1
            #statText (310.260) 80 16 e2 )
         il (mapcar '((4.5) (6.7) (8.9) (10.11) (12.13))
            '((i)
               (cons
                  (d-item dlg (car i))
                  (d-item dlg (cdr i)) ) ) ) )
      (mapc2 il val
         '((i v)
            (SetCtlValue (car i) (cdr v))
            (SetCtlValue (cdr i) (car v))
            (ShowControl (car i))
            (ShowControl (cdr i)) ) )
      (boldItem dlg 1)
      (while
         (lessp 2
            (ModalDialog
               '((dlg ev itemHit)
                  (or
                     (doDlg dlg ev itemHit)
                     (rtScroll dlg ev il) ) )
               itemHit ) ) )
      (prog1
         (when (eq 1 itemHit)
            (mapcar il
               '((i)
                  (cons
                     (GetCtlValue (cdr i))
                     (GetCtlValue (car i)) ) ) ) )
         (DisposDialog dlg) >

<de aboutDialog ()
   (local (dlg itemHit)
      (setq dlg
         (dialog #dBoxProc NIL NIL (100.100) 300 200
            #btnCtrl (40.150) 50 20 #(str "Ok")
            #btnCtrl (130.150) 140 20 "About Plug-ins .."
            #statText (100.20) 160 20 "Retouch 1.00"
            #statText (80.70) 160  20 "32 Bit Image Editor"
            #statText (90.100) 160 20 "BUG Europe 1991" ) )
      (boldItem dlg 1)
      (until (onep (ModalDialog doDlg itemHit))
         (when (eq 2 itemHit)
            (mapc PlugFiles plugAbout) ) )
      (DisposDialog dlg) >

[+ Secial versions of Get/PutFile, restricted to current Folder +]
<de getBox (20.40) 220. 200)>

<de getFile1 (s1 s2 . lst)
   (local (d n s c dlg lh i itemHit)
      (setq
         d (reverse
            (filter (dir)
               '((s) (member (fType s) lst)) ) )
         n (TickCount)
         s )
      (localPort
         (setq dlg
            (dialog #dBoxProc NIL NIL (100.100) 350 220
               #btnCtrl (260.140) 70 20 s2
               #btnCtrl (260.180) 70 20 #(str "Cancel")
               #statText (40.14) 170 16 s1
               #iconItem (279.50) 32 32 #cautionIcon ) )
         (boldItem dlg 1)
         (FrameRect '#(szRect getBox -1 -1))
         (setq lh
            (LNew '#getBox (cons2 0 0 1 (length d))
               (0.0) 0 dlg T NIL NIL T ) )
         (zero i)
         (mapc d
            '((s)
               (cellText lh 0 i s)
               (inc i) ) )
         (while
            (lessp 2
               (ModalDialog
                  '((dlg ev itemHit)
                     (when (memq (ev-what ev) (#keyDown #autoKey))
                        (when
                           (lessp
                              (ptr #DoubleTime)
                              (sub (TickCount) n) )
                           (setq s) )
                        (setq n (TickCount))
                        (case
                           (setq c
                              (bitAnd #charCodeMask (ev-message ev)) )
                           (30 (hitCell lh \U))
                           (31 (hitCell lh \D))
                           ((3 13 27))
                           (T (hitCell lh (setq s (nconc1 s c)))) ) )
                     (HiliteControl (d-item dlg 1)
                        (if (LGetSelect T (0.0) lh) 0 255) )
                     (or
                        (doDlg dlg ev itemHit)
                        (and
                           (eq #mouseDown (ev-what ev))
                           (LClick
                              (GlobalToLocal (ev-where ev))
                              (ev-modifiers ev)
                              lh )
                           (word itemHit 1) ) ) )

                  itemHit ) ) )
         (prog1
            (and
               (onep itemHit)
               (setq i (LGetSelect T (0.0) lh))
               (cellText lh (car i) (cdr i)) )
            (LDispose lh)
            (DisposDialog dlg) >

<de putBox (20.40) 220. 168)>

<de putFile1 (s1 s2 nm)
   (local (pt d dlg lh i itemHit)
      (setq d (reverse (dir)))
      (localPort
         (setq dlg
            (dialog #dBoxProc NIL NIL (100.100) 350 220
               #btnCtrl (260.140) 70 20 s2
               #btnCtrl (260.180) 70 20 #(str "Cancel")
               #statText (40.14) 170 16 s1
               #editText (20.182) 200 16 nm
               #iconItem (279.50) 32 32 #cautionIcon ) )
         (boldItem dlg 1)
         (FrameRect '#(szRect putBox -1 -1))
         (setq lh
            (LNew '#putBox (cons2 0 0 1 (length d))
               (0.0) 0 dlg T NIL NIL T ) )
         (zero i)
         (mapc d
            '((s)
               (cellText lh 0 i s)
               (inc i) ) )
         (SelIText dlg 4 0 9999)
         (while
            (or
               (lessp 2
                  (ModalDialog
                     '((dlg ev itemHit)
                        (or
                           (doDlg dlg ev itemHit)
                           (and
                              (eq #mouseDown (ev-what ev))
                              (inRect
                                 (setq pt (GlobalToLocal (ev-where ev)))
                                 '#(cons
                                    (car putBox)
                                    (cons
                                       (add SBarWidth (right putBox))
                                       (bottom putBox) ) ) )
                              (prog1
                                 (LClick pt (ev-modifiers ev) lh)
                                 (when (setq i (LGetSelect T (0.0) lh))
                                    (SetIText
                                       (d-item dlg 4)
                                       (cellText lh (car i) (cdr i)) )
                                    (SelIText dlg 4 0 9999) ) )
                              (word itemHit 1) ) ) )
                     itemHit ) )
               (and
                  (onep itemHit)
                  (member (setq nm (GetIText (d-item dlg 4))) d)
                  (not
                     (yesNo
                        (append #(str "Replace existing ") nm "?")
                        (120.310) ) ) ) ) )
         (prog1
            (when (onep itemHit) nm)
            (LDispose lh)
            (DisposDialog dlg) >

<de doDlgScroll (dlg ev il)
   (when (eq #mouseDown (ev-what ev))
      (local (pt part cntl v)
         (localPort dlg
            (setq
               pt (GlobalToLocal (ev-where ev))
               part (FindControl pt dlg cntl) )
            (unless (eq part #inThumb)
               (when (memq cntl il)
                  (TrackControl cntl pt
                     '((cntl part)
                        (setq v (GetCtlValue cntl))
                        (case part
                           (#inUpButton
                              (SetCtlValue cntl (sub v 10)) )
                           (#inDownButton
                              (SetCtlValue cntl (add v 10)) )
                           (#inPageUp
                              (SetCtlValue cntl (sub v 1000)) )
                           (#inPageDown
                              (SetCtlValue cntl (add v 1000)) ) ) ) )
                  NIL >

<de blendDialog (val)
   (local (dlg il itemHit)
      (setq
         dlg (dialog #dBoxProc NIL NIL (100.100) 330 160
            #btnCtrl (40.120) 50 20 #(str "Ok")
            #btnCtrl (230.120) 70 20 #(str "Cancel")
            #statText (110.20) 160 16 #(str "Blend Intensity")
            #resCtrl (60.60) 200 20 #hSBarId [4]
            #statText (20.60) 40 16 "0%"
            #statText (270.60) 40 16 "100%"
            #statText (78.80) 32 16 "0"
            #statText (113.80) 32 16 "25"
            #statText (151.80) 32 16 "50"
            #statText (188.80) 32 16 "75"
            #statText (222.80) 32 16 "100" )
         il (list (d-item dlg 4)) )
      (SetCtlValue (car il) val)
      (ShowControl (car il))
      (boldItem dlg 1)
      (while
         (lessp 2
            (ModalDialog
               '((dlg ev itemHit)
                  (or
                     (doDlg dlg ev itemHit)
                     (doDlgScroll dlg ev il) ) )
               itemHit ) ) )
      (prog1
         (when (eq 1 itemHit)
            (GetCtlValue (car il)) )
         (DisposDialog dlg) >

<de fiveBarDlg (ttl a1 a2 b1 b2 c1 c2 d1 d2 e1 e2 val)
   (local (dlg il itemHit)
      (setq
         dlg (dialog #dBoxProc NIL NIL (100.100) 400 300
            #btnCtrl (50.250) 50 20 #(str "Ok")
            #btnCtrl (290.250) 70 20 #(str "Cancel")
            #statText (120.40) 160 16 ttl
            #resCtrl (100.90) 200 20 #hSBarId [4]
            #resCtrl (100.120) 200 20 #hSBarId [5]
            #resCtrl (100.150) 200 20 #hSBarId [6]
            #resCtrl (100.180) 200 20 #hSBarId [7]
            #resCtrl (100.210) 200 20 #hSBarId [8]
            #statText (10.90) 80 16 ttl
            #statText (310.90) 80 16 ttl
            #statText (10.120) 80 16 ttl
            #statText (310.120) 80 16 ttl
            #statText (10.150) 80 16 ttl
            #statText (310.150) 80 16 ttl
            #statText (10.180) 80 16 ttl
            #statText (310.180) 80 16 ttl
            #statText (10.210) 80 16 ttl
            #statText (310.210) 80 16 ttl )
         il (mapcar (4 5 6 7 8) '((i) (d-item dlg i))) )
      (mapc2 il val
         '((i v)
            (SetCtlValue i (or v 0))
            (ShowControl i) ) )
      (boldItem dlg 1)
      (while
         (lessp 2
            (ModalDialog
               '((dlg ev itemHit)
                  (or
                     (doDlg dlg ev itemHit)
                     (doDlgScroll dlg ev il) ) )
               itemHit ) ) )
      (prog1
         (when (eq 1 itemHit)
            (mapcar il GetCtlValue) )
         (DisposDialog dlg) >


(setq :point '(:h . :v))
(setq :curve)

<de Curves
   (((30.90) 159.219) . NIL)
   (((188.90) 317.219) . NIL)
   (((346.90) 475.219) . NIL)
   (((504.90) 633.219) . NIL) >

[++ Retouch mode tone changes ++]
[++ Init Color Tone Curves ++]
<de initCurve (n)
   (local (l)
      (setq l (list 0))
      (for (i 1 129)
         (nconc1 l i) )
      (rplacd (nth n Curves) l) >

(for (i 0 4)
   (initCurve i) )

<de curvDlgFilter (:dlg ev itemHit)
   (local (x crv dh dv i)
      (GetMouse :point)
      (if
         (setq :curve
            (find Curves
               '((c)
                  (and
                     (inRect :point (car c))
                     (lessp
                        (abs
                           (sub
                              (sub (bottom (car c)) (cdr :point))
                              (nth
                                 (sub (car :point) (left (car c)))
                                 (cdr c) ) ) )
                        3 ) ) ) ) )
         (SetCursor (ptr (GetCursor #crossCursor)))
         (progn
            (do hide 'spot)
            (SetCursor Arrow) ) )
      (case (ev-what ev)
         (#mouseDown
            (when (setq crv (copy :curve))
               (setq x (sub (car :point) (left (car :curve))))
               (drag :point curvSpot
                  '((oldPt newPt)
                     (plotCurve crv -1)
                     (setq
                        dh (sub (car newPt) (car :point))
                        dv (sub (cdr newPt) (cdr :point)) )
                     (cond
                        ((plusp (bitAnd #shiftKey (ev-modifiers ev)))
                           (map2 (cdr :curve) (cdr crv)
                              '((l1 l2)
                                 (rplaca l2
                                    (sub (car l1) dv dh) ) ) ) )
                        ((lessp x 32)
                           (setq i 129)
                           (map2 (cdr :curve) (cdr crv)
                              '((l1 l2)
                                 (rplaca l2
                                    (sub
                                       (car l1)
                                       (muldiv dv (dec i) 128) ) ) ) ) )
                        ((lessp #(sub 128 32) x)
                           (setq i 0)
                           (map2 (cdr :curve) (cdr crv)
                              '((l1 l2)
                                 (rplaca l2
                                    (sub
                                       (car l1)
                                       (muldiv dv (inc i) 128) ) ) ) ) )
                        (T
                           (setq i 0)
                           (map2 (cdr :curve) (cdr crv)
                              '((l1 l2)
                                 (rplaca l2
                                    (sub
                                       (car l1)
                                       (muldiv dv
                                          (gamma
                                             (muldiv (inc i) 100 128) )
                                          #(mul 128 60) ) ) ) ) ) ) )
                     (plotCurve crv 0) ) )
               (rplacd :curve (cdr crv)) )
            NIL )
         (#keyDown
            (case (bitAnd #charCodeMask (ev-message ev))
               ((3 13) (word itemHit 1))
               (27 (word itemHit 2))
               (#helpKey
                  (when Help
                     (Help)
                     (showCurves)
                     (word itemHit 9999) >

<de plotCurve (crv col)
   (local (h v l)
      (setq
         h (left (car crv))
         v (bottom (car crv))
         l (cdr crv) )
      (PenNormal)
      (RGBForeColor col)
      (MoveTo
         h
         (sub v (limit (pop l) 0 128) 1) )
      (while l
         (LineTo (inc h) (sub v (limit (pop l) 0 128) 1)) >

<de showCurves ()
   (mapc Curves
      '((c)
         (PenSize 2 2)
         (FrameRect (szRect (car c) -2 -2))
         (plotCurve c 0) >

<de curvSpot (pt1 pt2)
   (local (n)
      (setq n (muldiv (sub (cdr pt1) (cdr pt2)) 100 128))
      (do print 'spot
         (append
            (and (plusp n) "+")
            (format n)
            "%" >

<de curvDialog ()
   (local (dlg itemHit)
      (localPort (setq dlg (GetNewDialog #curvDlg NIL -1))
         (showCurves)
         (while (lessp 2 (ModalDialog curvDlgFilter itemHit))
            (when (lessp 7 itemHit 12)
               (dec itemHit 8)
               (plotCurve (nth itemHit Curves) -1)
               (initCurve itemHit)
               (plotCurve (nth itemHit Curves) 0) ) )
         (DisposDialog dlg)
         (when (eq 1 itemHit)
            (mapcar Curves
               '((x)
                  (mapcon (cdr x)
                     '((l)
                        (when (cadr l)
                           (list
                              (limit (mul2 (car l)) 0 255)
                              (limit
                                 (div2
                                    (add
                                       (mul2 (car l))
                                       (mul2 (cadr l)) ) )
                                 0 255 >

T
