[file.l 28aug92]

(zero :tmp)

<de genTmp ()
   (append "$$Tmp" (format (inc :tmp))) >

<de storage (mem siz)
   (if (and UseDisk (lessp #smallArea siz))
      (and
         (needMem mem)
         (needVol Bin siz)
         (dynamo
            '((nm) (localVol Bin (erase nm)))
            (genTmp) ) )
      (and
         (needMem (add mem siz))
         (dynamo free (alloc siz)) >

<de openErr (nm f)
   (generalAlert
      #(str "Fatal Error")
      #(str "Cannot open file")
      nm )
   (and f (throw 'error)) >

<de eraCmd ()
   (local (nm)
      (when
         (setq nm
            (getFile1 #(str "Erase File") #(str "Erase")
               "CMYK" "pGrf" "blot" "auto" ) )
         (or
            (erase nm)
            (generalAlert
               #(str "Fatal Error")
               #(str "Cannot erase")
               nm >

<de launchMPS ()
   (unless (find Apps '((obj) (not (do close obj))))
      (cleanUp)
      (and
         (chDir #mpsPath)
         (launch #mpsApp) >

<de openJournal ()
   (unless (boundp 'Drvr)
      (OpenDriver ".auto" Drvr)
      (word 08E8 Drvr) [JournalRef] >

<de jnlCmd ()
   (local (s)
      (when (setq s (putFile "Journal File"))
         (openJournal)
         (setq JFile (create s))
         (fType s "auto")
         (Control Drvr 18 JFile) [+ Set refNum +]
         (word 08DE 1) >

<de stopJnlCmd ()
   (word 08DE 0) [+ JournalFlag off +]
   (close JFile)
   (off JFile) >

<de doPlay ()
   (openJournal)
   (local (nm)
      (when JFile
         (close JFile)
         (off JFile) )
      (localVol (GetVol)
         (when (setq nm (getFile "auto" "TEXT"))
            (if (equal "auto" (fType nm))
               (setq
                  JFile (open nm)
                  Batch )
               (setq
                  Batch (cons (GetVol) (open nm))
                  JFile (open (getLine (cdr Batch))) ) )
            (Control Drvr 18 JFile)
            (word 08DE -1) >

<de chgttl (obj nm)
   (local (-a)
      (with obj
         (SetWTitle
            (slot winPtr)
            (slot name
               (cond
                  ((match '#(append '(-) " - Zoom " '(-a)) (slot name))
                     (append nm " - Zoom " -a) )
                  ((match '#(append "<" '(-) ">") (slot name))
                     (append "<" nm ">") )
                  (T nm) >

<de saveCmyk (nm vol d)
   (local (fd)
      (with App
         (when
            (or
               nm
               (setq nm
                  (putFile1 #(str "Save Image")
                     #(str "Save") (slot- name) ) ) )
            (localVol (slot- vol (or vol (GetVol)))
               (when
                  (needVol 0
                     (mul #(mul 4 tile2) (slot- cols) (slot- rows)) )
                  (setq fd (create nm))
                  (flushTiles)
                  (zapUndo)
                  (when
                     (prog1
                        (wrCMYK
                           progress (append #(str "Save Image: ") nm)
                           (slot- fd) fd (get (slot- peep) 'base) )
                        (close fd) )
                     (unless (equal nm (slot name))
                        (slot- name nm)
                        (chgttl (slot home) nm)
                        (with (slot home)
                           (mapc (slot zooms)
                              '((x) (chgttl x nm)) )
                           (mapc (slot cmyk2)
                              '((x) (chgttl x nm)) ) ) )
                     (fType nm "CMYK")
                     (or d (remove (slot home) 'dirty))
                     (flag (slot home) 'there)
                     (slot- erase NIL)
                     (peepUp App) >

<de MkRevFile ()
   (with App
      (localVol Bin
         (saveCmyk (slot- name) (slot- vol) T)
         (remove (slot home) 'there)
         (slot- erase (slot- name)) >

<de readTiles (obj h v c1 r1 c2 r2)
   (local (cols rows c r tl fd b)
      (busy 20000)
      (with obj
         (default
            h (slot- pos-h)
            v (slot- pos-v)
            c1 0
            r1 0
            c2 20
            r2 20 )
         (setq
            cols (slot- cols)
            rows (slot- rows)
            c (add c1 (min (sub c2 c1) (sub cols h)))
            r (add r1 (min (sub r2 r1) (sub rows v)))
            tl (add h c1 (mul cols (add v r1)))
            fd (slot- fd)
            b (slot- base) )
         (for (row r1 r)
            (rdTile (sub c c1) fd tl b c1 row Plane)
            (for (col c1 c)
               (store
                  (bitOff col (access (slot- dirty) row))
                  (slot- dirty)
                  row ) )
            (for (col c c2)
               (clTile b col row) )
            (inc tl cols) )
         (for (row r r2)
            (for (col c1 c2)
               (clTile b col row) >

<de showTiles (App f)
   (local (rgn1 rgn2)
      (with App
         (off rgn1)
         (when (and (slot- showCut) (slot- mask))
            (setq rgn1 (NewRgn))
            (mapc (slot- mask)
               '((x)
                  (setq rgn2 (freeMaskRgn x))
                  (UnionRgn rgn1 rgn2 rgn1)
                  (DisposeRgn rgn2) ) )
            (EraseRect (slot view)) )
         (localClip (slot view)
            (cmykBits (slot- base) 640 (slot zoom) rgn1)
            (when (is showMask (get App 'home))
               (mapc (slot- mask)
                  '((z)
                     (drawMask z)
                     (when (memq z (if f Mark (slot- mark)))
                        (hiZug z) ) ) ) )
            (PenNormal)
            (PenMode #patXor)
            (and PxSrcRgn (eq PxSrc App) (FrameRgn PxSrcRgn))
            (and (and f Poly) (drawMask Poly)) )
         (and rgn1 (DisposeRgn rgn1)) >

T
