[peep.l 14aug92]

(setq :point '(:h . :v))

[++ Flush dirty tiles to file ++]
<de flushTiles (h1 v1 h2 v2)
   (default  h1 0  v1 0  h2 20  v2 20)
   (local (l b cols rows col row)
      (with App
         (setq
            l (slot- dirty)
            b (slot- base)
            cols (slot- cols)
            rows (slot- rows) )
         (for (v v1 v2)
            (for (h h1 h2)
               (when (bit h (access l v))
                  (and
                     (lessp (setq col (add h (slot- pos-h))) cols)
                     (lessp (setq row (add v (slot- pos-v))) rows)
                     (wrTile (slot- fd)
                        (add col (mul row cols))
                        b h v Plane ) )
                  (store (bitOff h (access l v)) l v) >

[++ Move in tile file to new position ++]
<de mvPeep (dh dv)
   (unless (and (zerop dh) (zerop dv))
      (zapUndo)
      (local (h v b l)
         (with (get Peep 'app)
            (setq
               h (add dh (slot- pos-h))
               v (add dv (slot- pos-v))
               b (slot- base)
               l (slot- dirty) )
            (cond
               ((or (leq 20 (abs dh)) (leq 20 (abs dv)))
                  (flushTiles 0 0 20 20)
                  (readTiles (get Peep 'app) h v) )
               ((and (minusp dh) (minusp dv))
                  (flushTiles (add 20 dh) 0 20 20)
                  (flushTiles 0 (add 20 dv) 20 20)
                  (reptn (minus dv)
                     (shift l)
                     (push 0 l) )
                  (map l
                     '((x)
                        (rplaca x (bitl (minus dh) (car x))) ) )
                  (slot- dirty l)
                  (for (row (add 19 dv) -1 (sub1 row))
                     (for (col (add 19 dh) -1 (sub1 col))
                        (mvTile b col row (minus dh) (minus dv)) ) )
                  (readTiles (get Peep 'app) h v 0 0 (minus dh) 20)
                  (readTiles (get Peep 'app) h v 0 0 20 (minus dv)) )
               ((minusp dh)
                  (flushTiles (add 20 dh) 0 20 20)
                  (flushTiles 0 0 20 dv)
                  (chop dv l)
                  (reptn dv (nconc1 l 0))
                  (map l
                     '((x)
                        (rplaca x (bitl (minus dh) (car x))) ) )
                  (slot- dirty l)
                  (for (row dv 20)
                     (for (col (add 19 dh) -1 (sub1 col))
                        (mvTile b col row (minus dh) (minus dv)) ) )
                  (readTiles (get Peep 'app) h v 0 0 (minus dh) 20)
                  (readTiles (get Peep 'app) h v 0 (sub 20 dv)) )
               ((minusp dv)
                  (flushTiles 0 0 dh 20)
                  (flushTiles 0 (add 20 dv) 20 20)
                  (reptn (minus dv)
                     (shift l)
                     (push 0 l) )
                  (map l
                     '((x)
                        (rplaca x (bitr dh (car x))) ) )
                  (slot- dirty l)
                  (for (row (add 19 dv) -1 (sub1 row))
                     (for (col dh 20)
                        (mvTile b col row (minus dh) (minus dv)) ) )
                  (readTiles (get Peep 'app) h v (sub 20 dh) 0)
                  (readTiles (get Peep 'app) h v 0 0 20 (minus dv)) )
               (T
                  (flushTiles 0 0 dh 20)
                  (flushTiles 0 0 20 dv)
                  (chop dv l)
                  (reptn dv (nconc1 l 0))
                  (map l
                     '((x) (rplaca x (bitr dh (car x)))) )
                  (slot- dirty l)
                  (for (row dv 20)
                     (for (col dh 20)
                        (mvTile b col row (minus dh) (minus dv)) ) )
                  (readTiles (get Peep 'app) h v (sub 20 dh) 0)
                  (readTiles (get Peep 'app) h v 0 (sub 20 dv)) ) )
            (slot- pos-h h)
            (slot- pos-v v)
            (invalCmyks (slot home)) >

[++ Move Peep around ++]
<de dragPeep1 (pt)
   (local (sc rct1 rct2 h v dh dv)
      (with Peep
         (setq
            sc (slot scale)
            rct1 (portRect (slot winPtr)) )
         (with (slot app)
            (setq
               h (slot- pos-h)
               v (slot- pos-v) ) ) )
      (while (StillDown)
         (setq rct2 (peep1 h v))
         (GetMouse :point)
         (setq
            dh
            (sub
               (if (lessp (car :point) (car pt))
                  (sub
                     (max (car :point) (sub (car pt) (left rct2)))
                     (div2 sc) )
                  (add
                     (min
                        (car :point)
                        (sub (right rct1) (sub (right rct2) (car pt))) )
                     (div2 sc) ) )
               (car pt) )
            dv
            (sub
               (if (lessp (cdr :point) (cdr pt))
                  (sub
                     (max
                        (cdr :point)
                        (sub (cdr pt) (top rct2)) )
                     (div2 sc) )
                  (add
                     (min
                        (cdr :point)
                        (sub
                           (bottom rct1)
                           (sub (bottom rct2) (cdr pt)) ) )
                     (div2 sc) ) )
               (cdr pt) )
            dh (sub dh (rem dh sc))
            dv (sub dv (rem dv sc)) )
         (drawPeep h v)
         (inc h (div dh sc))
         (inc v (div dv sc))
         (drawPeep h v)
         (setq pt
            (cons
               (add dh (car pt))
               (add dv (cdr pt)) ) ) )
      (with (get Peep 'app)
         (mvPeep
            (sub h (slot- pos-h))
            (sub v (slot- pos-v)) >

<de dragPeep2 (pt)
   (local (z ph pv rct hScl vScl h v h1 v1 dh dv)
      (with (get Peep 'app)
         (setq
            z (slot zoom)
            ph (slot- pos-h)
            pv (slot- pos-v)
            rct (peep1 ph pv)
            hScl
            (div
               (mul z 1000 #tile (min 20 (slot- cols)))
               (sub (right rct) (left rct)) )
            vScl
            (div
               (mul z 1000 #tile (min 20 (slot- rows)))
               (sub (bottom rct) (top rct)) )
            rct (peep2 ph pv)
            h (mul 1000 (GetCtlValue (slot hSBar)))
            v (mul 1000 (GetCtlValue (slot vSBar)))
            h1 (mul 1000 (GetCtlMax (slot hSBar)))
            v1 (mul 1000 (GetCtlMax (slot vSBar))) )
         (while (StillDown)
            (GetMouse :point)
            (setq
               dh
               (limit
                  (sub (car :point) (car pt))
                  (div (minus (add 1000 h)) hScl)
                  (div (sub h1 h) hScl) )
               dv
               (limit
                  (sub (cdr :point) (cdr pt))
                  (div (minus (add 1000 v)) vScl)
                  (div (sub v1 v) vScl) ) )
            (FrameRect rct)
            (setq rct (mvRect rct dh dv))
            (FrameRect rct)
            (inc h (mul dh hScl))
            (inc v (mul dv vScl))
            (setq pt
               (cons
                  (add dh (car pt))
                  (add dv (cdr pt)) ) ) )
         (FrameRect rct)
         (setq
            h (div h 1000)
            v (div v 1000) )
         (localPort (slot winPtr)
            (SetCtlValue (slot hSBar) h)
            (SetCtlValue (slot vSBar) v)
            (do inval (get Peep 'app))
            (SetOrigin h v)
            (slot view (viewRect Port))
            (fixSBars (get Peep 'app)) )
         (FrameRect (peep2 ph pv)) >

[+++ Create new peep +++]
[++ Return outer peepRectangle in peepwindow ++]
<de peep1 (h v)
   (local (sc)
      (with Peep
         (setq sc (slot scale))
         (cons2
            (setq h (mul h sc))
            (setq v (mul v sc))
            (add h (mul sc (min 20 (slot- cols))))
            (add v (mul sc (min 20 (slot- rows)))) >

[++ Calculate inner peepRectangle ++]
<de peep2 (h v)
   (local (rct z dh dv zh zv)
      (with (get Peep 'app)
         (setq
            rct '((32767 . 32767) 32767 . 32767)
            z (slot zoom) )
         (unless
            (and
               (zerop (GetCtlMax (slot hSBar)))
               (zerop (GetCtlMax (slot vSBar))) )
            (setq
               rct (peep1 h v)
               [z (mul z 640)]
               zv (mul z #tile (min 20 (slot- cols)))
               zh (mul z #tile (min 20 (slot- rows)))
               dh (sub (right rct) (left rct))
               dv (sub (bottom rct) (top rct)) )
            (rplaca (car rct)
               (add 1
                  (left rct)
                  (div (mul dh (GetCtlValue (slot hSBar))) zv) ) )
            (rplacd (car rct)
               (add 1
                  (top rct)
                  (div (mul dv (GetCtlValue (slot vSBar))) zh) ) )
            (rplaca (cdr rct)
               (add
                  (left rct)
                  (sub1 (div (mul dh (dots-h (slot winPtr))) zv)) ) )
            (rplacd (cdr rct)
               (add
                  (top rct)
                  (sub1 (div (mul dv (dots-v (slot winPtr))) zh)) ) ) )
         rct >

[++ Show 1 or 2 peep rectangles ++]
<de drawPeep (h v)
   (FrameRect (peep1 h v))
   (FrameRect (peep2 h v)) >

(object peep passive window)

<to T (obj hm b sc h v)
   (setq  h (mul h sc)  v (mul v sc))
   (local (pos)
      (with obj
         (slot home hm)
         (slot app hm)
         (slot scale sc)
         (slot base b)
         (slot cols h)
         [+ (slot pixMap (newOffMap h v)) +]
         (setq pos
            (cons
               2
               (sub (cddr (rect (add 6 ScreenBits))) v 2) ) )
         (localPort
            (slot winPtr
               (NewCWindow
                  NIL
                  (cons
                     pos
                     (cons
                        (add (car pos) h)
                        (add (cdr pos) v) ) )
                  #(str "Peep")
                  T #noGrowDocProc [#altDBoxProc] -1 NIL obj >

<to close (obj)
   (DisposHandle (get obj 'base))
   [+ (DisposPixMap (get obj 'pixMap)) +]
   (from window close obj) >

<to content (Peep pt)
   (with Peep
      (localPort (slot winPtr)
         (GlobalToLocal pt)
         (PenNormal)
         (PenMode #patXor)
         (with (slot app)
            (if
               (inRect
                  pt
                  (peep2 (slot- pos-h) (slot- pos-v)) )
               (dragPeep2 pt)
               (dragPeep1 pt) >

<to update (Peep)
   (from window update Peep
      '(()
         (with Peep
            (cmykBits (slot base) (slot cols) 1)
            (PenMode #patXor)
            (drawPeep (slot- pos-h) (slot- pos-v)) >

T
