[prim.l 14aug92]

[+ Extend rectangle to bottom right +]
<de xRect (r)
   (rplaca (cdr r) (add1 (cadr r)))
   (rplacd (cdr r) (add1 (cddr r)))
   r >

<de getMode ()
   (car (class App)) >

<de setMode (m)
   (with App
      (rplaca (class (slot home)) m)
      (mapc (get (slot home) 'zooms)
         '((x) (rplaca (class x) m)) >

<de pixPos (h v c)
   (add
      (mul #tile2 (add (mul (div v #tile) c) (div h #tile)))
      (mul (rem v #tile) #tile)
      (rem h #tile) >

<de scanLines (g)
   (local (r)
      (amount g
         '((z)
            (setq r (bounds z))
            (sub (bottom r) (top r)) >

<de hasMask (g)
   (local (r dh dv)
      (with App
         (setq
            r (bounds g)
            dh (mul #tile (slot- pos-h))
            dv (mul #tile (slot- pos-v)) )
         (and
            (leq 0 (sub (abs (left r)) dh) 640)
            (leq 0 (sub (abs (right r)) dh) 640)
            (leq 0 (sub (abs (top r)) dv) 640)
            (leq 0 (sub (abs (bottom r)) dv) 640) >

<de mvGraf (g dh dv)
   (graf g
      '((pt)
         (cons
            (add dh (car pt))
            (add dv (cdr pt)) >

<de mirror (g x)
   (setq x
      (if x
         (mul2 x)
         (local (r)
            (setq r (bounds g))
            (add (left r) (right r)) ) ) )
   (graf g
      '((pt)
         (cons
            (sub x (car pt))
            (cdr pt) >

<de invert (g y)
   (setq y
      (if y
         (mul2 y)
         (local (r)
            (setq r (bounds g))
            (add (top r) (bottom r)) ) ) )
   (graf g
      '((pt)
         (cons
            (car pt)
            (sub y (cdr pt)) >

<de isMirror (g1 g2)
   (local (z1 z2 pt1 pt2)
      (setq
         z1 (car g1)
         z2 (car g2)
         pt1 (pop z1)
         pt2 (pop z2) )
      (loop
         (NIL z1)
         (NIL z2)
         (T (neq (car pt1) (caar z1))
            (neq
               (sign (sub (caar z1) (car pt1)))
               (sign (sub (caar z2) (car pt2))) ) )
         (setq pt1 (pop z1))
         (setq pt2 (pop z2)) >

<de isInvert (g1 g2)
   (local (z1 z2 pt1 pt2)
      (setq
         z1 (car g1)
         z2 (car g2)
         pt1 (pop z1)
         pt2 (pop z2) )
      (loop
         (NIL z1)
         (NIL z2)
         (T (neq (cdr pt1) (cdar z1))
            (neq
               (sign (sub (cdar z1) (cdr pt1)))
               (sign (sub (cdar z2) (cdr pt2))) ) )
         (setq pt1 (pop z1))
         (setq pt2 (pop z2)) >

<de saveColor (g dyn f)
   (local (fd)
      (setq fd (localVol Bin (create (ref dyn))))
      (with App
         (if (hasMask g)
            <local (b dh dv p n)
               (setq
                  b (slot- base)
                  dh (mul #tile (slot- pos-h))
                  dv (mul #tile (slot- pos-v)) )
               (if (stringp (ref dyn))
                  (progress (scanLines Mark) #(str "Copy Pixel") T)
                  (busy 10000) )
               (localLock b
                  (scan g 2
                     '((v h1 h2)
                        (setq
                           p (pixPtr b
                              (sub (abs h1) dh)
                              (sub (abs v) dv) )
                           n (sub h2 h1) )
                        (writeBlock fd
                           (if f (sub p (mul 4 n)) p)
                           (mul 4 n) )
                        (when (stringp (ref dyn))
                           (progress) >
            (local (buf)
               (progress (scanLines Mark) #(str "Copy Pixel") T)
               (flushTiles)
               (setq buf (alloc (mul #(mul 4 tile2) (slot- cols))))
               (scan g 2
                  '((v h1 h2)
                     (tfRead (slot- fd) buf (slot- cols) v
                        (if f h2 h1) (if f h1 h2) )
                     (writeBlock fd buf (mul 4 (sub h2 h1)))
                     (progress) ) )
               (free buf) ) )
         (close fd)
         dyn >

<de undoColor (dyn g f)
   (local (fd)
      (unless (setq fd (localVol Bin (open (ref dyn))))
         (openErr (ref dyn) T) )
      (with App
         (if (hasMask g)
            <local (b dh dv p n)
               (touchMask Mark)
               (setq
                  b (slot- base)
                  dh (mul #tile (slot- pos-h))
                  dv (mul #tile (slot- pos-v)) )
               (if (stringp (ref dyn))
                  (progress (scanLines Mark) #(str "Undo"))
                  (busy 10000) )
               (localLock b
                  (catch T
                     (scan g 2
                        '((v h1 h2)
                           (setq
                              p (pixPtr b
                                 (sub (abs h1) dh)
                                 (sub (abs v) dv) )
                              n (sub h2 h1) )
                           (readBlock fd
                              (if f (sub p (mul 4 n)) p)
                              (mul 4 n) )
                           (and
                              (stringp (ref dyn))
                              (not (progress))
                              (throw T) >
            (local (buf)
               (progress (scanLines Mark) #(str "Undo"))
               (flushTiles)
               (setq buf (alloc (mul #(mul 4 tile2) (slot- cols))))
               (catch T
                  (scan g 2
                     '((v h1 h2)
                        (readBlock fd buf (mul 4 (sub h2 h1)))
                        (and f (xchg h1 h2))
                        (tfWrite (slot- fd) buf (slot- cols) v h1 h2)
                        (unless (progress) (throw T)) ) ) )
               (free buf)
               (readTiles App) ) )
         (close fd)
         (invalCmyks App) >

<de doPasteBits (dyn w g f)
   (local (fd)
      (unless (setq fd (localVol Bin (open (ref dyn))))
         (openErr (ref dyn) T) )
      (with App
         (if (hasMask g)
            <local (b dh dv)
               (touchMask Mark)
               (setq
                  b (slot- base)
                  dh (mul #tile (slot- pos-h))
                  dv (mul #tile (slot- pos-v)) )
               (if (stringp (ref dyn))
                  (progress (scanLines Mark) #(str "Paste Pixel"))
                  (busy 10000) )
               (localLock b
                  (catch T
                     (scan g 2
                        '((v h1 h2)
                           (readPx fd
                              (pixPtr b
                                 (sub (abs h1) dh)
                                 (sub (abs v) dv) )
                              (sub h2 h1) f w )
                           (and
                              (stringp (ref dyn))
                              (not (progress))
                              (throw T) >
            (local (buf)
               (progress (scanLines Mark) #(str "Paste Pixel"))
               (flushTiles)
               (setq buf (alloc (mul #(mul 4 tile2) (slot- cols))))
               (catch T
                  (scan g 2
                     '((v h1 h2)
                        (readBlock fd buf (mul 4 (sub h2 h1)))
                        (tfWrite (slot- fd)
                           buf (slot- cols) v h1 h2 w f )
                        (unless (progress) (throw T)) ) ) )
               (free buf)
               (readTiles App) ) )
         (close fd)
         (invalCmyks App) >

[++++++
<de pasteBits (m s w)
   (local (g f)
      (busy 20000)
      (setq g Mark)
      (when (setq f (isMirror (cdr BitsClip) Mark))
         (setq g (mirror g 0)) )
      (when (isInvert (cdr BitsClip) Mark)
         (setq g (invert g 0)) )
      (make s t
         (list (saveColor g m f) g f)
         undoColor
         (list (car BitsClip) w g f)
         doPasteBits >
++++++]

<de generalAlert (a b c)
   (ParamText a b c)
   (SetCursor Arrow)
   (CautionAlert #generalID)
   NIL >

<de memAlert ()
   (generalAlert #(str "Sorry")
      #(str "Not enough memory available")
      (if (lessp 1 (length Apps))
         #(str "Please close one of your jobs")
         #(str "for this operation") >

<de diskAlert ()
   (generalAlert #(str "Sorry")
      #(str "Not enough Disk Space")
      #(str "for this operation") >

<de needMem (n)
   (inc n #(mul safety 1024))
   (or
      (and (avail 2000) (lessp n (MaxMem)))
      (and (gc) (avail 2000) (lessp n (MaxMem)))
      (loop
         (NIL (zap1undo))
         (T (and (avail 2000) (lessp n (MaxMem))) T) )
      (memAlert) >

<de needVol (vol n)
   (inc n #(mul 20 1024))
   (or
      (lessp n (volBytes vol))
      (progn (gc) (lessp n (volBytes vol)))
      (loop
         (NIL (zap1undo))
         (T (lessp n (volBytes vol)) T) )
      (diskAlert) >

<de fitPoint (pt)
   (with App
      (and
         (leq 0 (car pt) (mul #tile (slot- cols)))
         (leq 0 (cdr pt) (mul #tile (slot- rows))) >

<de fitMask (g)
   (setq g (bounds g))
   (or
      (and (fitPoint (car g)) (fitPoint (cdr g)))
      (generalAlert #(str "Sorry") #(str "Mask is too big")) >

<de dots-h (win)
   (sub
      (right (portRect win))
      (left (portRect win))
      #(sub1 SBarWidth) >

<de dots-v (win)
   (sub
      (bottom (portRect win))
      (top (portRect win))
      #(sub1 SBarWidth) >

<de winLoc (dh dv pt)
   (local (oldPt)
      (setq oldPt (car (portRect Port)))
      (LocalToGlobal oldPt)
      (if (or (not pt) (equal pt oldPt))
         (cons
            (add dh (car oldPt))
            (add dv (cdr oldPt)) )
         pt >

<de newOffMap (h v)
   (local (pm p)
      (setq p (HLock (setq pm (NewPixMap))))
      (word (add 4 p) (bitOr 08000 (mul 4 h))) [+ rowBytes +]
      (rect (add 6 p) (cons2 0 0 h v)) [+ bounds +]
      (word (add 30 p) 16) [+ pixelType RGBDirect +]
      (word (add 32 p) 32) [+ pixelSize +]
      (word (add 34 p) 3) [+ cmpCount +]
      (word (add 36 p) 8) [+ cmpSize +]
      (HUnlock pm) >

<de zapBitMap (p)
   (free (ptr p))
   (free p) >

<de newBitMap (h v)
   (local (b r)
      (setq
         b (alloc 14)
         r (mul2 (add1 (div (sub1 h) 16))) ) [+ rowBytes +]
      (ptr b (alloc (mul v r))) [+ baseAdr +]
      (word (add 4 b) r) [+ rowBytes +]
      (rect (add 6 b) [+ bounds +]
         (cons2 0 0 h v) )
      b >

[Read one bit of bitmap]
<de bitmap (b h v)
   (local (n p)
      (setq
         n (add h (mul v 8 (word (add b 4))))
         p (add (ptr b) (div n 8)) )
      (bit (sub 7 (bitAnd 7 n)) (byte p)) >

T
