/* mac.h
 * 06nov92abu
 */

#include <Types.h>
#include <Values.h>
#include <SysEqu.h>
#include <Strings.h>
#include <Errors.h>
#include <Resources.h>
#include <QuickDraw.h>
#include <Fonts.h>
#include <Events.h>
#include <Windows.h>
#include <Menus.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <Desk.h>
#include <ToolUtils.h>
#include <Memory.h>
#include <SegLoad.h>
#include <Files.h>
#include <OSUtils.h>
#include <OSEvents.h>
#include <DiskInit.h>
#include <Packages.h>
#include <Devices.h>
#include <Serial.h>
#include <Traps.h>
#include <Picker.h>
/* #include <Color.h> */

#if PXCMD
#include "HyperXCmd.h"
#endif

typedef unsigned long pixel;

extern pico portSym;
extern WindowPtr console;

/* Prototypes */
#ifdef __cplusplus
extern "C" {
#endif
pico boxColor(integer,integer,integer);
pico boxQdRect(Rect*);
pico boxStyle(TextStyle*);
pico bufPLong(long);
pico checkMemErr(void);
pico checkResErr(void);
void cString(StringPtr,uchar*);
void drawConsole(void);
pico dynHandle(Handle);
pico fetchB(pico,int);
pico fetchW(pico,int);
pico fetchL(pico,int);
pico fetchPoint(pico,int);
pico fetchRect(pico,int);
void macString(uchar*,StringPtr);
void nextColor(pico*,RGBColor*);
ProcPtr nextProc(pico*, pico*, ProcPtr);
StringPtr nextCntString(pico*,StringPtr);
long nextPLong(pico*);
void nextQdPoint(pico*,Point*);
void nextQdRect(pico*,Rect*);
void nextStyle(pico*,TextStyle*);
void unBoxColor(pico,RGBColor*);
StringPtr bufCntString(pico,StringPtr);
void unBoxQdPoint(pico,Point*);
void unBoxQdRect(pico,Rect*);
void unBoxStyle(pico,TextStyle*);
#ifdef __cplusplus
}
#endif

#define boxQdPoint(pt) (newCell(boxNum(pt.h),boxNum(pt.v)))
#define	pstrlen(s) (((Ptr)(s))[0] + 1)

void SetUpA5(void ) = {
	0x2F0D, /* move.l a5,-(sp) */
	0x2A78, /* move.l 0x904,a5 */
	0x0904
};

void RestoreA5(void) = {
	0x2A5F /* move.l (sp)+,a5 */
};

