/* macCtl.c
 * 03nov92abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pascal void trackCProc(ControlHandle,integer);

static pico ctlRect(pico);
static pico pNewControl(pico);
static pico pGetNewControl(pico);
static pico pHideControl(pico);
static pico pShowControl(pico);
static pico pDrawControls(pico);
static pico pHiliteControl(pico);
static pico pFindControl(pico);
static pico pTrackControl(pico);
static pico pMoveControl(pico);
static pico pDragControl(pico);
static pico pSizeControl(pico);
static pico pSetCtlValue(pico);
static pico pGetCtlValue(pico);
static pico pSetCtlMin(pico);
static pico pGetCtlMin(pico);
static pico pSetCtlMax(pico);
static pico pGetCtlMax(pico);
static pico pSetCRefCon(pico);
static pico pGetCRefCon(pico);

symInit ctlSyms[] = {
   {"ctl-rect",        ctlRect},
    {"NewControl",     pNewControl},
    {"GetNewControl",  pGetNewControl},
    {"HideControl",    pHideControl},
    {"ShowControl",    pShowControl},
    {"DrawControls",   pDrawControls},
    {"HiliteControl",  pHiliteControl},
    {"FindControl",    pFindControl},
    {"TrackControl",   pTrackControl},
    {"MoveControl",    pMoveControl},
    {"DragControl",    pDragControl},
    {"SizeControl",    pSizeControl},
    {"SetCtlValue",    pSetCtlValue},
    {"GetCtlValue",    pGetCtlValue},
    {"SetCtlMin",      pSetCtlMin},
    {"GetCtlMin",      pGetCtlMin},
    {"SetCtlMax",      pSetCtlMax},
    {"GetCtlMax",      pGetCtlMax},
    {"SetCRefCon",     pSetCRefCon},
    {"GetCRefCon",     pGetCRefCon},
    NULL
};


pico ctlRect(x)
pico x;
{
   return fetchRect(x,8);
}

pico pNewControl(x)
pico x;
{
    WindowPtr theWindow;
    Rect boundsRect;
    Str255 title;
    bool visible;
    integer v, min, max, procID;

    theWindow = (WindowPtr)nextNum(&x);
    nextQdRect(&x,&boundsRect);
    nextCntString(&x,title);
    visible = nextBool(&x);
    v = (integer)nextNum(&x);
    min = (integer)nextNum(&x);
    max = (integer)nextNum(&x);
    procID = (integer)nextNum(&x);
    return chkPtr(NewControl(theWindow, &boundsRect, title, visible,
                        v, min, max, procID, (long)EVAL1(x)) );
}

pico pGetNewControl(x)
pico x;
{
    integer controlID;
    WindowPtr theWindow;

    controlID = (integer)nextNum(&x);
    theWindow = (WindowPtr)nextNum(&x);
    return chkPtr(GetNewControl(controlID, theWindow) );
}

pico pHideControl(x)
pico x;
{
   HideControl((ControlHandle)nextPtr(&x));
   return tSym;
}

pico pShowControl(x)
pico x;
{
   ShowControl((ControlHandle)nextPtr(&x));
   return tSym;
}

pico pDrawControls(x)
pico x;
{
    DrawControls((WindowPtr)nextNum(&x));
    return tSym;
}

pico pHiliteControl(x)
pico x;
{
    ControlHandle theControl;

    theControl = (ControlHandle)nextNum(&x);
    HiliteControl(theControl, (integer)nextNum(&x));
    return tSym;
}

pico pFindControl(x)
pico x;
{
    Point thePoint;
    WindowPtr theWindow;
    ControlHandle whichControl;
    integer n;

    nextQdPoint(&x,&thePoint);
    theWindow = (WindowPtr)nextNum(&x);
    n = FindControl(thePoint, theWindow, &whichControl);
    val(nextVar(&x)) = chkPtr(whichControl);
    return boxNum(n);
}

pico trackCDef;

pascal void trackCProc(theControl,partCode)
ControlHandle theControl;
integer partCode;
{
    apply2(trackCDef, boxNum(theControl), boxNum(partCode));
}

pico pTrackControl(x)
pico x;
{
    ControlHandle theControl;
    Point startPt;

    theControl = (ControlHandle)nextNum(&x);
    nextQdPoint(&x,&startPt);
    return boxNum(TrackControl(theControl, startPt,
            nextProc(&x, &trackCDef, (ProcPtr)trackCProc) ) );
}

pico pMoveControl(x)
pico x;
{
   ControlHandle theControl;
   integer h;

   theControl = nextPtr(&x);
   h = (integer)nextNum(&x);
   MoveControl(theControl, h, (integer)nextNum(&x));
   return tSym;
}

pico pDragControl(x)
pico x;
{
   ControlHandle theControl;
   Point startPt;
   Rect limitRect, slopRect;

   theControl = nextPtr(&x);
   nextQdPoint(&x, &startPt);
   nextQdRect(&x, &limitRect);
   nextQdRect(&x, &slopRect);
   DragControl(theControl, startPt, &limitRect, &slopRect, (integer)nextNum(&x));
   return tSym;
}

pico pSizeControl(x)
pico x;
{
   ControlHandle theControl;
   integer w;

   theControl = nextPtr(&x);
   w = (integer)nextNum(&x);
   SizeControl(theControl, w, (integer)nextNum(&x));
   return tSym;
}

pico pSetCtlValue(x)
pico x;
{
    ControlHandle theControl;
    number v;

    theControl = (ControlHandle)nextNum(&x);
    SetCtlValue(theControl, (integer)(v = nextNum(&x)));
    return boxNum(v);
}

pico pGetCtlValue(x)
pico x;
{
    return boxNum(GetCtlValue((ControlHandle)nextNum(&x)));
}

pico pSetCtlMin(x)
pico x;
{
    ControlHandle theControl;
    number v;

    theControl = (ControlHandle)nextNum(&x);
    SetCtlMin(theControl, (integer)(v = nextNum(&x)));
    return boxNum(v);
}

pico pGetCtlMin(x)
pico x;
{
    return boxNum(GetCtlMin((ControlHandle)nextNum(&x)));
}

pico pSetCtlMax(x)
pico x;
{
    ControlHandle theControl;
    number v;

    theControl = (ControlHandle)nextNum(&x);
    SetCtlMax(theControl, (integer)(v = nextNum(&x)));
    return boxNum(v);
}

pico pGetCtlMax(x)
pico x;
{
    return boxNum(GetCtlMax((ControlHandle)nextNum(&x)));
}

pico pSetCRefCon(x)
pico x;
{
    ControlHandle theControl;

    theControl = (ControlHandle)nextNum(&x);
    SetCRefCon(theControl,(long)EVAL1(x));
    return tSym;
}

pico pGetCRefCon(x)
pico x;
{
   long r;

   r = GetCRefCon((ControlHandle)nextNum(&x));
   return r? (pico)r : nilSym;
}
