/* macIO.c
 * 06sep92abu
 */

#include "pico.h"
#include "mac.h"
#include <SCSI.h>

/* Prototypes */
static pico pOpenDriver(pico);
static pico pCloseDriver(pico);
static pico pControl(pico);
static pico pSCSIReset(void);
static pico pSCSIGet(void);
static pico pSCSISelect(pico);
static pico pSCSICmd(pico);
static pico pSCSIRead(pico);
static pico pSCSIWrite(pico);
static pico pSCSIComplete(pico);
static pico pSCSIStat(void);

symInit macioSyms[] = {
   {"OpenDriver",     pOpenDriver},
   {"CloseDriver",   pCloseDriver},
   {"Control",       pControl},
   {"SCSIReset",     pSCSIReset},
   {"SCSIGet",       pSCSIGet},
   {"SCSISelect",    pSCSISelect},
   {"SCSICmd",       pSCSICmd},
   {"SCSIRead",      pSCSIRead},
   {"SCSIWrite",     pSCSIWrite},
   {"SCSIComplete",  pSCSIComplete},
   {"SCSIStat",      pSCSIStat},
   NULL
};

static SCSIInstr tib[2] = {{scNoInc,0,0},{scStop,0,0}};


pico pOpenDriver(x)
pico x;
{
   Str255 name;
   integer refNum;
   OSErr n;

   nextCntString(&x,name);
   n = OpenDriver(name, &refNum);
    val(nextVar(&x)) = boxNum(refNum);
    return boxNum(n);
}

pico pCloseDriver(x)
pico x;
{
   return boxNum(CloseDriver((integer)nextNum(&x)));
}

pico pControl(x)
pico x;
{
   integer refNum,csCode;

   refNum = (integer)nextNum(&x);
   csCode = (integer)nextNum(&x);
   return boxNum(Control(refNum,csCode,nextPtr(&x)));
}

pico pSCSIReset()
{
   return boxNum(SCSIReset());
}

pico pSCSIGet()
{
   return boxNum(SCSIGet());
}

pico pSCSISelect(x)
pico x;
{
   return boxNum(SCSISelect((integer)nextNum(&x)));
}

pico pSCSICmd(x)
pico x;
{
   register integer i;
   uchar buffer[128];

   i = 0;
   do
      buffer[i++] = (uchar)nextNum(&x);
   while (isCell(x));
   return boxNum(SCSICmd(buffer, i));
}

pico pSCSIRead(x)
pico x;
{
   tib[0].scParam1 = nextNum(&x);
   tib[0].scParam2 = nextNum(&x);
   return boxNum(SCSIRead((Ptr)tib));
}

pico pSCSIWrite(x)
pico x;
{
   tib[0].scParam1 = nextNum(&x);
   tib[0].scParam2 = nextNum(&x);
   return boxNum(SCSIWrite((Ptr)tib));
}

pico pSCSIComplete(x)
pico x;
{
   register pico statSym, msgSym;
   integer stat, message;
   OSErr res;

   statSym = nextVar(&x);
   msgSym = nextVar(&x);
   res = SCSIComplete(&stat, &message, nextNum(&x));
   val(statSym) = boxNum(stat);
   val(msgSym) = boxNum(message);
   return boxNum(res);
}

pico pSCSIStat()
{
   return boxNum(SCSIStat());
}
