/* macOs.c
 * 03nov92abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pHandToHand(pico);
static pico pPtrToHand(pico);
static pico pSysBeep(pico);

symInit osSyms[] = {
   {"HandToHand", pHandToHand},
   {"PtrToHand",  pPtrToHand},
   {"SysBeep",    pSysBeep},
   NULL
};

pico pHandToHand(x)
pico x;
{
   Handle h;

   h = (Handle)nextNum(&x);
   if (HandToHand(&h) != noErr)
      return nilSym;
   return chkPtr(h);
}
pico pPtrToHand(x)
pico x;
{
   Ptr srcPtr;
   Handle dstHndl;

   srcPtr = (Ptr)nextNum(&x);
   if (PtrToHand(srcPtr, &dstHndl, nextNum(&x)) != noErr)
      return nilSym;
   return chkPtr(dstHndl);
}

pico pSysBeep(x)
pico x;
{
   SysBeep((integer)nextNum(&x));
   return tSym;
}
