/* macRsrc.c
 * 03nov92abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pCloseResFile(pico);
static pico pOpenResFile(pico);
static pico pCountResources(pico);
static pico pGetIndResource(pico);
static pico pGetResource(pico);
static pico pGetNamedResource(pico);
static pico pLoadResource(pico);
static pico pReleaseResource(pico);
static pico pDetachResource(pico);
static pico pGetResInfo(pico);
static pico pChangedResource(pico);
static pico pAddResource(pico);
static pico pRmveResource(pico);

pico pCount1Resources(pico);
pico pGet1IndResource(pico);

symInit rsrcSyms[] = {
   {"OpenResFile",        pOpenResFile},
   {"CloseResFile",       pCloseResFile},
   {"CountResources",     pCountResources},
   {"GetIndResource",     pGetIndResource},
   {"GetResource",        pGetResource},
   {"GetNamedResource",   pGetNamedResource},
   {"LoadResource",       pLoadResource},
   {"ReleaseResource",    pReleaseResource},
   {"DetachResource",     pDetachResource},
   {"GetResInfo",         pGetResInfo},
   {"ChangedResource",    pChangedResource},
   {"AddResource",        pAddResource},
   {"RmveResource",       pRmveResource},
   {"Count1Resources",    pCount1Resources},
   {"Get1IndResource",    pGet1IndResource},
   NULL
};

pico pOpenResFile(x)
pico x;
{
   Str255 name;
   integer n;

   n = OpenResFile(nextCntString(&x,name));
   return n<0? nilSym : boxNum(n);
}

pico pCloseResFile(x)
pico x;
{
   CloseResFile((integer)nextNum(&x));
   return tSym;
}

pico pCountResources(x)
pico x;
{
   return boxNum(CountResources(nextPLong(&x)));
}

pico pGetIndResource(x)
pico x;
{
   ResType theType;

   theType = nextPLong(&x);
   return chkPtr(GetIndResource(theType, (integer)nextNum(&x)));
}

pico pGetResource(x)
pico x;
{
   ResType theType;

   theType = nextPLong(&x);
   return chkPtr(GetResource(theType, (integer)nextNum(&x)));
}

pico pGetNamedResource(x)
pico x;
{
   ResType theType;
   Str255 name;

   theType = nextPLong(&x);
   return chkPtr(GetNamedResource(theType, nextCntString(&x,name)));
}

pico pLoadResource(x)
pico x;
{
   LoadResource((Handle)nextNum(&x));
   return checkResErr();
}

pico pReleaseResource(x)
pico x;
{
   ReleaseResource((Handle)nextNum(&x));
   return checkResErr();
}

pico pDetachResource(x)
pico x;
{
   DetachResource((Handle)nextNum(&x));
   return checkResErr();
}

pico pGetResInfo(x)
pico x;
{
   Handle h;
   integer theID;
   ResType theType;
   Str255 name;

   h = (Handle)nextNum(&x);
   GetResInfo(h, &theID, &theType, name);
   if (isCell(x))
      val(nextVar(&x)) = boxNum(theID);
   if (isCell(x))
      val(nextVar(&x)) = unBufCntString(4, (uchar*)&theType);
   return unBufCntString(name[0], name+1);
}

pico pChangedResource(x)
pico x;
{
   ChangedResource((Handle)nextNum(&x));
   return checkResErr();
}

pico pAddResource(x)
pico x;
{
   Handle theResource;
   ResType theType;
   integer theID;
   Str255 name;

   theResource = (Handle)nextPtr(&x);
   theType = nextPLong(&x);
   theID = (integer)nextNum(&x);
   AddResource(theResource, theType, theID, nextCntString(&x,name));
   return checkResErr();
}

pico pRmveResource(x)
pico x;
{
   RmveResource((Handle)nextNum(&x));
   return checkResErr();
}

pico pCount1Resources(x)
pico x;
{
   return boxNum(Count1Resources(nextPLong(&x)));
}

pico pGet1IndResource(x)
pico x;
{
   ResType theType;

   theType = nextPLong(&x);
   return chkPtr(Get1IndResource(theType, (integer)nextNum(&x)));
}

