/* macWin.c
 * 07dec92abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico winUpdateRgn(pico);
static pico pNewWindow(pico);
static pico pGetNewWindow(pico);
static pico pCloseWindow(pico);
static pico pDisposeWindow(pico);
static pico pSetWTitle(pico);
static pico pSelectWindow(pico);
static pico pHideWindow(pico);
static pico pShowWindow(pico);
static pico pShowHide(pico);
static pico pBringToFront(pico);
static pico pSendBehind(pico);
static pico pFrontWindow(void);
static pico pDrawGrowIcon(pico);
static pico pFindWindow(pico);
static pico pTrackGoAway(pico);
static pico pMoveWindow(pico);
static pico pDragWindow(pico);
static pico pGrowWindow(pico);
static pico pSizeWindow(pico);
static pico pInvalRect(pico);
static pico pInvalRgn(pico);
static pico pValidRect(pico);
static pico pValidRgn(pico);
static pico pBeginUpdate(pico);
static pico pEndUpdate(pico);
static pico pSetWRefCon(pico);
static pico pGetWRefCon(pico);
static pico pSetWindowPic(pico);
static pico pGetWindowPic(pico);
static pico pTrackBox(pico);
static pico pZoomWindow(pico);

symInit winSyms[] = {
   {"UpdateRgn",     winUpdateRgn},
   {"NewWindow",     pNewWindow},
   {"GetNewWindow",  pGetNewWindow},
   {"CloseWindow",   pCloseWindow},
   {"DisposeWindow", pDisposeWindow},
   {"SetWTitle",     pSetWTitle},
   {"SelectWindow",  pSelectWindow},
   {"HideWindow",    pHideWindow},
   {"ShowWindow",    pShowWindow},
   {"ShowHide",      pShowHide},
   {"BringToFront",  pBringToFront},
   {"SendBehind",    pSendBehind},
   {"FrontWindow",   pFrontWindow},
   {"DrawGrowIcon",  pDrawGrowIcon},
   {"FindWindow",    pFindWindow},
   {"TrackGoAway",   pTrackGoAway},
   {"MoveWindow",    pMoveWindow},
   {"DragWindow",    pDragWindow},
   {"GrowWindow",    pGrowWindow},
   {"SizeWindow",    pSizeWindow},
   {"InvalRect",     pInvalRect},
   {"InvalRgn",      pInvalRgn},
   {"ValidRect",     pValidRect},
   {"ValidRgn",      pValidRgn},
   {"BeginUpdate",   pBeginUpdate},
   {"EndUpdate",     pEndUpdate},
   {"SetWRefCon",    pSetWRefCon},
   {"GetWRefCon",    pGetWRefCon},
   {"SetWindowPic",  pSetWindowPic},
   {"GetWindowPic",  pGetWindowPic},
   {"TrackBox",      pTrackBox},
   {"ZoomWindow",    pZoomWindow},
   NULL
};

pico winUpdateRgn(x)
pico x;
{
   return fetchL(x,122);
}

pico pNewWindow(x)
pico x;
{
   Ptr wStorage;
   Rect boundsRect;
   Str255 title;
   bool visible;
   integer procID;
   WindowPtr behind;
   bool goAwayFlag;

   wStorage = nextPtr(&x);
   nextQdRect(&x,&boundsRect);
   nextCntString(&x,title);
   visible = nextBool(&x);
   procID = (integer)nextNum(&x);
   behind = (WindowPtr)nextNum(&x);
   goAwayFlag = nextBool(&x);
   return chkPtr(NewWindow(wStorage, &boundsRect, title, visible,
                  procID, behind, goAwayFlag, (long)EVAL1(x)) );
}

pico pGetNewWindow(x)
pico x;
{
   integer windowID;
   Ptr wStorage;

   windowID = (integer)nextNum(&x);
   wStorage = (Ptr)nextPtr(&x);
   return chkPtr(GetNewWindow(windowID, wStorage, (WindowPtr)nextNum(&x)));
}

pico pCloseWindow(x)
pico x;
{
   CloseWindow((WindowPtr)nextNum(&x));
   return tSym;
}

pico pDisposeWindow(x)
pico x;
{
   DisposeWindow((WindowPtr)nextNum(&x));
   return tSym;
}

pico pSetWTitle(x)
pico x;
{
   WindowPtr theWindow;
   Str255 title;

   theWindow = (WindowPtr)nextNum(&x);
   nextCntString(&x,title);
   SetWTitle(theWindow, title);
   return tSym;
}

pico pSelectWindow(x)
pico x;
{
   SelectWindow((WindowPtr)nextNum(&x));
   return tSym;
}

pico pHideWindow(x)
pico x;
{
   HideWindow((WindowPtr)nextNum(&x));
   return tSym;
}

pico pShowWindow(x)
pico x;
{
   ShowWindow((WindowPtr)nextNum(&x));
   return tSym;
}

pico pShowHide(x)
pico x;
{
   WindowPtr theWindow;

   theWindow = (WindowPtr)nextNum(&x);
   ShowHide(theWindow,nextBool(&x));
   return tSym;
}

pico pBringToFront(x)
pico x;
{
   BringToFront((WindowPtr)nextNum(&x));
   return tSym;
}

pico pSendBehind(x)
pico x;
{
   WindowPtr theWindow;

   theWindow = (WindowPtr)nextNum(&x);
   SendBehind(theWindow, (WindowPtr)nextPtr(&x));
   return tSym;
}

pico pFrontWindow()
{
   return chkPtr(FrontWindow());
}

pico pDrawGrowIcon(x)
pico x;
{
   DrawGrowIcon((WindowPtr)nextNum(&x));
   return tSym;
}

pico pFindWindow(x)
pico x;
{
   integer res;
   Point pt;
   WindowPtr wp;

   nextQdPoint(&x,&pt);
   res = FindWindow(pt,&wp);
   val(nextVar(&x)) = boxNum(wp);
   return boxNum(res);
}

pico pTrackGoAway(x)
pico x;
{
   WindowPtr wp;
   Point pt;

   wp =(WindowPtr)nextNum(&x);
   nextQdPoint(&x,&pt);
   return boxBool(TrackGoAway(wp,pt));
}

pico pMoveWindow(x)
pico x;
{
   WindowPtr wp;
   integer h,v;

   wp =(WindowPtr)nextNum(&x);
   h = (integer)nextNum(&x);
   v = (integer)nextNum(&x);
   MoveWindow(wp,h,v,nextBool(&x));
   return tSym;
}

pico pDragWindow(x)
pico x;
{
   WindowPtr theWindow;
   Point startPt;
   Rect boundsRect;

   theWindow =(WindowPtr)nextNum(&x);
   nextQdPoint(&x,&startPt);
   nextQdRect(&x,&boundsRect);
   DragWindow(theWindow,startPt,&boundsRect);
   return tSym;
}

pico pGrowWindow(x)
pico x;
{
   WindowPtr theWindow;
   Point startPt;
   Rect sizeRect;

   theWindow =(WindowPtr)nextNum(&x);
   nextQdPoint(&x,&startPt);
   nextQdRect(&x,&sizeRect);
   return boxHiLo(GrowWindow(theWindow,startPt,&sizeRect));
}

pico pSizeWindow(x)
pico x;
{
   WindowPtr theWindow;
   integer w,h;

   theWindow =(WindowPtr)nextNum(&x);
   w = (integer)nextNum(&x);
   h = (integer)nextNum(&x);
   SizeWindow(theWindow, w, h, nextBool(&x));
   return tSym;
}

pico pInvalRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   InvalRect(&rect);
   return tSym;
}

pico pInvalRgn(x)
pico x;
{
   InvalRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pValidRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   ValidRect(&rect);
   return tSym;
}

pico pValidRgn(x)
pico x;
{
   ValidRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pBeginUpdate(x)
pico x;
{
   BeginUpdate((WindowPtr)nextNum(&x));
   return tSym;
}

pico pEndUpdate(x)
pico x;
{
   EndUpdate((WindowPtr)nextNum(&x));
   return tSym;
}

pico pSetWRefCon(x)
pico x;
{
   WindowPtr theWindow;

   theWindow = (WindowPtr)nextNum(&x);
   SetWRefCon(theWindow,(long)EVAL1(x));
   return tSym;
}

pico pGetWRefCon(x)
pico x;
{
   long r;

   r = GetWRefCon((WindowPtr)nextNum(&x));
   return r? (pico)r : nilSym;
}

pico pSetWindowPic(x)
pico x;
{
   WindowPtr theWindow;

   theWindow = (WindowPtr)nextNum(&x);
   SetWindowPic(theWindow, (PicHandle)nextPtr(&x));
   return tSym;
}

pico pGetWindowPic(x)
pico x;
{
   return chkPtr(GetWindowPic((WindowPtr)nextNum(&x)));
}

pico pTrackBox(x)
pico x;
{
   WindowPtr theWindow;
   Point thePt;

   theWindow = (WindowPtr)nextNum(&x);
   nextQdPoint(&x,&thePt);
   return boxBool(TrackBox(theWindow, thePt, (integer)nextNum(&x)));
}

pico pZoomWindow(x)
pico x;
{
   WindowPtr theWindow;
   integer partCode;

   theWindow = (WindowPtr)nextNum(&x);
   partCode = (integer)nextNum(&x);
   ZoomWindow(theWindow, partCode, nextBool(&x));
   return tSym;
}

