/* picoDebug.c
 * 12jan93
 */

#pragma segment picoDebug

#include "pico.h"

/* Prototypes */
static void dots(int);
static void how(pico,pico);
static bool nestp(pico,pico);


pico Loc(x)
register pico x;
{
   x = EVAL1(x);
   return isNum(x)? nilSym:boxPtr(num(x));
}

pico Has(x)
register pico x;
{
   register pico y;
   register int i;
	cell c1,c2;

   push(nilSym,c1);
   push(y = EVAL1(x), c2);
   for (i=0; i<=THREADS; ++i) {
      x = env.threads[i];
      while (isCell(x)) {
         if (equal(y, val(car(x))))
            tos(c1) = newCell(car(x),tos(c1));
         x = cdr(x);
      }
   }
   return pop(c1);
}

static bool nestp(x,y)
register pico x,y;
{
   while (isCell(y)) {
      if (match(x,car(y)) || isCell(car(y)) && nestp(x,car(y)))
         return YES;
      y = cdr(y);
   }
   return x == y;
}

pico Who(x)
register pico x;
{
   register int i;
   register pico y, z;
	cell c1,c2;

   push(nilSym,c1);
   push(z = EVAL1(x), c2);
   for (i=0; i<=THREADS; ++i) {
      x = env.threads[i];
      while (isCell(x)) {
         if (isCell(y = val(car(x))) && nestp(z,y))
            tos(c1) = newCell(car(x),tos(c1));
         x = cdr(x);
      }
   }
   return pop(c1);
}

static void how(x,y)
register pico x,y;
{
   register pico z,expr;

   expr = y;
   while (isCell(y)) {
      z = car(y);
      if (match(x,z) || isCell(z) && car(z)==quoteSym && cdr(z)==x) {
         tab();
         prin0((!isCell(z) || (car(z)==quoteSym))? expr:z);
         crlf();
      }
      else if (isCell(z))
         how(x,z);
      y = cdr(y);
   }
}

pico How(x)
register pico x;
{
   register int i;
   register pico y, z, t;
   picoFile *sSave;

   sSave = stream;
   setStream(NULL);
   y = EVAL1(x);
   if (isCell(x = cdr(x))) {
      NEEDSYM(y);
      how(EVAL1(x),val(y));
   }
   else
      for (i=0; i<=THREADS; ++i) {
         t = env.threads[i];
         while (isCell(t)) {
            if (isCell(x = val(car(t)))) {
               z = x;
               do
                  z = cdr(z);
               while (isCell(z));
               if (z == objectSym) {
                  while (isCell(z = car(x))) {
                     if (nestp(y,cdr(z))) {
                        prin0(car(z));
                        space();
                        prin0(car(t));
                        crlf();
                        how(y,cdr(z));
                     }
                     x = cdr(x);
                  }
               }
               else if (nestp(y,x)) {
                  prin0(car(t));
                  crlf();
                  how(y,x);
               }
            }
            t = cdr(t);
         }
      }
   stream = sSave;
   return y;
}

pico BreakFun(x)
register pico x;
{
   picoFile *sSave;

   val(logFlg) = nilSym;
   val(queueSym) = nilSym;
   sSave = stream;
   setStream(NULL);
   prompt('!');
   prin0(x);
   crlf();
   revalo(x);
   stream = sSave;
   return EVAL(x);
}

static void dots(i)
register int i;
{
   i  =  i < 64 ?  i:64;
   while (--i >= 0)
      chrOut('.');
}

pico TraceFun(x)
register pico x;
{
   pico foo, body;
   picoFile *sSave;

   sSave = stream;
   setStream(NULL);
   dots(++traceLevel);
   prin0(foo = car(x));
   x = cdr(x);
   body = cdr(x);
   chrOut('[');
   if (isCell(x = car(x)))
      loop {
         cutPr(val(car(x)));
         if (!isCell(x = cdr(x)))
            break;
         space();
      }
   chrOut(']');
   crlf();
   x = evalBody(body);
   dots(traceLevel--);
   prin0(foo);
   chrOut('=');
   cutPr(x);
   crlf();
   stream = sSave;
   return x;
}

pico ProfFun(x)
register pico x;
{
   pico y;
   long n, saveTime;
   static long profTime;

   saveTime = profTime;
   n = libTick();
   y = evalBody(cdr(x));
   n = (libTick() - n) - (profTime - saveTime);
   car(x) = boxNum(unBox(car(x)) + n);
   profTime += n;
   return y;
}

pico Dump(x)
register pico x;
{
   register char c, *adr;
   register int i, j, len;
   picoFile *sSave;

   adr = (char*)EVAL1(x);
   NEEDNUM(adr);
   adr = (char*)unBoxPtr((pico)adr);
   if (isNil(x = EVAL1(cdr(x))))
      len = 1;
   else
      len = (int)unBox(x);
   sSave = stream;
   setStream(NULL);
   for (i=0; i<len; ++i) {
      keyBreak();
      prHexNum((unsigned long)adr + i*16);
      prString("   ");
      j = 0;
      do {
         c = adr[i*16+j];
         hexChar(c >> 4 & 0xF);
         hexChar(c & 0xF);
         space();
      } while (++j < 16);
      prString("  ");
      j = 0;
      do {
         chrOut(((c = adr[i*16+j] & 0x7F) >= ' '  &&  c <= '~') ?  c : '.');
      } while (++j < 16);
      crlf();
   }
   stream = sSave;
   return boxPtr(num(adr+len*16));
}

pico Trail()
{
   register pico x;
   register bindFrame *p;
   cell c1;

   if (!(p = bindPtr))
      return nilSym;
   while (!p->self)
      if (!(p = p->link))
         return nilSym;
   push(x = newCell(p->self, nilSym), c1);
   while (p = p->link)
      if (p->self) {
         cdr(x) = newCell(p->self, nilSym);
         x = cdr(x);
      }
   return pop(c1);
}

pico Track(x)
pico x;
{
   register long i, cnt;
   register bindFrame *p, *q, *last;

   if (!isCell(x))
      cnt = MAXNUM;
   else {
      x = EVAL1(x);
      NEEDNUM(x);
      cnt = unBox(x);
   }
   p = bindPtr;
   last = NULL;
   while (p  &&  cnt > 0) {
      if (p->self) {
         --cnt;
         cutPr(p->self);
         i = p->cnt;
         while (--i >= 0) {
         	space();
				prin0(p->bnd[i].sym);
				chrOut('=');
				cutPr(val(p->bnd[i].sym));
			}
			crlf();
		}
      i = p->cnt;
      while (--i >= 0) {
			x = val(p->bnd[i].sym);
			val(p->bnd[i].sym) = p->bnd[i].val;
			p->bnd[i].val = x;
		}
		q = p;
      p = p->link;
		q->link = last;
		last = q;
   }
   while (last) {
      i = last->cnt;
      while (--i >= 0) {
			x = val(last->bnd[i].sym);
			val(last->bnd[i].sym) = last->bnd[i].val;
			last->bnd[i].val = x;
		}
		q = last;
		last = last->link;
		q->link = p;
		p = q;
   }
   return tSym;
}

pico Revalo(x)
register pico x;
{
   revalo(EVAL1(x));
   return tSym;
}
