/* picoGraf.c
 * 07jan93abu
 */

#pragma segment picoGraf

#include "pico.h"
#include "graf.h"

/* Points */
pico boxPoint(pt)
point *pt;
{
   return newCell(boxNum(pt->h),boxNum(pt->v));
}

void needPoint(x)
register pico x;
{
   if (!isCell(x) || !isNum(car(x)) || !isNum(cdr(x)))
      errObj(x, "Point expected");
}

void unBoxPoint(x,pt)
register pico x;
register point *pt;
{
   needPoint(x);
   pt->h = unBox(car(x));
   pt->v = unBox(cdr(x));
}

void nextPoint(p,pt)
register pico *p;
register point *pt;
{
   unBoxPoint(EVAL1(*p),pt);
   *p = cdr(*p);
}

long dist(h1,v1,h2,v2)
long h1,v1,h2,v2;
{
   register long dh,dv;

   if ((dh = h2 - h1) < 0)
      dh = -dh;
   if ((dv = v2 - v1) < 0)
      dv = -dv;
   return  dh>dv?  dh + dv*41/100 - dh/24  :  dv + dh*41/100 - dv/24;
}

/* Rectangles */
bool isRect(x)
register pico x;
{
   register pico y;

   return (isCell(x) && isCell(y = car(x)) && isCell(cdr(x)) &&
            isNum(car(y)) && isNum(cdr(y)) && isNum(cdr(car(x))) &&
                                                isNum(cdr(cdr(x))) );
}

void needRect(x)
pico x;
{
   if (!isRect(x))
      errObj(x, "Rectangle expected");
}

pico boxRect(r)
register rect *r;
{
   return newCell2(boxNum(r->left), boxNum(r->top),
                  boxNum(r->right), boxNum(r->bottom));
}

void unBoxRect(x,r)
register pico x;
register rect *r;
{
   register pico y;

   needRect(x);
   y = car(x);
   x = cdr(x);
   r->left = unBox(car(y));
   r->top = unBox(cdr(y));
   r->right = unBox(car(x));
   r->bottom = unBox(cdr(x));
}

void nextRect(p,r)
register pico *p;
rect *r;
{
   unBoxRect(EVAL1(*p),r);
   *p = cdr(*p);
}

pico Dist(x)
register pico x;
{
   register long dh,dv;
   register pico y;
	cell c1;

   push(y = EVAL1(x),c1);
   needPoint(y);
   x = cdr(x);
   needPoint(x = EVAL1(x));
   drop(c1);
   dh = unBox(car(y)) - unBox(car(x));
   dv = unBox(cdr(y)) - unBox(cdr(x));

   if (dh < 0)
      dh = -dh;
   if (dv < 0)
      dv = -dv;
   return
      boxNum(dh>dv?  dh + dv*41/100 - dh/24  :  dv + dh*41/100 - dv/24);
}

pico DistPt(x)
register pico x;
{
   register pico y;
	cell c1;

   push(y = EVAL1(x),c1);
   needPoint(y);
   x = cdr(x);
   needPoint(x = EVAL1(x));
   drop(c1);
   return boxNum(
      pythag(unBox(car(y)) - unBox(car(x)),
      unBox(cdr(y)) - unBox(cdr(x)) ) );
}

pico InRect(x)
pico x;
{
   point pt;
   rect r;

   nextPoint(&x,&pt);
   nextRect(&x,&r);
   return boxBool(
      pt.h >= r.left &&
      pt.h < r.right &&
      pt.v >= r.top &&
      pt.v < r.bottom );
}

bool intsec(a,b,d,e,f,p)
point *a,*b,*d,*e;
bool f;
point *p;
{
   register number dh,dv,n,h,v,k,w;
	uchar ov1,ov2;

   if (a->h==e->h && a->v==e->v  ||  a->h==d->h && a->v==d->v) {
      p->h = a->h;
      p->v = a->v;
      return YES;
   }
   if (b->h==e->h && b->v==e->v  ||  b->h==d->h && b->v==d->v) {
      p->h = b->h;
      p->v = b->v;
      return YES;
   }
   h = b->h - a->h;
   v = b->v - a->v;
   k = e->h - d->h;
   w = e->v - d->v;
   if (h == 0) {
      if (k == 0)
         return NO;
      p->h = a->h;
   }
   else if (k == 0)
      p->h = d->h;
   else {
      if (absNumber(h) >= absNumber(k)) {
         if (!(n = w - muldiv(k,v,h)))
            return NO;
         p->h = a->h;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (absNumber(dh)+absNumber(dv) >
						absNumber(b->h - d->h) + absNumber(b->v - d->v)) {
            p->h = b->h;
            dh = b->h - d->h;
            dv = b->v - d->v;
         }
         p->h  +=  mdchk(dv,k,n,&ov2) - mdchk(dh,w,n,&ov1);
			if (ov1 || ov2)
				return NO;
      }
      else {
         if (!(n = muldiv(h,w,k) - v))
            return NO;
         p->h = d->h;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (absNumber(dh)+absNumber(dv) >
						absNumber(a->h - e->h) + absNumber(a->v - e->v)) {
            p->h = e->h;
            dh = a->h - e->h;
            dv = a->v - e->v;
         }
         p->h  +=  mdchk(dv,h,n,&ov2) - mdchk(dh,v,n,&ov1);
			if (ov1 || ov2)
				return NO;
      }
   }
   if (v == 0) {
      if (w == 0)
         return NO;
      p->v = a->v;
   }
   else if (w == 0) {
      n = -k;
      p->v = d->v;
   }
   else {
      if (absNumber(v) >= absNumber(w)) {
         if (!(n = muldiv(h,w,v) - k))
            return NO;
         p->v = a->v;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (absNumber(dh)+absNumber(dv) >
						absNumber(b->h - d->h) + absNumber(b->v - d->v)) {
            p->v = b->v;
            dh = b->h - d->h;
            dv = b->v - d->v;
         }
         p->v  +=  mdchk(dv,k,n,&ov2) - mdchk(dh,w,n,&ov1);
			if (ov1 || ov2)
				return NO;
      }
      else {
         if (!(n = h - muldiv(k,v,w)))
            return NO;
         p->v = d->v;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (absNumber(dh)+absNumber(dv) >
						absNumber(a->h - e->h) + absNumber(a->v - e->v)) {
            p->v = e->v;
            dh = a->h - e->h;
            dv = a->v - e->v;
         }
         p->v  +=  mdchk(dv,h,n,&ov2) - mdchk(dh,v,n,&ov1);
			if (ov1 || ov2)
				return NO;
      }
   }
   if (!f) {
      n = p->h;
      if (n < a->h  &&  n < b->h  ||  n < d->h  &&  n < e->h ||
               n > a->h  &&  n > b->h  ||  n > d->h  &&  n > e->h )
         return NO;
      n = p->v;
      if (n < a->v  &&  n < b->v  ||  n < d->v  &&  n < e->v ||
               n > a->v  &&  n > b->v  ||  n > d->v  &&  n > e->v )
         return NO;
   }
   return YES;
}

pico Intsec(x)
pico x;
{
   point a,b,d,e,p;

   nextPoint(&x,&a);
   nextPoint(&x,&b);
   nextPoint(&x,&d);
   nextPoint(&x,&e);
   return
      intsec(&a, &b, &d, &e, !isNil(EVAL1(x)), &p)?
         newCell(boxNum(p.h),boxNum(p.v)) :
         nilSym;
}

pico Mdchk(x)
register pico x;
{
   register number m,n;
   uchar ovfl;

   m = num(EVAL1(x));
   NEEDNUM(m);
   m = unBox(m);
   x = cdr(x);
   n = num(EVAL1(x));
   NEEDNUM(n);
   n = unBox(n);
   x = cdr(x);
   x = EVAL1(x);
   NEEDNUM(x);
   if (x == ZERO)
      return nilSym;
   n = mdchk(m,n,unBox(x),&ovfl);
   return ovfl? nilSym : boxNum(n);
}

pico MvRect(x)
pico x;
{
   rect r;
   number h,v;

   nextRect(&x,&r);
   h = nextNum(&x);
   v = nextNum(&x);
   r.left += h;
   r.right += h;
   r.top += v;
   r.bottom += v;
   return boxRect(&r);
}

pico Pointp(x)
register pico x;
{
   x = EVAL1(x);
   return (!isCell(x) || !isNum(car(x)) || !isNum(cdr(x))) ? nilSym:tSym;
}

pico Pythag(x)
register pico x;
{
   register number y;

   y = num(EVAL1(x));
   NEEDNUM(y);
   x = cdr(x);
   x = EVAL1(x);
   NEEDNUM(x);
   return boxNum(pythag(unBox(y), unBox(x)));
}

pico Rectp(x)
register pico x;
{
   register pico y;

   x = EVAL1(x);
   return (!isCell(x) || !isCell(y = car(x)) || !isCell(cdr(x)) ||
            !isNum(car(y)) || !isNum(cdr(y)) || !isNum(cdr(car(x))) ||
            !isNum(cdr(cdr(x))) )
      ? nilSym:tSym;
}

pico SzRect(x)
pico x;
{
   rect r;
   number h,v;

   nextRect(&x,&r);
   h = nextNum(&x);
   v = nextNum(&x);
   r.left += h;
   r.right -= h;
   r.top += v;
   r.bottom -= v;
   return boxRect(&r);
}

symInit grafSyms[] = {
   {"bottom",       Cddr},
   {"dist",         Dist},
   {"distPt",       DistPt},
   {"inRect",       InRect},
   {"intsec",       Intsec},
   {"mdchk",        Mdchk},
   {"mvRect",       MvRect},
   {"pointp",       Pointp},
   {"pythag",       Pythag},
   {"rectp",        Rectp},
   {"right",        Cadr},
   {"szRect",       SzRect},
   {"top",          Cdar},
   NULL
};
