[main.l 21jun92]

[++ Init Application Environment ++]
<de init ()
   (reptn 8 (MoreMasters))
   (setq Event (alloc 16))
   (setMenu (demoMBar))
   (AddResMenu (fontM) "FONT")
   (for (i 1 (add1 (CountMItems (fontM))))
      (adMenu MBar "Font" 'app (list 'doFont i) (list 'isFont i)) )
   (for (i 0 7)
      (SetItemStyle (stylM) (add2 i) (bitl i 1)) )
   (do init 'spot)
   (run) >

<de cleanUp ()
>

[+++ Menu Bar +++]
<de demoMBar ()
   (mkMBar
      (app (neq App 'idle))
      (txt (get App 'text))
      (grf (get App 'graf))
      ((#appleMark)
         ("" "About UNSCAN .." T
            (new 'showWin "About"
               '("UNSCAN Demo" "BUG Europe 1991")
               300 200 ) )
         ("-") )
      ("File"
         ("" "New/N" T (newCmd))
         ("-")
         ("/L" "Load .." app (loadCmd))
         ("/S" "Save .." grf (saveCmd))
         ("/W" "Close" app (do close App))
         ("-")
         ("/Q" "Quit" T (on Done)) )
      ("Edit"
         ("/Z" "Undo" )
         ("-")
         ("/X" "Cut" )
         ("/C" "Copy" )
         ("/V" "Paste" )
         ("" "Clear" )
         ("-")
         ("" "UnScan" txt (uscCmd))
         ("/B" "Border .." grf (brdCmd))
         ("-")
         ("/+" "Zoom Up" grf (upCmd))
         ("/-" "Zoom Down" grf (dwnCmd))
         ("/P" "Paint" grf (paintCmd))
         ("/F" "Refresh" app (do inval App)) )
      ("Font")
      ("Style"
         ("" "Plain" app (doStyle) (isStyle))
         ("" "Bold" app (doStyle #bold) (isStyle #bold))
         ("" "Italic" app (doStyle #italic) (isStyle #italic))
         ("" "Underline" app (doStyle #underline) (isStyle #underline))
         ("" "Outline" app (doStyle #outline) (isStyle #outline))
         ("" "Shadow" app (doStyle #shadow) (isStyle #shadow))
         ("" "Condense" app (doStyle #condense) (isStyle #condense))
         ("" "Extend" app (doStyle #extend) (isStyle #extend)) >

<de loadCmd ()
   (local (s)
      (localVol (GetVol)
         (when (setq s (getFile "pGrf"))
            (with App
               (slot graf (append (slot graf) (read1 s))) )
            (do inval App) >

<de saveCmd ()
   (local (s f)
      (localVol (GetVol)
         (when
            (and
               (setq s (putFile "Save"))
               (setq f (create s)) )
            (print (get App 'graf) f)
            (close f)
            (fType s "pGrf") >

<de fontM ()
   (cadr (assoc "Font" MBar)) >

<de stylM ()
   (cadr (assoc "Style" MBar)) >

<de doFont (n)
   (TextFont (GetFNum (GetItem (fontM) n)))
   (do inval App) >

<de isFont (n)
   (eq
      (word (add 68 Port))
      (GetFNum (GetItem (fontM) n)) >

<de doStyle (n)
   (TextFace
      (if n
         (bitXor n (byte (add 70 Port)))
         0 ) )
   (do inval App) >

<de isStyle (n)
   (if n
      (not (zerop (bitAnd n (byte (add 70 Port)))))
      (zerop (byte (add 70 Port))) >

<de newCmd ()
   (with
      (new 'demo "Demo"
         (if (eq 'demo (car (class App)))
            (LocalToGlobal (cons 10 10))
            (100.100) )
         600 300 )
      (slot pos-h 0)
      (slot pos-v 0)
      (slot scale 10000) >

<de uscCmd ()
   (local (pt1 pt2 :r)
      (when
         (and
            (setq pt1 (click NIL NIL hvSpot))
            (setq pt2
               (click NIL STIFF hvSpot pt1
                  (lambda (pt1 pt2) (FrameRect (bounds pt1 pt2))) ) ) )
         (setq :r (bounds pt1 pt2))
         (with App
            (slot text NIL)
            (HideCursor)
            (slot graf
               (graf (unScan (top :r) (bottom :r) unSc1) ptGlobal) )
            (ShowCursor)
            (do inval App) )
         (gc 40000) >

<de unSc1 (v)
   (local (l f)
      (off l f)
      (for (h (left :r) (right :r))
         (when (neq f (zerop (pixel h v)))
            (toggle f)
            (setq l (nconc1 l (cons h v))) ) )
      (and f (nconc1 l (cons (right :r) v)))
      l >

<de brdCmd ()
   (local (s)
      (when (setq s (dialog1 "Border Width" "10"))
         (busy 20000)
         (with App
            (slot graf
               (append (slot graf)
                  (bench (border (slot graf) (number s 4))) ) ) )
         (do inval App) >

<de upCmd ()
   (local (r h v)
      (setq
         r (portRect Port)
         h (div2 (right r))
         v (div2 (bottom r)) )
      (with App
         (slot scale (div2 (slot scale)))
         (slot pos-h (sub (mul2 (add h (slot pos-h))) h))
         (slot pos-v (sub (mul2 (add v (slot pos-v))) v))
         (do inval App) >

<de dwnCmd ()
   (local (r h v)
      (setq
         r (portRect Port)
         h (div2 (right r))
         v (div2 (bottom r)) )
      (with App
         (slot scale (mul2 (slot scale)))
         (slot pos-h (sub (div2 (add h (slot pos-h))) h))
         (slot pos-v (sub (div2 (add v (slot pos-v))) v))
         (do inval App) >

<de paintCmd ()
   (with App
      (scan (graf (slot graf) ptLocal) 4
         (lambda (v h1 h2) (MoveTo h1 v) (LineTo h2 v)) >


[+++ App Object +++]
(object demo simpleWin)

<to update (App)
   (from window update App
      (lambda ()
         (EraseRect (portRect Port))
         (with App
            (when (slot graf)
               (draw (slot graf) (div2 (slot scale)) line2) )
            (when (slot text)
               (MoveTo
                  (sub (slot h) (slot pos-h))
                  (sub (slot v) (slot pos-v)) )
               (TextSize (slot size))
               (DrawString (slot text)) >

<to keyDown (App c)
   (local (r n)
      (setq
         r (portRect Port)
         n (muldiv (bottom r) 2 3) )
      (with App
         (slot h (div n 4))
         (slot v (sub n 20))
         (slot size n)
         (slot graf NIL)
         (slot text
            (if (eq 8 c)
               (reverse (cdr (reverse (slot text))))
               (append (slot text) (list c)) ) )
         (do inval App) >

<to setCursor (App pt)
   (with App
      (localPort (slot winPtr)
         (and
            (a-key)
            (eq Port (FrontWindow))
            (GlobalToLocal pt)
            (inView pt)
            (SetCursor (ptr (GetCursor #plusCursor))) >

<to content (App pt)
   (with App
      (if (neq (slot winPtr) (FrontWindow))
         (SelectWindow (SetPort (slot winPtr)))
         (localPort (slot winPtr)
            (GlobalToLocal pt)
            (if (a-key)
               (progn
                  (setq pt (do scroll App pt))
                  (slot pos-h (sub (slot pos-h) (car pt)))
                  (slot pos-v (sub (slot pos-v) (cdr pt))) )
               (local (z)
                  (when (setq z (mkZug pt))
                     (with App
                        (slot graf (cons z (slot graf))) ) )
                  (do inval App) >

T
