[math.l 30jan93]

<de fmul (a b)
   (muldiv a b 10000) >

<de fdiv (a b)
   (muldiv a 10000 b) >

[Max scale 40000]
(setq PXSIZE 3528)

<de p-mm (n scl)
   (muldiv n (mul scl #PXSIZE) 10000) >

<de mm-p (n scl)
   (muldiv n 10000 (mul scl #PXSIZE)) >

<de dpiScale (dpi scl)
   (muldiv scl #(mul 72 PXSIZE) (mul dpi 10000)) >

<de hLocal (h)
   (with App
      (mm-p
         (add h (slot org-h))
         (slot scale) >

<de vLocal (v)
   (with App
      (mm-p
         (add v (slot org-v))
         (slot scale) >

<de hGlobal (h)
   (with App
      (sub
         (p-mm h (slot scale))
         (slot org-h) >

<de vGlobal (v)
   (with App
      (sub
         (p-mm v (slot scale))
         (slot org-v) >

<de ptLocal (pt)
   (cons
      (hLocal (car pt))
      (vLocal (cdr pt)) >

<de ptGlobal (pt)
   (cons
      (hGlobal (car pt))
      (vGlobal (cdr pt)) >

<de vpGlobal (pt)
   (cons
      (setq pt (ptGlobal pt))
      (hv-xyz (car pt) (cdr pt) (or Snap1 Snap)) >

<de pt-xyz (pt pt0)
   (local (p)
      (setq p (hv-xyz (car pt) (cdr pt) pt0))
      (cons
         (car p)
         (cons (cdr p) pt) >

<de xyz-pt (x y z)
   (cons z
      (cons
         (cons x y)
         (xyz-hv x y z) >

<de pt-wp (pt pt0)
   (cons pt (hv-xyz (car pt) (cdr pt) pt0)) >

<de xyz-wp (x y z)
   (cons
      (xyz-hv x y z)
      (cons (cons x y) z) >

[++++++
<de mkPt0 (d t f)
   (xyz-wp
      (fmul d (cos t 100))
      0
      (fmul d (sin t 100)) >
++++++]

<de vp1-h ()
   (with App
      (or
         (mdchk
            (slot focLen)
            (tan (sub 9000 (slot angle)) 100)
            (cos (slot tilt) 100) )
         100000000 >

<de vp2-h ()
   (with App
      (or
         (mdchk
            (slot focLen)
            (tan (minus (slot angle)) 100)
            (cos (slot tilt) 100) )
         -100000000 >

<de vp-v ()
   (with App
      (or
         (mdchk
            (slot focLen)
            (tan (slot tilt) 100)
            10000 )
         100000000 >

<de nadir ()
   (with App
      (or
         (mdchk
            (slot focLen)
            10000
            (minus (tan (slot tilt) 100)) )
         100000000 >

[+ Zero-based coordinates +]
[++++++
   (hv-xyz h v a (slot tilt) (slot focLen) (slot pt0)) >
++++++]

[++++++
<de vpCoord (wp)
   (local (x y)
      (with App
         (setq
            x (sub (w-x wp) (w-x (slot pt0)))
            y (sub (w-y wp) (w-y (slot pt0))) )
         (cons
            (cons
               (rot-h x y (0.0) (slot angle))
               (rot-v x y (0.0) (slot angle)) )
            (sub (w-z wp) (w-z (slot pt0))) >
++++++]

[+ Angle between 3 points +]
<de winkel (a b c)
   (setq a
      (sub
         (angle
            (sub (car c) (car b))
            (sub (cdr c) (cdr b))
            100 )
         (angle
            (sub (car a) (car b))
            (sub (cdr a) (cdr b))
            100 ) ) )
   (if (minusp a) (add a 36000) a) >

[+ Rotate clockwise +]
[++++++
<de rotate (pt c a)
   (local (h v ca sa)
      (setq
         h (sub (car pt) (car c))
         v (sub (cdr pt) (cdr c))
         ca (cos a 100)
         sa (sin a 100) )
      (cons
         (add (car c) (fmul h ca) (fmul v (minus sa)))
         (add (cdr c) (fmul h sa) (fmul v ca)) >
++++++]

<de rotate (pt c a)
   (math
      a 100 "/r#c0!s1!" [0:cos(a) 1:sin(a)]
      (sub (car pt) (car c)) "2!" [2:dh]
      (sub (cdr pt) (cdr c)) "3!" [3:dv] )
   (cons
      (add (car c) (math "2@0@*3@1@*-.")) [dh*cos(a) - dv*sin(a)]
      (add (cdr c) (math "2@1@*3@0@*+.")) [dh*sin(a) + dv*cos(a)] >

<de rot-h (h v c a)
   (add
      (car c)
      (muldiv (sub h (car c)) (cos a 100) 10000)
      (muldiv (sub v (cdr c)) (minus (sin a 100)) 10000) >

<de rot-v (h v c a)
   (add
      (cdr c)
      (muldiv (sub h (car c)) (sin a 100) 10000)
      (muldiv (sub v (cdr c)) (cos a 100) 10000) >

[+ Mirror pt relative to pt0 +]
<de mirror (wp wp0)
   (xyz-wp
      #(fix 2*(w-x wp0) - (w-x wp))
      #(fix 2*(w-y wp0) - (w-y wp))
      #(fix 2*(w-z wp0) - (w-z wp)) >

[++++++
<de rSyst (a b c)
   (local (n)
      (setq n
         (max
            (abs (muldiv (car a) (cdr b) 100000000))
            (abs (muldiv (cdr a) (car b) 100000000))
            (abs (muldiv (car c) (cdr a) 100000000))
            (abs (muldiv (cdr c) (car a) 100000000))
            (abs (muldiv (car b) (cdr c) 100000000))
            (abs (muldiv (cdr b) (car c) 100000000)) ) )
      (when (zerop n)
         (setq n 1) )
      (minusp
         (add
            (sub
               (muldiv (car a) (cdr b) n)
               (muldiv (cdr a) (car b) n))
            (sub
               (muldiv (car c) (cdr a) n)
               (muldiv (cdr c) (car a) n))
            (sub
               (muldiv (car b) (cdr c) n)
               (muldiv (cdr b) (car c) n) >
++++++]


<de rSyst (a b c)
   (math
      (car a) (cdr b) "*"
      (cdr a) (car b) "*-"
      (car b) (cdr c) "*"
      (cdr b) (car c) "*-+"
      (car c) (cdr a) "*"
      (cdr c) (car a) "*-+"
      0 "<" >

T
