[palettes.l 14feb93]

<de vpPalette ()
   (off VP)
   (new 'palette #(str "V.P.")
      1 (2 . 40) 60 30
      (progn
         (MoveTo 12 20)
         (DrawString #(str "Plane")) )
      (plane (get App 'angle) (off VP))
      (progn
         (MoveTo 1 20)
         (DrawString #(str "Elevation")) )
      (plane (get App 'angle) (zero VP))
      (progn
         (MoveTo 12 20)
         (DrawString #(str "Side")) )
      (plane (get App 'angle) (setq VP 9000)) >

<de sel1graf (w pt)
   (local (wp1 wp2)
      (cond
         ((bit #shiftBit (ev-modifiers Event))
            (selGrafs (list w)
               (if (memq w Mark)
                  '((l) (mapc l unMark))
                  '((l) (mapc l mark)) ) ) )
         ((and
               (memq w Mark)
               (setq wp2
                  (click vpGlobal vpStiff vpSpot (setq wp1 (pt-wp pt))
                     '((wp1 wp2)
                        (mapc (vpMove Mark wp1 wp2)
                           '((w) (doDraw (cdr w))) ) )
                     NIL T ) )
               (not (equal wp1 wp2)) )
            (makeModify #(str "Move") (vpMove Mark wp1 wp2)) )
         (T
            (selGrafs (list w)
               '((l)
                  (mapc Mark unMark)
                  (mapc l mark) >

<de movePoint (w z wp)
   (local (i a b c g)
      (setq
         i (index wp z)
         a (unless (zerop i) (nth (sub1 i) z))
         b (copy wp)
         c (nth (add1 i) z) )
      (setq g
         (list
            (nconc
               (when a
                  (if (pointp (car a))
                     (list a)
                     (list (nth (sub2 i) z) a) ) )
               (list b)
               (when c
                  (if (pointp (car c))
                     (list c)
                     (list c (nth (add2 i) z)) ) ) ) ) )
      (and
         (click vpGlobal vpStiff vpSpot
            (if (and a c)
               wp
               (if (pointp (car a))
                  a
                  (if (pointp (car c)) c wp) ) )
            '((:wp wp)
               (rplaca (w-hv b) (w-h wp))
               (rplacd (w-hv b) (w-v wp))
               (doDraw g) )
            NIL T )
         (not (equal b wp))
         (makeModify #(str "Move Point")
            (mapcar Mark
               '((w1)
                  (if (eq w w1)
                     (mapcar w
                        '((z1)
                           (if (eq z z1)
                              (mapcar z '((x) (if (equal wp x) b x)))
                              z1 ) ) )
                     w1 >

<de doSelect (pt)
   (local (d w r wp)
      (off Snap Snap1)
      (with App
         (setq
            pt (ptGlobal pt)
            d (p-mm #dotSiz (slot scale)) )
         (cond
            ((setq w (find Mark '((w) (onSide pt (cdr w) d))))
               (if
                  (find (cdr w)
                     '((z)
                        (find z
                           '((x)
                              (and
                                 (pointp (car x))
                                 (lessp (dist pt (w-hv x)) d)
                                 (setq wp x) ) ) ) ) )
                  (movePoint w it wp)
                  (sel1graf w pt) ) )
            ((setq w (find (slot data) '((w) (onSide pt (cdr w) d))))
               (sel1graf w pt) )
            ((setq w (find (slot data) '((w) (inside pt (cdr w) d))))
               (sel1graf w pt) )
            (T
               (when (setq r (dragSelect pt))
                  (selGrafs
                     <filter (slot data)
                        '((w)
                           (not
                              (find (cdr w)
                                 '((z)
                                    (find z
                                       '((x)
                                          (and
                                             (pointp (car x))
                                             (not (inRect (w-hv x) r)) >
                     '((l)
                        (mapc Mark unMark)
                        (mapc l mark) >

<de doLine ()
   (local (wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2 (click vpGlobal vpStiff vpSpot wp1 line1 snapOk))
         (makeWire #(str "Line") (list (list wp1 wp2))) >

<de doRect ()
   (local (wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2
            (click vpGlobal vpStiff vpSpot wp1
               '((wp1 wp2) (doDraw (vpRect wp1 wp2)))
               snapOk ) )
         (makeWire #(str "Rect") (vpRect wp1 wp2)) >

<de doPoly ()
   (when (mkPoly)
      (makeWire #(str "Poly") (list it)) >

<de doElli ()
   (local (wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2
            (click vpGlobal vpStiff vpSpot wp1
               '((wp1 wp2) (doDraw (vpElli wp1 wp2)))
               snapOk ) )
         (makeWire #(str "Ellipse") (vpElli wp1 wp2)) >

<de doBezier ()
   (local (p q r s)
      (off Snap Snap1)
      (with App
         (and
            (setq p (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
            (setq q (click vpGlobal vpStiff vpSpot p line1 snapOk))
            (line1 p q)
            (prog1
               (and
                  (setq s (click vpGlobal vpStiff vpSpot p line1 snapOk))
                  (setq r
                     (click vpGlobal vpStiff vpSpot s
                        '((wp1 wp2)
                           (line1 wp1 wp2)
                           (doDraw
                              (list (list p (cons q wp2) wp1)) ) )
                        snapOk ) ) )
               (line1 p q) )
            (makeWire #(str "Bezier")
               (list (list p (cons q r) s)) >

<de doArc ()
   (local (pa p pe)
      (off Snap Snap1)
      (with App
         (and
            (setq pa (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
            (setq pe (click vpGlobal vpStiff vpSpot pa line1 snapOk))
            (setq p
               (click vpGlobal vpStiff vpSpot pa
                  '((wp1 wp2) (doDraw (vpArc wp1 wp2 pe)))
                  snapOk ) )
            (makeWire #(str "Arc") (vpArc pa p pe)) >

[++++++
<de doSpline ()
   (local (l p s b)
      (off Snap)
      (and
         (setq l (mkPoly 4))
         (setq
            p (car l)
            s (last l)
            b (bezier
               (caar l) (cdr (pop l))
               (caar l) (cdr (pop l))
               (caar l) (cdr (pop l))
               (caar l) (cdr (pop l)) ) )
         (makeWire #(str "Spline") (list (list p b s))) >
++++++]

<de doCut ()
   (print 'cut)
>

<de toolPalette ()
   (setq VpFoo doSelect)
   (new 'palette #(str "Tools")
      1 (2 . 160) 60 30
      [+ Select +]
      (progn
         (MoveTo 6 20)
         (DrawString #(str "Select")) )
      (setq VpFoo doSelect)
      [+ Line +]
      (progn
         (MoveTo 12 20)
         (DrawString #(str "Line")) )
      (progn (doLine) (do mark Tools))
      [+ Rect +]
      (progn
         (MoveTo 12 20)
         (DrawString #(str "Rect")) )
      (progn (doRect) (do mark Tools))
      [+ Poly +]
      (progn
         (MoveTo 12 20)
         (DrawString #(str "Poly")) )
      (progn (doPoly) (do mark Tools))
      [+ Ellipse +]
      (progn
         (MoveTo 6 20)
         (DrawString #(str "Ellipse")) )
      (progn (doElli) (do mark Tools))
      [+ Bezier +]
      (progn
         (MoveTo 10 20)
         (DrawString #(str "Bezier")) )
      (progn (doBezier) (do mark Tools))
      [+ Arc +]
      (progn
         (MoveTo 16 20)
         (DrawString #(str "Arc")) )
      (progn (doArc) (do mark Tools))
[++++++
      [+ Cut +]
      (progn
         (MoveTo 16 20)
         (DrawString #(str "Cut")) )
      (progn (doCut) (do mark Tools))
++++++]
      >

T
