/* vpGraf.c
 * 17jan93abu
 */

#pragma segment vpGraf

#include "viewPoint.h"
#include ":src:graf.h"

typedef struct {
   short cnt;
   short siz;
   number *lst;
} crossing;

#define BOUNDS(pt,pt1,pt2)\
   if (pt.h < pt1.h) pt1.h = pt.h;  else if (pt.h > pt2.h) pt2.h = pt.h;\
   if (pt.v < pt1.v) pt1.v = pt.v;  else if (pt.v > pt2.v) pt2.v = pt.v;


/* Globals */
static pico drawFoo;
static long drawN, crossN, onN;
static point onPt;
static point Bounds1,Bounds2;
static long crLin1,crLin2, crCnt, crSiz;
static crossing *crLst = NULL;


pico Angle(x)
pico x;
{
	number dx,dy;
	real a;

	dx = nextNum(&x);
	dy = nextNum(&x);
	if (!dx)
		a =  (dy > 0)? 90.0 : -90.0;
	else {
		a = atan((real)dy/(real)dx) * 180.0/PI;
		if	(dx < 0)
			if (dy > 0)
				a += 180.0;
			else
				a -= 180.0;
	}
	if (isCell(x))
		a *= (real)nextNum(&x);
	return boxReal(a);
}

pico Bezier(x)
pico x;
{
   number px,py,vx,vy,wx,wy,sx,sy;

   px = nextNum(&x);
   py = nextNum(&x);
   vx = nextNum(&x);
   vy = nextNum(&x);
   wx = nextNum(&x);
   wy = nextNum(&x);
   sx = nextNum(&x);
   sy = nextNum(&x);
   return newCell2(
      boxNum((3*sx - 10*px + 24*vx - 8*wx) / 9),
      boxNum((3*sy - 10*py + 24*vy - 8*wy) / 9),
      boxNum((3*px - 10*sx + 24*wx - 8*vx) / 9),
      boxNum((3*py - 10*sy + 24*wy - 8*vy) / 9) );
}

pico Center(x)
pico x;
{
   point a,b,c,ab,bc,d,e,m;

   nextPoint(&x,&a);
   nextPoint(&x,&b);
   nextPoint(&x,&c);
   if (a.h==b.h && a.v==b.v || b.h==c.h && b.v==c.v ||
                                          a.h==c.h && a.v==c.v )
      return nilSym;
   ab.h = (a.h + b.h) / 2;
   ab.v = (a.v + b.v) / 2;
   bc.h = (b.h + c.h) / 2;
   bc.v = (b.v + c.v) / 2;
   d.h = ab.h + b.v - a.v;
   d.v = ab.v - b.h + a.h;
   e.h = bc.h + c.v - b.v;
   e.v = bc.v - c.h + b.h;
   return
      intsec(&ab, &d, &bc, &e, YES, &m)?
         newCell(boxNum(m.h),boxNum(m.v)) :
         nilSym;
}

pico MidPt(x)
register pico x;
{
   register pico y;
	cell c1;

   push(y = EVAL1(x),c1);
   needPoint(y);
   x = cdr(x);
   needPoint(x = EVAL1(x));
   drop(c1);
   return newCell(
      boxNum((unBox(car(y)) + unBox(car(x))) / 2),
      boxNum((unBox(cdr(y)) + unBox(cdr(x))) / 2) );
}

void bounds(x)
register pico x;
{
   register number n;

   if (isCell(x)) {
      if (isNum(car(x))) {
         if ((n = unBox(car(x))) < Bounds1.h)
            Bounds1.h = n;
         if (n > Bounds2.h)
            Bounds2.h = n;
         if ((n = unBox(cdr(x))) < Bounds1.v)
            Bounds1.v = n;
         if (n > Bounds2.v)
            Bounds2.v = n;
      }
		else if (isNum(cdr(cdr(x))))
			bounds(car(x));
      else {
         bounds(car(x));
         bounds(cdr(x));
      }
   }
}

pico Bounds(x)
register pico x;
{
   Bounds1.h = Bounds1.v = MAXNUM;
   Bounds2.h = Bounds2.v = MAXNEG;
   NEEDCELL(x);
   do
      bounds(EVAL1(x));
   while (isCell(x = cdr(x)));
   return newCell2(boxNum(Bounds1.h), boxNum(Bounds1.v),
                        boxNum(Bounds2.h), boxNum(Bounds2.v));
}

pico graf(x,foo)
register pico x;
pico foo;
{
   register pico y,z;
	cell c1,c2;

   if (!isCell(x))
      return x;
   push(y = newCell(apply1(foo,car(x)),nilSym), c1);
   while (isCell(x = cdr(x))) {
      if (isNum(car(car(z = car(x)))))
         cdr(y) = newCell(apply1(foo,z),nilSym);
      else {
         push(z = apply1(foo,car(z)),c2);
         cdr(y) = newCell(newCell(z,apply1(foo,cdr(car(x)))),nilSym);
         drop(c2);
      }
      y = cdr(y);
   }
   return pop(c1);
}

pico Graf(x)
register pico x;
{
   register pico y;
	cell c1,c2,c3;

   if (isNil(y = EVAL1(x)))  /* Graf */
      return y;
   push(y,c1);
   x = cdr(x);
   push(EVAL1(x),c2);  /* foo */
   push(x = newCell(graf(car(y),tos(c2)),nilSym), c3);
   while (isCell(y = cdr(y))) {
      cdr(x) = newCell(graf(car(y),tos(c2)),nilSym);
      x = cdr(x);
   }
   drop(c1);
   return tos(c3);
}

void drawBez(px,py,qx,qy,rx,ry,sx,sy)
long px,py,qx,qy,rx,ry,sx,sy;
{
   long d,ax,ay,bx,by,cx,cy,dx,dy,ex,ey;

   if (!(d = dist(px,py,sx,sy)))
		return;
	ax = ry - qy;
	ay = qx - rx;
   if (absNumber(muldiv(qx-px,ax,d) + muldiv(qy-py,ay,d)) +
				absNumber(muldiv(rx-sx,ax,d) + muldiv(ry-sy,ay,d)) <= drawN)
		apply4(drawFoo,boxNum(px),boxNum(py),boxNum(sx),boxNum(sy));
	else {
		dx = ((ax = (px+qx)/2) + (bx = (qx+rx)/2)) / 2;
		dy = ((ay = (py+qy)/2) + (by = (qy+ry)/2)) / 2;
		ex = (bx + (cx = (rx+sx)/2)) / 2;
		ey = (by + (cy = (ry+sy)/2)) / 2;
		drawBez(px,py,ax,ay,dx,dy,(dx+ex)/2,(dy+ey)/2);
		drawBez((dx+ex)/2,(dy+ey)/2,ex,ey,cx,cy,sx,sy);
   }
}

pico Draw(x)
pico x;
{
   register pico y,z,p;
   pico bezFoo;
   number n;
	cell c1,c2;

   push(EVAL1(x),c1); /* Graf */
   x = cdr(x);
   n = nextNum(&x); /* Resolution */
   push(EVAL1(x), c2); /* Drawing function */
   bezFoo = isCell(x = cdr(x))? EVAL1(x) : NULL; /* Bezier function */
   x = tos(c1);
	drawFoo = tos(c2);
   drawN = n;
   while (isCell(x)) {
      y = car(x),  x = cdr(x);
      p = car(car(y));
      while (isCell(y = cdr(y))) {
         if (isNum(car(car(z = car(y))))) {
				z = car(z);
            apply4(drawFoo, car(p), cdr(p), car(z), cdr(z));
            p = z;
         }
         else {
            y = cdr(y);
            if (!bezFoo || apply4(bezFoo,p,car(z),cdr(z),car(y))==nilSym)
               drawBez(unBox(car(p)), unBox(cdr(p)),
								unBox(car(car(car(z)))),
								unBox(cdr(car(car(z)))),
								unBox(car(car(cdr(z)))),
								unBox(cdr(car(cdr(z)))),
								unBox(car(car(car(y)))),
								unBox(cdr(car(car(y)))) );
            p = car(car(y));
         }
      }
   }
   drop(c1);
   return tSym;
}

static bool onLine(h1,v1,h2,v2)
number h1,v1,h2,v2;
{
   register number dh,dv;

   dh = h2 - h1;
   dv = v2 - v1;
   if (dh || dv) {
      if (absNumber(dh) > absNumber(dv)) {
         if (dh > 0) {
            if (h1 <= onPt.h  &&  onPt.h <= h2  &&
                 absNumber(v1 + muldiv(onPt.h-h1,dv,dh) - onPt.v) <= onN)
               return YES;
         }
         else {
            if (h2 <= onPt.h  &&  onPt.h <= h1  &&
                 absNumber(v2 + muldiv(onPt.h-h2,dv,dh) - onPt.v) <= onN)
               return YES;
         }
      }
      else {
         if (dv > 0) {
            if (v1 <= onPt.v  &&  onPt.v <= v2  &&
                 absNumber(h1 + muldiv(onPt.v-v1,dh,dv) - onPt.h) <= onN)
               return YES;
         }
         else {
            if (v2 <= onPt.v  &&  onPt.v <= v1  &&
                 absNumber(h2 + muldiv(onPt.v-v2,dh,dv) - onPt.h) <= onN)
               return YES;
         }
      }
   }
   return NO;
}

static bool onBez(n,px,py,qx,qy,rx,ry,sx,sy)
register int n;
long px,py,qx,qy,rx,ry,sx,sy;
{
   register long a;
   long ax,ay,bx,by,cx,cy,dx,dy,ex,ey;

   a = onPt.h + onN;
   if (a<px && a<qx && a<rx && a<sx)
      return NO;
   a = onPt.h - onN;
   if (a>px && a>qx && a>rx && a>sx)
      return NO;
   a = onPt.v + onN;
   if (a<py && a<qy && a<ry && a<sy)
      return NO;
   a = onPt.v - onN;
   if (a>py && a>qy && a>ry && a>sy)
      return NO;
   if (--n < 0)
      return YES;  /* onLine(px,py,qx,qy) || onLine(qx,qy,rx,ry) ||
                                             onLine(rx,ry,sx,sy); */
   dx = ((ax = (px+qx)/2) + (bx = (qx+rx)/2)) / 2;
   dy = ((ay = (py+qy)/2) + (by = (qy+ry)/2)) / 2;
   ex = (bx + (cx = (rx+sx)/2)) / 2;
   ey = (by + (cy = (ry+sy)/2)) / 2;
   return
      onBez(n,px,py,ax,ay,dx,dy,(dx+ex)/2,(dy+ey)/2) ||
            onBez(n,(dx+ex)/2,(dy+ey)/2,ex,ey,cx,cy,sx,sy);
}

pico OnSide(x)
register pico x;
{
   register pico y,z;
   register number h1,v1,h2,v2;
   point pt;
   number n;
	cell c1;

   unBoxPoint(EVAL1(x),&pt);
   x = cdr(x);
   push(EVAL1(x),c1);
   n = 2;
   x = cdr(x);
   if (!isNil(x = EVAL1(x))) {
      NEEDNUM(x);
      n = unBox(x);
   }
   x = pop(c1);
   onPt = pt;
   onN = n;
   while (isCell(x)) {
      y = car(x),  x = cdr(x);
      z = car(car(y));
      h1 = unBox(car(z));
      v1 = unBox(cdr(z));
      if (dist(h1,v1,onPt.h,onPt.v) <= onN)
         return tSym;
      while (isCell(y = cdr(y))) {
         if (isNum(car(car(z = car(y))))) {
				z = car(z);
            if (onLine(h1, v1, h2 = unBox(car(z)), v2 = unBox(cdr(z))))
               return tSym;
         }
         else {
            y = cdr(y);
            if (onBez(3, h1, v1,
								unBox(car(car(car(z)))),
								unBox(cdr(car(car(z)))),
								unBox(car(car(cdr(z)))),
								unBox(cdr(car(cdr(z)))),
								h2 = unBox(car(car(car(y)))),
								v2 = unBox(cdr(car(car(y)))) ) )
               return tSym;
         }
         h1 = h2;
         v1 = v2;
      }
   }
   return nilSym;
}

bool cross(h1,v1,h2,v2)
number h1,v1,h2,v2;
{
	if (crCnt == 1) {
      register number c, i, *p, temp;

      if (v1 <= crLin1 && crLin1 < v2  ||  v2 <= crLin1 && crLin1 < v1) {
         c = h1 + muldiv(crLin1-v1, h2-h1, v2-v1);
         if (crLst[0].cnt == crLst[0].siz) {
            if (!(p = (number*)libRealloc((char*)crLst[0].lst,
									(crLst[0].siz + 4) * sizeof(number))))
					return NO;
				crLst[0].lst = p;
				crLst[0].siz += 4;
			}
			else
         	p = crLst[0].lst;
         i = 0;
         while (i < crLst[0].cnt  &&  c > *p)
            ++i, ++p;
         while (i++ < crLst[0].cnt)
            temp = *p,  *p++ = c,  c = temp;
         *p = c;
         ++crLst[0].cnt;
      }
	}
	else {
		register number c, i, *p, j, temp, dh,dv;
		register crossing *q;

		if (v2 < v1) {
			temp = v1,  v1 = v2,  v2 = temp;
			temp = h1,  h1 = h2,  h2 = temp;
		}
		dh = h2 - h1;
		dv = v2 - v1;
		q = crLst + v1 - crLin1;
		for (j = 0; j < dv; ++j) {
			c = h1 + j*dh/dv;
         if (q->cnt == q->siz) {
            if (!(p = (number*)libRealloc((char*)q->lst,
									(q->siz + 4) * sizeof(number))))
					return NO;
				q->lst = p;
				q->siz += 4;
			}
			else 
         	p = q->lst;
         i = 0;
         while (i < q->cnt  &&  c > *p)
            ++i, ++p;
         while (i++ < q->cnt)
            temp = *p,  *p++ = c,  c = temp;
         *p = c;
         ++q->cnt;
			++q;
		}
	}
	return YES;
}

bool crossBez(px,py,qx,qy,rx,ry,sx,sy)
long px,py,qx,qy,rx,ry,sx,sy;
{
   long d,ax,ay,bx,by,cx,cy,dx,dy,ex,ey;

   if (py<crLin1 && qy<crLin1 && ry<crLin1 && sy<crLin1 ||
					py>=crLin2 && qy>=crLin2 && ry>=crLin2 && sy>=crLin2)
      return YES;
   if (!(d = dist(px,py,sx,sy)))
      return YES;
   ax = ry - qy;
   ay = qx - rx;
   if (absNumber(muldiv(qx-px,ax,d) + muldiv(qy-py,ay,d)) +
         absNumber(muldiv(rx-sx,ax,d) + muldiv(ry-sy,ay,d)) <= crossN)
      return cross(px,py,qx,qy) && cross(qx,qy,rx,ry) && cross(rx,ry,sx,sy);
   dx = ((ax = (px+qx)/2) + (bx = (qx+rx)/2)) / 2;
   dy = ((ay = (py+qy)/2) + (by = (qy+ry)/2)) / 2;
   ex = (bx + (cx = (rx+sx)/2)) / 2;
   ey = (by + (cy = (ry+sy)/2)) / 2;
   return crossBez(px,py,ax,ay,dx,dy,(dx+ex)/2,(dy+ey)/2) &&
      				crossBez((dx+ex)/2,(dy+ey)/2,ex,ey,cx,cy,sx,sy);
}

bool buildCross(x)
pico x;
{
   register pico y,z;
   register number h1,v1,h2,v2;
	crossing *p;

   if (!crLst) {
      if (!(crLst = (crossing*)libAlloc(crCnt*sizeof(crossing))))
			return NO;
      crSiz = 0;
	}
	else if (crSiz < crCnt) {
		if (!(p = (crossing*)libRealloc((char*)crLst,
												crCnt*sizeof(crossing))))
			return NO;
		crLst = p;
	}
	while (crSiz < crCnt) {
		if (!(crLst[crSiz].lst = (number*)libAlloc(4*sizeof(number))))
			return NO;
		crLst[crSiz++].siz = 4;
	}
	v1 = crCnt;
	while (--v1 >= 0)
		crLst[v1].cnt = 0;
   while (isCell(x)) {
      y = car(x),  x = cdr(x);
      z = car(car(y));
      h1 = unBox(car(z));
      v1 = unBox(cdr(z));
      while (isCell(y = cdr(y))) {
         if (isNum(car(car(z = car(y))))) {
				z = car(z);
            if (!cross(h1, v1, h2=unBox(car(z)), v2=unBox(cdr(z))))
					return NO;
			}
         else {
            y = cdr(y);
            if (!crossBez(h1, v1,
								unBox(car(car(car(z)))),
								unBox(cdr(car(car(z)))),
                        unBox(car(car(cdr(z)))),
								unBox(cdr(car(cdr(z)))),
                        h2 = unBox(car(car(car(y)))),
								v2 = unBox(cdr(car(car(y)))) ) )
					return NO;
         }
         h1 = h2;
         v1 = v2;
      }
   }
	return YES;
}

pico Inside(x)
register pico x;
{
   register pico y;
   register number h,v,i;
   register bool res;
   number n;
	cell c1;

   y = EVAL1(x);
   needPoint(y);
   h = unBox(car(y)); /* Point */
   v = unBox(cdr(y));
   x = cdr(x);
   push(EVAL1(x),c1); /* Graf */
   x = cdr(x);
	n = num(EVAL1(x)); /* Resolution */
	NEEDNUM(n);
   crossN = unBox(n);
   crLin1 = v;
   crLin2 = v + 1;
	crCnt = 1;
   if (!buildCross(pop(c1)))
		return voidSym;
   res = NO;
   for (i = 0; i < crLst[0].cnt && crLst[0].lst[i] <= h; ++i)
      res = !res;
   return  (res && i<crLst[0].cnt)?  tSym : nilSym;
}

#if 0
pico Scan(x)
register pico x;
{
	register pico y,z;
   register long i;
	register crossing *p;
	cell c1,c2;

   push(EVAL1(x),c1); /* Graf */
   x = cdr(x);
	i = num(EVAL1(x)); /* Resolution */
	NEEDNUM(i);
   i = unBox(i);
	x = cdr(x);
   push(EVAL1(x),c2); /* Function */
   crossN = i;
	crLin1 = MAXNUM;
	crLin2 = MAXNEG;
	x = tos(c1);
	while (isCell(x)) {
      y = car(x),  x = cdr(x);
		while (isCell(y)) {
			z = car(y),  y = cdr(y);
			if (isNum(car(z))) {
				if ((i = unBox(cdr(z))) < crLin1)
					crLin1 = i;
				if (i > crLin2)
					crLin2 = i;
			}
			else {
				if ((i = unBox(cdr(car(z)))) < crLin1)
					crLin1 = i;
				else if (i > crLin2)
					crLin2 = i;
				if ((i = unBox(cdr(cdr(z)))) < crLin1)
					crLin1 = i;
				else if (i > crLin2)
					crLin2 = i;
			}
		}
	}
	if ((crCnt = crLin2 - crLin1) <= 0) {
		drop(c1);
		return nilSym;
	}
   if (!buildCross(tos(c1))) {
		drop(c1);
		return voidSym;
	}
	p = crLst;
	if (isNil(tos(c2))) {
		number n = 0;

		drop(c1);
		while (--crCnt >= 0) {
   		/* Add up scan length's */
   		for (i = 0; i < p->cnt; i += 2)
      		n += p->lst[i+1] - p->lst[i];
			++p;
			++crLin1;
		}
		return boxNum(n);
   }
   x = nilSym;
	while (--crCnt >= 0) {
   	/* Apply function to pairs of crosspoints */
   	for (i = 0; i < p->cnt; i += 2)
      	x = apply4(tos(c2), boxNum(crLin1),
					boxNum(p->lst[i]), boxNum(p->lst[i+1]),
					i? nilSym:tSym );
		++p;
		++crLin1;
	}
   drop(c1);
   return x;
}
#endif

symInit vpGrafSyms[] = {
   {"angle",      Angle},
   {"bezier",     Bezier},
   {"center",     Center},
	{"midPt",      MidPt},
   {"bounds",     Bounds},
   {"graf",       Graf},
   {"draw",       Draw},
   {"onSide",     OnSide},
   {"inside",     Inside},
	NULL
};
