/* vpSubr.c
 * 24jan93abu
 */

#pragma segment vpSubr

#include "viewPoint.h"

/* Globals */
static real FocLen, PosX, PosZ, CosT, SinT, FCosT, FSinT;
static bool HPlane;
static real VAngle, CosA, SinA, TanA;


pico Camera(arg)
pico arg;
{
	real delta, t;

	FocLen = nextFix(&arg);
	delta = -nextFix(&arg);
	t = nextAngle(&arg);
	CosT = cos(t);
	SinT = sin(t);
	PosX = delta * CosT;
	PosZ = delta * SinT;
	FCosT = FocLen * CosT;
	FSinT = FocLen * SinT;
	return tSym;
}

pico Plane(arg)
pico arg;
{
	VAngle = nextAngle(&arg);
	if (!(HPlane = isNil(arg = EVAL1(arg))))
		VAngle  +=  (real)unBox(arg) * PI / 18000.0;
	CosA = cos(VAngle);
	SinA = sin(VAngle);
	TanA = tan(VAngle);
	return arg;
}

/* Rotate from viewPoint coordinates */
pico rot_x(arg)
register pico arg;
{
	arg = EVAL1(arg);
	NEEDCELL(arg);
	return boxFix(
			unBoxFix(car(car(cdr(arg))))*CosA -
			unBoxFix(cdr(car(cdr(arg))))*SinA );
}

pico rot_y(arg)
pico arg;
{
	arg = EVAL1(arg);
	NEEDCELL(arg);
	return boxFix(
			unBoxFix(car(car(cdr(arg))))*SinA +
			unBoxFix(cdr(car(cdr(arg))))*CosA );
}

/* Rotate to viewPoint coordinates */
pico x_rot(arg)
pico arg;
{
	real x,y;

	x = nextFix(&arg);
	y = nextFix(&arg);
	return boxFix(x*CosA + y*SinA);
}

pico y_rot(arg)
pico arg;
{
	real x,y;

	x = nextFix(&arg);
	y = nextFix(&arg);
	return boxFix(y*CosA - x*SinA);
}

/* Transform xyz to 2-D */
pico xyz_hv(arg)
pico arg;
{
	real x,y,z,a;

	x = nextFix(&arg) - PosX;
	y = nextFix(&arg);
	z = nextFix(&arg) - PosZ;
	a = x*CosT + z*SinT;
	return newCell(boxFix(FocLen*y / a), boxFix((x*FSinT - z*FCosT) / a) );
}

/* Transform 2-D to xyz */
pico hv_xyz(arg)
pico arg;
{
	real h,v,n,k,y,z;

	h = nextFix(&arg);
	v = nextFix(&arg);
	arg = EVAL1(arg);
	if (HPlane) {
		n = FSinT - v*CosT;
		if (isNil(arg))
			return newCell(
				newCell(boxFix(-PosZ*(FCosT + v*SinT)/n + PosX), boxFix(-PosZ*h/n)),
				boxNum(0) );
		z = unBoxFix(cdr(cdr(arg))) - PosZ; /* Hook point z */
		return newCell(
			newCell(boxFix(z*(FCosT + v*SinT)/n + PosX), boxFix(z*h/n)),
			cdr(cdr(arg)) /*boxFix(z)*/ );
	}
	n = FCosT + v*SinT - h*TanA;
	/* Hook point:  k = x - y*TanA */
	if (isNil(arg))
		k = -PosX;
	else
		k = unBoxFix(car(car(cdr(arg))))-PosX - unBoxFix(cdr(car(cdr(arg))))*TanA;
	y = k * h / n;
	return newCell(
		newCell(boxFix(k + y*TanA + PosX), boxFix(y)),
		boxFix(k*(FSinT - v*CosT) / n + PosZ) );
}

symInit vpSubrSyms[] = {
	{"camera",  Camera},
	{"plane",   Plane},
	{"rot-x",   rot_x},
	{"rot-y",   rot_y},
	{"x-rot",   x_rot},
	{"y-rot",   y_rot},
	{"xyz-hv",  xyz_hv},
	{"hv-xyz",  hv_xyz},
	NULL
};
