;;; -*- Mode: LISP;  Syntax: COMMON-LISP; Package: (*SIM-I COMMON-LISP-GLOBAL); Base: 10; Muser: yes -*-

(in-package :*sim-i)

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.


;;;; The Simulator's representation of a pvar.

;;; (In CMU CL, nasty circularities arise bacause Internal-Pvarp gets declared
;;; inline as being (Typep Foo 'Pvar), which gets optimized into a call to
;;; Internal-Pvarp thanks to the Pvar Deftype.  So we define Internal-Pvarp
;;; differently in CMU CL...)
 
#|
(defstruct (pvar (:predicate #+CMU %internal-pvarp #-CMU internal-pvarp) (:print-function print-pvar))
  name
  location
  class
  canonical-pvar-type
  lvalue?
  constant?
  vp-set
  (plist nil)
  other-1
  other-2
  other-3
  other-4
  )
|#

(defstruct (pvar-struct (:predicate #+CMU %internal-pvarp #-CMU internal-pvarp) 
                        (:print-function print-pvar)
                        (:conc-name pvar-)
                        (:constructor make-pvar))
  name
  location
  class
  canonical-pvar-type
  lvalue?
  constant?
  vp-set
  (plist nil)
  other-1
  other-2
  other-3
  other-4
  )

(defun pvar-p (x) (internal-pvarp x))

#+CMU
(defun internal-pvarp (object)
  (and (ext:structurep object)
       (let ((obj-name (svref object 0)))
	 (or (eq obj-name 'pvar)
	     (not (null (memq 'pvar
			      (dd-includes
 			       (get obj-name '%structure-definition)))))))))


(defun copy-pvar-slots (dest source)
  (setf (pvar-name dest) (pvar-name source))
  (setf (pvar-location dest) (pvar-location source))
  (setf (pvar-class dest) (pvar-class source))
  (setf (pvar-canonical-pvar-type dest) (pvar-canonical-pvar-type source))
  (setf (pvar-lvalue? dest) (pvar-lvalue? source))
  (setf (pvar-constant? dest) (pvar-constant? source))
  (setf (pvar-vp-set dest) (pvar-vp-set source))
  (setf (pvar-plist dest) (pvar-plist source))
  (setf (pvar-other-1 dest) (pvar-other-1 source))
  (setf (pvar-other-2 dest) (pvar-other-2 source))
  (setf (pvar-other-3 dest) (pvar-other-3 source))
  (setf (pvar-other-4 dest) (pvar-other-4 source))
  )

(defun is-pvar (x) (pvar-p x))

(defun pvar-type (pvar) (pvar-class pvar))
(defun pvar-data (pvar) (pvar-location pvar))

(defsetf pvar-type (pvar) (value) `(setf (pvar-class ,pvar) ,value))
(defsetf pvar-data (pvar) (value) `(setf (pvar-location ,pvar) ,value))

(defun pvar-array (pvar) (pvar-location pvar))
(defun pvar-array-dimensions (array-pvar) (pvar-other-1 array-pvar))
(defun pvar-array-canonical-element-type (array-pvar) (pvar-other-2 array-pvar))
(defun pvar-array-element-type (array-pvar) (pvar-other-2 array-pvar))
(defun pvar-array-displaced-array (array-pvar) (pvar-other-3 array-pvar))
(defun pvar-sideways-p (array-pvar) (pvar-other-4 array-pvar))

(defsetf pvar-array (pvar) (value) `(setf (pvar-location ,pvar) ,value))
(defsetf pvar-array-dimensions (pvar) (value) `(setf (pvar-other-1 ,pvar) ,value))
(defsetf pvar-array-canonical-element-type (pvar) (value) `(setf (pvar-other-2 ,pvar) ,value))
(defsetf pvar-array-element-type (pvar) (value) `(setf (pvar-other-2 ,pvar) ,value))
(defsetf pvar-array-displaced-array (pvar) (value) `(setf (pvar-other-3 ,pvar) ,value))
(defsetf pvar-sideways-p (pvar) (value) `(setf (pvar-other-4 ,pvar) ,value))

(defun pvar-structure (pvar) (pvar-location pvar))
(defun pvar-structure-name (pvar) (pvar-other-1 pvar))
(defun pvar-address-object-geometry-id (pvar) (pvar-other-2 pvar))

(defsetf pvar-structure (pvar) (value) `(setf (pvar-location ,pvar) ,value))
(defsetf pvar-structure-name (pvar) (value) `(setf (pvar-other-1 ,pvar) ,value))
(defsetf pvar-address-object-geometry-id (pvar) (value) `(setf (pvar-other-2 ,pvar) ,value))

(defun void-pvar-p (pvar) (eq :void (pvar-other-1 pvar)))
(defun make-void (pvar) (setf (pvar-other-1 pvar) :void))
(defun make-non-void (pvar) (setf (pvar-other-1 pvar) nil))

;(defun general-pvar-array-list (pvar) (pvar-other-1 pvar))
;(defun general-pvar-structure-list (pvar) (pvar-other-2 pvar))
;(defsetf general-pvar-array-list (pvar) (value) `(setf (pvar-other-1 ,pvar) ,value))
;(defsetf general-pvar-structure-list (pvar) (value) `(setf (pvar-other-2 ,pvar) ,value))

(defun pvar-constant-value (pvar) (pvar-plist pvar))
(defsetf pvar-constant-value (pvar) (value) `(setf (pvar-plist ,pvar) ,value))


(defvar *pvar-length-error-message*
	"The ~S of a pvar has no meaning with respect to the *Lisp language itself.  ~@
         It only has meaning with respect to Paris, the CM Assembly language, and the ~@
         *Lisp Simulator knows nothing about Paris.  Pure *Lisp code cannot use ~S.
        "
  )

(defun pvar-length (pvar)
  pvar
  (error *pvar-length-error-message* 'length 'pvar-length)
  )

(defun pvar-mantissa-length (pvar)
  pvar
  (error *pvar-length-error-message* 'mantissa-length 'pvar-mantissa-length)
  )

(defun pvar-exponent-length (pvar)
  pvar
  (error *pvar-length-error-message* 'exponent-length 'pvar-exponent-length)
  )

(defun clear-non-essential-pvar-slots (pvar)
  (setf (pvar-plist pvar) nil)
  (setf (pvar-other-1 pvar) nil)
  (setf (pvar-other-2 pvar) nil)
  (setf (pvar-other-3 pvar) nil)
  (setf (pvar-other-4 pvar) nil)
  )
	

(defun general-pvar-class-label () :general)
(defun array-pvar-class-label () :array)
(defun structure-pvar-class-label () :structure)
(defun general-pvar-p (pvar) (eq (general-pvar-class-label) (pvar-class pvar)))
(defun array-pvar-p (pvar) (eq (array-pvar-class-label) (pvar-class pvar)))
(defun structure-pvar-p (pvar) (eq (structure-pvar-class-label) (pvar-class pvar)))
;(defun general-pvar-without-arrays-p (pvar)
;  (and (general-pvar-p pvar) (null (general-pvar-array-list pvar)))
;  )
;(defun general-pvar-without-structures-p (pvar)
;  (and (general-pvar-p pvar) (null (general-pvar-structure-list pvar)))
;  )
(defun simple-general-pvar-p (pvar)
  (and (general-pvar-p pvar)) ; (null (general-pvar-array-list pvar)) (null (general-pvar-structure-list pvar)))
  )
(defun scalar-pvar-p (pvar) (simple-general-pvar-p pvar))
(defun non-scalar-pvar-p (pvar) (or (array-pvar-p pvar) (structure-pvar-p pvar)))


(defun canonical-pvar-type-from-pvar (pvar) (pvar-canonical-pvar-type pvar))

(defun describe-pvar (pvar &optional (stream nil))
  
  (terpri stream)
  (let ((stream (if stream stream *standard-output*)))
    (terpri stream)
    (progn
      (format stream "Pvar name: ~S~%" (pvar-name pvar))
      (format stream "Lvalue?:   ~S~%" (pvar-lvalue? pvar))
      (format stream "Constant?: ~S~%" (pvar-constant? pvar))
      (format stream "Class:     ~S~%" (pvar-class pvar))
      (format stream "Canonical-pvar-type: ~S~%" (pvar-canonical-pvar-type pvar))
      (format stream "Vp Set:    ~S~%" (pvar-vp-set pvar))
      (when (pvar-constant-value pvar)
	(format stream "Constant value: ~S~%" (pvar-constant-value pvar))
	)
      (when (void-pvar-p pvar)
	(format stream "*** This pvar has not been initialized ***~%")
	)
      (when (array-pvar-p pvar)
	(format stream "Array dimensions: ~S~%" (pvar-array-dimensions pvar))
	(format stream "Canonical element pvar type: ~S~%" (pvar-array-canonical-element-type pvar))
	)
      (terpri stream)
      )))


(defun print-pvar (pvar stream depth)
  depth
  (format stream "#<PVAR ~A ~S ~A ~A ~A>"
	  (pvar-name pvar)
	  (pvar-type pvar)
	  (case (pvar-type pvar)
	    (:general "")
	    (:array (format nil "~S" (pvar-array-dimensions pvar)))
	    (:structure (format nil "~S" (pvar-structure-name pvar)))
	    (otherwise "UNALLOCATED")
	    )
	  (if (pvar-vp-set pvar) (vp-set-name (pvar-vp-set pvar)) NIL)
	  (if (pvar-vp-set pvar) (vp-set-dimensions (pvar-vp-set pvar)) nil)
	  ))
