/* xlio - xlisp i/o routines */

#include <stdio.h>
#include "xlisp.h"

/* global variables */
int (*xlgetc)();
int xlpvals;

/* local variables */
static int prompt;
static FILE *ifp;

/* tgetc - get a character from the terminal */
static int tgetc()
{
    int ch;

    /* prompt if necessary */
    if (prompt) {
	printf("> ");
	prompt = FALSE;
    }

    /* get the character */
    if ((ch = getchar()) == '\n')
	prompt = TRUE;

    /* return the character */
    return (ch);
}

/* xltin - setup terminal input */
int xltin()
{
    /* initialize */
    prompt = TRUE;
    xlgetc = tgetc;
    xlpvals = TRUE;
}

/* fgetc - get a character from a file */
static int fgetc()
{
    int ch;

    /* get a character */
    if ((ch = getc(ifp)) <= 0) {
	xlgetc = tgetc;
	xlpvals = TRUE;
	return (tgetc());
    }

    /* return it */
    return (ch);
}

/* xlfin - setup file input */
xlfin(str)
  char *str;
{
    char fname[100];

    /* create the file name */
    strcpy(fname,str);

    /* open the input file */
    if ((ifp = fopen(fname,"r")) == NULL) {
	printf("can't open \"%s\" for input\n",fname);
	return;
    }

    /* setup input from the file */
    xlgetc = fgetc;
    xlpvals = FALSE;
}
