/* xlio - xlisp i/o routines */

#ifdef AZTEC
#include "stdio.h"
#else
#include <stdio.h>
#endif

#include "xlisp.h"

/* global variables */
int xlplevel=0;
int xlfsize=0;

/* external variables */
extern struct node *xlstack;
extern struct node *s_stdin;

/* local variables */
static int prompt=TRUE;

/* xlgetc - get a character from a file or stream */
int xlgetc(fptr)
  struct node *fptr;
{
    struct node *lptr,*cptr;
    FILE *fp;
    int ch;

    /* check for input from nil */
    if (fptr == NULL)
	ch = EOF;

    /* otherwise, check for input from a stream */
    else if (fptr->n_type == LIST) {
	if ((lptr = fptr->n_listvalue) == NULL)
	    ch = EOF;
	else {
	    if (lptr->n_type != LIST ||
		(cptr = lptr->n_listvalue) == NULL || cptr->n_type != INT)
		xlfail("bad stream");
	    if ((fptr->n_listvalue = lptr->n_listnext) == NULL)
		fptr->n_listnext = NULL;
	    ch = cptr->n_int;
	}
    }

    /* otherwise, check for a buffered file character */
    else if (ch = fptr->n_savech)
	fptr->n_savech = 0;

    /* otherwise, get a new character */
    else {

	/* get the file pointer */
	fp = fptr->n_fp;

	/* prompt if necessary */
	if (prompt && fp == stdin) {
	    if (xlplevel > 0)
		printf("%d> ",xlplevel);
	    else
		printf("> ");
	    prompt = FALSE;
	}

	/* get the character */
	if ((ch = getc(fp)) == '\n' && fp == stdin)
	    prompt = TRUE;

	/* check for input abort */
	if (fp == stdin && ch == '\007') {
	    putchar('\n');
	    xlfail("input aborted");
	}
    }

    /* return the character */
    return (ch);
}

/* xlpeek - peek at a character from a file or stream */
int xlpeek(fptr)
  struct node *fptr;
{
    struct node *lptr,*cptr;
    int ch;

    /* check for input from nil */
    if (fptr == NULL)
	ch = EOF;

    /* otherwise, check for input from a stream */
    else if (fptr->n_type == LIST) {
	if ((lptr = fptr->n_listvalue) == NULL)
	    ch = EOF;
	else {
	    if (lptr->n_type != LIST ||
		(cptr = lptr->n_listvalue) == NULL || cptr->n_type != INT)
		xlfail("bad stream");
	    ch = cptr->n_int;
	}
    }

    /* otherwise, get the next file character and save it */
    else
	ch = fptr->n_savech = xlgetc(fptr);

    /* return the character */
    return (ch);
}

/* xlputc - put a character to a file or stream */
xlputc(fptr,ch)
  struct node *fptr; int ch;
{
    struct node *oldstk,lptr;

    /* count the character */
    xlfsize++;

    /* check for output to nil */
    if (fptr == NULL)
	;

    /* otherwise, check for output to a stream */
    else if (fptr->n_type == LIST) {
	oldstk = xlsave(&lptr,NULL);
	lptr.n_ptr = newnode(LIST);
	lptr.n_ptr->n_listvalue = newnode(INT);
	lptr.n_ptr->n_listvalue->n_int = ch;
	if (fptr->n_listnext)
	    fptr->n_listnext->n_listnext = lptr.n_ptr;
	else
	    fptr->n_listvalue = lptr.n_ptr;
	fptr->n_listnext = lptr.n_ptr;
	xlstack = oldstk;
    }

    /* otherwise, output the character to a file */
    else
	putc(ch,fptr->n_fp);
}

/* xlflush - flush the input buffer */
int xlflush()
{
    if (!prompt)
	while (xlgetc(s_stdin->n_symvalue) != '\n')
	    ;
}
