
-- SPPRT13SP.TST

-- SPECIFICATION FOR PACKAGE SPPRT13

-- PURPOSE:
--     THIS PACKAGE CONTAINS CONSTANTS OF TYPE SYSTEM.ADDRESS.
--     THESE CONSTANTS ARE USED BY SELECTED CHAPTER 13 TESTS,
--     BY PARTS OF THE AVAT SYSTEM, AND BY ISOLATED TESTS FOR
--     OTHER CHAPTERS.

-- MACRO SUBSTITUTIONS:
--     $VARIABLE_ADDRESS, $VARIABLE_ADDRESS1, AND $VARIABLE_ADDRESS2 ARE
--     EXPRESSIONS YIELDING LEGAL ADDRESSES FOR VARIABLES FOR THIS
--     IMPLEMENTATION.

--     $ENTRY_ADDRESS, $ENTRY_ADDRESS1, AND $ENTRY_ADDRESS2 ARE
--     EXPRESSIONS YIELDING LEGAL ADDRESSES FOR TASK ENTRIES
--     (I.E., FOR INTERRUPTS) FOR THIS IMPLEMENTATION.

--     IF NO EXPRESSIONS CAN BE GIVEN THAT ARE SATISFACTORY FOR THE
--     VALUES OF THESE CONSTANTS, THEN DECLARE SUITABLE FUNCTIONS
--     IN THE SPECIFICATION OF PACKAGE FCNDECL, CREATE A PACKAGE BODY
--     CONTAINING BODIES FOR THE FUNCTIONS, AND REPLACE THE MACROS WITH
--     APPROPRIATE FUNCTION CALLS.

WITH FCNDECL; USE FCNDECL;
WITH SYSTEM;
PACKAGE SPPRT13 IS

	VARIABLE_ADDRESS  : CONSTANT SYSTEM.ADDRESS := FCNDECL.VARIABLE_ADDRESS;
	VARIABLE_ADDRESS1 : CONSTANT SYSTEM.ADDRESS := FCNDECL.VARIABLE_ADDRESS;
	VARIABLE_ADDRESS2 : CONSTANT SYSTEM.ADDRESS := FCNDECL.VARIABLE_ADDRESS;

	ENTRY_ADDRESS  : CONSTANT SYSTEM.ADDRESS := FCNDECL.ENTRY_ADDRESS;
	ENTRY_ADDRESS1 : CONSTANT SYSTEM.ADDRESS := FCNDECL.ENTRY_ADDRESS;
	ENTRY_ADDRESS2 : CONSTANT SYSTEM.ADDRESS := FCNDECL.ENTRY_ADDRESS;

END SPPRT13;
