#include "macros.h"

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#include <assert.h>
#include <stdio.h>

#include "db_common.h"
#include "db_export.h"
#include "db_records.h"

#define CHILD_SIZE 4
#define CUM_SIZE1 5
#define CUM_SIZE2 4

#define IS_COMPOUND(buffer) ((*((unsigned char *)(buffer+type_byte-1)))>=128)
#define GET_CHILD(buffer,i) (buffer+dbix_ch_start+((i)-1)*4-1)

#define GET_CUM_C(buffer,i) (buffer+dbix_cum_start+((i)-1)*5-1)
#define GET_CUM_NC(buffer,i) (buffer+dbnc_cum_start+((i)-1)*5-1)
#define GET_CUM(buffer,i) ((IS_COMPOUND(buffer)) \
			? (GET_CUM_C(buffer,i)) : (GET_CUM_NC(buffer,i)))

#define GET_CUM2_C(buffer,i) (buffer+dbix_cum2_start+((i)-1)*4-1)
#define GET_CUM2_NC(buffer,i) (buffer+dbnc_cum2_start+((i)-1)*4-1)

#define GET_CUM2(buffer,i) ((IS_COMPOUND(buffer)) \
			? (GET_CUM2_C(buffer,i)) : (GET_CUM2_NC(buffer,i)))

#define GET_CHILDREN(buffer) (buffer+dbix_ch_start-1)

#define GET_CUMS_C(buffer) (buffer+dbix_cum_start-1)
#define GET_CUMS_NC(buffer) (buffer+dbnc_cum_start-1)
#define GET_CUMS(buffer) ((IS_COMPOUND(buffer)) \
			? (GET_CUMS_C(buffer)) : (GET_CUMS_NC(buffer)))

#define GET_CUMS2_C(buffer) (buffer+dbix_cum2_start-1)
#define GET_CUMS2_NC(buffer) (buffer+dbnc_cum2_start-1)
#define GET_CUMS2(buffer) ((IS_COMPOUND(buffer)) \
			? (GET_CUMS2_C(buffer)) : (GET_CUMS2_NC(buffer)))

#define GET_NEXT_CHILD(r) (r+4)
#define GET_NEXT_CUM(r) (r+5)
#define GET_NEXT_CUM2(r) (r+4)

#define GET_PREV_CHILD(r) (r-4)
#define GET_PREV_CUM(r) (r-5)
#define GET_PREV_CUM2(r) (r-4)

#define NEXT_CHILD(r) (r=r+4)
#define NEXT_CUM(r) (r=r+5)
#define NEXT_CUM2(r) (r=r+4)

#define PREV_CHILD(r) (r=r-4)
#define PREV_CUM(r) (r=r-5)
#define PREV_CUM2(r) (r=r-4)

#define VOC(t,k) (str_to_rec(GET_CHILD((t),(k))))
#define SET_VOC(t,k,rec) rec_to_str(GET_CHILD((t),(k)),(rec))


static void split_node (int32 rec, int k);
static void share_right (int32 rec, int n);
static int pull_from_right (int32 rec, int k);
static int pull_from_left (int32 rec, int k);
static int join_with_left (int32 rec, int k);
static int join_with_right (int32 rec, int k);
static unsigned char tmp_buffer[REC_SIZE];


int32
dbix_create ()
{
  int32 rec;

#ifdef VERBOSE
fprintf(stderr,"dbix_create\n");
#endif
  rec = new_rec ();
  set_type (rec, db_index_node_ncr);
  return rec;

}

long
dbix_get_cum (int32 rec)
{
  unsigned char *buffer, *p;
  long the_cum;
  int nch;

#ifdef VERBOSE
fprintf(stderr,"dbix_get_cum\n");
#endif

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);
  if (nch==0) return 0;

  p = GET_CUM (buffer, nch);
  the_cum = str_to_cum (p);

  return the_cum;
}

int32
dbix_get_cum2 (int32 rec)
{
  unsigned char *buffer, *p;
  int32 the_cum;
  int nch;

#ifdef VERBOSE
fprintf(stderr,"dbix_get_cum2\n");
#endif

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);
  if (nch==0) return 0;

  p = GET_CUM2 (buffer, nch);
  the_cum = str_to_cum2 (p);

  return the_cum;
}

static void
share_right (int32 rec, int k)
{
  int32 ndk, ndkp1, new_r;
  int nchk, nchkp1, numleft, nummov;
  unsigned char *stg;
  unsigned char *buffer;
  int ic;

#ifdef VERBOSE
	printf("SR rec=%d k=%d\n",rec,k);
#endif

  buffer = rec_load (rec);

  ndk = VOC (buffer, k);
  ndkp1 = VOC (buffer, k + 1);
  nchk = NUM_CH (rec_load (ndk));
  nchkp1 = NUM_CH (rec_load (ndkp1));
  numleft = (nchk + nchkp1) / 2;

  if (rec_refcount (ndkp1) > 1)
    {
      new_r = rec_abs_copy (ndkp1);
      rec_incref (ndkp1, -1);
      rec_increfs (new_r, 1);
      ndkp1 = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k + 1, new_r);
      rec_dirtify (rec);
    }
  if (rec_refcount (ndk) > 1)
    {
      new_r = rec_abs_copy (ndk);
      rec_incref (ndk, -1);
      rec_increfs (new_r, 1);
      ndk = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k, new_r);
      rec_dirtify (rec);
    }

  if (numleft > nchk)
    {
      unsigned char *r, *s, *p, *q, *p1, *s1, *t, *u;
      int j, nch;
      long right_cum, moved_cum, total_moved;
      long tt;
      int32 moved_cum2;

      nummov = numleft - nchk;

      bcopy (rec_load (ndkp1), tmp_buffer, REC_SIZE);
      r = tmp_buffer;

      p = GET_CUM2 (r, nummov);
      moved_cum2 = str_to_cum2 (p);

      p = GET_CUM (r, nummov);

      /*
       * Get the cumulant of the last child of the right node that we are
       * moving left 
       */

      moved_cum = str_to_cum (p);

      q = rec_load (ndk);
      ic = IS_COMPOUND(q);
      right_cum = 0;
      s = GET_CUMS (q);
      t = GET_CUMS2 (q);
      s1 = GET_CHILDREN (q);
      if (nchk > 0)
	{
	  s = GET_CUM (q, nchk);
	  right_cum = str_to_cum (s);
	  NEXT_CUM (s);
	  s1 = GET_CHILD (q, nchk + 1);
	  t = GET_CUM2 (q, nchk + 1);
	}

      nch = NUM_CH (q);
      p = GET_CUMS (r);
      u = GET_CUMS2 (r);
      p1 = GET_CHILDREN (r);
      for (j = 1; j <= nummov; j++)
	{
	  cum_to_str (s, (str_to_cum (p) + right_cum));
	  if (ic) rec_to_str (s1, (str_to_rec (p1)));
	  cum2_to_str (t, (str_to_cum2 (u)));
	  NEXT_CUM (s);
	  NEXT_CUM (p);

	  NEXT_CUM2 (t);
	  NEXT_CUM2 (u);

	  NEXT_CHILD (s1);
	  NEXT_CHILD (p1);

	}

      /*
       * Now move the recs and cums of the right node (ndkp1)
       */

      s = GET_CUMS (r);
      t = GET_CUMS2 (r);
      s1 = GET_CHILDREN (r);

      for (j = 1; j <= (nchkp1 - nummov); j++)
	{
	  cum_to_str (s, (str_to_cum (p) - moved_cum));
	  cum2_to_str (t, (str_to_cum2 (u)));
	  if (ic) rec_to_str (s1, (str_to_rec (p1)));

	  NEXT_CUM (s);
	  NEXT_CUM (p);

	  NEXT_CUM2 (t);
	  NEXT_CUM2 (u);

	  NEXT_CHILD (s1);
	  NEXT_CHILD (p1);
	}

      SET_NUM_CH (q, (nch + nummov));
      rec_dirtify (ndk);

      rec_load (ndkp1);
      SET_NUM_CH (tmp_buffer, (nchkp1 - nummov));
      rec_setrecbuf (ndkp1, tmp_buffer, REC_SIZE);

      /*
       * update the cumulant for children k in rec 
       */

      buffer = rec_load (rec);
      p = GET_CUM (buffer, k);
      cum_to_str (p, (str_to_cum (p) + moved_cum));
      p = GET_CUM2 (buffer, k);
      cum2_to_str (p, moved_cum2);

      rec_dirtify (rec);

      return;
    }
  else
    {
      unsigned char *r, *s, *p, *q, *t, *u;
      int j, nch;
      long rem_left_cum, total_moved;
      int32 cum2_to_move;
      long tt;

      nummov = nchk - numleft;

      bcopy (rec_load (ndk), tmp_buffer, REC_SIZE);
      r = tmp_buffer;
      ic = IS_COMPOUND(r);

      t = GET_CUM2 (r, numleft);
      cum2_to_move = str_to_cum2 (t);

      p = GET_CUM (r, numleft);
      rem_left_cum = str_to_cum (p);

      q = GET_NEXT_CUM (p);
      u = GET_NEXT_CUM2 (t);
      for (j = numleft + 1; j <= nchk; j++)
	{
	  NEXT_CUM (p);
	  cum_to_str (p, (tt = (str_to_cum (p) - rem_left_cum)));

	}
      total_moved = str_to_cum (p);

      /*
       * Update ndk 
       */

      SET_NUM_CH (r, numleft);
      rec_setrecbuf (ndk, tmp_buffer, REC_SIZE);

      /*
       * Update rec 
       */

      buffer = rec_load (rec);
      p = GET_CUM (buffer, k);
      cum_to_str (p, (str_to_cum (p) - total_moved));
      p = GET_CUM2 (buffer, k);
      cum2_to_str (p, cum2_to_move);
      rec_dirtify (rec);

      s = rec_load (ndkp1);

      /*
       * move the cums 
       */

      /*
       * p points to the last cum of the right child 
       */

      p = GET_CUM (s, nchkp1);
      t = GET_CUM2 (s, nchkp1);

      /*
       * while we move the cums to make space for the left stuff, we can
       * update the values 
       */

      for (j = 1; j <= nchkp1; j++)
	{
	  cum_to_str (p + (CUM_SIZE1 * nummov), (str_to_cum (p) + total_moved));
	  cum2_to_str (t + (CUM_SIZE2 * nummov), (str_to_cum2 (t)));
	  PREV_CUM (p);
	  PREV_CUM2 (t);
	}
      bcopy (q, GET_CUMS (s), nummov * CUM_SIZE1);
      bcopy (u, GET_CUMS2 (s), nummov * CUM_SIZE2);

      /*
       * Copy the children 
       */

      nch = NUM_CH (s);
      if (ic) {
      if (nch > 0)
	{
	  p = GET_CHILD (s, nch + 1) - 1;
	  /*
	   * * point to the last byte of the last ch * pointer  
	   */
	  r = p + CHILD_SIZE * nummov;
	  for (j = 1; j <= CHILD_SIZE * nch; j++)
	    {
	      *r-- = *p--;
	    }
	}

      p = GET_CHILDREN (s);
      r = GET_CHILD (tmp_buffer, numleft + 1);
      bcopy (r, p, nummov * CHILD_SIZE);
      }
      SET_NUM_CH (s, nch + nummov);
      rec_dirtify (ndkp1);

    }

}

long
dbix_comp_cum (int32 rec, long t, int flag, long *cum,int32 *cum2,int srch)
{
  unsigned char *buffer, *p,*q;
  int j, n_ch;
  long l, the_cum, prev_cum, retcum;
  long result;
  int32 m,the_cum2,retcum2;

#ifdef VERBOSE
fprintf(stdout,"comp_cum rec=%d t=%ld flag=%d srch=%d\n",rec,t,flag,srch);
#endif

  buffer = rec_load (rec);
  if (flag == 1)
    {
      j = NUM_CH (buffer);
      assert (j > 0);
      p = GET_CUM2 (buffer, j);
      the_cum2 = str_to_cum2 (p);
      p = GET_CUM (buffer, j);
      the_cum = str_to_cum (p);
      prev_cum = 0;
      if (j > 1)
	prev_cum = str_to_cum (GET_PREV_CUM (p));
    }
  else
    {
      p = GET_CUMS (buffer);
      q = GET_CUMS2 (buffer);
      prev_cum = 0;
      n_ch = NUM_CH (buffer);
      if (srch==1) {
         j = 1;
         while ((j <= n_ch) && (t > (l = str_to_cum (p))))
	   {
	     j++;
	     NEXT_CUM (p);
	     NEXT_CUM2 (q);
	     prev_cum = l;
   	   }
         if (j > n_ch)
   	   {
	     return -1;
   	   }
         the_cum = l;
         the_cum2 = str_to_cum2(q);
      } else {
         j = 1;
         l=str_to_cum(p);
         while ((j <= n_ch) && (t > (m = str_to_cum2 (q))))
	   {
	     j++;
	     l=str_to_cum(p);
	     NEXT_CUM (p);
	     NEXT_CUM2 (q);
	     prev_cum = l;
   	   }
         if (j > n_ch)
	   {
	     return -1;
	   }
         the_cum = str_to_cum(p);
         the_cum2 = m;
     }
    }
  if (j == 1)
    prev_cum = 0;

  
  if (!is_compound (buffer))
    {
      *cum = the_cum;
      *cum2 = the_cum2;
      return (the_cum - prev_cum);

    }
  else
    {
      if ((srch==2)||(flag==1)) {
         result = dbix_comp_cum (str_to_rec (GET_CHILD (buffer, j)),
			    (t), flag, &retcum,&retcum2,srch);
      } else {
         result = dbix_comp_cum (str_to_rec (GET_CHILD (buffer, j)),
			    (t - prev_cum), flag, &retcum,&retcum2,srch);
      }
      *cum = (retcum + prev_cum);
      *cum2 = (retcum2);
      return result;
    }

}

static void
split_node (int32 rec, int k)
{
  unsigned char *buffer, *p, *t;
  int nch, i, ic;
  int32 newrec;
  int32 first_ch;

  newrec = new_rec ();

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  /*
   * Copy the previous cum 
   */

  p = GET_CUM (buffer, nch + 2) - 1;
  for (i = 1; i <= CUM_SIZE1 * (nch - k + 1); i++)
    {
      *p = *(GET_PREV_CUM (p));
      p--;
    }

  t = GET_CUM2 (buffer, nch + 2) - 1;
  for (i = 1; i <= CUM_SIZE2 * (nch - k + 1); i++)
    {
      *t = *(GET_PREV_CUM2 (t));
      t--;
    }


  /*
   * Do the same for the child pointers 
   */

  p = GET_CHILD (buffer, nch + 2) - 1;
  for (i = 1; i <= CHILD_SIZE * (nch - k + 1); i++)
    {
      *p = *(GET_PREV_CHILD (p));
      p--;
    }
  p++;
  rec_to_str (p, newrec);

  p = GET_CHILDREN (buffer);
  first_ch = str_to_rec (p);

  SET_NUM_CH (buffer, nch + 1);
  rec_dirtify (rec);

  if (rec_is_compound (first_ch))
    set_type (newrec, db_index_node_record);
  else
    set_type (newrec, db_index_node_ncr);

  share_right (rec, k);

}

static int
pull_from_left (int32 rec, int k)
{
  unsigned char *buffer, *p;
  int32 newrec, child;
  if (k == 1)
    return FALSE;

  buffer = rec_load (rec);

  p = GET_CHILD (buffer, k - 1);
  child = str_to_rec (p);
  buffer = rec_load (child);

  if (NUM_CH (buffer) <= dbix_low_lim)
    return FALSE;

  share_right (rec, k - 1);
  return TRUE;
}

static int
pull_from_right (int32 rec, int k)
{
  unsigned char *buffer, *p;
  int32 newrec, child;

  buffer = rec_load (rec);

  if (k >= NUM_CH (buffer))
    return FALSE;

  p = GET_CHILD (buffer, k + 1);
  child = str_to_rec (p);
  buffer = rec_load (child);

  if (NUM_CH (buffer) <= dbix_low_lim)
    return FALSE;

  share_right (rec, k);
  return TRUE;
}

static int
join_with_left (int32 rec, int k)
{
  unsigned char *buffer, *p, *q, *r,*s;
  int32 new_r, ndk, ndkm1;
  int nch, nchtocopy, i;
  long last_left_cum;
  int ic;

  if (k == 1)
    return FALSE;

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  ndk = VOC (buffer, k);
  ndkm1 = VOC (buffer, k - 1);

  if (rec_refcount (ndkm1) > 1)
    {
      new_r = rec_abs_copy (ndkm1);
      rec_incref (ndkm1, -1);
      rec_increfs (new_r, 1);
      ndkm1 = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k - 1, new_r);
      rec_dirtify (rec);
    }

  p = GET_CUM (buffer, k - 1);
  r = GET_CUM2 (buffer, k - 1);
  /*
   * Points to cum k-1 
   */

  for (i = 1; i <= CUM_SIZE1 * (nch - k + 1); i++)
    {
      *p = *(GET_NEXT_CUM (p));
      p++;
      r++;
    }

  for (i = 1; i <= CUM_SIZE2 * (nch - k + 1); i++)
    {
      *r = *(GET_NEXT_CUM2 (r));
      r++;
    }

  SET_NUM_CH (buffer, nch - 1);
  rec_dirtify (rec);

  /*
   * Done with rec... 
   */

  bcopy (buffer = rec_load (ndk), tmp_buffer, REC_SIZE);
  nchtocopy = NUM_CH (buffer);
  SET_NUM_CH (buffer, 0);
  rec_dirtify (ndk);
  rec_incref (ndk, -1);

  buffer = rec_load (ndkm1);
  ic = IS_COMPOUND(buffer);
  nch = NUM_CH (buffer);
  p = GET_CUM (buffer, nch);
  r = GET_CUM2 (buffer, nch);
  last_left_cum = str_to_cum (p);

  q = GET_CUMS (tmp_buffer);
  s = GET_CUMS2 (tmp_buffer);
  NEXT_CUM (p);
  NEXT_CUM2 (r);
  for (i = 1; i <= nchtocopy; i++)
    {
      cum_to_str (p, (str_to_cum (q) + last_left_cum));
      cum2_to_str (r, (str_to_cum2 (s)));
      NEXT_CUM (p); NEXT_CUM (q);
      NEXT_CUM2 (r); NEXT_CUM2 (s);
    }

  if (ic) {
     p = GET_CHILD (buffer, nch + 1);
     bcopy (GET_CHILDREN (tmp_buffer), p, nchtocopy * CHILD_SIZE);
  }
  SET_NUM_CH (buffer, nch + nchtocopy);

  rec_dirtify (ndkm1);

  return TRUE;

}

static int
join_with_right (int32 rec, int k)
{
  unsigned char *buffer, *p, *q, *r, *s;
  int32 new_r, ndk, ndkp1;
  int nch, nchtocopy, i;
  long last_left_cum;
  int ic;

  buffer = rec_load (rec);

  if (k >= NUM_CH (buffer))
    return FALSE;

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  ndk = VOC (buffer, k);
  ndkp1 = VOC (buffer, k + 1);

  if (rec_refcount (ndkp1) > 1)
    {
      new_r = rec_abs_copy (ndkp1);
      rec_incref (ndkp1, -1);
      rec_increfs (new_r, 1);
      ndkp1 = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k + 1, new_r);
      rec_dirtify (rec);
    }

  p = GET_CUM (buffer, k);
  r = GET_CUM2 (buffer, k);
  /*
   * Points to cum k 
   */

  last_left_cum = str_to_cum (p);

  for (i = 1; i <= CUM_SIZE1 * (nch - k); i++)
    {
      *p = *(GET_NEXT_CUM (p));
      p++;
    }

  for (i = 1; i <= CUM_SIZE2 * (nch - k); i++)
    {
      *r = *(GET_NEXT_CUM2 (r));
      r++;
    }

  p = GET_CHILD (buffer, k);
  /*
   * Points to ch k 
   */

  for (i = 1; i <= CHILD_SIZE * (nch - k); i++)
    {
      *p = *(GET_NEXT_CHILD (p));
      p++;
    }

  SET_NUM_CH (buffer, nch - 1);
  rec_dirtify (rec);

  /*
   * Done with rec... 
   */

  bcopy (buffer = rec_load (ndk), tmp_buffer, REC_SIZE);
  nch = NUM_CH (buffer);
  SET_NUM_CH (buffer, 0);
  rec_dirtify (ndk);
  rec_incref (ndk, -1);

  buffer = rec_load (ndkp1);
  ic = IS_COMPOUND(buffer);
  nchtocopy = NUM_CH (buffer);

  p = GET_CUMS (buffer);
  r = GET_CUMS2 (buffer);
  q = GET_CUM (tmp_buffer, nch + 1);
  s = GET_CUM2 (tmp_buffer, nch + 1);

  for (i = 1; i <= nchtocopy; i++)
    {
      cum_to_str (q, (str_to_cum (p) + last_left_cum));
      cum2_to_str(s, str_to_cum2 (r));
      NEXT_CUM (p); NEXT_CUM (q);
      NEXT_CUM2 (r); NEXT_CUM2 (s);
    }

  if (ic) {
     p = GET_CHILD (tmp_buffer, nch + 1);
     bcopy (GET_CHILDREN (buffer), p, nchtocopy * CHILD_SIZE);
  }
  SET_NUM_CH (tmp_buffer, nch + nchtocopy);

  rec_setrecbuf (ndkp1, tmp_buffer, REC_SIZE);

  return TRUE;

}

static void
update_cums (int32 rec, int k, long cum)
{
  unsigned char *buffer, *p;
  int nch, ic, i;
  int32 ch;

  buffer=rec_load (rec);
  nch = NUM_CH (buffer);
  ic = is_compound (buffer);
  
  p = GET_CUM(buffer,k);
  for (i = k; i <= nch; i++)
    {
      cum_to_str(p,str_to_cum(p)+cum);
      NEXT_CUM (p);
    }
  rec_dirtify(rec);

}

int32
dbix_make_from_tuple (unsigned char *recs,
		     unsigned char *cums, unsigned char *cums2, int count)
{
  int32 rec;
  unsigned char *buffer, *p, *s, *q,*r,*t;
  long cum;
  int32 cum2;
  int i, compound_now;
  int newcount;

  if (count <= dbix_hi_lim)
    {
      rec = new_rec ();
      buffer = rec_load (rec);
      set_type (rec, wdoccs_str_node_ncr);
      bcopy (recs, GET_CHILDREN (buffer), count * CHILD_SIZE);

      /*
       * Now do the cums 
       */

      p = GET_CUMS (buffer); s = cums;
      r = GET_CUMS2 (buffer); t = cums2;

      cum = 0;
      for (i = 1; i <= count; i++)
	{
	  cum += str_to_cum (s);
	  cum_to_str (p, cum);
	  NEXT_CUM (s);
	  NEXT_CUM (p);
	
	  cum2_to_str(r,str_to_cum2(t));
	  NEXT_CUM2 (t);
	  NEXT_CUM2 (r);
	}

      SET_NUM_CH (buffer, count);
      rec_dirtify (rec);
      return rec;

    }

  compound_now = FALSE;
  while (count > dbix_hi_lim)
    {
      int last;
      unsigned char *pcum;
      unsigned char *pcum2;
      unsigned char *pch;

      p = recs;
      s = cums;
      t = cums2;
      pcum = cums;
      pcum2 = cums2;
      pch = recs;
      newcount = 0;
      last = FALSE;
      while (count > 0)
	{
	  int k;
	  int32 section;

	  if (((count - dbix_hi_lim) == 0) || (last) ||
	      ((count - dbix_hi_lim) >= dbix_low_lim))
	    {
	      if (last)
		k = count;
	      else
		k = dbix_hi_lim;
	    }
	  else
	    {
	      last = TRUE;
	      k = count / 2;
	    }
	  section = new_rec ();

	  if (compound_now)
	    set_type (section, wdoccs_str_node_record);
	  else
	    set_type (section, wdoccs_str_node_ncr);

	  buffer = rec_load (section);
	  bcopy (p, GET_CHILDREN (buffer), k * CHILD_SIZE);
	  p += k * CHILD_SIZE;

	  /*
	   * Now do the cums 
	   */

	  q = GET_CUMS (buffer);
          r = GET_CUMS2 (buffer); 
	  cum = 0; 
	  for (i = 1; i <= k; i++)
	    {
	      cum += str_to_cum (s);
	      cum_to_str (q, cum);
	      NEXT_CUM (s);
	      NEXT_CUM (q);

	      bcopy(t,r,CUM_SIZE2);
	      cum2=str_to_cum2(t);
	      NEXT_CUM2 (t);
	      NEXT_CUM2 (r);
	    }

	  SET_NUM_CH (buffer, k);
	  rec_dirtify (section);

	  /*
	   * Now store record & cum for the next level 
	   */

	  cum_to_str (pcum, cum);
	  cum2_to_str (pcum2, cum2);
	  rec_to_str (pch, section);
	  NEXT_CUM (pcum);
	  NEXT_CUM2 (pcum2);
	  NEXT_CHILD (pch);

	  newcount++;
	  count -= k;
	  if ((count<dbix_hi_lim)&&(count>=dbix_low_lim)) 
		last=TRUE;
	}
      count = newcount;
      compound_now = TRUE;

    }

  rec = new_rec ();
  buffer = rec_load (rec);
  set_type (rec, wdoccs_str_node_record);
  bcopy (recs, GET_CHILDREN (buffer), count * CHILD_SIZE);

  /*
   * Now do the cums 
   */

  p = GET_CUMS (buffer);
  s = cums;
  cum = 0;
  for (i = 1; i <= count; i++)
    {
      cum += str_to_cum (s);
      cum_to_str (p, cum);
      NEXT_CUM (s);
      NEXT_CUM (p);
    }

  bcopy (cums2, GET_CUMS2 (buffer), count * CUM_SIZE2);

  SET_NUM_CH (buffer, count);
  rec_dirtify (rec);
  return rec;

}

int32
dbix_set_comp (int32 rec, long t, int flag, int32 x1,long x2,int srch)
{
  unsigned char *buffer, *p, *q;
  int i, j, n_ch;
  long l, the_cum, prev_cum, old_cum;
  int ic;
  int32 the_cum2,the_ch, recno, new_r,m;

#ifdef VERBOSE
  printf("SET_COMP rec=%d, t=%ld, flag=%d,   x1=%d x2=%ld,   srch=%d\n",
		rec,t,flag,x1,x2,srch);
#endif
  if (rec_refcount (rec) > 1)
    {
      new_r = rec_abs_copy (rec);
      rec_increfs (new_r, 1);
      rec_incref (rec, -1);
      rec = new_r;
      rec_dirtify (rec);
    }

  buffer = rec_load (rec);
  ic = is_compound (buffer);
  if (flag == 1)
    {
      j = n_ch = NUM_CH (buffer);
      assert (j > 0); /* Deletion or change @ end of empty tree */
      p = GET_CUM (buffer, j);
      the_cum = str_to_cum (p);
      q = GET_CUM2 (buffer, j);
      the_cum2 = str_to_cum2 (q);
      if (srch==1) t = the_cum; else t=the_cum2;
      prev_cum = 0;
      if (j > 1) 
 	 prev_cum = str_to_cum (GET_PREV_CUM (p));
    }
  else
    {
      p = GET_CUMS (buffer);
      q = GET_CUMS2 (buffer);
      prev_cum = 0;
      n_ch = NUM_CH (buffer);
      j = 1;
      if (srch==1) {
      while ((j <= n_ch) && (t > (l = str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	  NEXT_CUM2 (q);
	  prev_cum = l;
	}
      } else {
      l=str_to_cum(p);
      while ((j <= n_ch) && (t > (m = str_to_cum2 (q))))
	{
	  j++;
	  prev_cum = l;
	  NEXT_CUM (p);
	  NEXT_CUM2 (q);
	  l=str_to_cum(p);
	}
      }
      if (j > n_ch)
	{
        assert (n_ch > 0); /* Deletion or change @ end of empty tree */
#ifdef VERBOSE
	  printf ("Search index %ld out of range in rec %d \n", t, rec);
#endif
	  j=n_ch;
	  PREV_CUM(p);
	  PREV_CUM2(q);
	  l = str_to_cum(p);
	  m = str_to_cum2(q);
	  PREV_CUM(p);
	  prev_cum = str_to_cum(p);
	}
      the_cum = l;
    }
  if (j == 1)
    prev_cum = 0;

  p = GET_CHILD (buffer, j);
  the_ch = str_to_rec (p);

  old_cum = the_cum - prev_cum;

  buffer = rec_load (rec);
  p = GET_CHILD (buffer, j);

  /*
   * Deletion 
   */
  if (x1 == 0)
    {
      if (!(ic))
	{
	  buffer = rec_load (rec);
          if (n_ch>0) {
	  p = GET_CUM (buffer, j);
	  for (i = 1; i <= CUM_SIZE1 * (n_ch - j); i++)
	    {
	      *p = *(GET_NEXT_CUM (p));
	      p++;
	    }
	  q = GET_CUM2 (buffer, j);
	  for (i = 1; i <= CUM_SIZE2 * (n_ch - j); i++)
	    {
	      *q = *(GET_NEXT_CUM2 (q));
	      q++;
	    }
	  }
	  SET_NUM_CH (buffer, n_ch - 1);
	  rec_dirtify (rec);
	  update_cums (rec, j, -old_cum);

	}
      else
	{

	  long old_ch_leafsum;
	  long new_ch_leafsum;
	  int32 old_rec;
	  int32 child_cum2;
	  int32 the_child;
	  unsigned char tmp_buffer[REC_SIZE];

	  old_ch_leafsum = dbix_get_cum (the_ch);
	  if (srch==1) 
	     the_ch = dbix_set_comp (the_ch, (t - prev_cum), 0, 0,0,srch);
          else 
	     the_ch = dbix_set_comp (the_ch, (t), 0, 0,0,srch);

	  new_ch_leafsum = dbix_get_cum (the_ch);
	  if (j==n_ch) child_cum2 = dbix_get_cum2(the_ch);
	  buffer = rec_load (rec);
	  p = GET_CHILD (buffer, j);
	  rec_to_str (p, the_ch);
	  if (j==n_ch) {
		q = GET_CUM2(buffer,j);	
	 	cum2_to_str(q,child_cum2);
	  }
	  rec_dirtify (rec);
	  update_cums (rec, j, (new_ch_leafsum - old_ch_leafsum));
	  

	  buffer = rec_load (the_ch);
	  if (NUM_CH (buffer) >= dbix_low_lim)
	    return rec;
	  if ((pull_from_left (rec, j)) || (pull_from_right (rec, j)))
	    return rec;
	  if ((!join_with_left (rec, j)) && (!join_with_right (rec, j)))
	    assert (FALSE);
	  buffer = rec_load (rec);

	  if (NUM_CH (buffer) > 1)
	    return rec;

	  the_child = VOC(buffer,1);
	  bcopy(rec_load(the_child),tmp_buffer,REC_SIZE);
	  buffer = rec_load(rec);
  	  rec_setrecbuf (rec, tmp_buffer, REC_SIZE);
	  
	  buffer=rec_load(the_child);
	  if (IS_COMPOUND(buffer)) {
		SET_NUM_CH(buffer,0);
	  	rec_dirtify(the_child);
	  }
	  rec_incref (the_child, -1);
	}
      return rec;
    }
  else
    {

      /*
       * Insertion 
       */
      if (!ic)
	{
	  int32 old_x;
	  long cum_change;

          p = GET_CUM2(buffer,j);
	  cum2_to_str(p,x1);
	  rec_dirtify (rec);

	  cum_change = x2  - old_cum;
	  update_cums (rec, j, cum_change);
	  return rec;

	}
      else
	{
	  long cum_change;
	  int32 child_cum2;

	  if (srch==1)
 	     the_ch = dbix_set_comp (the_ch, (t - prev_cum), 0, x1,x2,1);
	  else
 	     the_ch = dbix_set_comp (the_ch, t, 0, x1,x2,2);

	  cum_change = dbix_get_cum (the_ch) - old_cum;
	  if (j==n_ch) child_cum2 = dbix_get_cum2(the_ch);
	  buffer = rec_load (rec);
	  p = GET_CHILD (buffer, j);
	  rec_to_str (p, the_ch);
	  if (j==n_ch) {
		q = GET_CUM2(buffer,j);	
	 	cum2_to_str(q,child_cum2);
	  }
	  rec_dirtify (rec);
	  update_cums (rec, j, cum_change);
	  return rec;

	}

      return EMPTY;

    }
}

static void
split_in_two (int32 rec)
{
  unsigned char *buffer, *p, *q, *r;
  unsigned char split_buffer[REC_SIZE];
  int32 newrec,n1;
  unsigned char the_type;
  int nch, t, i,ic;
  long cum, cum_last;
  int32 cum2_last,cum2;

  bcopy (rec_load (rec), split_buffer, REC_SIZE);
  nch = NUM_CH (split_buffer);
  if (ic=is_compound (split_buffer))
    the_type = db_index_node_record;
  else
    the_type = db_index_node_ncr;

  newrec = new_rec ();
  set_type (newrec, the_type);
  buffer = rec_load (newrec);
  t = nch / 2;
  r = GET_CUM2 (split_buffer, t);
  cum2_last = str_to_cum2 (r);
  p = GET_CUM (split_buffer, t);
  cum_last = str_to_cum (p);
  bcopy (GET_CUMS (split_buffer), GET_CUMS (buffer), CUM_SIZE1 * t);
  bcopy (GET_CUMS2 (split_buffer), GET_CUMS2 (buffer), CUM_SIZE2 * t);
  if (ic)
     bcopy (GET_CHILDREN (split_buffer), GET_CHILDREN (buffer), CHILD_SIZE * t);
  SET_NUM_CH (buffer, t);
  rec_dirtify (newrec);
  n1 = newrec;


  nch = nch - t;
  newrec = new_rec ();
  set_type (newrec, the_type);
  buffer = rec_load (newrec);
  bcopy (GET_CUM2 (split_buffer, t + 1),
	 GET_CUMS2 (buffer),
	 CUM_SIZE2 * nch);
  bcopy (GET_CUM (split_buffer, t + 1),
	 GET_CUMS (buffer),
	 CUM_SIZE1 * nch);
  if (ic) bcopy (GET_CHILD (split_buffer, t + 1),
	         GET_CHILDREN (buffer),
	         CHILD_SIZE * nch);

  p = GET_CUMS (buffer);
  r = GET_CUMS2 (buffer);
  for (i = 1; i <= nch; i++)
    {
      cum2 = str_to_cum2 (r);
      cum = str_to_cum (p);
      cum_to_str (p, cum - cum_last);
      NEXT_CUM (p);
      NEXT_CUM2 (r);
    }
  SET_NUM_CH (buffer, nch);
  rec_dirtify (newrec);

  set_is_compound (rec, TRUE);

  buffer = rec_load(rec);
  SET_NUM_CH (buffer, 2);
  cum_to_str (GET_CUMS (buffer), cum_last);
  cum2_to_str (GET_CUMS2 (buffer), cum2_last);
  rec_to_str (GET_CHILDREN (buffer), n1);

  cum_to_str (GET_CUM (buffer, 2), cum);
  cum2_to_str (GET_CUM2 (buffer, 2), cum2);
  rec_to_str (GET_CHILD (buffer, 2), newrec);
  rec_dirtify (rec);

}

int32
dbix_insert (int32 rec, long t, int flag, int32 x,long x2,int srch)
{
  unsigned char *buffer, *p, *q;
  int i, j, n_ch;
  long l, the_cum, prev_cum, last_cum, x_cum;
  int ic;
  int32 the_ch, recno, new_r,x_cum2,m;


  if (rec_refcount (rec) > 1)
    {
      new_r = rec_abs_copy (rec);
      rec_increfs (new_r, 1);
      rec_incref (rec, -1);
      rec = new_r;
      rec_dirtify (rec);
    }

  x_cum2 = x;
  x_cum = x2;

  buffer = rec_load (rec);
  last_cum = dbix_get_cum (rec);
  ic = is_compound (buffer);


  buffer = rec_load (rec);

  if (flag == 1)
    {
      n_ch = NUM_CH (buffer);
      j = 0;
      the_cum = prev_cum = 0;
    }
  else
    {
      p = GET_CUMS (buffer);
      q = GET_CUMS (buffer);
      prev_cum = 0;
      n_ch = NUM_CH (buffer);
      j = 1;
      if (srch==1) {
      while ((j <= n_ch) && (t > (l = str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	  NEXT_CUM2 (q);
	  prev_cum = l;
	}
      } else {
      l = str_to_cum(p);
      while ((j <= n_ch) && (t > (m = str_to_cum2 (q))))
	{
	  j++;
	  prev_cum = l;
	  NEXT_CUM (p);
	  NEXT_CUM2 (q);
          l = str_to_cum(p);
	}
      }
      if (j > n_ch)
	{
	  j = 0;
	}
      else
	{
	  the_cum = l;
	}
    }

  if (j == 0)
    {
      if (!ic)
	{
	  p = GET_CUM (buffer, n_ch + 1);
	  cum_to_str (p, last_cum + x_cum);
	  q = GET_CUM2 (buffer, n_ch + 1);
	  cum2_to_str (q, x_cum2);
	  n_ch++;
	  SET_NUM_CH (buffer, n_ch);
	  rec_dirtify (rec);
	  if (n_ch > dbnc_hi_lim)
	    {
	      split_in_two (rec);
	    }
	  return rec;

	}
      else
	{			/*
				 * is compound 
				 */
	  int32 last_child;

	  p = GET_CHILD (buffer, n_ch);
	  last_child = str_to_rec (p);
	  last_child = dbix_insert (last_child, 0, 1, x,x2,srch);
	  buffer = rec_load (rec);
	  p = GET_CHILD (buffer, n_ch);
	  rec_to_str (p, last_child);
	  p = GET_CUM (buffer, n_ch);
	  cum_to_str (p, last_cum + x_cum);
	  p = GET_CUM2 (buffer, n_ch);
	  cum2_to_str (p, x_cum2);

	  rec_dirtify (rec);

	  p = rec_load (last_child);
	  if (is_compound(p)) {
	     if (NUM_CH (p) < (dbix_hi_lim ))
	        return rec;

          } else {
	     if (NUM_CH (p) < (dbnc_hi_lim ))
	        return rec;
	  }

	  split_node (rec, n_ch);
	  buffer = rec_load (rec);
	  if ((NUM_CH (buffer) <= dbix_hi_lim))
	    return rec;

	  split_in_two (rec);
	  return rec;

	}

    }
  if (!ic)
    {

      p = GET_CUM (buffer, n_ch + 2) - 1;
      for (i = 1; i <= CUM_SIZE1 * (n_ch - j + 1); i++)
	{
	  *p = *(GET_PREV_CUM (p));
	  p--;
	}
      p = GET_CUM (buffer, j);

      q = GET_CUM2 (buffer, n_ch + 2) - 1;
      for (i = 1; i <= CUM_SIZE2 * (n_ch - j + 1); i++)
	{
	  *q = *(GET_PREV_CUM2 (q));
	  q--;
	}

      q = GET_CUM2 (buffer, j);
      cum2_to_str(q,x_cum2); 

      /*
       *  p Points to cum j 
       */

      if (j == 1)
	cum_to_str (p, 0);
      else
	cum_to_str (p, str_to_cum (GET_PREV_CUM (p)));


/*
      p = GET_CHILD (buffer, n_ch + 2) - 1;

      for (i = 1; i <= CHILD_SIZE * (n_ch - j + 1); i++)
	{
	  *p = *(GET_PREV_CHILD (p));
	  p--;
	}

      p = GET_CHILD (buffer, j);

      rec_to_str (p, x);
*/

      n_ch++;
      SET_NUM_CH (buffer, n_ch);
      rec_dirtify (rec);
      update_cums (rec, j, x_cum);
      buffer = rec_load (rec);

      if (n_ch > dbnc_hi_lim)
	{
	  split_in_two (rec);
	}
      return rec;

    }
  else
    {				/*
				 * is compound 
				 */
      int32 child;
      int32 child_cum2;

      p = GET_CHILD (buffer, j);
      child = str_to_rec (p);
      if (srch==1)
         child = dbix_insert (child, (t - prev_cum), 0, x,x2,srch);
      else
         child = dbix_insert (child, (t), 0, x,x2,srch);

      child_cum2 = dbix_get_cum2(child);
      
      buffer = rec_load (rec);
      p = GET_CHILD (buffer, j);
      rec_to_str (p, child);
      rec_dirtify (rec);
      update_cums (rec, j, x_cum);
      buffer = rec_load(rec);
      p = GET_CUM2( buffer,j);
      cum2_to_str(p,child_cum2);

      p = rec_load (child);
      if (is_compound(p)) {
         if (NUM_CH (p) < (dbix_hi_lim ))
            return rec;

      } else {
         if (NUM_CH (p) < (dbnc_hi_lim ))
            return rec;
      }

      split_node (rec, j);
      buffer = rec_load (rec);
      if ((NUM_CH (buffer) <= dbix_hi_lim))
	return rec;

      split_in_two (rec);
      return rec;

    }

}

int32
dbix_first_past_to(int32 rec, int32 t, int32 fi,int32 la, int32 *w,int32 *pos)
{
  unsigned char *buffer, *p,*q;
  int j, n_ch;
  long l,the_cum, prev_cum, retcum;
  int32 recno;
  int32 m,the_cum2;
  int wl,ixbeg,ixend;
  int32 retw;
  int retpos;

  buffer = rec_load (rec);
  wl = wo_length(rec);
  if (GET_TYPE(buffer)==wdoccs_string_record) {
	/* search directly */
    
      if (wl<la) la=wl;

      j = fi;
      while ((j <= la) && (t > (m = str_to_cum2 (p))))
	{
	  j++;
	  NEXT_CUM2 (p);
	}
      if (j >la)
	{
	  return EMPTY;
	}
	
      *w = l;
      *pos = j;
      return rec;

	
  }
/*
      n_ch = NUM_CH (buffer);
      p = GET_CUMS (buffer);
      j = 1;
      while ((j <= n_ch) && (fi < (l = str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	  prev_cum = l;
	}
      if (j > n_ch)
	{
	  fprintf("INDICATED STARTING POINT NOT PRESENT!\n");
	  assert(FALSE);
	} else ixbeg=j;
      j = ixbeg;
      while ((j <= n_ch) && (la < (str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	}
      if (j > n_ch)
	{
	  fprintf("INDICATED ENDING POINT NOT PRESENT!\n");
	  assert(FALSE);
	} else ixend = j;

      if (ixbeg==ixend) {
	 p = GET_CHILD(buffer,ixbeg);
         
	 j = dbix_first_past_to(str_to_rec(p),t,fi-prev_cum,la-prev_cum,
		&retw,&retpos);
	 if (j==EMTPY) return EMPTY;
	 *w=retw;
         *pos=prev_cum+retpos;
	 return rec;

      }
      buffer = rec_load(rec);
      p = GET_CHILD(buffer,ixbeg);
         
      j = dbix_first_past_to(str_to_rec(p),t,fi-prev_cum,l-prev_cum,
		&retw,&retpos);

      if (j!=EMPTY) {
	 *w=retw;
         *pos=prev_cum+retpos;
	 return rec;
      }
   assert(FALSE);

/ *
      buffer=rec_load(rec);



      the_cum = l;
      the_cum2 = str_to_cum2(q);
      } else {
      j = 1;
      while ((j <= n_ch) && (t > (m = str_to_cum2 (q))))
	{
	  j++;
	  l=str_to_cum(p);
	  NEXT_CUM (p);
	  NEXT_CUM2 (q);
	  prev_cum = l;
	}
      if (j > n_ch)
	{
	  return EMPTY;
	}
      the_cum = l;
      the_cum2 = m;
      }
    }
  if (j == 1)
    prev_cum = 0;
  if (!is_compound (buffer))
    {
      *cum = the_cum;
      *cum2 = the_cum2;
      return str_to_rec (GET_CHILD (buffer, j));

    }
  else
    {
      if (srch==1) {
         recno = dbix_comp_cum (str_to_rec (GET_CHILD (buffer, j)),
			    (t - prev_cum), flag, &retcum,&retcum2,1);
      } else {
         recno = dbix_comp_cum (str_to_rec (GET_CHILD (buffer, j)),
			    (t), flag, &retcum,&retcum2,2);
      }
      *cum = (retcum + prev_cum);
      *cum2 = (retcum2);
      return recno;
    }
*/

}
