/*\
\*/


#if MPWC
#pragma segment system
#endif

/* SETL2 system header files */

#include "macros.h"

#include <assert.h>

#include "db_common.h"
#include "db_records.h"
#include "db_export.h"

/* constants */

#define YES         1                  /* true constant                     */
#define NO          0                  /* false constant                    */


string_h_ptr_type setl2_string(SETL_SYSTEM_PROTO char *s,int slen)
{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char *string_char_ptr, *string_char_end;


   get_string_header(string_hdr);
   string_hdr->s_use_count = 1;
   string_hdr->s_hash_code = -1;
   string_hdr->s_length = 0;
   string_hdr->s_head = string_hdr->s_tail = NULL;
   string_char_ptr = string_char_end = NULL;

   /* copy the source string */

   while (slen-->0) {

      if (string_char_ptr == string_char_end) {

         get_string_cell(string_cell);
         if (string_hdr->s_tail != NULL)
            (string_hdr->s_tail)->s_next = string_cell;
         string_cell->s_prev = string_hdr->s_tail;
         string_cell->s_next = NULL;
         string_hdr->s_tail = string_cell;
         if (string_hdr->s_head == NULL)
            string_hdr->s_head = string_cell;
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;

      }

      *string_char_ptr++ = *s++;
      string_hdr->s_length++;

   }
   return string_hdr;
}

void set_return_integer(SETL_SYSTEM_PROTO specifier *target,int32 value){
int32 hi_bits;

  target->sp_form = ft_short;
  if (!(hi_bits = value & INT_HIGH_BITS) ||
             hi_bits == INT_HIGH_BITS) {
     target->sp_val.sp_short_value = value;
  } else {
     short_to_long(SETL_SYSTEM target,value);
  } 

}

char *stg_of_4(int32 a)
{
static char buffer[16];
int i;

   for (i=3;i>=0;i--) {
	buffer[i]=a%256;
	a=a/256;
   }
  return buffer;
}

char *stg_of_5(long a)
{
static char buffer[16];
int i;

   for (i=4;i>=0;i--) {
	buffer[i]=a%256;
	a=a/256;
   }
  return buffer;
}

int32 setl2string_to_int(string_h_ptr_type string_hdr)
{
string_c_ptr_type string_cell;         /* string cell pointer               */
char *string_char_ptr, *string_char_end;
unsigned char buff[16];
unsigned char *t;
unsigned char *s;
int32 aa;

   assert(string_hdr->s_length==4);
   t = buff;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < buff + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++);

   }
   aa=0;
   aa=buff[3]+256*(buff[2]+256*(buff[1]+256*buff[0]));

   return aa;
}

/* DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR */
/* DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR */
/* DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR */
/* DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR DR */
  
SETL_API void DR_IS_COMPOUND(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"is_compound",
            abend_opnd_str(SETL_SYSTEM argv));

   if (rec_is_compound(setl2string_to_int(argv[0].sp_val.sp_string_ptr))) {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_true->sp_val.sp_atom_num;
      return;

   } else {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_false->sp_val.sp_atom_num;
      return;

   }

}

SETL_API void DR_NEW_REC(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */


   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(new_rec()),4);

   return;

}

SETL_API void DR_FLUSH(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"flush_rec",
            abend_opnd_str(SETL_SYSTEM argv));

   rec_flush(setl2string_to_int(argv[0].sp_val.sp_string_ptr));

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void DR_FLUSH_ALL(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   flush_all();

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

   return;

}

SETL_API void db_dr_force_cb(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   force_can_buffer();

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void DR_LOAD(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char *string_char_ptr, *string_char_end;
char *s, *t;                           /* temporary looping variables       */
int slen;

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"flush_rec",
            abend_opnd_str(SETL_SYSTEM argv));

   t=s=(rec_load(setl2string_to_int(argv[0].sp_val.sp_string_ptr)));

   /* first we make a SETL2 string out of the C string */

   get_string_header(string_hdr);
   string_hdr->s_use_count = 1;
   string_hdr->s_hash_code = -1;
   string_hdr->s_length = 0;
   string_hdr->s_head = string_hdr->s_tail = NULL;
   string_char_ptr = string_char_end = NULL;
   slen=REC_SIZE;

   /* copy the source string */

   while (slen-->0) {

      if (string_char_ptr == string_char_end) {

         get_string_cell(string_cell);
         if (string_hdr->s_tail != NULL)
            (string_hdr->s_tail)->s_next = string_cell;
         string_cell->s_prev = string_hdr->s_tail;
         string_cell->s_next = NULL;
         string_hdr->s_tail = string_cell;
         if (string_hdr->s_head == NULL)
            string_hdr->s_head = string_cell;
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;

      }

      *string_char_ptr++ = *s++;
      string_hdr->s_length++;

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = string_hdr;

   return;

}

SETL_API void DR_COPY(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"copy",
            abend_opnd_str(SETL_SYSTEM argv));


   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(
	rec_copy( setl2string_to_int(argv[0].sp_val.sp_string_ptr))),4);
   return;

}

SETL_API void DR_ABS_COPY(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"abs_copy",
            abend_opnd_str(SETL_SYSTEM argv));


   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(
	rec_abs_copy( setl2string_to_int(argv[0].sp_val.sp_string_ptr))),4);
   return;
}

SETL_API void REFCOUNT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   if (argv[0].sp_form != ft_short )
      abend(SETL_SYSTEM msg_bad_arg,"integer",1,"refcount",
            abend_opnd_str(SETL_SYSTEM argv));

   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target,rec_refcount( argv[0].sp_val.sp_short_value));

   return;

}

SETL_API void DR_SETRECBUF(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char *s, *t;                           /* temporary looping variables       */
int i,l;
char buff[REC_SIZE+1];
int32 rec;

   /* convert the file name to a C character string */


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"setrecbuf",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",2,"setrecbuf",
            abend_opnd_str(SETL_SYSTEM argv+1));

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   string_hdr = argv[1].sp_val.sp_string_ptr;

   l = 0;
   t = buff;
   for (string_cell = string_hdr->s_head;
        string_cell != NULL;
        string_cell = string_cell->s_next) {

      for (s = string_cell->s_cell_value;
           t < buff + string_hdr->s_length &&
              s < string_cell->s_cell_value + STR_CELL_WIDTH;
           *t++ = *s++) l++;

   }
   *t = '\0';

   rec_setrecbuf(rec,buff,l);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void INCREF(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"incref",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"short",2,"incref",
            abend_opnd_str(SETL_SYSTEM argv+1));

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   rec_incref(rec,argv[1].sp_val.sp_short_value);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void XFREF(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec1;
int32 rec2;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"xfref",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",2,"xfref",
            abend_opnd_str(SETL_SYSTEM argv+1));

   rec1=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   rec2=setl2string_to_int(argv[1].sp_val.sp_string_ptr);
   rec_xfref(rec1,rec2);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void DR_DIRTIFY(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dirtify",
            abend_opnd_str(SETL_SYSTEM argv));

   rec_dirtify(setl2string_to_int(argv[0].sp_val.sp_string_ptr));

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void INCREFS(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"incref",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"short",2,"incref",
            abend_opnd_str(SETL_SYSTEM argv+1));

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   rec_increfs(rec,argv[1].sp_val.sp_short_value);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void DR_CHECK_MEMORY(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;



   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target,rec_check_mem());
   return;
}

SETL_API void DR_RECNO_GENERATOR(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;



   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target,rec_generator());
   return;

}

SETL_API void DR_WRITE_REFCOUNT_DATA(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
   int32 refrec=write_refcount_data();

   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target,refrec);
   return;

}

/* BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR */  
/* BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR */  
/* BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR */  
/* BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR BNR */  

SETL_API void BNR_CREATE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */


   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(bnr_create()),4);

   return;

}

SETL_API void BNR_COMP_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"bnr_comp_cum",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=bnr_comp_cum(rec,0,1,&cum);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"bnr_comp_cum",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=bnr_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=2;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec,cum);
      }
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 


}

SETL_API void BNR_COMP(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;
long cum;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"bnr_comp",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=bnr_comp_cum(rec,0,1,&cum);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"bnr_comp_cum",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=bnr_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);
   return;

}


SETL_API void BNR_GET_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"bnr_get_cum",
            abend_opnd_str(SETL_SYSTEM argv));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target,(int)bnr_get_cum(rec));

   return;

}

SETL_API void BNR_MAKE_FROM_TUPLE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int count;
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*buffer;
int32 rec;
unsigned char *arg_cum;     

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"make_from_tuple",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[0].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple of strings",1,"make_from_tuple",
               abend_opnd_str(SETL_SYSTEM argv));

      if (source_element->sp_form != ft_string)
         abend(SETL_SYSTEM msg_bad_arg,"tuple of strings",1,"make_from_tuple",
               abend_opnd_str(SETL_SYSTEM argv));

      count++;
      total_length += (source_element->sp_val.sp_string_ptr)->s_length + 1;

   }

   /* we've calculated how much space we need, now we allocate it */

   arg_string = (unsigned char *)malloc((size_t)count*4);
   if (arg_string == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   arg_cum = (unsigned char *)malloc((size_t)count*5);
   if (arg_cum == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   q=arg_string;
   r=arg_cum;

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[0].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      string_hdr = source_element->sp_val.sp_string_ptr;
      string_length = string_hdr->s_length;
      if (string_length>REC_SIZE) string_length=REC_SIZE;

      rec=new_rec();
      p=buffer=rec_load(rec);
      rec_to_str(q,rec);
      cum_to_str(r,(long)string_length);
      count++; q+=4; r+=5;
      p=p+sr_char_start-1;

      string_cell = string_hdr->s_head;
      if (string_cell == NULL) {
         string_char_ptr = string_char_end = NULL;
      }
      else {
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;
      }

      /* copy the string into the buffer */

      while (string_length--) {

         if (string_char_ptr == string_char_end) {

            string_cell = string_cell->s_next;
            string_char_ptr = string_cell->s_cell_value;
            string_char_end = string_char_ptr + STR_CELL_WIDTH;

         }

         *p++ = *string_char_ptr++;

      }

      string_length = string_hdr->s_length;
      if (string_length>REC_SIZE) string_length=REC_SIZE;

      set_type(rec,string_record);
      bytes_from_int(buffer+sr_ncr_1-1,string_length);
      rec_dirtify(rec);



   }


   rec = bnr_make_from_tuple(arg_string,arg_cum,count);
   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   free(arg_string);
   free(arg_cum);
   return;

}


SETL_API void BNR_SET_COMP(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 i, j, count;
int32 rec,x;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"bnr_set_comp",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[2].sp_form == ft_omega) x=0;
   else x=setl2string_to_int(argv[2].sp_val.sp_string_ptr);

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=bnr_set_comp(rec,0,1,x);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"bnr_set_comp",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=bnr_set_comp(rec,(long)argv[1].sp_val.sp_short_value,0,x);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void BNR_INSERT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 i, j, count;
int32 rec,x;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"bnr_insert",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[2].sp_form == ft_omega) x=0;
   else x=setl2string_to_int(argv[2].sp_val.sp_string_ptr);

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=bnr_insert(rec,0,1,x);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"bnr_insert",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=bnr_insert(rec,(long)argv[1].sp_val.sp_short_value,0,x);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

/* WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX */
/* WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX */
/* WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX */
/* WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX WIX */
  
SETL_API void db_wix_make_from_tuple(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int count;
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*buffer;
int32 rec;
unsigned char *arg_cum;     

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"make_from_tuple",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[0].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple of strings",1,"make_from_tuple",
               abend_opnd_str(SETL_SYSTEM argv));

      if (source_element->sp_form != ft_string)
         abend(SETL_SYSTEM msg_bad_arg,"tuple of strings",1,"make_from_tuple",
               abend_opnd_str(SETL_SYSTEM argv));

      count++;
      total_length += (source_element->sp_val.sp_string_ptr)->s_length + 1;

   }

   /* we've calculated how much space we need, now we allocate it */

   arg_string = (unsigned char *)malloc((size_t)count*4);
   if (arg_string == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   arg_cum = (unsigned char *)malloc((size_t)count*5);
   if (arg_cum == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   q=arg_string;
   r=arg_cum;

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[0].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      string_hdr = source_element->sp_val.sp_string_ptr;
      string_length = string_hdr->s_length;
      if (string_length>REC_SIZE) string_length=REC_SIZE;

      rec=new_rec();
      p=buffer=rec_load(rec);
      rec_to_str(q,rec);
      cum_to_str(r,(long)string_length);
      count++; q+=4; r+=5;
      p=p+sr_char_start-1;

      string_cell = string_hdr->s_head;
      if (string_cell == NULL) {
         string_char_ptr = string_char_end = NULL;
      }
      else {
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;
      }

      /* copy the string into the buffer */

      while (string_length--) {

         if (string_char_ptr == string_char_end) {

            string_cell = string_cell->s_next;
            string_char_ptr = string_cell->s_cell_value;
            string_char_end = string_char_ptr + STR_CELL_WIDTH;

         }

         *p++ = *string_char_ptr++;

      }

      string_length = string_hdr->s_length;
      if (string_length>REC_SIZE) string_length=REC_SIZE;

      set_type(rec,string_record);
      bytes_from_int(buffer+sr_ncr_1-1,string_length);
      rec_dirtify(rec);



   }


   rec = bnr_make_from_tuple(arg_string,arg_cum,count);
   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   free(arg_string);
   free(arg_cum);
   return;

}

SETL_API void WIX_CREATE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(wix_create()),4);

   return;

}


/* WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO */
/* WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO */
/* WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO */
/* WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO WO */

SETL_API void WO_CREATE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */


   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(wo_create()),4);

   return;

}


SETL_API void WO_GET_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_get_cum",
            abend_opnd_str(SETL_SYSTEM argv));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target, (int)wo_get_cum(rec));

   return;

}

SETL_API void WO_GET_CUM2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_get_cum2",
            abend_opnd_str(SETL_SYSTEM argv));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(
     SETL_SYSTEM 		stg_of_4((int)wo_get_cum2(rec)),4);

   return;

}

SETL_API void WO_MAKE_FROM_TUPLE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int count;
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*s,*buffer;
int32 rec;
unsigned char *arg_cum;     
unsigned char *arg_cum2;     

   /* the last must be a tuple of strings */

   if (argv[0].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",1,"make_from_tuple",
            abend_opnd_str(SETL_SYSTEM argv));

   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[0].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple of strings",1,"make_from_tuple",
               abend_opnd_str(SETL_SYSTEM argv));

      if (source_element->sp_form != ft_string)
         abend(SETL_SYSTEM msg_bad_arg,"tuple of strings",1,"make_from_tuple",
               abend_opnd_str(SETL_SYSTEM argv));

      count++;
      total_length += (source_element->sp_val.sp_string_ptr)->s_length + 1;

   }

   /* we've calculated how much space we need, now we allocate it */

   arg_string = (unsigned char *)malloc((size_t)count*4);
   if (arg_string == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   arg_cum = (unsigned char *)malloc((size_t)count*5);
   arg_cum2 = (unsigned char *)malloc((size_t)count*4);
   if (arg_cum == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   if (arg_cum2 == NULL)
         giveup(SETL_SYSTEM msg_malloc_error);
   q=arg_string;
   r=arg_cum;
   s=arg_cum2;

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[0].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      string_hdr = source_element->sp_val.sp_string_ptr;
      string_length = string_hdr->s_length;
      if (string_length>REC_SIZE) string_length=REC_SIZE;

      rec=new_rec();
      buffer=rec_load(rec);
      rec_to_str(q,rec);
      assert(string_length%4==0);
      cum_to_str(r,(long)(string_length/4));
      count++; q+=4; r+=5;
      p=buffer+wo_occs_start-1;

      string_cell = string_hdr->s_head;
      if (string_cell == NULL) {
         string_char_ptr = string_char_end = NULL;
      }
      else {
         string_char_ptr = string_cell->s_cell_value;
         string_char_end = string_char_ptr + STR_CELL_WIDTH;
      }

      /* copy the string into the buffer */

      while (string_length--) {

         if (string_char_ptr == string_char_end) {

            string_cell = string_cell->s_next;
            string_char_ptr = string_cell->s_cell_value;
            string_char_end = string_char_ptr + STR_CELL_WIDTH;

         }

         *p++ = *string_char_ptr++;

      }

      string_length = string_hdr->s_length;
      p=buffer+wo_occs_start-1;
      bcopy(p,s,4);
      s+=4;
      if (string_length>REC_SIZE) string_length=REC_SIZE;

      set_type(rec,wdoccs_string_record);
      byte_from_int(buffer+wo_nr_1-1,string_length/4);
      rec_dirtify(rec);



   }


   rec = wo_make_from_tuple(arg_string,arg_cum,arg_cum2,count);
   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   free(arg_string);
   free(arg_cum);
   free(arg_cum2);
   return;

}

SETL_API void WO_COMP_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_comp_cum",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,0,1,&cum,&cum2,1);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_comp_cum",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,1);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=3;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);
      }
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)cum);
      }
      if (elements==3) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 


}

SETL_API void WO_COMP(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;
long cum;
int32 cum2;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_comp",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,0,1,&cum,&cum2,1);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_comp_cum",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,1);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);
   return;

}

SETL_API void WO_COMP_CUM2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_comp_cum2",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,0,1,&cum,&cum2,2);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_comp_cum2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,2);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=3;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);
      }
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)cum);
      }
      if (elements==3) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 


}

SETL_API void WO_COMP2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;
long cum;
int32 cum2;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_comp2",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,0,1,&cum,&cum2,2);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_comp_cum2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      rec=wo_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,2);
      if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);
   return;

}

SETL_API void WO_SET_COMP(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 i, j, count;
int32 rec,x;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_set_comp",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[2].sp_form == ft_omega) x=0;
   else x=setl2string_to_int(argv[2].sp_val.sp_string_ptr);

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=wo_set_comp(rec,0,1,x,1);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_set_comp",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=wo_set_comp(rec,(long)argv[1].sp_val.sp_short_value,0,x,1);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void WO_SET_COMP2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 i, j, count;
int32 rec,x;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_set_comp2",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[2].sp_form == ft_omega) x=0;
   else x=setl2string_to_int(argv[2].sp_val.sp_string_ptr);

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=wo_set_comp(rec,0,1,x,2);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_set_comp2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=wo_set_comp(rec,(long)argv[1].sp_val.sp_short_value,0,x,2);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void WO_INSERT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 i, j, count;
int32 rec,x;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_insert",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[2].sp_form == ft_omega) x=0;
   else x=setl2string_to_int(argv[2].sp_val.sp_string_ptr);

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=wo_insert(rec,0,1,x,1,0);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_insert",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=wo_insert(rec,(long)argv[1].sp_val.sp_short_value,0,x,1,0);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void WO_INSERT2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 i, j, count;
int32 rec,x;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_insert2",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[2].sp_form == ft_omega) x=0;
   else x=setl2string_to_int(argv[2].sp_val.sp_string_ptr);

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=wo_insert(rec,0,1,x,2,0);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wo_insert2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=wo_insert(rec,(long)argv[1].sp_val.sp_short_value,0,x,2,0);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void db_wo_first_past_to(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
char *s, *t;                           /* temporary looping variables       */
int32 i, j, count;
int32 rec;
long cum;
int elements;
int32 key;
int32 w,pos;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_first_past_to",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_string)
         abend(SETL_SYSTEM msg_bad_arg,"string",2,"wo_first_past_to",
               abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",3,"wo_first_past_to",
               abend_opnd_str(SETL_SYSTEM argv+2));

   if (argv[3].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",4,"wo_first_past_to",
               abend_opnd_str(SETL_SYSTEM argv+3));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   key=setl2string_to_int(argv[1].sp_val.sp_string_ptr);

   rec = wo_first_past_to(rec,key,
	       argv[2].sp_val.sp_short_value,
	       argv[3].sp_val.sp_short_value,&w,&pos);

   if (rec==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
   }
   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=2;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(w),4);
      }
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)pos);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 


}

/* DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX */
/* DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX */
/* DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX */
/* DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX DBIX */

SETL_API void DBIX_CREATE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */


   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(dbix_create()),4);

   return;

}

SETL_API void DBIX_GET_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_get_cum",
            abend_opnd_str(SETL_SYSTEM argv));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   unmark_specifier(target);
   set_return_integer(SETL_SYSTEM target, (int)dbix_get_cum(rec));

   return;

}

SETL_API void DBIX_GET_CUM2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wo_get_cum2",
            abend_opnd_str(SETL_SYSTEM argv));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(
		SETL_SYSTEM stg_of_4((int)dbix_get_cum2(rec)),4);

   return;

}

SETL_API void DBIX_COMP_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
TUPLE_CONSTRUCTOR(ca)
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
long result;
int elements;
specifier s;


   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_comp_cum",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,0,1,&cum,&cum2,1);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"dbix_comp_cum",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,1);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   TUPLE_CONSTRUCTOR_BEGIN(ca);

   s.sp_form = ft_string;
   s.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
   TUPLE_ADD_CELL(ca,&s);

   set_return_integer(SETL_SYSTEM &s, (int32)result);
   TUPLE_ADD_CELL(ca,&s);

   set_return_integer(SETL_SYSTEM &s, (int32)cum);
   TUPLE_ADD_CELL(ca,&s);

   TUPLE_CONSTRUCTOR_END(ca);

   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = TUPLE_HEADER(ca);

   return;
 


}


SETL_API void DBIX_COMP_CUM2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
long result;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_comp_cum2",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,0,1,&cum,&cum2,2);
      if (result==-1) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_string)
         abend(SETL_SYSTEM msg_bad_arg,"string",2,"dbix_comp_cum2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,(long)
      		(setl2string_to_int(argv[1].sp_val.sp_string_ptr)),
		0,&cum,&cum2,2);
      if (result==-1) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=3;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)result);
      }
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
      }
      if (elements==3) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec,(int32)cum);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 
}

SETL_API void DBIX_COMP(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
long result;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_comp",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,0,1,&cum,&cum2,1);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"dbix_comp",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,1);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=2;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)result);
      }
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 


}


SETL_API void DBIX_COMP2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
long result;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_comp2",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,0,1,&cum,&cum2,2);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"dbix_comp2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=dbix_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,2);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=2;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)result);
      }
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 
}

SETL_API void DBIX_SET_COMP(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*buffer;
int32 i, j, count;
int32 rec,x;
long x2;
int32  x1;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_set_comp",
            abend_opnd_str(SETL_SYSTEM argv));

   /* the last must be a tuple */

   if (argv[2].sp_form == ft_omega) { 
	x1=0;
	x2=0;
   } else {
   if (argv[2].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_set_comp",
            abend_opnd_str(SETL_SYSTEM argv+2));


   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_set_comp",
               abend_opnd_str(SETL_SYSTEM argv+2));

      count++;

   }

   /* we've calculated how much space we need, now we allocate it */

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      if (count==0) {
          if (source_element->sp_form != ft_string)
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(1)",3,"dbix_set_comp",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  x1=setl2string_to_int(source_element->sp_val.sp_string_ptr);
      }
      if (count==1) {
          if (source_element->sp_form == ft_short) {
	     x2=(long)(source_element->sp_val.sp_short_value);
          } else if (source_element->sp_form == ft_long) {
	     x2=(long)long_to_short(SETL_SYSTEM source_element->sp_val.sp_long_ptr);
          } else {
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(2)",3,"dbix_set_comp",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  }
      }
      count++; 



   }
	
   }


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=dbix_set_comp(rec,0,1,x1,x2,1);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"dbix_set_comp",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=dbix_set_comp(rec,(long)argv[1].sp_val.sp_short_value,0,x1,x2,1);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void DBIX_SET_COMP2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*buffer;
int32 i, j, count;
int32 rec,x;
long x2;
int32  x1;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_set_comp2",
            abend_opnd_str(SETL_SYSTEM argv));

   /* the last must be a tuple */

   if (argv[2].sp_form == ft_omega) { 
	x1=0;
	x2=0;
   } else {
   if (argv[2].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_set_comp2",
            abend_opnd_str(SETL_SYSTEM argv+2));


   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_set_comp2",
               abend_opnd_str(SETL_SYSTEM argv+2));

      count++;

   }

   /* we've calculated how much space we need, now we allocate it */

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      if (count==0) {
          if (source_element->sp_form != ft_string)
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(1)",3,"dbix_set_comp2",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  x1=setl2string_to_int(source_element->sp_val.sp_string_ptr);
      }
      if (count==1) {
          if (source_element->sp_form != ft_short)
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(2)",3,"dbix_set_comp2",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  x2=(long)(source_element->sp_val.sp_short_value);
      }
      count++; 



   }
	
   }


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=dbix_set_comp(rec,0,1,x1,x2,2);

   } else {

      if (argv[1].sp_form != ft_string)
         abend(SETL_SYSTEM msg_bad_arg,"string",2,"dbix_set_comp2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=dbix_set_comp(rec,
		(long)(setl2string_to_int(argv[1].sp_val.sp_string_ptr)),
		0,x1,x2,2);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);

}

SETL_API void DBIX_INSERT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*buffer;
int32 i, j, count;
int32 rec,x;
long x2;
int32  x1;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_insert",
            abend_opnd_str(SETL_SYSTEM argv));


   /* the last must be a tuple */

   if (argv[2].sp_form == ft_omega) { 
	x1=0;
	x2=0;
   } else {
   if (argv[2].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_insert",
            abend_opnd_str(SETL_SYSTEM argv+2));


   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_set_comp",
               abend_opnd_str(SETL_SYSTEM argv+2));

      count++;

   }

   /* we've calculated how much space we need, now we allocate it */

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      if (count==0) {
          if (source_element->sp_form != ft_string)
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(1)",3,"dbix_insert",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  x1=setl2string_to_int(source_element->sp_val.sp_string_ptr);
      }
      if (count==1) {
          if (source_element->sp_form == ft_short) {
	     x2=(long)(source_element->sp_val.sp_short_value);
          } else if (source_element->sp_form == ft_long) {
	     x2=(long)long_to_short(SETL_SYSTEM source_element->sp_val.sp_long_ptr);
          } else {
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(2)",3,"dbix_insert",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  }

      }
      count++; 



   }
	
   }

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=dbix_insert(rec,0,1,x1,x2,1);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"dbix_insert",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=dbix_insert(rec,(long)argv[1].sp_val.sp_short_value,0,x1,x2,1);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);


}

SETL_API void DBIX_INSERT2(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int total_length;                      /* total string length               */
struct comm_block *save_comm_block;    /* block used by this instance       */
tuple_h_ptr_type source_root, source_work_hdr;
                                       /* root and internal node pointers   */
tuple_c_ptr_type source_cell;          /* current cell pointer              */
int32 source_number;                   /* current cell number               */
int source_height, source_index;       /* current height and index          */
specifier *source_element;             /* tuple element                     */
string_h_ptr_type string_hdr;
                                       /* source and target strings         */
string_c_ptr_type string_cell;
                                       /* source and target string cells    */
int32 string_length;                   /* source string length              */
char *string_char_ptr, *string_char_end;
                                       /* source string pointers            */
char *p;                               /* temporary looping variable        */
unsigned char *arg_string;             /* argument storage string           */
unsigned char *q,*r,*buffer;
int32 i, j, count;
int32 rec,x;
long x2;
int32  x1;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"dbix_insert2",
            abend_opnd_str(SETL_SYSTEM argv));


   /* the last must be a tuple */

   if (argv[2].sp_form == ft_omega) { 
	x1=0;
	x2=0;
   } else {
   if (argv[2].sp_form != ft_tuple)
      abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_insert2",
            abend_opnd_str(SETL_SYSTEM argv+2));


   /* set up to loop over the tuple, counting arguments and lengths */

   count = 0;
   total_length = 0;
   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;

      /* we expect each element of the tuple to be a string */

      if (count < source_number)
         abend(SETL_SYSTEM msg_bad_arg,"tuple",3,"dbix_set_comp",
               abend_opnd_str(SETL_SYSTEM argv+2));

      count++;

   }

   /* we've calculated how much space we need, now we allocate it */

   /* loop over the tuple again, building up the array for C */

   count = 0;

   source_root = argv[2].sp_val.sp_tuple_ptr;
   source_work_hdr = source_root;
   source_number = -1;
   source_height = source_root->t_ntype.t_root.t_height;
   source_index = 0;

   /* loop over the elements of source */

   while (source_number < source_root->t_ntype.t_root.t_length) {

      /* find the next element in the tuple */

      source_element = NULL;
      for (;;) {

         /* if we have an element already, return it */

         if (!source_height && source_index < TUP_HEADER_SIZE) {

            if (source_work_hdr->t_child[source_index].t_cell == NULL) {

               source_number++;
               source_index++;

               continue;

            }

            source_cell = source_work_hdr->t_child[source_index].t_cell;
            source_element = &(source_cell->t_spec);

            source_number++;
            source_index++;

            break;

         }

         /* move up if we're at the end of a node */

         if (source_index >= TUP_HEADER_SIZE) {

            /* break if we've exhausted the source */

            if (source_work_hdr == source_root)
               break;

            source_height++;
            source_index =
               source_work_hdr->t_ntype.t_intern.t_child_index + 1;
            source_work_hdr =
               source_work_hdr->t_ntype.t_intern.t_parent;

            continue;

         }

         /* skip over null nodes */

         if (source_work_hdr->t_child[source_index].t_header == NULL) {

            source_number += 1L << (source_height * TUP_SHIFT_DIST);
            source_index++;

            continue;

         }

         /* otherwise drop down a level */

         source_work_hdr =
            source_work_hdr->t_child[source_index].t_header;
         source_index = 0;
         source_height--;

      }

      if (source_element == NULL)
         break;


      /* initialize the source string */

      if (count==0) {
          if (source_element->sp_form != ft_string)
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(1)",3,"dbix_set_comp",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  x1=setl2string_to_int(source_element->sp_val.sp_string_ptr);
      }
      if (count==1) {
          if (source_element->sp_form != ft_short)
        	abend(SETL_SYSTEM msg_bad_arg,"tuple(.)(2)",3,"dbix_set_comp",
                     abend_opnd_str(SETL_SYSTEM argv+2));
	  x2=(long)(source_element->sp_val.sp_short_value);
      }
      count++; 



   }
	
   }

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

   if (argv[1].sp_form == ft_omega) {

      rec=dbix_insert(rec,0,1,x1,x2,2);

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"dbix_insert2",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=dbix_insert(rec,(long)argv[1].sp_val.sp_short_value,0,x1,x2,2);

   }

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(rec),4);

   push_pstack(target);


}

SETL_API void WIX_COMP_CUM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
tuple_h_ptr_type tuple_root, tuple_work_hdr, new_tuple_hdr;
                                       /* tuple header pointers             */
tuple_c_ptr_type tuple_cell;           /* tuple cell pointer                */
int tuple_index, tuple_height;         /* used to descend header trees      */
int32 tuple_length;                    /* current tuple length              */
int32 expansion_trigger;               /* size which triggers header        */
                                       /* expansion                         */
string_h_ptr_type target_hdr;          /* target string                     */
string_c_ptr_type target_cell;         /* target string cell                */
int32 i, j, count;
int32 rec;
long cum;
int32 cum2;
long result;
int elements;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"wix_comp_cum",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form == ft_omega) {
      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=wix_comp_cum(rec,0,1,&cum,&cum2,1);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }

   } else {

      if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"wix_comp_cum",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      result=wix_comp_cum(rec,(long)argv[1].sp_val.sp_short_value,0,&cum,&cum2,1);
      if (result==0) {
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;
      }
   }

   /*
    *  We have to initialize a tuple to hold the lines we will read.
    */

   get_tuple_header(tuple_root);
   tuple_root->t_use_count = 1;
   tuple_root->t_hash_code = 0;
   tuple_root->t_ntype.t_root.t_length = 0;
   tuple_root->t_ntype.t_root.t_height = 0;
   for (i = 0;
        i < TUP_HEADER_SIZE;
        tuple_root->t_child[i++].t_cell = NULL);
   tuple_length = 0;
   expansion_trigger = TUP_HEADER_SIZE;


   for (elements=1;elements<=3;elements++) {
      /* expand the tuple tree if necessary */

      if (tuple_length >= expansion_trigger) {

         tuple_work_hdr = tuple_root;

         get_tuple_header(tuple_root);

         tuple_root->t_use_count = 1;
         tuple_root->t_hash_code =
            tuple_work_hdr->t_hash_code;
         tuple_root->t_ntype.t_root.t_length =
            tuple_work_hdr->t_ntype.t_root.t_length;
         tuple_root->t_ntype.t_root.t_height =
            tuple_work_hdr->t_ntype.t_root.t_height + 1;

         for (i = 1;
              i < TUP_HEADER_SIZE;
              tuple_root->t_child[i++].t_header = NULL);

         tuple_root->t_child[0].t_header = tuple_work_hdr;

         tuple_work_hdr->t_ntype.t_intern.t_parent = tuple_root;
         tuple_work_hdr->t_ntype.t_intern.t_child_index = 0;

         expansion_trigger *= TUP_HEADER_SIZE;

      }

      tuple_root->t_ntype.t_root.t_length++;

      /* descend the tree to a leaf */

      tuple_work_hdr = tuple_root;
      for (tuple_height = tuple_work_hdr->t_ntype.t_root.t_height;
           tuple_height;
           tuple_height--) {

         /* extract the element's index at this level */

         tuple_index = (tuple_length >>
                              (tuple_height * TUP_SHIFT_DIST)) &
                           TUP_SHIFT_MASK;

         /* if we're missing a header record, allocate one */

         if (tuple_work_hdr->t_child[tuple_index].t_header == NULL) {

            get_tuple_header(new_tuple_hdr);
            new_tuple_hdr->t_ntype.t_intern.t_parent = tuple_work_hdr;
            new_tuple_hdr->t_ntype.t_intern.t_child_index = tuple_index;
            for (i = 0;
                 i < TUP_HEADER_SIZE;
                 new_tuple_hdr->t_child[i++].t_cell = NULL);
            tuple_work_hdr->t_child[tuple_index].t_header =
                  new_tuple_hdr;
            tuple_work_hdr = new_tuple_hdr;

         }
         else {

            tuple_work_hdr =
               tuple_work_hdr->t_child[tuple_index].t_header;

         }
      }

      /*
       *  At this point, tuple_work_hdr points to the lowest level header
       *  record.  We insert the new element.
       */

      tuple_index = tuple_length & TUP_SHIFT_MASK;
      get_tuple_cell(tuple_cell);
      if (elements==1) {
         tuple_cell->t_spec.sp_form = ft_string;
         tuple_cell->t_spec.sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM stg_of_4(cum2),4);
      }
      if (elements==2) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)result);
      }
      if (elements==3) {
         set_return_integer(SETL_SYSTEM &tuple_cell->t_spec, (int32)cum);
      }
      spec_hash_code(tuple_cell->t_hash_code,&(tuple_cell->t_spec));
      tuple_root->t_hash_code ^= tuple_cell->t_hash_code;
      tuple_work_hdr->t_child[tuple_index].t_cell = tuple_cell;

      /* increment the tuple size */

      tuple_length++;

   }
   tuple_root->t_ntype.t_root.t_length = tuple_length;
   unmark_specifier(target);
   target->sp_form = ft_tuple;
   target->sp_val.sp_tuple_ptr = tuple_root;
 
   return;
 
}

/* END END END END END END END END END END END END END END END END END */
/* END END END END END END END END END END END END END END END END END */
/* END END END END END END END END END END END END END END END END END */
/* END END END END END END END END END END END END END END END END END */

SETL_API void SHARE_RIGHT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"share_right",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
      abend(SETL_SYSTEM msg_bad_arg,"short",2,"share_right",
            abend_opnd_str(SETL_SYSTEM argv+1));

   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   share_right(rec,argv[1].sp_val.sp_short_value);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void SPLIT_NODE(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
int32 rec;
long cum;



   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"split_node",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"split_node",
               abend_opnd_str(SETL_SYSTEM argv+1));

      rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
      split_node(rec,(long)argv[1].sp_val.sp_short_value);
   	unmark_specifier(target);
        target->sp_form = ft_omega;
        return;

}

SETL_API void PULL_FROM_RIGHT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"pull_from_right",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"pull_from_right",
               abend_opnd_str(SETL_SYSTEM argv+1));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   if (pull_from_right(rec,argv[1].sp_val.sp_short_value)) {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_true->sp_val.sp_atom_num;
      return;

   } else {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_false->sp_val.sp_atom_num;
      return;

   }

}

SETL_API void PULL_FROM_LEFT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"pull_from_left",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"pull_from_left",
               abend_opnd_str(SETL_SYSTEM argv+1));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   if (pull_from_left(rec,argv[1].sp_val.sp_short_value)) {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_true->sp_val.sp_atom_num;
      return;

   } else {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_false->sp_val.sp_atom_num;
      return;

   }

}

SETL_API void JOIN_WITH_LEFT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"join_with_left",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"join_with_left",
               abend_opnd_str(SETL_SYSTEM argv+1));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   if (join_with_left(rec,argv[1].sp_val.sp_short_value)) {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_true->sp_val.sp_atom_num;
      return;

   } else {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_false->sp_val.sp_atom_num;
      return;

   }

}

SETL_API void JOIN_WITH_RIGHT(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"join_with_right",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"join_with_right",
               abend_opnd_str(SETL_SYSTEM argv+1));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);
   if (join_with_right(rec,argv[1].sp_val.sp_short_value)) {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_true->sp_val.sp_atom_num;
      return;

   } else {

      unmark_specifier(target);
      target->sp_form = ft_atom;
      target->sp_val.sp_atom_num = spec_false->sp_val.sp_atom_num;
      return;

   }

}

SETL_API void db_update_cums(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
string_h_ptr_type string_hdr;          /* string root                       */
string_c_ptr_type string_cell;         /* string cell pointer               */
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
int32 rec;

   if (argv[0].sp_form != ft_string)
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"update_cums",
            abend_opnd_str(SETL_SYSTEM argv));

   if (argv[1].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",2,"update_cums",
               abend_opnd_str(SETL_SYSTEM argv+1));

   if (argv[2].sp_form != ft_short)
         abend(SETL_SYSTEM msg_bad_arg,"short",3,"update_cums",
               abend_opnd_str(SETL_SYSTEM argv+2));


   rec=setl2string_to_int(argv[0].sp_val.sp_string_ptr);

/*
   update_cums(rec,
	       argv[1].sp_val.sp_short_value,
	       (long)argv[2].sp_val.sp_short_value);
*/
}


/*
 * DB DB DB DB DB DB
 */

SETL_API void DB_CLOSE_DB(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
char param[32+1];
STRING_ITERATOR(sa);


   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"db_close_db",
            abend_opnd_str(SETL_SYSTEM argv));

   ITERATE_STRING_BEGIN(sa,argv[0]);
   STRING_CONVERT(sa,param);

   close_db(param);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;
}


SETL_API void DB_OPEN_DB(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
char file_name[PATH_LENGTH + 1];       /* file name                         */
char *s, *t;                           /* temporary looping variables       */
STRING_ITERATOR(sa);

   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"db_open_db",
            abend_opnd_str(SETL_SYSTEM argv));

   ITERATE_STRING_BEGIN(sa,argv[0]);
   STRING_CONVERT(sa,file_name);

   open_db(file_name);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;

}

SETL_API void DB_READ_PARAM(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{

   unmark_specifier(target);
   target->sp_form = ft_string;
   target->sp_val.sp_string_ptr = setl2_string(SETL_SYSTEM db_get_param(),32);

   return;

}

SETL_API void DB_DEBUG(
   SETL_SYSTEM_PROTO
   int argc,                           /* number of arguments passed        */
   specifier *argv,                    /* argument vector (two here)        */
   specifier *target)                  /* return value                      */

{
char param[32+1];
STRING_ITERATOR(sa);


   if (argv[0].sp_form != ft_string )
      abend(SETL_SYSTEM msg_bad_arg,"string",1,"db_debug",
            abend_opnd_str(SETL_SYSTEM argv));

   ITERATE_STRING_BEGIN(sa,argv[0]);
   STRING_CONVERT(sa,param);

   unmark_specifier(target);
   target->sp_form = ft_omega;
   return;
}

