/**************************************************************************************
/* Filename:	gr_ops.c
/*		Copyright  1998-99 Giuseppe Di Mauro. All rights reserved.
/*
/* Description:	mathematical operations
/*
/***************************************************************************************/

#include <math.h>
#include <stdlib.h>

#include "gr_ops.h"

	/*
	 *	Implementation
	 */

/**************************************************************************************
/*	Function:		is_pow_of_2
/*	Description:	check if an integer number is a power of 2
/*
/*	Parameters:
/*		<- n		the number to check
/*
/*	Result:
/*		1	is a power of 2
/*		0	is not a power of 2
/*
/***************************************************************************************/

int is_pow_of_2(int n)
{
	while (n && !(n%2))
		n >>= 1;
			
	return (n==1)?1:0;
}

/**************************************************************************************
/*	Function:		plus_op
/*	Description:	compute the sum of two unsigned byte values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char plus_op(unsigned char x, unsigned char y)
{
	return x+y;
}

/**************************************************************************************
/*	Function:		minus_op
/*	Description:	compute the difference of two unsigned byte values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char minus_op(unsigned char x, unsigned char y)
{
	return x-y;
}

/**************************************************************************************
/*	Function:		times_op
/*	Description:	compute the multiplication of two unsigned byte values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char times_op(unsigned char x, unsigned char y)
{
	return x*y;
}

/**************************************************************************************
/*	Function:		divide_op
/*	Description:	compute the division of two unsigned byte values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char divide_op(unsigned char x, unsigned char y)
{
	return x/y;
}

/**************************************************************************************
/*	Function:		maxim_op
/*	Description:	compute the max between two unsigned byte values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char maxim_op(unsigned char x, unsigned char y)
{
	return max(x,y);
}

/**************************************************************************************
/*	Function:		minim_op
/*	Description:	compute the minimum between two unsigned byte values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char minim_op(unsigned char x, unsigned char y)
{
	return min(x,y);
}

/**************************************************************************************
/*	Function:		power_op
/*	Description:	compute the minimum power of the first by the second unsigned
/*					byte operands
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char power_op(unsigned char x, unsigned char y)
{
	return pow(x,y);
}

/**************************************************************************************
/*	Function:		fplus_op
/*	Description:	compute the sum of two float values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fplus_op(float x, float y)
{
	return x+y;
}

/**************************************************************************************
/*	Function:		fminus_op
/*	Description:	compute the difference of two float values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fminus_op(float x, float y)
{
	return x-y;
}

/**************************************************************************************
/*	Function:		ftimes_op
/*	Description:	compute the multiplication of two float values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float ftimes_op(float x, float y)
{
	return x*y;
}

/**************************************************************************************
/*	Function:		fdivide_op
/*	Description:	compute the division of two float values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fdivide_op(float x, float y)
{
	return x/y;
}

/**************************************************************************************
/*	Function:		fmaxim_op
/*	Description:	compute the max between two float values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fmaxim_op(float x, float y)
{
	return max(x,y);
}

/**************************************************************************************
/*	Function:		fminim_op
/*	Description:	compute the minimum between two float values
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fminim_op(float x, float y)
{
	return min(x,y);
}

/**************************************************************************************
/*	Function:		fpower_op
/*	Description:	compute the power of the first operand by the second float value
/*
/*	Parameters:
/*		<- x		first operand
/*		<- y		second operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fpower_op(float x, float y)
{
	return pow(x,y);
}

/**************************************************************************************
/*	Function:		sin_op
/*	Description:	compute the sin of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char sin_op(unsigned char a)
{
	return sin(a);
}

/**************************************************************************************
/*	Function:		sin_op
/*	Description:	compute the sin of a float value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fsin_op(float a)
{
	return sin(a);
}

/**************************************************************************************
/*	Function:		cosin_op
/*	Description:	compute the cosine of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char cosin_op(unsigned char a)
{
	return cos(a);
}

/**************************************************************************************
/*	Function:		fcosin_op
/*	Description:	compute the cosine of a float value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fcosin_op(float a)
{
	return cos(a);
}

/**************************************************************************************
/*	Function:		tan_op
/*	Description:	compute the tangent of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char tan_op(unsigned char a)
{
	return tan(a);
}

/**************************************************************************************
/*	Function:		ftan_op
/*	Description:	compute the tangent of a float value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float ftan_op(float a)
{
	return tan(a);
}

/**************************************************************************************
/*	Function:		exp_op
/*	Description:	compute the exp of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char exp_op(unsigned char a)
{
	return exp(a);
}

/**************************************************************************************
/*	Function:		fexp_op
/*	Description:	compute the exp of a float value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fexp_op(float a)
{
	return exp(a);
}

/**************************************************************************************
/*	Function:		log_op
/*	Description:	compute the log of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char log_op(unsigned char a)
{
	return log(a);
}

/**************************************************************************************
/*	Function:		flog_op
/*	Description:	compute the log of a float value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float flog_op(float a)
{
	return log(a);
}

/**************************************************************************************
/*	Function:		abs_op
/*	Description:	compute the absolute value of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char abs_op(unsigned char a)
{
	return abs(a);
}

/**************************************************************************************
/*	Function:		fabs_op
/*	Description:	compute the absolute value of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fabs_op(float a)
{
	return fabs(a);
}

/**************************************************************************************
/*	Function:		even_op
/*	Description:	compute the even predicate of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char even_op(unsigned char a)
{
	return !(a&1);
}

/**************************************************************************************
/*	Function:		feven_op
/*	Description:	compute the even predicate of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float feven_op(float a)
{
	return even_op(a);
}

/**************************************************************************************
/*	Function:		odd_op
/*	Description:	compute the odd predicate of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char odd_op(unsigned char a)
{
	return (a&1);
}

/**************************************************************************************
/*	Function:		fodd_op
/*	Description:	compute the odd predicate of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fodd_op(float a)
{
	return odd_op(a);
}

/**************************************************************************************
/*	Function:		sqrt_op
/*	Description:	compute the sqrt operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char sqrt_op(unsigned char a)
{
	return sqrt(a);
}

/**************************************************************************************
/*	Function:		fsqrt_op
/*	Description:	compute the sqrt operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fsqrt_op(float a)
{
	return sqrt(a);
}

/**************************************************************************************
/*	Function:		asin_op
/*	Description:	compute the arcsin operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char asin_op(unsigned char a)
{
	return asin(a);
}

/**************************************************************************************
/*	Function:		fasin_op
/*	Description:	compute the arcsin operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fasin_op(float a)
{
	return asin(a);
}

/**************************************************************************************
/*	Function:		acosin_op
/*	Description:	compute the arc-cosine operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char acosin_op(unsigned char a)
{
	return acos(a);
}

/**************************************************************************************
/*	Function:		facosin_op
/*	Description:	compute the arc-cosine operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float facosin_op(float a)
{
	return acos(a);
}

/**************************************************************************************
/*	Function:		atan_op
/*	Description:	compute the arc-tangent operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char atan_op(unsigned char a)
{
	return atan(a);
}

/**************************************************************************************
/*	Function:		fatan_op
/*	Description:	compute the arc-tangent operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fatan_op(float a)
{
	return atan(a);
}

/**************************************************************************************
/*	Function:		fix_op
/*	Description:	compute the fix operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char fix_op(unsigned char a)
{
	return ROUND(a);
}

/**************************************************************************************
/*	Function:		ffix_op
/*	Description:	compute the fix operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float ffix_op(float a)
{
	return ROUND(a);
}

/**************************************************************************************
/*	Function:		floor_op
/*	Description:	compute the floor operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char floor_op(unsigned char a)
{
	return floor(a);
}

/**************************************************************************************
/*	Function:		ffloor_op
/*	Description:	compute the floor operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float ffloor_op(float a)
{
	return floor(a);
}

/**************************************************************************************
/*	Function:		ceiling_op
/*	Description:	compute the ceiling operation of an unsigned byte value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

unsigned char ceiling_op(unsigned char a)
{
	return ceil(a);
}

/**************************************************************************************
/*	Function:		fceiling_op
/*	Description:	compute the ceiling operation of a real value
/*
/*	Parameters:
/*		<- a		operand
/*
/*	Result:
/*		result of the operation
/*
/***************************************************************************************/

float fceiling_op(float a)
{
	return ceil(a);
}

