#ifndef __OPS_H__
#define __OPS_H__

#include <math.h>

#ifdef __cplusplus
extern "C" {
#endif

int is_pow_of_2(int n);

unsigned char plus_op(unsigned char x, unsigned char y);
unsigned char minus_op(unsigned char x, unsigned char y);
unsigned char times_op(unsigned char x, unsigned char y);
unsigned char divide_op(unsigned char x, unsigned char y);
unsigned char maxim_op(unsigned char x, unsigned char y);
unsigned char minim_op(unsigned char x, unsigned char y);
unsigned char power_op(unsigned char x, unsigned char y);

float fplus_op(float x, float y);
float fminus_op(float x, float y);
float ftimes_op(float x, float y);
float fdivide_op(float x, float y);
float fmaxim_op(float x, float y);
float fminim_op(float x, float y);
float fpower_op(float x, float y);

unsigned char sin_op(unsigned char a);
float fsin_op(float a);
unsigned char cosin_op(unsigned char a);
float fcosin_op(float a);
unsigned char tan_op(unsigned char a);
float ftan_op(float a);
unsigned char exp_op(unsigned char a);
float fexp_op(float a);
unsigned char log_op(unsigned char a);
float flog_op(float a);
unsigned char abs_op(unsigned char a);
float fabs_op(float a);
unsigned char even_op(unsigned char a);
float feven_op(float a);
unsigned char odd_op(unsigned char a);
float fodd_op(float a);
unsigned char sqrt_op(unsigned char a);
float fsqrt_op(float a);
unsigned char asin_op(unsigned char a);
float fasin_op(float a);
unsigned char acosin_op(unsigned char a);
float facosin_op(float a);
unsigned char atan_op(unsigned char a);
float fatan_op(float a);
unsigned char fix_op(unsigned char a);
float ffix_op(float a);
unsigned char floor_op(unsigned char a);
float ffloor_op(float a);
unsigned char ceiling_op(unsigned char a);
float fceiling_op(float a);

#ifndef min
#define min(a,b) ((a)<(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif

#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

#define ROUND(a) (floor((a)+0.5))

#ifdef __cplusplus
}
#endif

#endif /* __FOPS_H__ */

